﻿/**
 *************************************************************************************
 * [标题：ExmayUI JQuery Dialog 插件]<br>
 *************************************************************************************
 * [描述：ExmayUI JQuery Dialog 插件]<br>
 *************************************************************************************
 * @author Exmay Team / 亿美团队
 *************************************************************************************
 * @version Version 1.0.1 Beta / v1.0.1 测试版
 *************************************************************************************
 */

/*
 * ***********************************************************************************
 * 版权：Copyright © 2012 Exmay Inc. All Rights Reserved. 长沙亿美软件有限公司　版权所有
 * ***********************************************************************************
 * 企业文化：专注　创新　分享　共赢
 * ***********************************************************************************
 * 官方网站：http://www.exmay.com
 * ***********************************************************************************
 * 官方邮箱：service@exmay.com
 * ***********************************************************************************
 */

﻿(function($) {
	
	// 初始化内容面板
    function initExmayContentPanel(target) {
        var $target = $(target);
        $target.wrapInner('<div class="exmayui-dialog-content"></div>');
        var $content = $target.find(">div.exmayui-dialog-content");
        $content.css("padding", $target.css("padding"));
        $target.css("padding", 0);
//        $content.exmayPanel({
//            border: false, // 重点，无边框
//            doSize: false
//        });
        return $content;
    };
	
	// 初始化对话框
    function initExmayDialog(target) {
		var $target = $(target);
        var opts = $target.data("exmayDialog").options;
        var $contentPanel = $target.data("exmayDialog").contentPanel;
        $target.find("div.exmayui-dialog-messagebar").remove();
        $target.find("div.exmayui-dialog-toolbar").remove();
        $target.find("div.exmayui-dialog-button").remove();
        
		// 工具栏按钮初始化
        if (opts.toolbar) {
            var $toolbar = $('<div class="exmayui-dialog-toolbar"></div>').prependTo(target);
            for (var i = 0; i < opts.toolbar.length; i++) {
                var p = opts.toolbar[i];
                if (p == "-") {
                    $toolbar.append('<div class="exmayui-dialog-tool-separator"></div>');
                } else {
                    var $button = $('<a href="javascript:;"></a>').appendTo($toolbar);
                    $button.css("float", "left").text(p.text);
                    if (p.icon) {
                        $button.attr("icon", p.icon);
                    }
                    if (p.handler) {
                        $button[0].onclick = p.handler;
                    }
                    $button.exmayButton({
                        plain: true,
                        disabled: (p.disabled || false)
                    });
                };
            }
            $toolbar.append('<div style="clear:both"></div>');
        }
        
       // 信息栏初始化
       if (opts.messagebar) {
            var $messagebar = $('<div class="exmayui-dialog-messagebar"></div>').prependTo(target);
           	var image = opts.messagebar.image;
            var icon = opts.messagebar.icon;
            var title = opts.messagebar.title;
           	var message = opts.messagebar.message;
           	var $icon = $('<div class="exmayui-dialog-messagebar-icon"></div>').appendTo($messagebar);
           	if (image) {
           		$icon.append('<img src="' + image + '" wight="32" height="32" />');
           	} else {
           		$icon.addClass(icon);
           	}
           	var $information = $('<div class="exmayui-dialog-messagebar-information"></div>').appendTo($messagebar);
           	$('<div class="exmayui-dialog-messagebar-title"></div>').text(title).appendTo($information);
           	$('<div class="exmayui-dialog-messagebar-message"></div>').text(message).appendTo($information);
       };
		
		// 操作按钮初始化
        var $dialogButtons;
        if (opts.buttons) {
            $dialogButtons = $('<div class="exmayui-dialog-button"></div>').appendTo(target).hide();
            for (var i = 0; i < opts.buttons.length; i++) {
                var dialogButton = opts.buttons[i];
                var $button = $('<a href="javascript:;"></a>').appendTo($dialogButtons);
                if(i != 0 && i+1 == opts.buttons.length){
                	$button.css("margin-right", 0);
                } else {
                	$button.css("margin-right", 5);
                }
                if(dialogButton.submit) {
                	$button.attr("id","exmay-dialog-submit");
                }
                $button.exmayButton(dialogButton);
                if (dialogButton.handler) {
//                    $button.bind("click", function() {
//                    	dialogButton.handler.call($target, $target);
////                    	dialogButton.handler($target);
//                    });
//                	$button[0].onclick = function() {
//                		dialogButton.handler.call($target, $target);
//                	};
   					$button.bind("click", dialogButton.handler);
                }
//   				$button.bind("click", function(){
//   					$(target).exmayDialog("destroy");
//   				});
//                $button.exmayButton(dialogButton);
                
            }
        }
		
		// URL处理
        if (opts.url) {
//            $contentPanel.exmayPanel({
//                url: opts.url,
//                onLoad: opts.onLoad
//            });
			
        	var $load = $('<div class="exmayui-panel-loading"></div>').html("数据加载中...");
			$load.appendTo($contentPanel);
        	
        	var $iframe = $('<iframe id="exmay-panel-frame" name="exmay-panel-frame" width="100%" height="100%" frameborder="0"></iframe>');
			
        	if(exmayIsIE6) {
        		var el = document.createElement('iframe');
        			el.id = "exmay-panel-frame";
					el.width = '100%';
					el.height = '100%';
				//	el.src = 'http://www.baidu.com';
				exmaySetIframeSrc(el, opts.url);
				$contentPanel[0].appendChild(el);
        		//$iframe.attr("src", "http://www.baidu.com");
				iframe = el;
				if (iframe.attachEvent) {
					iframe.attachEvent("onload", function() {
						$load.remove();
					});
				} else {
					iframe.onload = function() {
						$load.remove();
					};
				}
			} else {
				//iframe.src = cache.options.url;
	        	$iframe.attr("src", opts.url);
				var iframe = $iframe[0];
				
				if (iframe.attachEvent) {
					iframe.attachEvent("onload", function() {
						$load.remove();
					});
				} else {
					iframe.onload = function() {
						$load.remove();
					};
				}
				
				$iframe.appendTo($contentPanel);
			}
            opts.url = null;
			
        }
        
        if($dialogButtons) {
        	$dialogButtons.show();
        }
        		
		// 窗口初始化
        $target.exmayWindow($.extend({}, opts, {
			// 调整大小
            onResize: function(width, height) {
                //var $content = $target.exmayPanel("exmayPanel").find("div.exmayui-panel-content-middle");
                var $content = $target.exmayPanel("exmayPanel").find("div.exmayui-panel-content-middle");
//                $contentPanel.exmayPanel("resize", {
//                   	width : $content.width(),
//                    height: (height == "auto") ? "auto": $content.height() - $content.find(">div.exmayui-dialog-messagebar").outerHeight() - $content.find(">div.exmayui-dialog-toolbar").outerHeight() - $content.find(">div.exmayui-dialog-button").outerHeight()
//                });
                // 调整对话框内容大小
                //var $dialogContent = $content.find(".exmayui-dialog-content");
                var myHeight = $content.height() - 
	                   $content.find(">div.exmayui-dialog-messagebar").outerHeight() - 
	                   $content.find(">div.exmayui-dialog-toolbar").outerHeight() - 
	                   $content.find(">div.exmayui-dialog-button").outerHeight() - 
	                   ($contentPanel.outerHeight() - $contentPanel.height());
                $contentPanel.css({
					height: (height == "auto") ? 
	                   "auto": myHeight
                });
                var $iframe = $content.find("iframe");
                	$iframe.height(myHeight)
                if (opts.onResize) {
                    opts.onResize.call(target, width, height);
                }
            }
        }));
    };
	
	// 刷新对话框
    function refreshExmayDialog(target) {
        var $contentPanel = $(target).data("exmayDialog").contentPanel;
        $contentPanel.exmayPanel("refresh");
    };
	
	// 对话框(缓存版)
    $.fn.exmayDialog = function(options, data) {

		if (typeof options == "string") {
			var method = $.fn.exmayDialog.methods[options];
			if (method) {
				return method(this, data);
			} else {
				return this.exmayWindow(options, data);
			}
		};

        options = options || {};
		
        return this.each(function() {
			var $this = $(this);				  
            var cache = $this.data("exmayDialog");
            if (cache) {
                $.extend(cache.options, options);
//                if(cache.options.url) {
//                	$this.exmayPanel("refresh", cache.options.url);
//                }
            } else {
                var opts = $.extend({}, $.fn.exmayDialog.defaults, $.fn.exmayDialog.parseOptions(this), options)
                $this.data("exmayDialog", {
                    options: opts,
                    contentPanel: initExmayContentPanel(this)
                });
            	initExmayDialog(this);
            }
        });
    };
    
	// 对话框插件(无缓存版)
    $.exmayDialog = function(options, data) {
    	var $parent = $(top.document.body);
    	var $dialog = $('<div class="exmayui-dialog" closed="true" icon="icon-save" style="width:400px;height:200px;"></div>');
    	var opts = {
    		onClose : function() {
    			$dialog.exmayDialog("destroy");
    		}
    	};
    	options = $.extend({}, options, opts)
    	$dialog.appendTo($parent).exmayDialog(options, data).exmayDialog("open");
    	return $dialog; 
    };
	
    // 对话框方法
	$.fn.exmayDialog.methods = {
		// 获取对话框选项
		options : function($target) {
			var opts = $.data($target[0], "exmayDialog").options;
			var options = $target.exmayPanel("options");
			$.extend(opts, {
				closed : options.closed,
				collapsed : options.collapsed,
				minimized : options.minimized,
				maximized : options.maximized
			});
			//var _19 = $.data($target[0], "exmayDialog").contentPanel;
			return opts;
		},
		// 对话框
		dialog : function($target) {
			return $target.exmayWindow("exmayWindow");
		},
		// 刷新内容面板
		refresh : function($target) {
			return $target.each(function() {
				refreshExmayDialog(this);
			});
		}
	};
    
    // 解析对话框选项
    $.fn.exmayDialog.parseOptions = function(target) {
    	var $target = $(target);
		return $.extend({},$.fn.exmayWindow.parseOptions(target),{});
    };
    
	// 对话框属性
	$.fn.exmayDialog.defaults = $.extend( {}, $.fn.exmayWindow.defaults, {
        title: "新对话框",
        url: null,
        isFrame : false, // 是否是框架页面
        modal : true,
        fullScreen: false,
        collapsible: false,
        minimizable: false,
        maximizable: false,
        resizable: false,
        messagebar: null,
        toolbar: null,
        buttons: null
	});

})(jQuery);