/**
 *************************************************************************************
 * [标题：ExmayUI JQuery Droppable 插件]<br>
 *************************************************************************************
 * [描述：ExmayUI JQuery Droppable 插件]<br>
 *************************************************************************************
 * @author Exmay Team / 亿美团队
 *************************************************************************************
 * @version Version 1.0.1 Beta / v1.0.1 测试版
 *************************************************************************************
 */

/*
 * ***********************************************************************************
 * 版权：Copyright © 2012 Exmay Inc. All Rights Reserved. 长沙亿美软件有限公司　版权所有
 * ***********************************************************************************
 * 企业文化：专注　创新　分享　共赢
 * ***********************************************************************************
 * 官方网站：http://www.exmay.com
 * ***********************************************************************************
 * 官方邮箱：service@exmay.com
 * ***********************************************************************************
 */

(function($) {
	
	function exmayInitDropEvents(target) {
		var $target = $target;
		$target.addClass("exmayui-droppable");
		$target.bind("_exmayDragenter", function(e, data) {
			$target.data("exmayDroppable").options.onDragEnter.apply(target, [ e, data ]);
		});
		$target.bind("_exmayDragleave", function(e, data) {
			$target.data("exmayDroppable").options.onDragLeave.apply(target, [ e, data ]);
		});
		$target.bind("_exmayDragover", function(e, data) {
			$target.data("exmayDroppable").options.onDragOver.apply(target, [ e, data ]);
		});
		$target.bind("_drop", function(e, data) {
			$target.data("exmayDroppable").options.onDrop.apply(target, [ e, data ]);
		});
	};
	
	$.fn.exmayDroppable = function(options, data) {
		if (typeof options == "string") {
			return $.fn.exmayDroppable.methods[options](this, data);
		}
		options = options || {};
		return this.each(function() {
			var $this = $(this);
			var cache = $this.data("exmayDroppable");
			if (cache) {
				$.extend(cache.options, options);
			} else {
				exmayInitDropEvents(this);
				$this.data("exmayDroppable", {
					options : $.extend( {}, $.fn.exmayDroppable.defaults, options)
				});
			}
		});
	};
	
	$.fn.exmayDroppable.methods = {};
	
	$.fn.exmayDroppable.defaults = {
		accept : null,
		onDragEnter : function(e, data) {
		},
		onDragOver : function(e, data) {
		},
		onDragLeave : function(e, data) {
		},
		onDrop : function(e, data) {
		}
	};
	
})(jQuery);
