﻿/**
 *************************************************************************************
 * [标题：ExmayUI JQuery Loader 插件]<br>
 *************************************************************************************
 * [描述：ExmayUI JQuery Loader 插件]<br>
 *************************************************************************************
 * @author Exmay Team / 亿美团队
 *************************************************************************************
 * @version Version 1.0.1 Beta / v1.0.1 测试版
 *************************************************************************************
 */

/*
 * ***********************************************************************************
 * 版权：Copyright © 2012 Exmay Inc. All Rights Reserved. 长沙亿美软件有限公司　版权所有
 * ***********************************************************************************
 * 企业文化：专注　创新　分享　共赢
 * ***********************************************************************************
 * 官方网站：http://www.exmay.com
 * ***********************************************************************************
 * 官方邮箱：service@exmay.com
 * ***********************************************************************************
 */

(function() {
	var resources = {
		button	: {
			js : "/exmayui-button/exmayui-button.js"
		},
		checkbox : {
			js : "/exmayui-checkbox/exmayui-checkbox.js"
		},
		combobox : {
			js : "/exmayui-combobox/exmayui-combobox.js"
		},
		date : {
			js : "/exmayui-date/exmayui-date.js"
		},
		dialog : {
			js : "/exmayui-messagebox/exmayui-dialog.js",
			dependencies : ["window"]
		},
		draggable : {
			js : "/exmayui-draggable/exmayui-draggable.js"
		},
		droppable : {
			js : "/exmayui-droppable/exmayui-droppable.js"
		},
		editor : {
			js : "/exmayui-editor/exmayui-editor.js"
		},
		loading : {
			js : "/exmayui-loading/exmayui-loading.js"
		},
		messagebox : {
			js : "/exmayui-messagebox/exmayui-messagebox.js",
			dependencies : ["window"]
		},
		menu : {
			js : "/exmayui-menu/exmayui-menu.js"
		},
		radio : {
			js : "/exmayui-radio/exmayui-radio.js"
		},		
		parser : {
			js : "/exmayui-parser/exmayui-parser.js"
		},
		panel : {
			js : "/exmayui-panel/exmayui-panel.js",
			dependencies : [ "draggable", "droppable", "resizable"]
		},
		resizable : {
			js : "/exmayui-resizable/exmayui-resizable.js"
		},
		selectable : {
			js : "/exmayui-selectable/exmayui-selectable.js"
		},
		selector : {
			js : "/exmayui-selector/exmayui-selector.js"
		},
		tabs : {
			js : "/exmayui-tabs/exmayui-tabs.js"
		},
		textbox : {
			js : "/exmayui-textbox/exmayui-textbox.js"
		},
		tip : {
			js : "/exmayui-tip/exmayui-tip.js",
			dependencies : ["panel"]
		},
		tree : {
			js : "/exmayui-tree/exmayui-tree.js"
		},
		window : {
			js : "/exmayui-window/exmayui-window.js",
			dependencies : ["panel"]
		},
		validator : {
			js : "/exmayui-validator/exmayui-validator.js",
			dependencies : ["tip"]
		}
	};
	
	// 加载JS
	var loads = {};
	function exmayLoadJs(url, fn) {
		var status = false;
		var scriptTags = document.createElement("script");
		scriptTags.type = "text/javascript";
		scriptTags.language = "javascript";
		scriptTags.src = url;
		scriptTags.onload = scriptTags.onreadystatechange = function() {
			if (!status
					&& (!scriptTags.readyState || scriptTags.readyState == "loaded" || scriptTags.readyState == "complete")) {
				status = true;
				scriptTags.onload = scriptTags.onreadystatechange = null;
				if (fn) {
					fn.call(scriptTags);
				}
			}
		};
		document.getElementsByTagName("head")[0].appendChild(scriptTags);
	};
	
	// 清除并加载JS
	function exmayRemove4LoadJs(url, fn) {
		exmayLoadJs(url, function() {
			document.getElementsByTagName("head")[0].removeChild(this);
			if (fn) {
				fn();
			}
		});
	};
	
	// 加载CSS
	function exmayLoadCss(url, fn) {
		var cssTag = document.createElement("link");
		cssTag.rel = "stylesheet";
		cssTag.type = "text/css";
		cssTag.media = "screen";
		cssTag.href = url;
		document.getElementsByTagName("head")[0].appendChild(cssTag);
		if (fn) {
			fn.call(cssTag);
		}
	};
	
	// 执行加载
	function exmayExecuteLoad(options, fn) { 
		loads[options] = "loading";
		var module = resources[options];
		var moduleCss = module["css"];
		var moduleJs = module["js"];
		var loadStatus = "loading";
		var cssStatus = ($.exmayLoader.css && moduleCss) ? "loading" : "loaded";
		var url = "";
		// CSS
		if ($.exmayLoader.css && moduleCss) {
			if (exmayValidate.http(moduleCss)) {
				url = moduleCss;
			} else {
				url = $.exmayLoader.base + "skin/" + $.exmayLoader.theme + "/"
						+ moduleCss;
			}
			exmayLoadCss(url, function() {
				cssStatus = "loaded";
				if (loadStatus == "loaded" && cssStatus == "loaded") {
					loadedProgress();
				}
			});
		}
		
		// JS
		if (exmayValidate.http(moduleJs)) {
			url = moduleJs;
		} else {
			url = $.exmayLoader.base + moduleJs;
		}
//		alert(window.location.href + "\r\n" + url);
		exmayLoadJs(url, function() {
			loadStatus = "loaded";
			if (loadStatus == "loaded" && cssStatus == "loaded") {
				loadedProgress();
			}
		});
		
		// 加载完毕处理
		function loadedProgress() {
			loads[options] = "loaded";
			$.exmayLoader.onProgress(options);
			if (fn) {
				fn();
			}
		};
	};
	
	// 加载模块
	function exmayLoads(options, fn) {
		var modules = [];
		var isLoad = false;
		if (typeof options == "string") {
			parserModule(options);
		} else {
			for ( var i = 0; i < options.length; i++) {
				parserModule(options[i]);
			}
		}
		// 解析模块
		function parserModule(opts) {
			if (!resources[opts]) {
				return;
			}
			var dependencies = resources[opts]["dependencies"];
			if (dependencies) {
				for ( var i = 0; i < dependencies.length; i++) {
					parserModule(dependencies[i]);
				}
			}
			modules.push(opts);
		};
		// 执行函数
		function executeFunction() {
			if (fn) {
				fn();
			}
			$.exmayLoader.onLoad(options);
		};
		var timer = 0;
		// 执行加载
		function executeLoad() {
			if (modules.length) {
				var module = modules[0];
				if (!loads[module]) { // 判断模块是否加载
					isLoad = true;
					exmayExecuteLoad(module, function() {
						modules.shift(); // shift() 方法用于把数组的第一个元素从其中删除，并返回第一个元素的值。
						executeLoad();
					});
				} else {
					if (loads[module] == "loaded") {
						modules.shift();
						executeLoad();
					} else {
						if (timer < $.exmayLoader.timeout) {
							timer += 10;
							setTimeout(arguments.callee, 10);
						}
					}
				}
			} else {
				executeFunction();
			}
		};
		executeLoad();
	};
	
	// 验证
	exmayValidate = {
		css : function(name) {
			return /\.css$/i.test(name);
		},
		js : function(name) {
			return /\.js$/i.test(name);
		},
		http : function(name) {
			return /^http/i.test(name);
		}
	};
	
	// 定义加载器
	$.exmayLoader = {
		modules : resources,
		timeout : 2000,
		base : Exmay.path.framework + '/jquery-exmayui-1.0.1',
		css : true,
		load : function(options, fn) {
			if (exmayValidate.css(options)) {
				if (exmayValidate.http(options)) {
					exmayLoadCss(options, fn);
				} else {
					exmayLoadCss($.exmayLoader.base + options, fn);
				}
			} else {
				if (exmayValidate.js(options)) {
					if (exmayValidate.http(options)) {
						exmayLoadJs(options, fn);
					} else {
						exmayLoadJs($.exmayLoader.base + options, fn);
					}
				} else {
					exmayLoads(options, fn);
				}
			}
		},
		onProgress : function(options) {
		},
		onLoad : function(options) {
		}
	};
	// 初始化加载器
	/*if (window.jQuery) {
		$(function() {
			$.exmayLoader.load("parser", function() {
				$.exmayParser.parse();
			});
		});
	}*/
})();