﻿/**
 *************************************************************************************
 * [标题：ExmayUI JQuery Menu 插件]<br>
 *************************************************************************************
 * [描述：ExmayUI JQuery Menu 插件]<br>
 *************************************************************************************
 * @author Exmay Team / 亿美团队
 *************************************************************************************
 * @version Version 1.0.1 Beta / v1.0.1 测试版
 *************************************************************************************
 */

/*
 * ***********************************************************************************
 * 版权：Copyright © 2012 Exmay Inc. All Rights Reserved. 长沙亿美软件有限公司　版权所有
 * ***********************************************************************************
 * 企业文化：专注　创新　分享　共赢
 * ***********************************************************************************
 * 官方网站：http://www.exmay.com
 * ***********************************************************************************
 * 官方邮箱：service@exmay.com
 * ***********************************************************************************
 */

(function($){
		  
	// 初始化菜单
	function initMenu(obj) {
		// 菜单
		$menu = $(">ul", obj);
		// 添加样式，隐藏
		$menu.addClass("exmayui-menu-list").hide();
		var $shadow = $('<div class="exmayui-menu-shadow"></div>').insertAfter($menu);
		$shadow.css("z-index", $.fn.exmayMenu.defaults.zIndex++).hide();
		$menu.css("z-index", $.fn.exmayMenu.defaults.zIndex++);
		// 菜单项
		$menuItem = $(">li", $menu);
		// 初始化菜单项
		initMenuItem($menuItem);
		
	};
	
	// 初始化菜单项
	function initMenuItem($menuItem) {
		$menuItem.each( function() { 
			if ($(this).hasClass("exmayui-menu-separator")) {
				$(this).html("&nbsp;");
			} else { 
				$(this).addClass("exmayui-menu-item");
				$(">a", this).addClass("exmayui-menu-text");
				$menuRightArrow = $('<span class="exmayui-menu-rightarrow"></span>');
				// 菜单有子菜单加入右箭头
				if ($(">ul", this).size() > 0) {
					$menuRightArrow.insertAfter($(">a", this));
					// 遍历子菜单
					initMenu(this);
				}
				
				// 菜单项事件
				menuItemEvent($(this));		
				
			}
			// 单选复选
			if($(this).attr("radioName")) {
				var $menuCheckbox = $('<input type="radio" name="' +  $(this).attr("radioName") +'" class="exmayui-radio" />');
				if($(this).attr("radioValue")) {
					$menuCheckbox.attr("value", $(this).attr("radioValue"));
				}
				if($(this).attr("checked") == "true") {
					$menuCheckbox.attr("checked", true);
				}
				$menuCheckbox.insertBefore($(">a", this));
			}
			
			if($(this).attr("checkboxName")) {
				var $menuCheckbox = $('<input type="checkbox" name="' +  $(this).attr("checkboxName") +'" class="exmayui-checkbox" />');
				if($(this).attr("value")) {
					$menuCheckbox.attr("value", $(this).attr("value"));
				}
				if($(this).attr("checkboxValue")) {
					$menuCheckbox.attr("value", $(this).attr("checkboxValue"));
				}
				if($(this).attr("checked") == "true") {
					$menuCheckbox.attr("checked", true);
				}
				$menuCheckbox.insertBefore($(">a", this));
			}
			
		});
	};
	
	// 菜单事件绑定
	function menuEvent(obj) {
		var opts = $(obj).data("menu").options;
		var $menu = $(">ul", obj);
		
		if(opts.contextMenu) {
			// 取消浏览器默认右击菜单
			$(opts.target).each(function(){
				this.oncontextmenu = function(){return false;}
			});
			// 右键单击事件
			$(opts.target).bind('contextmenu',function(e){	
				var position = {
					left : e.pageX,
					top : e.pageY
				};
				// 显示项级菜单
				showMenu(obj, position);
			});
		}
	};
	
	// 菜单项事件绑定
	function menuItemEvent(obj) {
		$(obj).hover(function(e) { 
			if($(this).siblings().hasClass("exmayui-menu-active")) {
				var $activeItem = $(">li.exmayui-menu-active", $(e.target).closest("ul"));
				
				var $activeLastItem = $("li.exmayui-menu-active", $activeItem);
				
				if($activeLastItem.length > 0) {
					$activeLastItem.last().find(">ul").hide();
					$activeLastItem.last().find(".exmayui-menu-shadow").hide();
					$activeLastItem.last().parents("ul").each(function(){
						if($(this).attr("id") == $activeItem.parent("ul").attr("id")) {
							return false;
						}
						$(this).hide();
						$(this).siblings(".exmayui-menu-shadow").hide();
					});
				} else {
					$(">ul", $activeItem).hide();
					$(">div.exmayui-menu-shadow", $activeItem).hide();
				}
				
				$activeItem.removeClass("exmayui-menu-active");
				if($("ul li", $activeItem).hasClass("exmayui-menu-active")) {
					$("ul li", $activeItem).removeClass("exmayui-menu-active");
				}
			}
			$(this).addClass("exmayui-menu-active");
			// 显示子菜单
			showSubMenu($(this));
		}, function(e) {
			if(e.target == this) {							
				$(this).removeClass("exmayui-menu-active");
			}
			if($(">ul", $(e.target)).css("display") == "block") {
				$(this).addClass("exmayui-menu-active");
			}
		});
	};
	
	// 显示菜单
	function showMenu(obj, position) {
		var opts = $(obj).data("menu").options;
		var $menu = $(">ul", obj);
		var left = position.left;
		var top = position.top;
		var width = $menu.outerWidth();
		var height = $menu.outerHeight();
		if(left + width > $(document).width()) {
			left = $(document).width() - width;
		}
		if(top + height > $(document).height()) {
			top = $(document).height() - height;
		}
		
		$menu.css({
			left: left,
			top: top
		});
		$(">div.exmayui-menu-shadow", obj).css({
			display : "block",
			left : $menu.css("left"),
			top : $menu.css("top"),
			width : $menu.outerWidth(),
			height : $menu.outerHeight()
		});
//		// 隐藏所有菜单
//		$("ul", obj).hide();
		hideMenu(obj);
		// 取消所有激活
		$("li.exmayui-menu-active", obj).removeClass("exmayui-menu-active");
		// 显示项级菜单
		$menu.show();
		$(obj).show();
		$(obj).bind("mousedown.exmayMenu", function(){
			$(document).unbind(".exmayMenu");
		}).bind("mouseup.exmayMenu", function(){
				hideMenu(obj);
		});
		//$(".exmayui-menu-shadow", obj).show();
		$(".exmayui-treegrid-row").unbind(".exmayMenu").bind("mousedown.exmayMenu",function(e){	
			hideMenu(obj);
		});
		$(document).unbind(".exmayMenu").bind("mousedown.exmayMenu",function(e){	
			hideMenu(obj);
		});
		//$(">li", $menu).show();	
		// 隐藏菜单
		if(opts.onShow) {
			opts.onShow.call();
		}
		return false;
	};
	
	// 显示子菜单
	function showSubMenu(obj) {
		$subMenu = $(">ul", obj);
		if ($subMenu.size() > 0) {
			var parentLeft = $(obj).offset().left;
			var parentTop = $(obj).offset().top;
			var parentWidth = $(obj).outerWidth();
			var parentHeight = $(obj).outerHeight();
			var left = parentWidth - 2;
			var top = -3;
			var width = $subMenu.outerWidth();
			var height = $subMenu.outerHeight();
			if(parentLeft + parentWidth + width > $(document).width()) {
				left = left - parentWidth - width + 4;
			}
			if(parentTop + parentHeight + height  > $(document).height()) {
				top = top - height + parentHeight;
			}
			$subMenu.css({
				left : left,
				top : top 
			});
			$(">div.exmayui-menu-shadow", obj).css({
				display : "block",
				left : left,
				top : top,
				width : $subMenu.outerWidth(),
				height : $subMenu.outerHeight()
			});
			$subMenu.show();
			//$(">li", $subMenu).show();	
		}
	};
	
	// 隐藏菜单
	function hideMenu(obj) {
		$(document).unbind(".exmayMenu");
		var $activeItem = $("li.exmayui-menu-active", obj);
		if($activeItem.length >0) {
			$activeItem.last().find(">ul").hide();
			$activeItem.last().find(">ul").siblings(".exmayui-menu-shadow").hide();
			$activeItem.last().parents("ul").each(function() {
				$(this).hide();
				$(this).siblings(".exmayui-menu-shadow").hide();
			});
			$(">ul", obj).siblings(".exmayui-menu-shadow").hide();
		} else {
			$(">ul", obj).hide();
			$(">ul", obj).siblings(".exmayui-menu-shadow").hide();
		}
		//return false;
	};
	
	
	function getChecked(obj, name) {
		var ids = [];
		$(obj).find("input[name="+ name +"]:checked").each(function(){
			ids.push($(this).parent("li").attr("id"));
		});
		return ids;
	};
	
	function setChecked(obj, data) {
		
	};
	
	// 启用
	function enableMenuItem(target, item) {
		$(item, target).removeAttr("disabled");
		$(item, target).removeClass("exmayui-menu-item-disabled");
		//bindMenuEvents(item);
	}
	;

	// 禁用
	function disableMenuItem(target, item) {
		$(item, target).attr("disabled", true);
		$(item, target).addClass("exmayui-menu-item-disabled");
	}
	;
	
	$.fn.exmayMenu = function(options, data) {
		$("#exmay-ui-resource-menu").show();	
		if (typeof options == "string"){
			switch(options){
				case "show": // 显示
					return this.each(function(){
						showMenu(this, data);
					});
				case "hide": // 隐藏
					return this.each(function(){
						hideMenu(this);
					});
				case "getChecked" : //　选中
					return getChecked(this, data);
				case "enableMenuItem" : //　启用
					return enableMenuItem(this, data);
				case "disableMenuItem" : //　禁用
					return disableMenuItem(this, data);
			}
		}
		
		options = options || {};
		
		return this.each(function(){
			var $this = $(this);
			
			// 定义缓存
			var cache = $this.data("menu");
			
			// 定义选项
			var opts = null;
				
			// 如果数据已缓存
			if (cache) {
				// 删除所有.exmayMenu命名空间绑定的事件
				$this.unbind(".exmayMenu");
				// 通过数据缓存为选项赋值
				opts = $.extend(cache.options, options || {});
			} else {
				// 重新初始化选项
				opts = $.extend( {}, $.fn.exmayMenu.defaults, options || {});
				// 初始化菜单
				var menu = initMenu(this);
				// 对数据进行缓存
				$this.data("menu", {options : opts} );
			}
			
			// 菜单事件绑定
			menuEvent(this);
			
		});
	};
	
	$.fn.exmayMenu.defaults = {
		left : 0,  // 左边距
		top : 0,  // 右边距
		zIndex : 200000,  // 层级
		contextMenu : false,  // 是否右键
		target : document,
		onShow : function() {  // 显示
		},
		onHide : function() {  // 隐藏
		}	
	};
	
})(jQuery);