/**
 *************************************************************************************
 * [标题：ExmayUI JQuery Messagebox 插件]<br>
 *************************************************************************************
 * [描述：ExmayUI JQuery Messagebox 插件]<br>
 *************************************************************************************
 * @author Exmay Team / 亿美团队
 *************************************************************************************
 * @version Version 1.0.1 Beta / v1.0.1 测试版
 *************************************************************************************
 */

/*
 * ***********************************************************************************
 * 版权：Copyright © 2012 Exmay Inc. All Rights Reserved. 长沙亿美软件有限公司　版权所有
 * ***********************************************************************************
 * 企业文化：专注　创新　分享　共赢
 * ***********************************************************************************
 * 官方网站：http://www.exmay.com
 * ***********************************************************************************
 * 官方邮箱：service@exmay.com
 * ***********************************************************************************
 */

(function($) {

	var $win = null;
	var $function = null;
	var buttonEvent = false;
	
	// 初始化信息提示框
    function initExmayMessagebox(title, message, buttons, prompt) {
    	// 兼容框架页
    	var $parent = $(top.document.body);
    	if($.exmayMessagebox.defaults.parent) {
    		$parent = $($.exmayMessagebox.defaults.parent);
    	}
    	
 		var $messagebox = $('<div class="exmayui-messagebox-body"></div>').appendTo($parent);
 		$win = $messagebox;
        $messagebox.append(message);
        if (buttons) {
        	if(prompt) {
	        	var $checkbox = $('<input type="checkbox" id="exmay-prompt" class="exmayui-checkbox" />');
	        	var $label = $(' <label for="exmay-prompt" style="margin-left:5px;">以后不再提示</label>');
	        	var $prompt = $('<div style="vertical-align:middle; padding-top:5px;"></div>');
	        	$checkbox.appendTo($prompt);
	        	$label.appendTo($prompt);
	        	$prompt.appendTo($messagebox);
	        	$checkbox.exmayCheckbox();
        	}
            var tb = $('<div class="exmayui-messagebox-button"></div>').appendTo($messagebox);
            var $lastButton = null;
            var hasOk = false;
            for (var button in buttons) {
               	var $button = $('<a href="javascript:;"></a>');
            	var icon = "icon-ok";
        		if(button == "取消") {
        			icon = "icon-cancel"
        			$lastButton.removeAttr("id");
        			$button.attr("id","exmay-messagebox-submit");
        		} else {
        			$button.attr("id","exmay-messagebox-submit");
        			hasOk = true;
        		}
                $button.attr("icon",icon).text(button).css("margin-right", 10).bind("click",  eval(buttons[button])).appendTo(tb).exmayButton();
           		$lastButton = $button;
            }
            $lastButton.css("margin-right", 0);
        }
    	
        $messagebox.exmayWindow({
            title : title,
            width : 300,
            height : "auto",
            modal : true,
            zIndex: $.fn.exmayWindow.defaults.zIndex++,
			fullScreen : false,
            collapsible : false,
            minimizable : false,
            maximizable : false,
            resizable : false,
            onClose : function() {
                setTimeout(function() {
                	// 调用窗口销毁方法
                    $messagebox.exmayWindow("destroy");
                    if($function && !buttonEvent) {
                    	eval($function(true));
                    	$function = null;
                    }
                    buttonEvent = false;
                }, 100);
            }
        });
        $parent.find("#exmay-messagebox-submit").focus();
        // HACK
        $messagebox.parent().css("z-index", $.fn.exmayWindow.defaults.zIndex++);
        return $messagebox;
    };

     var timer = null;
	// 显示信息提示框
    function showExmayMessagebox(el, type, speed, timeout, opts) {
        var $window = $(el).exmayWindow("exmayWindow");
        if (!$window) {
            return;
        }
        switch (type) {
        case null:
            $window.show();
            break;
        case "slide":
            $window.slideDown(speed);
            break;
        case "fade":
            $window.fadeIn(speed);
            break;
        case "show":
            $window.show(speed);
            break;
        }
       
//        if (timeout > 0) {
//            timer = setTimeout(function() {
//                hideExmayMessagebox(el, type, speed);
//            },
//            timeout * 1000);
//        }
        if (timeout > 0) {
			var time = timeout;
            timer = setInterval(function() {
				time--;
				// 调用[窗口]设置标题
				$(el).exmayWindow("setTitle", opts.title.replace("{second}", time));
				// 设置内容
				$(el).find("div.exmayui-panel-content-middle").html(opts.msg.replace("{second}", time));
				if(time == 0) {
					if(opts.mini) {
						$(el).exmayWindow("exmayWindow").animate({bottom: -($(el).exmayWindow("exmayWindow").outerHeight() - ($(el).offset().top - $(el).exmayWindow("exmayWindow").offset().top))}, "slow");
					} else {
						hideExmayMessagebox(el, type, speed);
					}
					clearInterval(timer);
				}
            },
            1000);
        }
		
        // 最小化窗口自动关闭
		if(opts.mini) {
			$window.hover(function() {
				$(el).exmayWindow("exmayWindow").animate({bottom : 0}, "slow");
			});
		} else {
			$window.hover(function() {
				if (timer) {
					clearInterval(timer);
				}
			}, function() {
	//            if (timeout > 0) {
	//                timer = setTimeout(function() {
	//                    hideExmayMessagebox(el, type, speed);
	//                },
	//                timeout * 1000);
	//            }
				var time = timeout;
				//$(el).exmayWindow("setTitle", opts.title.replace("{second}", time));
				//$(el).html(opts.msg.replace("{second}", time));
				timer = setInterval(function() {
					time--;
					//$(el).exmayWindow("setTitle", opts.title.replace("{second}", time));
					//$(el).html(opts.msg.replace("{second}", time));
					if(time == 0) {
						hideExmayMessagebox(el, type, speed);
						clearInterval(timer);
					}
				},
				1000);
			});
		}
    };
	
	// 隐藏对话框
    function hideExmayMessagebox(target, type, speed) {
        if (target.locked == true) {
            return;
        }
        target.locked = true;
        var $window = $(target).exmayWindow("exmayWindow");
        if (!$window) {
            return;
        }
        switch (type) {
        case null:
            $window.hide();
            break;
        case "slide":
            $window.slideUp(speed);
            break;
        case "fade":
            $window.fadeOut(speed);
            break;
        case "show":
            $window.hide(speed);
            break;
        }
        setTimeout(function() {
            $(target).exmayWindow("destroy");
			if (timer) {
				clearInterval(timer);
			}
        },
        speed);
    	$(window).unbind("scroll.exmayMessagebox");
    };
	
	// 信息提示框
    $.exmayMessagebox = {
		
		// 显示
        show: function(options) {
            var opts = $.extend({
                showType: "slide",
                showSpeed: 600,
                width: 250,
                height: 100,
                msg: "",
                title: "",
                timeout: 5,
				mini : false,
				parent : null
            }, options || {});
			var msg = opts.msg;
			var title = opts.title;
			msg = msg.replace("{second}", opts.timeout);
			title = title.replace("{second}", opts.timeout);
			// 兼容框架页
    		var $parent = $(top.document.body);
    		if(opts.parent) {
    			$parent = $(opts.parent);
    			$.exmayMessagebox.defaults.parent = opts.parent;
    		}
            var win = $('<div class="exmayui-messagebox-body"></div>').html(msg).appendTo($parent);
            win.exmayWindow({
				icon : opts.icon,
                title: title,
                width: opts.width,
                height: opts.height,
                zIndex: $.fn.exmayWindow.defaults.zIndex++,
                fullScreen : false,
                collapsible: false,
                minimizable: false,
                maximizable: false,
                shadow: false,
                draggable: false,
                resizable: false,
                closed: true,
                onBeforeOpen: function() {
                    showExmayMessagebox(this, opts.showType, opts.showSpeed, opts.timeout, opts);
                    return false;
                },
                onBeforeClose: function() {
                    hideExmayMessagebox(this, opts.showType, opts.showSpeed);
					// 清除事件绑定
                    $(window).unbind("scroll.exmayMessagebox");
                    // 关于前清除定时器
					if (timer) {
						clearInterval(timer);
					}
                    return false;
                }
            });
           var bottom = null;
           function exmayGetTop() {
	           var top0 =  $(window).height() - opts.height + $(document).scrollTop(); 
	           var top = null;
	            if($.browser.version == "6.0"){
					var height = document.documentElement.clientHeight;
					top = top0+height-400-opts.height;
				} else {
					bottom = -document.body.scrollTop - document.documentElement.scrollTop;
				}
	            return top;
            };
            win.exmayWindow("exmayWindow").css({
                left: null,
                top: exmayGetTop(),
                right: 0,
                zIndex: $.fn.exmayWindow.defaults.zIndex++, // 很重要
                //zIndex: 10000,
                bottom: bottom
            });
            // 兼容
            win.exmayWindow("exmayWindow").css({left : "", top : ""}); 
            win.exmayWindow("open");
            // 滚动条事件
           $(window).bind("scroll.exmayMessagebox", function() { 
	        	 win.exmayWindow("exmayWindow").css({
	                left: null,
	                top: exmayGetTop(),
	                right: 0,
	                //zIndex: $.fn.exmayWindow.defaults.zIndex++,
	                //zIndex: 10000,
	                bottom: bottom
	            });
           });
        },
		
		// 警告
        alert: function(title, msg, options, fn, flag) {
            var message = "<div>" + msg + "</div>";
            switch (options) {
            case "error":
                message = '<div class="exmayui-messagebox-icon exmayui-messagebox-error"></div>' + message;
                break;
            case "info":
                message = '<div class="exmayui-messagebox-icon exmayui-messagebox-info"></div>' + message;
                break;
            case "question":
                message = '<div class="exmayui-messagebox-icon exmayui-messagebox-question"></div>' + message;
                break;
            case "warning":
                message = '<div class="exmayui-messagebox-icon exmayui-messagebox-warning"></div>' + message;
                break;
            }
            message += '<div style="clear:both;"/>';
            var buttons = {};
            if(flag) {
            	$function = fn;
            }
            $win = initExmayMessagebox(title, message, getButtons());
            function getButtons() {
                buttons[$.exmayMessagebox.defaults.ok] = function() {
                    buttonEvent = true;
                    $win.exmayWindow("close");
                    if (fn) {
                        fn(true);
                        return false;
                    }
                };
                return buttons;
            };
        },
		
		// 确认
        confirm: function(title, msg, fn, flag) {
            var message = '<div class="exmayui-messagebox-icon exmayui-messagebox-question"></div>' + '<div>' + msg + '</div>' + '<div style="clear:both;"/>';
            var buttons = {};
            if(flag) {
            	$function = fn;
            }
            $win = initExmayMessagebox(title, message, getButtons(), true);
            function getButtons() {
                buttons[$.exmayMessagebox.defaults.ok] = function() {
                	buttonEvent = true;
                	$win.exmayWindow("close");
                    if (fn) {
                        fn(true);
                        return false;
                    }
                };
                buttons[$.exmayMessagebox.defaults.cancel] = function() {
                	buttonEvent = true;
                	$win.exmayWindow("close");
                    if (fn) {
                        fn(false);
                        return false;
                    }
                };            	
                return buttons;
            };
        },
		
		// 提示
        prompt: function(title, msg, fn, type) {
        	var input;
        	if(type == "textarea") {
        		input = '<textarea class="exmayui-messagebox-input"></textarea>';
        	} else {
        		input = '<input class="exmayui-messagebox-input exmay-ui-input-text" type="text" style="width:253px;" />';
        	}
            var message = '<div class="exmayui-messagebox-icon exmayui-messagebox-question"></div>' + '<div>' + msg + '</div>' + '<br/>' + input + '<div style="clear:both;"/>';
            var buttons = {};
            $win = initExmayMessagebox(title, message, getButtons());
            function getButtons(){
                buttons[$.exmayMessagebox.defaults.ok] = function() {
                	$win.exmayWindow("close");
                    if (fn) {
                        fn($(".exmayui-messagebox-input", $win).val());
                        return false;
                    }
                };
                buttons[$.exmayMessagebox.defaults.cancel] = function() {
                	$win.exmayWindow("close");
                    if (fn) {
                        fn();
                        return false;
                    }
                }; 
                return buttons;
            };
        }
    };
	
    $.exmayMessagebox.defaults = {
		icon : null, // 图标
		image : null, // 图片
        ok: "确定", // 确定
        cancel: "取消", // 取消,
        parent : null
    };
	
})(jQuery);