/**
 *************************************************************************************
 * [标题：ExmayUI JQuery Pagination 插件]<br>
 *************************************************************************************
 * [描述：ExmayUI JQuery Pagination 插件]<br>
 *************************************************************************************
 * @author Exmay Team / 亿美团队
 *************************************************************************************
 * @version Version 1.0.1 Beta / v1.0.1 测试版
 *************************************************************************************
 */

/*
 * ***********************************************************************************
 * 版权：Copyright © 2012 Exmay Inc. All Rights Reserved. 长沙亿美软件有限公司　版权所有
 * ***********************************************************************************
 * 企业文化：专注　创新　分享　共赢
 * ***********************************************************************************
 * 官方网站：http://www.exmay.com
 * ***********************************************************************************
 * 官方邮箱：service@exmay.com
 * ***********************************************************************************
 */

(function($) {

	function initExmayPagination(target) {
		var $target = $(target);
		var opts = $target.data("exmayPagination").options;
		$target.empty();
		
		if(opts.showInfo) {
			$('<span class="exmayui-pagination-info"></span>').appendTo($target);
		}
				
		if (opts.showPageList) {
			var $pageList = $('<select class="exmayui-combobox exmayui-pagination-page-list" style="width:30px;"></select>');
			for ( var i = 0; i < opts.pageList.length; i++) {
				$("<option></option>").text(opts.pageList[i]).attr("selected", opts.pageList[i] == opts.pageSize ? "selected" : "").appendTo($pageList);
			}
			$pageList.appendTo($(target));
			opts.pageSize = parseInt($pageList.val());
			exmayInsertSeparator($target);
		}
		

		var $firstPage = $('<a href="javascript:;" class="exmayui-button" icon="icon-pagination-first"></a><span style="padding-right:5px;"></span>').appendTo($target);
		var $previewPage = $('<a href="javascript:;" class="exmayui-button" icon="icon-pagination-prev"></a>').appendTo($target);

		exmayInsertSeparator($target);

		$('<span style="padding-left:6px;">' + opts.beforePageText + '</span>').appendTo($target);
		$('<input class="exmayui-pagination-num exmay-ui-input-text" type="text" value="1" size="2" style="width:20px;height:14px;">').appendTo($target);
		$('<span style="padding-right:6px;"></span>').appendTo($target);

		exmayInsertSeparator($target);

		var $nextPage = $('<a href="javascript:;" class="exmayui-button" icon="icon-pagination-next"></a><span style="padding-right:5px;"></span>').appendTo($target);
		var $lastPage = $('<a href="javascript:;" class="exmayui-button" icon="icon-pagination-last"></a>').appendTo($target);


		if (opts.showPageNoList) {
			exmayInsertSeparator($target);
			var $showPageNoList = $('<select class="exmayui-combobox exmayui-pagination-page-no-list" style="width:20px;"></select>');
			for ( var i = 1; i < 11; i++) {
				$("<option></option>").text(i).attr("selected", i == 1 ? "selected" : "").appendTo($showPageNoList);
			}
			$showPageNoList.appendTo($(target));
		}
		
		var $refresh = null;
		if (opts.showRefresh) {
			exmayInsertSeparator($target);
			$refresh = $('<a href="javascript:;" class="exmayui-button" icon="icon-pagination-load"></a>').appendTo($target);
		}


		// 重新解析
		if ($.exmayParser) {
			$.exmayParser.parse($target);
		}
		
		function exmayInsertSeparator($target) {
			$('<span class="exmayui-pagination-button-separator"></span>').appendTo($target);
		}
		$target.data("exmayPagination", {
			options : opts,
			firstPage : $firstPage,
			previewPage : $previewPage,
			nextPage : $nextPage,
			lastPage : $lastPage,
			refresh : $refresh
		});
	}
	;
	
	function bindExmayPaginationEvents(target){
		var $target = $(target);
		var cache = $target.data("exmayPagination");
		var opts = cache.options;
		cache.firstPage.unbind(".exmayPagination").bind("click.exmayPagination", function() {
			if (opts.pageNo > 1)
				exmayChangePage(target, 1);
		});
		cache.previewPage.unbind(".exmayPagination").bind("click.exmayPagination", function() {
			if (opts.pageNo > 1)
				exmayChangePage(target, opts.pageNo - 1);
		});
		cache.nextPage.unbind(".exmayPagination").bind("click.exmayPagination", function() {
			var pageCount = Math.ceil(opts.totalCount / opts.pageSize);
			if (opts.pageNo < pageCount)
				exmayChangePage(target, opts.pageNo + 1);
		});
		cache.lastPage.unbind(".exmayPagination").bind("click.exmayPagination", function() {
			var pageCount = Math.ceil(opts.totalCount / opts.pageSize);
			if (opts.pageNo < pageCount)
				exmayChangePage(target, pageCount);
		});
		if(opts.showRefresh) {
			cache.refresh.unbind(".exmayPagination").bind("click.exmayPagination", function() {
				exmayChangePage(target,  opts.pageNo);
			});
		}
	}

	function exmayChangePage(target, page) {
		var opts = $(target).data("exmayPagination").options;
		var pageCount = Math.ceil(opts.totalCount / opts.pageSize);
		var pageNo = page;
		if (page < 1)
			pageNo = 1;
		if (page > pageCount)
			pageNo = pageCount;
		opts.onChangePage.call(target, pageNo, opts.pageSize);
		opts.pageNo = pageNo;
		exmayShowPaginationInfo(target);
	};

	function exmayShowPaginationInfo(target) {
		var $target = $(target);
		var opts = $target.data("exmayPagination").options;

		var pageCount = Math.ceil(opts.totalCount / opts.pageSize);
		var num = $target.find("input.exmayui-pagination-num");
		num.val(opts.pageNo);
		num.next("span").html(opts.afterPageText.replace(/{pages}/, pageCount));

		var paginationMsg = opts.paginationMsg;
		paginationMsg = paginationMsg.replace(/{from}/, opts.pageSize * (opts.pageNo - 1) + 1);
		paginationMsg = paginationMsg.replace(/{to}/, Math.min(opts.pageSize * (opts.pageNo), opts.totalCount));
		paginationMsg = paginationMsg.replace(/{totalCount}/, opts.totalCount);

		$target.find(".exmayui-pagination-info").html(paginationMsg);

		if(opts.pageNo == 1) {
			$(".icon-pagination-first,.icon-pagination-prev", target).parents("a").exmayButton("disable");
		} else {
			$(".icon-pagination-first,.icon-pagination-prev", target).parents("a").exmayButton("enable");
		} 
		
		if (opts.pageNo == pageCount) {
			$(".icon-pagination-next,.icon-pagination-last", target).parents("a").exmayButton("disable");
		} else {
			$(".icon-pagination-next,.icon-pagination-last", target).parents("a").exmayButton("enable");
		}

		//$target.find(".icon-pagination-load").removeClass("icon-pagination-loading");
		if (opts.loading) {
			$target.find(".icon-pagination-load").addClass("icon-pagination-loading");
		} else {
			$target.find(".icon-pagination-load").removeClass("icon-pagination-loading");
		}
	};
	
	function exmayRefreshPagination(target) {
		var $target = $(target);
		var opts = $target.data("exmayPagination").options;
		exmayChangePage(target,  opts.pageNo);
	};

	$.fn.exmayPagination = function(options, data) {

		if (typeof options == "string") {
			return $.fn.exmayPagination.methods[options](this, data);
		}

		this.each(function() {
			var $this = $(this);
			var opts = null;
			var cache = $this.data("exmayPagination");
			if (cache) {
				opts = $.extend(cache.options, options);
				cache.options = opts;
			} else {
				opts = $.extend( {}, $.fn.exmayPagination.defaults, $.fn.exmayPagination.parseOptions(this), options);
				$this.data("exmayPagination", {
					options : opts
				});
				initExmayPagination(this);
			}
			bindExmayPaginationEvents(this);
			exmayShowPaginationInfo(this);
		});

	};

	// 插件方法
	$.fn.exmayPagination.methods = {
		options : function(target, data) {
			return $(target).data("exmayPagination").options;
		},
		loading : function(target, data) {
			return $(target).each(function() {
				setLoadStatus(this, true);
			});
		},
		loaded : function(target, data) {
			return $(target).each(function() {
				setLoadStatus(this, false);
			});
		},
		refresh : function(target,data) {
			exmayRefreshPagination(target);
		}
	};

	$.fn.exmayPagination.parseOptions = function(target) {
		var $target = $(target);
		return {

		}
	};

	// 插件属性
	$.fn.exmayPagination.defaults = {
		theme : "default",
		totalCount : 0,
		pageSize : 10,
		pageNo : 1,
		pageList : [ 10, 20, 30, 40, 50 ],
		loading : false,
		buttons : null,
		showPageList : false,
		showPageNoList : false,
		showRefresh : true,
		showInfo : true,
		onChangePage : function(pageNo, pageSize) {
		},
		onBeforeRefresh : function(pageNo, pageSize) {
		},
		onRefresh : function(pageNo, pageSize) {
		},
		onChangePageSize : function(pageSize) {
		},

		beforePageText : "当前页",
		afterPageText : "/ {pages}",
		paginationMsg : "显示 {from} 到 {to} 总共 {totalCount} 条记录"
	};

})(jQuery);