/**
 *************************************************************************************
 * [标题：ExmayUI JQuery Panel 插件]<br>
 *************************************************************************************
 * [描述：ExmayUI JQuery Panel 插件]<br>
 *************************************************************************************
 * @author Exmay Team / 亿美团队
 *************************************************************************************
 * @version Version 1.0.1 Beta / v1.0.1 测试版
 *************************************************************************************
 */

/*
 * ***********************************************************************************
 * 版权：Copyright © 2012 Exmay Inc. All Rights Reserved. 长沙亿美软件有限公司　版权所有
 * ***********************************************************************************
 * 企业文化：专注　创新　分享　共赢
 * ***********************************************************************************
 * 官方网站：http://www.exmay.com
 * ***********************************************************************************
 * 官方邮箱：service@exmay.com
 * ***********************************************************************************
 */

(function($) {
	// 初始化面板
    function initExmayPanel($target) {
		$target.removeClass("exmayui-panel");
		$target.removeAttr("title");
        var $panel = $target.addClass("exmayui-panel-body").wrap('<div class="exmayui-panel"></div>').parent();
        $panel.bind("_resize", function() {
            var opts = $target.data("exmayPanel").options;
            if (opts.fit == true) {
                resizeExmayPanel($target);
            }
            return false;
        });
        $panel.hide();
        return $panel;
    };
	
	// 初始化面板底部
	function initExmayPanelFooter($target) {
		var opts = $target.data("exmayPanel").options;
		var $panel = $target.data("exmayPanel").exmayPanel;
		var $content = $panel.find(">div.exmayui-panel-body");
		var $contentMiddle = $content.find(".exmayui-panel-content-middle");
		var $statusContent = $(".exmayui-panel-status-content", $contentMiddle);
		if(opts.border) {
			$statusBar = $('<div class="exmayui-panel-status-bar"></div>').appendTo($panel);
			$statusLeft = $('<div class="exmayui-panel-status-left"></div>').appendTo($statusBar);
			$statusMiddle = $('<div class="exmayui-panel-status-middle"></div>').appendTo($statusBar);
			$statusRight = $('<div class="exmayui-panel-status-right"></div>').appendTo($statusBar);
			if($contentMiddle.html() != null) {
				$statusContent.appendTo($statusMiddle);
			}
		}
		$panel.hide();
	};
	
	// 初始化面板主体
	function initExmayPanelBody($target) {
		var opts = $target.data("exmayPanel").options;
		var $panel = $target.data("exmayPanel").exmayPanel;
		var $body = $panel.find(">div.exmayui-panel-body");
		var content = $body.html();
		var style = $body.attr("style");
		$body.removeAttr("style");
		//$body.empty();
		var $middle = $('<div class="exmayui-panel-content-middle"></div>');
		$body.wrapInner($middle);
		if(opts.border) {
			var $left = $('<div class="exmayui-panel-content-left"></div>').prependTo($body);
			var $right = $('<div class="exmayui-panel-content-right"></div>').appendTo($body);
		}
		$middle.attr("style", style);
		$panel.hide();
		//$middle.html(content);
	};
	
	// 初始化面板头部
	function initExmayPanelHeader($target) {
		var opts = $target.data("exmayPanel").options;
		var $panel = $target.data("exmayPanel").exmayPanel;
		//removeNode($panel.find(">div.exmayui-panel-header"));
		
		// 判断标题是否存在
		if (opts.title) {
			var $header = $('<div class="exmayui-panel-header"></div>').prependTo($panel);
			var $left = $('<div class="exmayui-panel-title-left"></div>').appendTo($header);
			var $middle = $('<div class="exmayui-panel-title-middle"></div>').appendTo($header);
			var $title =  $('<div class="exmayui-panel-title"></div>').appendTo($middle);
			var $word = $('<span class="exmayui-panel-title-word"></span>').html(opts.title).appendTo($title);
			$(".exmayui-panel-title", $target).bind("dblclick.exmayWritable", exmayWritable);
			if (opts.icon) {
				//$header.find(".exmayui-panel-title").addClass("exmayui-panel-with-icon");
				$('<span class="exmayui-panel-icon exmay-ui-png"></span>').addClass(opts.icon).prependTo($title);
			}
			var $tool = $('<div class="exmayui-panel-tool"></div>').appendTo($middle);
			var $right = $('<div class="exmayui-panel-title-right"></div>').appendTo($header);
			if(opts.hideToolbar) {
				$tool.hide();
				//$header.hover(function(){$tool.show();},function(){$tool.hide();});
				$header.bind("mouseover.display", exmayHeaderShow);
				$header.bind("mouseout.display", exmayHeaderHide);
			}
			if (opts.closable) {
				$('<div class="exmayui-panel-tool-close"></div>').appendTo($tool).bind("click", exmayDoClose).bind("mousedown", function(){return false;});
			}
			if (opts.maximizable) {
				$('<div class="exmayui-panel-tool-max"></div>').appendTo($tool).bind("click", exmayDoMaximize);
			}
			if (opts.minimizable) {
				$('<div class="exmayui-panel-tool-min"></div>').appendTo($tool).bind("click", exmayDoMinimize);
				if($("#exmayui-tabs-minimizable-panel").length = 0) {
					var $exmayTabs = $('<div id="exmayui-tabs-minimizable-panel" class="exmayui-tabs" style="height:30px;"></div>');
					$exmayTabs.css({
						position : "absolute",
						left : $panel.parent().css("padding-left"),
						bottom : $panel.parent().css("padding-bottom"),
						width : $panel.parent().width()
					});
					$exmayTabs.insertAfter($panel);
					$exmayTabs.hide();
				}
			}
			if (opts.collapsible) {
				$('<div class="exmayui-panel-tool-collapse"></div>').appendTo($tool).bind("click", exmayDoCollapse);
			}
			if(opts.fullScreen) {
				$('<div class="exmayui-panel-tool-full-screen"></div>').appendTo($tool).bind("click", exmayDoFullScreen);
			}
			if (opts.tools) {
				for ( var i = opts.tools.length - 1; i >= 0; i--) {
					var t = $("<div></div>").addClass(opts.tools[i].icon).appendTo($tool);
					if (opts.tools[i].handler) {
						t.bind("click", eval(opts.tools[i].handler));
					}
				}
			}
			$tool.find("div").hover(function() {
				$(this).addClass("exmayui-panel-tool-over");
			}, function() {
				$(this).removeClass("exmayui-panel-tool-over");
			});
			$panel.find(">div.exmayui-panel-body").removeClass("exmayui-panel-body-noheader");
		} else {
			$panel.find(">div.exmayui-panel-body").addClass("exmayui-panel-body-noheader");
		}
		
		// 头部显示
		function exmayHeaderShow(e){
			var x = e.pageX;
			var $input = $(this).find(".exmayui-panel-title-input");
			if($input.length > 0) {
				var left = $input.offset().left;
				var width = $input.outerWidth();
				if(x > left && x < left + width) {
					$header.unbind(".display");
				} else {
					$tool.show();
				}
			} else {
				$tool.show();	
			}
		};
		
		// 头部隐藏
		function exmayHeaderHide() {
			$tool.hide();
		};
		
		// 是否可写
		function exmayWritable(){
			var title = $(".exmayui-panel-title", $target).text();
			var $input = $('<input type="text" name="title" value="' + title + '" class="exmayui-panel-title-input" size="10" />');
			$(".exmayui-panel-title", $target).html($input);
			$input.focus();
			$input.bind("mouseover", function(e){
				$("#tip").html("在文本框上");
				$header.unbind(".display");								  
			});
			$input.bind("mouseout", function(e){
				$("#tip").html("不在文本框");
				$header.bind("mouseover.display", exmayHeaderShow).bind("mouseout.display", exmayHeaderHide);
			});
			$(".exmayui-panel-title", $target).unbind(".exmayWritable");
			$input.keypress(function(e){
				var code = e.keyCode||e.which||e.charCode;
				if(code == 13){
					$(".exmayui-panel-title", $target).html($input.val());
					$(".exmayui-panel-title", $target).bind("click.exmayWritable", exmayWritable);
				}
			});
			$input.blur(function(e){
				$(".exmayui-panel-title", $target).html($input.val());
				$(".exmayui-panel-title", $target).bind("dblclick.exmayWritable", exmayWritable);
			});
		};
		function exmayDoFullScreen() {
			if ($(this).hasClass("exmayui-panel-tool-restore-full")) { 
				restoreFullExmayPanel($target);
			} else {
				fullScreenExmayPanel($target);
			}
		};
		function exmayDoCollapse() {
			if ($(this).hasClass("exmayui-panel-tool-expand")) {
				expandExmayPanel($target, true);
			} else {
				collapseExmayPanel($target, true);
			}
			return false;
		};
		function exmayDoMinimize() {
			minimizeExmayPanel($target);
			return false;
//			if ($(this).hasClass("window-restore-button")) {
//				restoreExmayPanel($target);
//			} else {
//				minimizeExmayPanel($target);
//			}
//			return false;
		};
		function exmayDoMaximize() {
			if ($(this).hasClass("exmayui-panel-tool-restore")) {
				restoreExmayPanel($target);
			} else {
				maximizeExmayPanel($target);
			}
			return false;
		};
		function exmayDoClose() {
			closeExmayPanel($target);
			return false;
		};
	};
	
	// 调整面板大小
	function resizeExmayPanel($target, data) {

		var opts = $target.data("exmayPanel").options;
		var $panel = $target.data("exmayPanel").exmayPanel;
		var $titleBar = $panel.find(">div.exmayui-panel-header");
		var $content = $panel.find(">div.exmayui-panel-body");
		
		// 标题栏
		var $titleLeft = $titleBar.find(".exmayui-panel-title-left");
		var $titleMiddle = $titleBar.find(".exmayui-panel-title-middle");
		var $panelTitle = $titleMiddle.find(".exmayui-panel-title");
		var $panelTitleWord = $titleMiddle.find(".exmayui-panel-title-word");
		var $titleRight = $titleBar.find(".exmayui-panel-title-right");

		// 内容
		var $contentLeft = $content.find(".exmayui-panel-content-left");
		var $contentMiddle = $content.find(".exmayui-panel-content-middle");
		var $contentRight = $content.find(".exmayui-panel-content-right");
		
		// 状态栏
		var $statusBar = $panel.find(".exmayui-panel-status-bar");
		var $statusLeft = $panel.find(".exmayui-panel-status-left");
		var $statusMiddle = $panel.find(".exmayui-panel-status-middle");
		var $statusRight = $panel.find(".exmayui-panel-status-right");
		
		if (data) {
			if (data.width) {
				opts.width = data.width;
			}
			if (data.height) {
				opts.height = data.height;
			}
			if (data.left != null) {
				opts.left = data.left;
			}
			if (data.top != null) {
				opts.top = data.top;
			}
		}
		if (opts.fit == true) {
			var $parent = $panel.parent();
			opts.width = $parent.width();
			opts.height = $parent.height();
		}
		if(opts.full == true) {
			opts.width = $(document.body).width();
			opts.height = $(document.body).height();
		}
		$panel.css( {
			left : opts.left,
			top : opts.top
		});
		$panel.css(opts.style);
		$panel.addClass(opts.cls);
		$titleBar.addClass(opts.headerCls);
		$content.addClass(opts.bodyCls);
		
/*		// 设置宽度
		if (!isNaN(opts.width)) {
			if ($.boxModel == true) {
				$panel.width(opts.width - ($panel.outerWidth() - $panel.width()));
				$header.width($panel.width() - ($header.outerWidth() - $header.width()));
				$body.width($panel.width() - ($body.outerWidth() - $body.width()));
			} else {
				$panel.width(opts.width);
				$header.width($panel.width());
				$body.width($panel.width());
			}
		} else {
			$panel.width("auto");
			$body.width("auto");
		}
		
		// 设置高度
		if (!isNaN(opts.height)) {
			if ($.boxModel == true) {
				$panel.height(opts.height - ($panel.outerHeight() - $panel.height()));
				$body.height($panel.height() - $header.outerHeight() - $statusBar.outerHeight()
						- ($body.outerHeight() - $body.height()));
			} else {
				$panel.height(opts.height);
				$body.height($panel.height() - $header.outerHeight() - $statusBar.outerHeight());
			}
		} else {
			$body.height("auto");
		}
		$panel.css("height", null);
		// 设置头部中间宽度
		$middle.css({
			width : $header.innerWidth() - $left.outerWidth() - $right.outerWidth()
		});
		// 设置主体内容大小
		// 需要考虑盒模型
		$contentMiddle.width($body.width() - $contentLeft.outerWidth() - $contentRight.outerWidth() - ($contentMiddle.outerWidth() - $contentMiddle.width()));
		//$body.height(win.height() - $windowTitleBar.outerHeight() - $windowStatusBar.outerHeight());
		$contentLeft.height($body.height());
		$contentMiddle.height($body.height());
		$contentRight.height($body.height());
		opts.onResize.apply($target, [ opts.width, opts.height ]);
		// 状态栏
		$statusBar.width($panel.width() - ($statusBar.outerWidth() - $statusBar.width()));
		$statusMiddle.width($statusBar.width() - $statusLeft.outerWidth() - ($statusMiddle.outerWidth() - $statusMiddle.width()) - $statusRight.outerWidth());*/
		
/*		// 设置宽度
		if (!isNaN(opts.width)){
			if ($.boxModel == true){
				$panel.width(opts.width - ($panel.outerWidth() - $panel.width()));
				$header.width($panel.width() - ($header.outerWidth() - $header.width()));
				$body.width($panel.width() - ($body.outerWidth() - $body.width()));
			} else {
				$panel.width(opts.width);
				$header.width($panel.width());
				$body.width($panel.width());
			}
		} else {
			$panel.width("auto");
			$body.width("auto");
		}
		
		// 设置高度
		if (!isNaN(opts.height)){
			if ($.boxModel == true){
				$panel.height(opts.height - ($panel.outerHeight() - $panel.height()));
				$body.height($panel.height() - $header.outerHeight() - ($body.outerHeight() - $body.height()));
			} else {
				$panel.height(opts.height);
				$body.height($panel.height() - $header.outerHeight());
			}
		} else {
			$body.height("auto");
		}
		$panel.css("height", null);*/
		
//		// jQuery 确定css方框模型（盒模型Box Model）
//		{ 
//		　　width:180px; 
//		　　height:72px; 
//		　　padding:10px; 
//		　　bording-width:5px; 
//		} 
//		if ($.boxModel == true) {
//			在W3C的严格模式下，元素的内容显示的范围是180*72px。
//			内边距和边框在180*72像素的范围之外。
//			所以整个元素的覆盖面积是：width:180 + 10*2 + 5*2 = 210px，height:72 +10*2 + 5*2 =102px。 	
//		} else { 
//			在IE的兼容模式下整个元素的覆盖面积为180*72像素。
//			内容的大小减小到宽度180 - 10*2 - 5*2=150px，高度72 - 10*2 - 5*2 =42px。		
//		}
		
		
		// 调整宽度
		if (!isNaN(opts.width)) {
			// jQuery 确定CSS方框模型（盒模型Box Model）
			if ($.support.boxModel == true) {
				$panel.width(opts.width - ($panel.outerWidth() - $panel.width()));
				// 标题栏
				$titleBar.width($panel.width() - ($titleBar.outerWidth() - $titleBar.width()));
				$titleMiddle.width($titleBar.width() - $titleLeft.outerWidth() - ($titleMiddle.outerWidth() - $titleMiddle.width()) - $titleRight.outerWidth());
				// 内容
				$content.width($panel.width() - ($content.outerWidth() - $content.width()));
				$contentMiddle.width($content.width() - $contentLeft.outerWidth() - ($contentMiddle.outerWidth() - $contentMiddle.width()) - $contentRight.outerWidth());
				// 状态栏
				$statusBar.width($panel.width() - ($statusBar.outerWidth() - $statusBar.width()));
				$statusMiddle.width($statusBar.width() - $statusLeft.outerWidth() - ($statusMiddle.outerWidth() - $statusMiddle.width()) - $statusRight.outerWidth());
			} else {
				$panel.width(opts.width);
				// 标题
				$titleBar.width($panel.width());
				$titleMiddle.width($titleBar.width() - $titleLeft.outerWidth() - $titleRight.outerWidth());
				// 内容
				$content.width($panel.width());
				$contentMiddle.width($content.width() - $contentLeft.outerWidth() - $contentRight.outerWidth());
				// 状态栏
				$statusBar.width($panel.width());
				$statusMiddle.width($statusBar.width() - $statusLeft.outerWidth() - $statusRight.outerWidth());
			}
		} else {
			$panel.width("auto");
			// 标题
			$titleBar.width("auto");
			$titleMiddle.width("auto");
			// 内容
			$content.width("auto");
			$contentMiddle.width("auto");
			// 状态栏
			$statusBar.width("auto");
			$statusMiddle.width("auto");
		}
		
		//　调整高度
		if (!isNaN(opts.height)) {
			// jQuery 确定CSS方框模型（盒模型Box Model）
			var myContent = "";
			if ($.support.boxModel == true) {
				$contentMiddle.find("iframe").height("auto");
				$panel.height(opts.height - ($panel.outerHeight() - $panel.height()));
				// 内容
				$content.height($panel.height() - $titleBar.outerHeight() - ($content.outerHeight() - $content.height()) - $statusBar.outerHeight());
				$contentLeft.height($content.height() - ($contentLeft.outerHeight() - $contentLeft.height()));
				$contentMiddle.height($content.height() -  ($contentMiddle.outerHeight() - $contentMiddle.height()));
				$contentRight.height($content.height() - ($contentRight.outerHeight() - $contentRight.height()));
			} else {
				$panel.height(opts.height);
				// 内容
				$content.css("height", null); 
				$content.height($panel.height() - $titleBar.outerHeight() - $statusBar.outerHeight());
				$contentLeft.height($content.height());
				$contentMiddle.height($content.height());
				$contentRight.height($content.height());
			}
		} else {
			$panel.height("auto");
			// 内容
			$content.height("auto");
			$contentMiddle.height("auto");
			$contentLeft.height($contentMiddle.outerHeight());
			$contentRight.height($contentMiddle.outerHeight());
		}
		$panel.css("height", null); 
		
		// IE6兼容
		/*if ($.browser.msie && ($.browser.version == "6.0") && !$.support.style) { 
			$content.css({"top": "-21px", "position": "relative"});
			$statusBar.css({"top": "-21px", "position": "relative"});
		}*/
		
		opts.onResize.apply($target, [opts.width, opts.height]);
		
		$panel.find(">div.exmayui-panel-body>div").triggerHandler("_resize");
	};

	// 移动面板
	function moveExmayPanel($target, data) {
		var opts = $target.data("exmayPanel").options;
		var $panel = $target.data("exmayPanel").exmayPanel;
		if (data) {
			if (data.left != null) {
				opts.left = data.left;
			}
			if (data.top != null) {
				opts.top = data.top;
			}
		}
		$panel.css( {
			left : opts.left,
			top : opts.top
		});
		opts.onMove.apply($target, [ opts.left, opts.top ]);
	};
	
	// 刷新面板
	function refreshExmayPanel($target, data) {
		var cache = $target.data("exmayPanel");
		if(data) {
			cache.options.url = data;
		}
		if (cache.options.url && !cache.isLoaded) {
			cache.isLoaded = false;
			var $panelBody = cache.exmayPanel.find(">.exmayui-panel-body");
			var $panelContent = $panelBody.find(".exmayui-panel-content-middle");
			var $load = $('<div class="exmayui-panel-loading"></div>').html(cache.options.loadingMessage);
			$load.appendTo($panelContent);
			var $iframe = $('<iframe id="exmay-panel-frame" name="exmay-panel-frame" width="100%" height="100%" frameborder="0" style="border: medium none;" src=""></iframe>');
			$iframe.attr("src", cache.options.url);
			
			var iframe = $iframe[0];
			
			if(exmayIsIE6) {
        		var el = document.createElement('iframe');
        			el.id = "exmay-panel-frame";
					el.width = '100%';
					el.height = '100%';
				//	el.src = 'http://www.baidu.com';
				exmaySetIframeSrc(el, opts.url);
				$contentPanel[0].appendChild(el);
        		//$iframe.attr("src", "http://www.baidu.com");
				iframe = el;
				if (iframe.attachEvent) {
					iframe.attachEvent("onload", function() {
						$load.remove();
					});
				} else {
					iframe.onload = function() {
						$load.remove();
					};
				}
			} else {
				iframe.src = cache.options.url;
				if (iframe.attachEvent) {
					iframe.attachEvent("onload", function() {
						$load.remove();
					});
				} else {
					iframe.onload = function() {
						$load.remove();
					};
				}
				$iframe.appendTo($panelContent);
			}

				cache.options.onLoad.apply($target, arguments);
				cache.isLoaded = true;

		}
	};
	
	// 打开/显示面板
	function openExmayPanel($target, data) {
		var opts = $target.data("exmayPanel").options;
		var $panel = $target.data("exmayPanel").exmayPanel;
		if (data != true) {
			if (opts.onBeforeOpen.call($target) == false) {
				return;
			}
		}
		$panel.show();
		opts.closed = false;
		opts.onOpen.call($target);
	};
	
	// 关闭/隐藏面板
	function closeExmayPanel($target, data) {
		var opts = $target.data("exmayPanel").options;
		var $panel = $target.data("exmayPanel").exmayPanel;
		if (data != true) {
			if (opts.onBeforeClose.call($target) == false) {
				return;
			}
		}
		$panel.hide();
		opts.closed = true;
		opts.onClose.call($target);
	};
	
	// 销毁/删除面板
	function destroyExmayPanel($target, data) {
		var opts = $target.data("exmayPanel").options;
		var $panel = $target.data("exmayPanel").exmayPanel;
		if (data != true) {
			if (opts.onBeforeDestroy.call($target) == false) {
				return;
			}
		}
		removeNode($panel);
		opts.onDestroy.call($target);
	};

	// 移除节点
	function removeNode(node) {
		node.each(function() {
			$(this).remove();
			if ($.browser.msie) {
				this.outerHTML = "";
			}
		});
	};

	// 收缩面板
	function collapseExmayPanel($target, data) {
		var opts = $target.data("exmayPanel").options;
		var $panel = $target.data("exmayPanel").exmayPanel;
		var body = $panel.find(">div.exmayui-panel-body");
		body.stop(true, true);
		if (opts.onBeforeCollapse.call($target) == false) {
			return;
		}
		$panel.find(">div.exmayui-panel-header .exmayui-panel-tool-collapse").addClass("exmayui-panel-tool-expand");
		if (data == true) {
			body.slideUp("normal", function() {
				opts.collapsed = true;
				opts.onCollapse.call($target);
			});
		} else {
			body.hide();
			opts.collapsed = true;
			opts.onCollapse.call($target);
		}
	};
	
	// 展开面板
	function expandExmayPanel($target, data) {
		var opts = $target.data("exmayPanel").options;
		var $panel = $target.data("exmayPanel").exmayPanel;
		var body = $panel.find(">div.exmayui-panel-body");
		body.stop(true, true);
		if (opts.onBeforeExpand.call($target) == false) {
			return;
		}
		$panel.find(">div.exmayui-panel-header .exmayui-panel-tool-collapse").removeClass("exmayui-panel-tool-expand");
		if (data == true) {
			body.slideDown("normal", function() {
				opts.collapsed = false;
				opts.onExpand.call($target);
			});
		} else {
			body.show();
			opts.collapsed = false;
			opts.onExpand.call($target);
		}
	};
	
	// 最大化面板
	function maximizeExmayPanel($target) {
		var opts = $target.data("exmayPanel").options;
		var $panel = $target.data("exmayPanel").exmayPanel;
		$panel.find(">div.exmayui-panel-header .exmayui-panel-tool-max").addClass("exmayui-panel-tool-restore");
		$target.data("exmayPanel").original = {
			width : opts.width,
			height : opts.height,
			left : opts.left,
			top : opts.top,
			fit : opts.fit
		};
		opts.left = 0;
		opts.top = 0;
		opts.fit = true;
		resizeExmayPanel($target);
		opts.minimized = false;
		opts.maximized = true;
		opts.onMaximize.call($target);
	};
	
	// 全屏化页面
	function fullScreenExmayPanel($target) {
		var opts = $target.data("exmayPanel").options;
		var $panel = $target.data("exmayPanel").exmayPanel;
		$panel.find(">div.exmayui-panel-header .exmayui-panel-tool-full-screen").addClass("exmayui-panel-tool-restore-full");
		$target.data("exmayPanel").original = {
			width : opts.width,
			height : opts.height,
			left : opts.left,
			top : opts.top,
			full : opts.full
		};
		opts.left = 0;
		opts.top = 0;
		opts.full = true;
		resizeExmayPanel($target);
		opts.minimized = false;
		opts.maximized = false;
		opts.onMaximize.call($target);
	};
	
	// 还原全屏面板
	function restoreFullExmayPanel($target) {
		var opts = $target.data("exmayPanel").options;
		var $panel = $target.data("exmayPanel").exmayPanel;
		$panel.show();
		$panel.find(">div.exmayui-panel-header .exmayui-panel-tool-full-screen").removeClass("exmayui-panel-tool-restore-full");
		var $original = $target.data("exmayPanel").original;
		opts.width = $original.width;
		opts.height = $original.height;
		opts.left = $original.left;
		opts.top = $original.top;
		opts.full = $original.full;
		resizeExmayPanel($target);
		opts.minimized = false;
		opts.maximized = false;
		opts.onRestore.call($target);
	};
	
	// 最小化面板
	function minimizeExmayPanel($target) {
		var opts = $target.data("exmayPanel").options;
		var $panel = $target.data("exmayPanel").exmayPanel;
		$(".exmayui-panel-tool", $panel).hide();
		$panel.hide();
		var $exmayTabs = $("#exmayui-tabs-minimizable-panel");
		$exmayTabs.show();
		$exmayTabs.exmayTabs('add',{
			title : opts.title,
			closable : false
		});
		$("li.exmayui-tabs-selected", $exmayTabs).bind("click", function(){
			$panel.show();
			$exmayTabs.exmayTabs('close', opts.title);
			if($("li.exmayui-tabs-selected", $exmayTabs).length == 0) {
				$exmayTabs.hide();
			}
		});
		$(".exmayui-panel-tool", $panel).show();
		opts.minimized = true;
		opts.maximized = false;
		opts.onMinimize.call($target);
	};
	
	// 还原面板
	function restoreExmayPanel($target) {
		var opts = $target.data("exmayPanel").options;
		var $panel = $target.data("exmayPanel").exmayPanel;
		$panel.show();
		$panel.find(">div.exmayui-panel-header .exmayui-panel-tool-max").removeClass("exmayui-panel-tool-restore");
		var $original = $target.data("exmayPanel").original;
		opts.width = $original.width;
		opts.height = $original.height;
		opts.left = $original.left;
		opts.top = $original.top;
		opts.fit = $original.fit;
		resizeExmayPanel($target);
		opts.minimized = false;
		opts.maximized = false;
		opts.onRestore.call($target);
	};
	
	// 设置面板边框
	function setPanelBorder($target) {
		var opts = $target.data("exmayPanel").options;
		var $panel = $target.data("exmayPanel").exmayPanel;
		if (opts.border == true) {
			$panel.find(">div.exmayui-panel-header").removeClass("exmayui-panel-header-noborder");
			$panel.find(">div.exmayui-panel-body").removeClass("exmayui-panel-body-noborder");
		} else {
			$panel.find(">div.exmayui-panel-header").addClass("exmayui-panel-header-noborder");
			$panel.find(">div.exmayui-panel-body").addClass("exmayui-panel-body-noborder");
		}
	};
	
	// 设置面板标题
	function setPanelTitle($target, data) {
		$target.data("exmayPanel").options.title = data;
		$target.exmayExmayPanel("header").find("span.exmayui-panel-title-word").html(data);
	};
	
	// 面板插件定义
    $.fn.exmayPanel = function(options, data) {
        if (typeof options == "string") {
            return $.fn.exmayPanel.methods[options](this, data);
        }
        options = options || {};
        return this.each(function() {
			var $this = $(this);
            var cache = $this.data("exmayPanel");
            var opts;
            if (cache) {
                opts = $.extend(cache.options, options);
                cache.options = opts;
           	} else {
                opts = $.extend({}, $.fn.exmayPanel.defaults, $.fn.exmayPanel.parseOptions(this), options);
                cache = $this.data("exmayPanel", {
                    options: opts,
                    exmayPanel: initExmayPanel($this),
                    isLoaded: false
                });
	            if (opts.content) {
	                $(this).html(opts.content);
	                if ($.exmayParser) {
	                    $.exmayParser.parse(this);
	                }
	            }
	            initExmayPanelHeader($this);
				initExmayPanelBody($this);
				initExmayPanelFooter($this);
	            setPanelBorder($this);
	            refreshExmayPanel($this);
            }
            if (opts.doSize == true) {
                $this.data("exmayPanel").exmayPanel.css("display", "block");
                resizeExmayPanel($this);
            }
            if (opts.closed == true || opts.minimized == true) {
                $this.data("exmayPanel").exmayPanel.hide();
            } else {
                openExmayPanel($this);
            }
        });
    };
	
	// 面板方法
    $.fn.exmayPanel.methods = {
        options: function(target) {
            return $(target).data("exmayPanel").options;
        },
		// 面板
        exmayPanel: function(target) {
            return $(target).data("exmayPanel").exmayPanel;
        },
        header: function($target) {
            return $target.data("exmayPanel").exmayPanel.find(">div.exmayui-panel-header");
        },
        body: function($target) {
            return $target.data("exmayPanel").exmayPanel.find(">div.exmayui-panel-body");
        },
        setTitle: function($target, data) {
            return $target.each(function() {
                setPanelTitle($(this), data);
            });
        },
		// 打开面板
        open: function($target, data) {
            return $target.each(function() {
                openExmayPanel($(this), data);
            });
        },
		// 关闭面板
        close: function($target, data) {
            return $target.each(function() {
                closeExmayPanel($(this), data);
            });
        },
        // 销毁面板
        destroy: function($target, data) {
            return $target.each(function() {
                destroyExmayPanel($(this), data);
            });
        },
        // 刷新面板
        refresh: function($target, data) {
            return $target.each(function() {
               $(this).data("exmayPanel").isLoaded = false;
                refreshExmayPanel($(this), data);
            });
        },
		// 设置面板大小
        resize: function(target, data) {
            return target.each(function() {
                resizeExmayPanel($(this), data);
            });
        },
        // 移动面板
        move: function(target, data) {
            return target.each(function() {
                moveExmayPanel($(this), data);
            });
        },
        maximize: function($target) {
            return $target.each(function() {
                maximizeExmayPanel($(this));
            });
        },
        minimize: function($target) {
            return $target.each(function() {
                minimizeExmayPanel($(this));
            });
        },
        restore: function($target) {
            return $target.each(function() {
                	($(this));
            });
        },
        collapse: function($target, data) {
            return $target.each(function() {
                collapseExmayPanel($(this), data);
            });
        },
        expand: function($target, data) {
            return $target.each(function() {
                expandExmayPanel($(this), data);
            });
        }
    };
	
	// 解析面板选项
    $.fn.exmayPanel.parseOptions = function(target) {
        var $target = $(target);
        return {
            width: (parseInt(target.style.width) || undefined),
            height: (parseInt(target.style.height) || undefined),
            left: (parseInt(target.style.left) || undefined),
            top: (parseInt(target.style.top) || undefined),
            title: ($target.attr("title") || undefined),
            icon: ($target.attr("icon") || $target.attr("icon")),
            cls: $target.attr("cls"),
            headerCls: $target.attr("headerCls"),
            bodyCls: $target.attr("bodyCls"),
            url: $target.attr("url"),
            cache: ($target.attr("cache") ? $target.attr("cache") == "true": undefined),
            fit: ($target.attr("fit") ? $target.attr("fit") == "true": undefined),
            border: ($target.attr("border") ? $target.attr("border") == "true": undefined),
            noheader: ($target.attr("noheader") ? $target.attr("noheader") == "true": undefined),
            collapsible: ($target.attr("collapsible") ? $target.attr("collapsible") == "true": undefined),
            minimizable: ($target.attr("minimizable") ? $target.attr("minimizable") == "true": undefined),
            maximizable: ($target.attr("maximizable") ? $target.attr("maximizable") == "true": undefined),
            closable: ($target.attr("closable") ? $target.attr("closable") == "true": undefined),
            collapsed: ($target.attr("collapsed") ? $target.attr("collapsed") == "true": undefined),
            minimized: ($target.attr("minimized") ? $target.attr("minimized") == "true": undefined),
            maximized: ($target.attr("maximized") ? $target.attr("maximized") == "true": undefined),
			fullScreen: ($target.attr("fullScreen") ? $target.attr("fullScreen") == "true": undefined),
            closed: ($target.attr("closed") ? $target.attr("closed") == "true": undefined)
        };
    };
	
	// 面板参数
    $.fn.exmayPanel.defaults = {
        title: null,
        icon: null,
        width: "auto",
        height: "auto",
        left: null,
        top: null,
        cls: null,
        headerCls: null,
        bodyCls: null,
        style: {},
        url: null, // 链接
        cache: true,
        fit: false,
		full: false,
        border: true,
        doSize: true,
        noheader: false,
        content: null,
        collapsible: false,
        minimizable: false,
        maximizable: false,
        closable: false,
        collapsed: false,
        minimized: false,
        maximized: false,
		fullScreen : false,
        closed: false,
        tools: [],
        loadingMessage: "数据加载中...",
        onLoad: function() {},
        onBeforeOpen: function() {},
        onOpen: function() {},
        onBeforeClose: function() {},
        onClose: function() {},
        onBeforeDestroy: function() {},
        onDestroy: function() {},
		onResize : function(width, height) {},
		onMove : function(left, top) {},
        onMaximize: function() {},
        onRestore: function() {},
        onMinimize: function() {},
        onBeforeCollapse: function() {},
        onBeforeExpand: function() {},
        onCollapse: function() {},
        onExpand: function() {}
    };
	
})(jQuery);