/**
 *************************************************************************************
 * [标题：ExmayUI JQuery Radio 插件]<br>
 *************************************************************************************
 * [描述：ExmayUI JQuery Radio 插件]<br>
 *************************************************************************************
 * @author Exmay Team / 亿美团队
 *************************************************************************************
 * @version Version 1.0.1 Beta / v1.0.1 测试版
 *************************************************************************************
 */

/*
 * ***********************************************************************************
 * 版权：Copyright © 2012 Exmay Inc. All Rights Reserved. 长沙亿美软件有限公司　版权所有
 * ***********************************************************************************
 * 企业文化：专注　创新　分享　共赢
 * ***********************************************************************************
 * 官方网站：http://www.exmay.com
 * ***********************************************************************************
 * 官方邮箱：service@exmay.com
 * ***********************************************************************************
 */

(function($) {
	
	function initCheckbox(obj, opts) {
		$(obj).hide();
		var $radio = $('<span class="exmayui-radio-icon"></span>');
		$radio.addClass("exmayui-radio-unchecked");
		$radio.insertBefore($(obj));
		if($(obj).attr("id")) {
			$("label[for='" + $(obj).attr("id") + "']").addClass("exmayui-radio-text");
		}
		if($(obj).attr("checked")){
			$radio.removeClass("exmayui-radio-unchecked").addClass("exmayui-radio-checked");
		}
		if(opts.disabled) {
			$radio.addClass("exmayui-radio-disabled");
		}
	};
	
	function radioEvent(obj) {
		var $target = $(obj);
		var opts = $target.data("radio").options;
		
		// 单选框
		$(obj).bind("change.exmayRadio", function() {
			$(obj).prev(".exmayui-radio-icon").trigger("click");
		});
		
		// 单选图标
		$(obj).prev(".exmayui-radio-icon").bind("click.exmayRadio", function() {
			// 取消全部单选
			$('input[name="' + $(obj).attr("name") + '"]').removeAttr("checked");
			$('input[name="' + $(obj).attr("name") + '"]').prev(".exmayui-radio-icon").removeClass("exmayui-radio-checked").addClass("exmayui-radio-unchecked");
			// 单选
			if($(this).hasClass("exmayui-radio-checked")) {
				$(this).removeClass("exmayui-radio-checked").addClass("exmayui-radio-unchecked");
				$(obj).removeAttr("checked");
			} else {
				$(this).removeClass("exmayui-radio-unchecked").addClass("exmayui-radio-checked");
				$(obj).attr("checked", true);
				if(opts.onClick) {
					opts.onClick.call(obj);
				}
			}
		});
		
		// 单选框文本
		$(obj).next(".exmayui-radio-text").bind("click.exmayRadio", function(){
			$(obj).prev(".exmayui-radio-icon").trigger("click");
		});
		
	};
	
	function getOptions(obj) {
		var $target = $(obj);
		return {
			disabled :($target.attr("disabled") ? $target.attr("disabled") == "true": undefined)
		};
	};
	
	// 取出选中
	function getChecked(name) {
		var value = $("input[type='radio'][name='" + name +"']:checked").val();
		var text = $("input[type='radio'][name='" + name +"']:checked").next(".exmayui-radio-text").text();
		return {
			value : value, 
			text : text
		};
	};
	
	// 设置选中
	function setChecked(obj) {
		$(obj).attr("checked", true);
		$(obj).trigger("change");
	};
	
	// 启用
	function enableRadio(obj) {
		$(obj).removeAttr("disabled");
		$(obj).prev(".exmayui-radio-icon").removeClass("exmayui-radio-disabled");
		radioEvent(obj);
	};
	
	// 禁用
	function disableRadio(obj) {
		$(obj).attr("disabled", true);
		$(obj).prev(".exmayui-radio-icon").addClass("exmayui-radio-disabled");
		$(obj).unbind(".exmayRadio");
		$(obj).prev(".exmayui-radio-icon").unbind(".exmayRadio");
		$(obj).next(".exmayui-radio-text").unbind(".exmayRadio");
		
	};
	
	//  
	// 插件的定义
	//  
	$.fn.exmayRadio = function(options, data) {
		if (typeof options == "string"){
			switch(options){
				case "getChecked" : //　选中
					return getChecked(data);
				case "setChecked" : // 设选中
					return setChecked(this);
				case "enable" :
					return enableRadio(this);
				case "disable" :
					return disableRadio(this);
			}
		}
		
		//
		// 插件主方法
		//
		return this.each(function() {
			$this = $(this);    
			// 定义选项
			var opts = null;
			// 将数据缓存赋值给缓存
			var cache = $this.data("radio");
			// 如果数据已缓存
			if (cache) {
				// 删除绑定的事件
				//cache.unbind(".exmayRadio");
				// 通过数据缓存为选项赋值
				opts = $.extend(cache.options, options || {});
				cache.options = opts;
			} else {
				// 重新初始化选项
				opts = $.extend( {}, $.fn.exmayRadio.defaults, getOptions(this), options || {});
				// 初始化
				initCheckbox(this, opts);
				// 对数据进行缓存
				$this.data("radio", {options : opts} );
				if(!opts.disabled) {
					radioEvent(this);
				}
				if($this.attr("value") == $this.attr("default")) {
					setChecked(this);
				}
			}
		});
	};
	
	//  
	// 插件的defaults
	//  
	$.fn.exmayRadio.defaults = {
		disabled : false,
		onClick : function(){}
	};
	
})(jQuery);
//
// radio插件
// 结束
//