/**
 *************************************************************************************
 * [标题：ExmayUI JQuery Resizable 插件]<br>
 *************************************************************************************
 * [描述：ExmayUI JQuery Resizable 插件]<br>
 *************************************************************************************
 * @author Exmay Team / 亿美团队
 *************************************************************************************
 * @version Version 1.0.1 Beta / v1.0.1 测试版
 *************************************************************************************
 */

/*
 * ***********************************************************************************
 * 版权：Copyright © 2012 Exmay Inc. All Rights Reserved. 长沙亿美软件有限公司　版权所有
 * ***********************************************************************************
 * 企业文化：专注　创新　分享　共赢
 * ***********************************************************************************
 * 官方网站：http://www.exmay.com
 * ***********************************************************************************
 * 官方邮箱：service@exmay.com
 * ***********************************************************************************
 */

(function($){
	
	$.fn.exmayResizable = function(options){
		
		function exmayResize(e){
			var resizeData = e.data;
			var options = $(resizeData.target).data("exmayResizable").options;
			if (resizeData.direction.indexOf("e") != -1) {
				var width = resizeData.startWidth + e.pageX - resizeData.startX;
				width = Math.min(Math.max(width, options.minWidth), options.maxWidth);
				resizeData.width = width;
			}
			if (resizeData.direction.indexOf("s") != -1) {
				var height = resizeData.startHeight + e.pageY - resizeData.startY;
				height = Math.min(Math.max(height, options.minHeight), options.maxHeight
				);
				resizeData.height = height;
			}
			if (resizeData.direction.indexOf("w") != -1) {
				resizeData.width = resizeData.startWidth - e.pageX + resizeData.startX;
				if (resizeData.width >= options.minWidth && resizeData.width <= options.maxWidth) {
					resizeData.left = resizeData.startLeft + e.pageX - resizeData.startX;
				}
			}
			if (resizeData.direction.indexOf("n") != -1) {
				resizeData.height = resizeData.startHeight - e.pageY + resizeData.startY;
				if (resizeData.height >= options.minHeight && resizeData.height <= options.maxHeight) {
					resizeData.top = resizeData.startTop + e.pageY - resizeData.startY;
				}
			}
		}
		
		function exmayApplySize(e){
			var resizeData = e.data;
			var target = resizeData.target;
			if ($.boxModel == true){
				$(target).css({
					width: resizeData.width - resizeData.deltaWidth,
					height: resizeData.height - resizeData.deltaHeight,
					left: resizeData.left,
					top: resizeData.top
				});
			} else {
				$(target).css({
					width: resizeData.width,
					height: resizeData.height,
					left: resizeData.left,
					top: resizeData.top
				});
			}
		}
		
		function exmayDoDown(e){
			$(e.data.target).data("exmayResizable").options.onStartResize.call(e.data.target, e);
			return false;
		}
		
		function exmayDoMove(e){
			exmayResize(e);
			if ($(e.data.target).data("exmayResizable").options.onResize.call(e.data.target, e) != false){
				exmayApplySize(e)
			}
			return false;
		}
		
		function exmayDoUp(e){
			exmayResize(e, true);
			exmayApplySize(e);
			$(document).unbind(".exmayResizable");
			$(e.data.target).data("exmayResizable").options.onStopResize.call(e.data.target, e);
			return false;
		}
		
		return this.each(function(){
			var opts = null;
			var state = $(this).data("exmayResizable");
			if (state) {
				$(this).unbind(".exmayResizable");
				opts = $.extend(state.options, options || {});
			} else {
				opts = $.extend({}, $.fn.exmayResizable.defaults, options || {});
			}
			
			if (opts.disabled == true) {
				return;
			}
			
			$(this).data("exmayResizable", {options: opts});
			
			var target = this;
			
			$(this).bind("mousemove.exmayResizable", exmayOnMouseMove).bind("mousedown.exmayResizable", exmayOnMouseDown);
			
			function exmayOnMouseMove(e) {
				var direction = exmayGetDirection(e);
				if (direction == "") {
					$(target).css("cursor", "default");
				} else {
					$(target).css("cursor", direction + "-resize");
				}
			}
			
			function exmayOnMouseDown(e) {
				var direction = exmayGetDirection(e);
				if (direction == "") return;
				
				var data = {
					target: this,
					direction: direction,
					startLeft: exmayGetCssValue("left"),
					startTop: exmayGetCssValue("top"),
					left: exmayGetCssValue("left"),
					top: exmayGetCssValue("top"),
					startX: e.pageX,
					startY: e.pageY,
					startWidth: $(target).outerWidth(),
					startHeight: $(target).outerHeight(),
					width: $(target).outerWidth(),
					height: $(target).outerHeight(),
					deltaWidth: $(target).outerWidth() - $(target).width(),
					deltaHeight: $(target).outerHeight() - $(target).height()
				};
				$(document).bind("mousedown.exmayResizable", data, exmayDoDown);
				$(document).bind("mousemove.exmayResizable", data, exmayDoMove);
				$(document).bind("mouseup.exmayResizable", data, exmayDoUp);
			}
			
			function exmayGetDirection(e) {
				var direction = "";
				var offset = $(target).offset();
				var width = $(target).outerWidth();
				var height = $(target).outerHeight();
				var edge = opts.edge;
				if (e.pageY > offset.top && e.pageY < offset.top + edge) {
					direction += "n";
				} else if (e.pageY < offset.top + height && e.pageY > offset.top + height - edge) {
					direction += "s";
				}
				if (e.pageX > offset.left && e.pageX < offset.left + edge) {
					direction += "w";
				} else if (e.pageX < offset.left + width && e.pageX > offset.left + width - edge) {
					direction += "e";
				}
				
				var handles = opts.handles.split(",");
				for(var i=0; i<handles.length; i++) {
					var handle = handles[i].replace(/(^\s*)|(\s*$)/g, "");
					if (handle == "all" || handle == direction) {
						return direction;
					}
				}
				return "";
			}
			
			function exmayGetCssValue(css) {
				var val = parseInt($(target).css(css));
				if (isNaN(val)) {
					return 0;
				} else {
					return val;
				}
			}
			
		});
	};
	
	$.fn.exmayResizable.defaults = {
			disabled:false,
			handles:"n, e, s, w, ne, se, sw, nw, all",
			minWidth: 10,
			minHeight: 10,
			maxWidth: 10000, 
			maxHeight: 10000, 
			edge:5,
			onStartResize: function(e){},
			onResize: function(e){},
			onStopResize: function(e){}
	};
	
})(jQuery);