/**
 *************************************************************************************
 * [标题：ExmayUI JQuery Sortable 插件]<br>
 *************************************************************************************
 * [描述：ExmayUI JQuery Sortable 插件]<br>
 *************************************************************************************
 * @author Exmay Team / 亿美团队
 *************************************************************************************
 * @version Version 1.0.1 Beta / v1.0.1 测试版
 *************************************************************************************
 */

/*
 * ***********************************************************************************
 * 版权：Copyright © 2012 Exmay Inc. All Rights Reserved. 长沙亿美软件有限公司　版权所有
 * ***********************************************************************************
 * 企业文化：专注　创新　分享　共赢
 * ***********************************************************************************
 * 官方网站：http://www.exmay.com
 * ***********************************************************************************
 * 官方邮箱：service@exmay.com
 * ***********************************************************************************
 */

(function($) {

	function initExmaySortable(target) {
		var $target = $(target);
		//var opts = $target.data("exmaySortable").options;
		var indicator = $('<tr><td style="border-top:2px dashed #FFF000;height:2px;" colspan="6"></td></tr>');
		$target.exmayDraggable( {
			revert : true,
			handle : ".exmay-ui-sortable",
			deltaX : 0,
			deltaY : 0,
			proxy : "clone"
		}).exmayDroppable( {
			onDragOver : function(e, source) {
				//indicator = $(source).empty();
				indicator.insertAfter(this);
				indicator.show();
				$(".exmayui-selectable").exmaySelectable({checkbox : true});
			},
			onDragLeave : function(e, source) {
				indicator.hide();
			},
			onDrop : function(e, source) {
				$(source).insertAfter(this);
				indicator.hide();
				var id = $(source).attr("id");
				var targetId = $(e.target).attr("id");
				$.ajax( {
					url : opts.url,
					type : "post",
					dataType : "json",
					data : {
						ajax : true,
						id : id,
						targetId : targetId
					},
					timeout : 20000,// 设置请求超时时间（毫秒）。
					error : function() { // 请求失败时调用函数。
						$.exmayMessagebox.alert("排序", "请求失败!", "error");
					},
					success : function(data) {
						$.exmayMessagebox.alert("排序", "排序成功!", "info",function(ok){
							if(ok) {
								window.location.reload();
							}
						});
					}
				});
				$(".exmayui-selectable").exmaySelectable({checkbox : false});
			}
		});
	}

	$.fn.exmaySortable = function(options) {
		if (typeof options == "string") {
			return $.fn.exmaySortable.methods[options](this, data);
		}
		options = options || {};
		return this.each(function() {
			var $this = $(this);
			var cache = $this.data("exmaySortable");
			if (cache) {
				$.extend(cache.options, options);
			} else {
				$this.data("exmaySortable", {
					options : $.extend( {}, $.fn.exmaySortable.defaults, options)
				});
				initExmaySortable(this);
			}
		});
	};

	$.fn.exmaySortable.methods = {};

	$.fn.exmaySortable.defaults = {
		url:"${adminPath}/privilege/menu/sort/",
		accepter : ".exmay-ui-sortable",
		target : ".exmay-ui-sortable-item",
		handle : ".exmay-ui-sortable",
		beforDrag : function(e) {
		},
		onDrag : function(e) {
		},
		onDrop : function(e) {
		}
	};

})(jQuery)