﻿/**
 *************************************************************************************
 * [标题：ExmayUI JQuery Tabs 插件]<br>
 *************************************************************************************
 * [描述：ExmayUI JQuery Tabs 插件]<br>
 *************************************************************************************
 * @author Exmay Team / 亿美团队
 *************************************************************************************
 * @version Version 1.0.1 Beta / v1.0.1 测试版
 *************************************************************************************
 */

/*
 * ***********************************************************************************
 * 版权：Copyright © 2012 Exmay Inc. All Rights Reserved. 长沙亿美软件有限公司　版权所有
 * ***********************************************************************************
 * 企业文化：专注　创新　分享　共赢
 * ***********************************************************************************
 * 官方网站：http://www.exmay.com
 * ***********************************************************************************
 * 官方邮箱：service@exmay.com
 * ***********************************************************************************
 */

//
//jQuery ExmayUI Tabs(选项卡)插件 开始
//
(function($) {

	// 初始化所有选项卡
	function initExmayTabs(target) {
		var opts = $(target).data("exmayTabs").options;
		// 兼容美观
		$(target).css({display : "block"});
		
		// 定义选项卡元素
		var $tabsHeader = $('<div class="exmayui-tabs-header"></div>');
		var $tabsPrevious = $('<div class="exmayui-tabs-scroller-previous"></div>');
		var $tabsNext = $('<div class="exmayui-tabs-scroller-next"></div>');
		var $tabsWrap = $('<div class="exmayui-tabs-wrap"></div>');
		var $tabsList = $('<ul class="exmayui-tabs-list"></ul>');
		
		// 组装选项卡
		$(target).wrapInner($('<div class="exmayui-tabs-panels"></div>'));
		$tabsPrevious.appendTo($tabsHeader);
		$tabsList.appendTo($tabsWrap);
		$tabsWrap.appendTo($tabsHeader);
		$tabsNext.appendTo($tabsHeader);
		$tabsHeader.prependTo($(target));
		
		// 遍历所有选项卡
		$(">div.exmayui-tabs-panels>div", target).each(function() {
			
			// 如果选项卡没有ID，则生成一个ID
			if (!$(this).attr("id")) {
				$(this).attr("id", "exmay-tab-panel-" + $.fn.exmayTabs.defaults.idSeed++);
			}
			
			// 缓存选项卡数据
			var data = {
				id : $(this).attr("id"),
				title : $(this).attr("title"),
				alt : $(this).attr("alt"),
				content : null,
				href : $(this).attr("href"),
				closable : $(this).attr("closable") == "true",
				icon : $(this).attr("icon"),
				selected : $(this).attr("selected") == "true",
				cache : $(this).attr("cache") == "false" ? false : true,
				json : $(this).attr("json")
			};
			
			// 清除标题
			$(this).attr("title", "");
			
			// 初始化单个选项卡
			var $tab = initTab(target, data);
			var $top = $('<span class="exmay-ui-top-bg"><span></span> </span>');
			$top.width($tab.outerWidth());
			$tab.prepend($top);
			
		});
		
		//  圆角效果
		if(opts.rounded) {
			var $top = $('<span class="exmay-ui-top-bg"><span></span> </span>');
			var $bottom = $('<span class="exmay-ui-bottom-bg"><span></span> </span>');
			$(target).prepend($top);
			$(target).append($bottom);
		}
		
		// 前一个、后一个鼠标停留与离开事件
		$(".exmayui-tabs-scroller-previous, .exmayui-tabs-scroller-next", $tabsHeader).hover(function() {
			$(this).addClass("exmayui-tabs-scroller-over");
		}, function() {
			$(this).removeClass("exmayui-tabs-scroller-over");
		});
		
		// 窗口大小调整时事件
		$(target).bind("_resize", function() {
			var opts = $(target).data("exmayTabs").options;
			// 自适应父容器
			if (opts.fit == true) {
				exmayResizeTabs(target);
				resizeTab(target);
			}
			return false;
		});
		
	};
	
	// 初始化单个选项卡
	function initTab(target, data) {
		
		// 定义单个选项卡元素
		var $tabsHeader = $(">div.exmayui-tabs-header", target);
		var $tabsList = $("ul.exmayui-tabs-list", $tabsHeader);
		var $tabTitle = $("<li></li>");
		var $inner = $('<a class="exmayui-tabs-inner" href="javascript:;"></a>');
		var $title = $("<span></span>").html(data.title);
		
		// 组装单个选项卡
		$title.appendTo($inner);
		$inner.appendTo($tabTitle);
		$tabTitle.appendTo($tabsList);
		
		// JSON
		if(data.json) {
			$tabTitle.attr("json", data.json);
		}
		
		// 提示
		if(data.alt) {
			$title.attr("title", data.alt);
		}
		
		// 可关闭
		if (data.closable) {
			$title.addClass("exmayui-tabs-closable");
			$inner.after('<a href="javascript:;" class="exmayui-tabs-close"></a>');
		}
		
		// 有图标
		if (data.icon) {
			$title.addClass("exmayui-tabs-with-icon");
			$title.after($("<span/>").addClass("exmayui-tabs-icon").addClass(data.icon));
		}
		
		if(data.id) {
			$tabTitle.attr("id", data.id + "-tab");
		}
		
		// 已选中
		if (data.selected) {
			$tabTitle.addClass("exmayui-tabs-selected");
		}
		
		// 内容
		if (data.content) {
			$("#" + data.id).html(data.content);
		}
		
		// 移除标题
		$("#" + data.id).removeAttr("title");
		
		// 缓存数据
		$tabTitle.data("tabs.tab", {
			id : data.id,
			title : data.title,
			href : data.href,
			loaded : false,
			cache : data.cache
		});
		
		return $tabTitle;
		
	};
	
	// 调整选项卡大小
	function exmayResizeTabs(target) {
		var opts = $(target).data("exmayTabs").options;
		var $tabsHeader = $(">div.exmayui-tabs-header", target);
		var $tabsPanel = $(">div.exmayui-tabs-panels", target);
		// 自适应父容器
		if (opts.fit == true) {
			var $parent = $(target).parent();
			opts.width = $parent.width();
			opts.height = $parent.height();
		}
		
		var tabsWidth = opts.width;
		var tabsHeight = opts.height;
		
		// 为选项卡重新设宽度与高度
		$(target).width(opts.width).height(opts.height);
		
		// 选项卡标题宽度
		// 判断浏览器是否支持盒模型
		if ($.boxModel == true) {
			var titlesWidth = $tabsHeader.outerWidth() - $tabsHeader.width();
			$tabsHeader.width($(target).width() - titlesWidth);
		} else {
			$tabsHeader.width($(target).width());
		}
		
		if(opts.axis == "vertical") {
			$tabsHeader.css({"float": "left"});
			//$tabsPanel.css({float:"left"});
			$tabsHeader.width(146);
			// 判断浏览器是否支持盒模型
			if ($.boxModel == true) {
				var titlesHeight = $tabsHeader.outerHeight() - $tabsHeader.height();
				$tabsHeader.height($(target).height() - titlesHeight);
			} else {
				$tabsHeader.width($(target).height());
			}	
		}
		// 处理选项卡滚动条
		handleTabsScroller(target);
		
		// 选项卡内容宽度处理
		if (!isNaN(tabsWidth)) {
			if ($.boxModel == true) {
				var titlesWidth = $tabsPanel.outerWidth() - $tabsPanel.width();
			} else {
				$tabsPanel.width(tabsWidth);
			}
		} else {
			$tabsPanel.width("auto");
		}
		
		// 选项卡内容高度处理
		if (!isNaN(tabsHeight)) {
			if ($.boxModel == true) {
				var titlesWidth = $tabsPanel.outerHeight() - $tabsPanel.height();
				$tabsPanel.css("height", (tabsHeight - $tabsHeader.outerHeight() - titlesWidth) || "auto");
			} else {
				$tabsPanel.css("height", tabsHeight - $tabsHeader.outerHeight());
			}
		} else {
			$tabsPanel.height("auto");
		}
		
//		if(opts.axis == "vertical") {
//			$tabsPanel.addClass("exmayui-tabs-vertical-panels");
//		} else {
//			$tabsPanel.addClass("exmayui-tabs-horizontal-panels");
//		}
		
		if(opts.axis == "vertical") {
			$(">div.exmayui-tabs-wrap", $tabsHeader).css({clear:"both", width:146, top:0});
			$("ul.exmayui-tabs-list", $tabsHeader).css({width:140, height:"auto"});
			$("ul.exmayui-tabs-list>li", $tabsHeader).css({width:140});
			$tabsPanel.width(352);
			$tabsPanel.height(247);
			$(".exmayui-tabs-inner", $tabsHeader).width(120);
		}
		
		// 横向纵向
		if(opts.axis == "vertical") {
			$(".exmayui-tabs-scrolling", $tabsHeader).addClass("exmayui-tabs-vertical-scrolling");
			$(".exmayui-tabs-scroller-previous", $tabsHeader).addClass("exmayui-tabs-vertical-scroller-previous");
			$(".exmayui-tabs-scroller-next", $tabsHeader).addClass("exmayui-tabs-vertical-scroller-next");
			if(opts.display == "reverse") {
				$tabsPanel.addClass("exmayui-tabs-vertical-reverse-panels");
				$tabsHeader.addClass("exmayui-tabs-vertical-reverse-header");
				$("ul.exmayui-tabs-list", $tabsHeader).addClass("exmayui-tabs-vertical-reverse-list");
			} else {
				$tabsPanel.addClass("exmayui-tabs-vertical-forward-panels");
				$tabsHeader.addClass("exmayui-tabs-vertical-forward-header");
				$("ul.exmayui-tabs-list", $tabsHeader).addClass("exmayui-tabs-vertical-forward-list");
			}
		} else {
			//$(".exmayui-tabs-scrolling", $tabsHeader).addClass("exmayui-tabs-horizontal-scrolling");
			$(".exmayui-tabs-scroller-previous", $tabsHeader).addClass("exmayui-tabs-horizontal-scroller-previous");
			$(".exmayui-tabs-scroller-next", $tabsHeader).addClass("exmayui-tabs-horizontal-scroller-next");
			if(opts.display == "reverse") {
				$tabsPanel.addClass("exmayui-tabs-horizontal-reverse-panels");
				$tabsHeader.addClass("exmayui-tabs-horizontal-reverse-header");
				$("ul.exmayui-tabs-list", $tabsHeader).addClass("exmayui-tabs-horizontal-reverse-list");
			} else {
				$tabsPanel.addClass("exmayui-tabs-horizontal-forward-panels");
				$tabsHeader.addClass("exmayui-tabs-horizontal-forward-header");
				$("ul.exmayui-tabs-list", $tabsHeader).addClass("exmayui-tabs-horizontal-forward-list");
			}
		}
		
		// 重新解析对象
		if ($.exmayParser) {
			//$.exmayParser.parse(target);
		}
		
	};
	
	// 调整单个选项卡大小
	function resizeTab(target) {
		var $tab = $(">div.exmayui-tabs-header ul.exmayui-tabs-list li.exmayui-tabs-selected", target);
		if ($tab.length) {
			var id = $tab.data("tabs.tab").id;
			var $tabContent = $("#" + id);
			var $tabPanel = $(">div.exmayui-tabs-panels", target);
			if ($tabPanel.css("height").toLowerCase() != "auto") {
				if ($.boxModel == true) {
					$tabContent.height($tabPanel.height() - ($tabContent.outerHeight() - $tabContent.height()));
					//$tabContent.width($tabPanel.width() - ($tabContent.outerWidth() - $tabContent.width()));
				} else {
					$tabContent.height($tabPanel.height());
					//$tabContent.width($tabPanel.width());
				}
			}
			$(">div", $tabContent).triggerHandler("_resize");
		}
	};
	
	// 选项卡滚动条详细处理
	function handleTabsScroller(target) {
		var opts = $(target).data("exmayTabs").options;
		var $tabsHeader = $(">div.exmayui-tabs-header", target);
		// 纵向选项卡
		if(opts.axis == "vertical") {
			var tabsHeight = 0;
			$("ul.exmayui-tabs-list li", $tabsHeader).each(function() {
				tabsHeight += $(this).outerHeight(true);
			});
			if (tabsHeight > $tabsHeader.height()) {
				$(".exmayui-tabs-scroller-previous", $tabsHeader).css("display", "block");
				$(".exmayui-tabs-scroller-next", $tabsHeader).css("display", "block");
				$(".exmayui-tabs-wrap", $tabsHeader).addClass("exmayui-tabs-scrolling");
				if ($.boxModel == true) {
					$(".exmayui-tabs-wrap", $tabsHeader).css("left", 2);
				} else {
					$(".exmayui-tabs-wrap", $tabsHeader).css("left", 0);
				}
				var titlesHeight = $tabsHeader.height() - $(".exmayui-tabs-scroller-previous", $tabsHeader).outerHeight() - $(".exmayui-tabs-scroller-next", $tabsHeader).outerHeight();
				$(".exmayui-tabs-wrap", $tabsHeader).height(titlesHeight);
			} else {
				$(".exmayui-tabs-scroller-previous", $tabsHeader).css("display", "none");
				$(".exmayui-tabs-scroller-next", $tabsHeader).css("display", "none");	
				$(".exmayui-tabs-wrap", $tabsHeader).removeClass("exmayui-tabs-scrolling").scrollTop(0);
				$(".exmayui-tabs-wrap", $tabsHeader).height($tabsHeader.height());
				$(".exmayui-tabs-wrap", $tabsHeader).css("top", 0);
			}
		} else { // 横向选项卡
			var tabsWidth = 0;
			$("ul.exmayui-tabs-list li", $tabsHeader).each(function() {
				tabsWidth += $(this).outerWidth(true);
			});
			if (tabsWidth > $tabsHeader.width()) {
				$(".exmayui-tabs-scroller-previous", $tabsHeader).css("display", "block");
				$(".exmayui-tabs-scroller-next", $tabsHeader).css("display", "block");
				$(".exmayui-tabs-wrap", $tabsHeader).addClass("exmayui-tabs-scrolling");
				if ($.boxModel == true) {
					var width = $(".exmayui-tabs-wrap").width();
					$(".exmayui-tabs-wrap", $tabsHeader).css("left", 2);
				} else {
					$(".exmayui-tabs-wrap", $tabsHeader).css("left", 0);
				}
				var titlesWidth = $tabsHeader.width() - $(".exmayui-tabs-scroller-previous", $tabsHeader).outerWidth() - $(".exmayui-tabs-scroller-next", $tabsHeader).outerWidth();
				$(".exmayui-tabs-wrap", $tabsHeader).width(titlesWidth);
			} else {
				$(".exmayui-tabs-scroller-previous", $tabsHeader).css("display", "none");
				$(".exmayui-tabs-scroller-next", $tabsHeader).css("display", "none");
				$(".exmayui-tabs-wrap", $tabsHeader).removeClass("exmayui-tabs-scrolling").scrollLeft(0);
				$(".exmayui-tabs-wrap", $tabsHeader).width($tabsHeader.width());
				$(".exmayui-tabs-wrap", $tabsHeader).css("left", 0);
			}
		}
	};
	
	// 方向调整
	function setDirection(target) {
		var opts = $(target).data("exmayTabs").options;
		var $tabsHeader = $(">div.exmayui-tabs-header", target);
		var $tabsPanel = $(">div.exmayui-tabs-panels", target);
		if(opts.display == "reverse") {
			$tabsPanel.after($tabsHeader);
			//$tabsPanel.hide();
		}
	};
	
	// 事件绑定
	function bindExmayTabsEvents(target) {
		var opts = $(target).data("exmayTabs").options;
		var $tabsHeader = $(">div.exmayui-tabs-header", target);
		var $tabsPanel = $(">div.exmayui-tabs-panels", target);
		var $tabs = $("ul.exmayui-tabs-list", $tabsHeader);
		
		// 是否有背景图片
		if (opts.plain == true) {
			$tabsHeader.addClass("exmayui-tabs-header-plain");
		} else {
			$tabsHeader.removeClass("exmayui-tabs-header-plain");
		}
		
		// 边框
		if (opts.border == true) {
			$tabsHeader.removeClass("exmayui-tabs-header-noborder");
			$tabsPanel.removeClass("exmayui-tabs-panels-noborder");
		} else {
			$tabsHeader.addClass("exmayui-tabs-header-noborder");
			$tabsPanel.addClass("exmayui-tabs-panels-noborder");
		}
		
		$("li", $tabs).each(function(){
			$(this).data("exmayTab",{
				init : false
			});
		});
		
		// 选项卡单击事件
		$("li", $tabs).unbind(".exmayTabs").bind("click.exmayTabs", function() {
			var init = $(this).data("exmayTab").init;
			if(!init) {
				if(opts.onInitTab) {
					opts.onInitTab.call($(this));
				}
				$(this).data("exmayTab").init = true;
			}
			// 圆角效果
			var $oldSelectedTab = $(".exmayui-tabs-selected", $tabs);
			
			$(".exmayui-tabs-selected", $tabs).removeClass("exmayui-tabs-selected");

			$oldSelectedTab.each(function(){
				$(".exmay-ui-top-bg", this).width($(this).outerWidth());
				$(".exmay-ui-top-bg", this).removeClass("exmay-ui-top-bg-hover");
			});
			
			$(this).addClass("exmayui-tabs-selected");
						
			// 圆角效果
			$(".exmay-ui-top-bg", this).width($(this).outerWidth());
			$(".exmay-ui-top-bg", this).addClass("exmay-ui-top-bg-hover");
			
			$(this).blur();
			$(">div.exmayui-tabs-panels>div", target).css("display", "none");
			var $tabsWrap = $(".exmayui-tabs-wrap", $tabsHeader);
			
			// 横向参数
			var width = getWidth(target, this);
			var left = width - $tabsWrap.scrollLeft();
			var right = left + $(this).outerWidth();
			
			// 纵向参数
			var height = getHeight(target, this);
			var top = height - $tabsWrap.scrollTop();
			var bottom = top + $(this).outerHeight();
			
			
			if(opts.axis == "vertical") {
				// 高度
				if (top < 0 || bottom > $tabsWrap.innerHeight()) {
					var pos = Math.min(height - ($tabsWrap.height() - $(this).height()) / 2, getPos(target));
					// 自定义效果0
					$tabsWrap.animate( {
						scrollTop : pos
					}, opts.scrollDuration);
				}	
			} else {
				// 宽度
				if (left < 0 || right > $tabsWrap.innerWidth()) {
					var pos = Math.min(width - ($tabsWrap.width() - $(this).width()) / 2, getPosition(target));
					// 自定义效果1
					$tabsWrap.animate( {
						scrollLeft : pos
					}, opts.scrollDuration);
				}
			}
			
			var $tabTitle = $(this).data("tabs.tab");
			var $tab = $("#" + $tabTitle.id);
			$tab.css("display", "block");
			
			// 链接
			if ($tabTitle.href && (!$tabTitle.loaded || !$tabTitle.cache)) {
				$tab.load($tabTitle.href, null, function() {
					if ($.exmayParser) {
						$.exmayParser.parse($tab);
					}
					opts.onLoad.apply(this, arguments);
					$tabTitle.loaded = true;
				});
			}
			resizeTab(target);
			opts.onSelect.call($tab, $tabTitle.title);
			
		}).hover(function(){
				$(".exmayui-tabs-inner", this).addClass("exmayui-tabs-inner-hover");
				$(".exmay-ui-top-bg", this).addClass("exmay-ui-top-bg-hover");
			}, function(){
				$(".exmayui-tabs-inner", this).removeClass("exmayui-tabs-inner-hover");
				if(!$(this).hasClass("exmayui-tabs-selected")) {
					$(".exmay-ui-top-bg", this).removeClass("exmay-ui-top-bg-hover");
				}
		});
		
		// 点击关闭事件
		$("a.exmayui-tabs-close", $tabs).unbind(".exmayTabs").bind("click.exmayTabs", function() {
			var tab = $(this).parent()[0];
			var data = $(tab).data("tabs.tab");
			closeTab(target, data.title);
		});
		
		// 前一个单击事件
		$(".exmayui-tabs-scroller-previous", $tabsHeader).unbind(".exmayTabs").bind("click.exmayTabs", function() {
			var $tabsWrap = $(".exmayui-tabs-wrap", $tabsHeader);
			if(opts.axis == "vertical") {
				var pos = $tabsWrap.scrollTop() - opts.scrollIncrement;
				// 自定义效果0
				$tabsWrap.animate( {
					scrollTop : pos
				}, opts.scrollDuration);
			} else {
				var pos = $tabsWrap.scrollLeft() - opts.scrollIncrement;
				// 自定义效果2
				$tabsWrap.animate( {
					scrollLeft : pos
				}, opts.scrollDuration);
			}
		});
		
		// 后一个单击事件
		$(".exmayui-tabs-scroller-next", $tabsHeader).unbind(".exmayTabs").bind("click.exmayTabs", function() {
			var $tabsWrap = $(".exmayui-tabs-wrap", $tabsHeader);
			if(opts.axis == "vertical") {
				var pos = Math.min($tabsWrap.scrollTop() + opts.scrollIncrement, getPos(target));
				// 自定义效果3
				$tabsWrap.animate( {
					scrollTop : pos
				}, opts.scrollDuration);
			} else {
				var pos = Math.min($tabsWrap.scrollLeft() + opts.scrollIncrement, getPosition(target));
				// 自定义效果3
				$tabsWrap.animate( {
					scrollLeft : pos
				}, opts.scrollDuration);
			}
		});
	};
	
	// 获取宽度
	function getWidth(target, tab) {
		var width = 0;
		var b = true;
		$(">div.exmayui-tabs-header ul.exmayui-tabs-list li", target).each(function() {
			if (this == tab) {
				b = false;
			}
			if (b == true) {
				width += $(this).outerWidth(true);
			}
		});
		return width;
	};	
	
	// 获取高度
	function getHeight(target, tab) {
		var height = 0;
		var b = true;
		$(">div.exmayui-tabs-header ul.exmayui-tabs-list li", target).each(function() {
			if (this == tab) {
				b = false;
			}
			if (b == true) {
				height += $(this).outerHeight(true);
			}
		});
		return height;
	};

	// 添加选项卡
	function addTab(target, data) {
		data = $.extend( {
			id : null,
			title : "",
			content : "",
			href : null,
			cache : true,
			icon : null,
			closable : false,
			selected : true,
			height : "auto",
			width : "auto"
		}, data || {});
		if (data.selected) {
			$(".exmayui-tabs-header .exmayui-tabs-wrap .exmayui-tabs-list li", target).removeClass("exmayui-tabs-selected");
		}
		data.id = "exmay-tab-panel-" + $.fn.exmayTabs.defaults.idSeed++;
		$("<div></div>").attr("id", data.id).attr("title", data.title).height(data.height).width(data.width).appendTo($(">div.exmayui-tabs-panels", target));
		initTab(target, data);
	};
	
	// 关闭选项卡
	function closeTab(target, data) {
		var opts = $(target).data("exmayTabs").options;
		if (typeof data == "string") {
			var tab = $('>div.exmayui-tabs-header li:has(a span:contains("' + data + '"))', target)[0];
			if (!tab) {
				return;
			}
			var $tab = $(tab).data("tabs.tab");
			var $tabContent = $("#" + $tab.id);
			if (opts.onClose.call($tabContent, $tab.title) == false) {
				return;
			}
			var $selectedTab = $(tab).hasClass("exmayui-tabs-selected");
			var $prevTab = $(tab).prev();
			$(tab).removeData("tabs.tab");
			$(tab).remove();
			$tabContent.remove();
			// 重新调整选项卡
			//exmayResizeTabs(target);
			if ($selectedTab) {
				//$prevTab.trigger("click");
				if($prevTab.length > 0) {
					selectTab(target, $prevTab.data("tabs.tab").title);
				}
			} else {
				var $tabsWrap = $(">div.exmayui-tabs-header .exmayui-tabs-wrap", target);
				if(opts.axis == "vertical") {
					var pos = Math.min($tabsWrap.scrollTop(), getPos(target));
					// 自定义效果0
					$tabsWrap.animate( {
						scrollTop : pos
					}, opts.scrollDuration);
				} else {
					var pos = Math.min($tabsWrap.scrollLeft(), getPosition(target));
					// 自定义效果4
					$tabsWrap.animate( {
						scrollLeft : pos
					}, opts.scrollDuration);
				}
			}
		}
	};
	
	function exmayShowTabs(target) {
		var $target = $(target);
		$target.show();
	}
	
	function exmayHideTabs(target,data) {
		var $target = $(target);
		if(data){
			var $tab;
			if(data.indexOf("#") !=-1){
				$tab = $(data+"-tab",target);
			}else{
				$tab = $('>div.exmayui-tabs-header li:has(a span:contains("' + data + '"))', target);
			}
			$tab.hide();
		}else{
			$target.hide();
		}
	}
	
	// 选择选项卡
	function selectTab(target, data) {
		var $tab = null;
		var tab = null;
		if (data) {
			if(data.substr(0,1)=="#"){
				tab = $("a", data + "-tab").find("span:first-child")[0];
			} else {
				tab = $('>div.exmayui-tabs-header li:has(a span:contains("' + data + '"))', target)[0];
			}
			if (tab) {
				$(tab).trigger("click");
				$tab = $(tab);
			}
		} else {
			var $tabs = $(">div.exmayui-tabs-header ul.exmayui-tabs-list", target);
			if ($(".exmayui-tabs-selected", $tabs).length == 0) {
				$("li:first", $tabs).trigger("click");
				$tab = $("li:first", $tabs);
			} else {
				$(".exmayui-tabs-selected", $tabs).trigger("click");
				$tab = $(".exmayui-tabs-selected", $tabs);
			}
		}
		if($tab != null) {
			var $top = $(".exmay-ui-top-bg", $tab);
			$top.width($tab.outerWidth());
		}
	};
	
	function exmayGetSelectedTab(target){
		var $tabs = $(">div.exmayui-tabs-header ul.exmayui-tabs-list", target);
		var $selectedTag = $(".exmayui-tabs-selected", $tabs);
		return $selectedTag;
	}
	
	// 获取位置
	function getPosition(target) {
		var $tabsHeader = $(">div.exmayui-tabs-header", target);
		var tabsWidth = 0;
		$("ul.exmayui-tabs-list li", $tabsHeader).each(function() {
			tabsWidth += $(this).outerWidth(true);
		});
		var wrapWidth = $(".exmayui-tabs-wrap", $tabsHeader).width();
		var tabsLeft = parseInt($(".exmayui-tabs-list", $tabsHeader).css("padding-left"));
		return tabsWidth - wrapWidth + tabsLeft;
	};
	
	// 获取位置
	function getPos(target) {
		var $tabsHeader = $(">div.exmayui-tabs-header", target);
		var tabsHeight = 0;
		$("ul.exmayui-tabs-list li", $tabsHeader).each(function() {
			tabsHeight += $(this).outerHeight(true);
		});
		var wrapHeight = $(".exmayui-tabs-wrap", $tabsHeader).height();
		var tabsTop = parseInt($(".exmayui-tabs-list", $tabsHeader).css("padding-top"));
		return tabsHeight - wrapHeight + tabsTop;
	};
	
	// 判断选项卡是否存在
	function existsTab(target, data) {
		return $('>div.exmayui-tabs-header li:has(a span:contains("' + data + '"))', target).length > 0;
	};
	
	// 获取选项值
	function getOptions($target) {
		return {
			width : (parseInt($target.css("width")) || undefined),
			height : (parseInt($target.css("height")) || undefined),
			axis : $target.attr("axis"),
			display : $target.attr("display"),
			fit : ($target.attr("fit") ? $target.attr("fit") == "true" : undefined),
			border : ($target.attr("border") ? $target.attr("border") == "true" : undefined),
			plain : ($target.attr("plain") ? $target.attr("plain") == "true" : undefined),
			rounded : ($target.attr("rounded") ? $target.attr("rounded") == "true" : undefined),
			scrollIncrement : $target.attr("scrollIncrement")
		}	
	}
	
	//jQuery ExmayUI Tabs(选项卡)插件 定义
	$.fn.exmayTabs = function(options, data) {
		
		// 选项公用方法调用
		if (typeof options == "string") {
			switch (options) {
			case "resize": // 调整选项卡大小
				return this.each(function() {
					exmayResizeTabs(this);
				});
			case "add": // 添加选项卡
				return this.each(function() {
					addTab(this, data);
					$(this).exmayTabs();
				});
			case "close": // 关闭选项卡
				return this.each(function() {
					closeTab(this, data);
				});
			case "show": // 显示Tabs
				return this.each(function() {
					exmayShowTabs(this, data);
				});
			case "hide": // 隐藏Tabs
				return this.each(function() {
					exmayHideTabs(this, data);
				});
			case "select": // 选中选项卡
				return this.each(function() {
					selectTab(this, data);
				});
			case "getSelected": // 选中选项卡
				return exmayGetSelectedTab(this);
			case "exists": // 判断选项卡是否存在
				return existsTab(this[0], data);
			}
			
		}
		
		options = options || {};
		
		//jQuery ExmayUI Tabs(选项卡)插件 主方法
		return this.each(function() {
					var $this = $(this);  
					// 定义缓存
					var cache = $this.data("exmayTabs");
					// 定义选项
					var opts = null;
					if (cache) {
						// 通过数据缓存为选项赋值
						opts = $.extend(cache.options, options || {});
						cache.options = opts;
					} else {
						// 为选项重新赋值
						opts = $.extend({}, $.fn.exmayTabs.defaults, getOptions($this), options);
						// 对数据进行缓存
						$this.data("exmayTabs", { options : opts });
						// 初始化
						initExmayTabs(this);
						// 事件绑定
						bindExmayTabsEvents(this);
						// 调整选项卡大小
						exmayResizeTabs(this);
						// 选择选项卡
						selectTab(this);
						// 方向调整
						setDirection(this);
					}
					
				});
	};
	
	// Tabs(选项卡)默认属性值
	$.fn.exmayTabs.defaults = {
		width : "auto",  // 宽度
		height : "auto",  // 高度
		axis : "horizontal", // 方向(横向:horizontal 纵向:vertical)
		display : "forward",  // 显示方式(正向:forward 反向:reverse)
		idSeed : 0,  //
		plain : false,  //
		fit : false,  // 自适应
		border : true,  // 边框
		rounded : true,
		scrollIncrement : 100,  // 滚动增量
		scrollDuration : 400,  // 滚动长短
		onLoad : function() {},  // 加载
		onInitTab : function(){}, // 初始化Tab
		onSelect : function(data) {},  //　选中
		onClose : function(data) {}  //　关闭
	};
	
})(jQuery);
//
// jQuery ExmayUI Tabs(选项卡)插件 结束
//