/**
 *************************************************************************************
 * [标题：ExmayUI JQuery Textbox 插件]<br>
 *************************************************************************************
 * [描述：ExmayUI JQuery Textbox 插件]<br>
 *************************************************************************************
 * @author Exmay Team / 亿美团队
 *************************************************************************************
 * @version Version 1.0.1 Beta / v1.0.1 测试版
 *************************************************************************************
 */

/*
 * ***********************************************************************************
 * 版权：Copyright © 2012 Exmay Inc. All Rights Reserved. 长沙亿美软件有限公司　版权所有
 * ***********************************************************************************
 * 企业文化：专注　创新　分享　共赢
 * ***********************************************************************************
 * 官方网站：http://www.exmay.com
 * ***********************************************************************************
 * 官方邮箱：service@exmay.com
 * ***********************************************************************************
 */

(function($) {

	// 初始化Textbox
	function initExmayTextbox(target) {
		var $target = $(target);
		var opts = $target.data("exmayTextbox").options;
//		var $textbox = $('<span class="exmayui-textbox"></span>');	
//		var $icon = $('<span><span class="exmayui-textbox-icon"></span></span>');
//		$textbox.insertAfter(target);
////		$target.appendTo($textbox);
//		//$target.wrapInner(target);
//		$icon.appendTo($textbox);
//		$("span", $icon).addClass(opts.icon);
//		$target.width(opts.width-$icon.width()-10);
//		$target.removeClass("exmayui-textbox");
//		/*$target.data("exmayTextbox", {
//			options : opts,
//			exmayTextbox : $textbox		
//		});*/
		var $textbox = $('<span class="exmayui-textbox"></span>');
		var $icon = $('<span><span class="exmayui-textbox-icon"></span></span>');
		$textbox.insertAfter(target);
		$target.appendTo($textbox);
		$target.removeClass("exmayui-textbox");
		$target.width(opts.width-$icon.width()-28);
		$icon.appendTo($textbox);
		$("span", $icon).addClass(opts.icon);
		$target.data("exmayTextbox", {
			options : opts,
			exmayTextbox : $textbox		
		});
	};

	// 事件绑定
	function bindExmayTextboxEvents(target, options) {
		var $target = $(target);
		var opts = options;
		var $textbox = $target.data("exmayTextbox").exmayTextbox;
		var $icon = $textbox.find(".exmayui-textbox-icon");
		if(opts.event) {
			var event = opts.event;
			var pos = event.indexOf(":");
			var evt = "click";
			var fn = "";
			if(pos == -1) {
				fn = event;
			} else {
				evt = event.substring(0,pos);
				fn = event.substring(pos+1,event.length);
			}
			$icon.bind(evt+".exmayTextbox", function() {
				eval(fn);
				return false;
			}).bind("mouseover.exmayTextbox", function() {
				$(this).addClass("exmayui-textbox-icon-hover");
			}).bind("mouseout.exmayTextbox", function() {
				$(this).removeClass("exmayui-textbox-icon-hover");
			});
		}
	};

	// 文本框
	$.fn.exmayTextbox = function(options, data) {

		// 方法调用
		if (typeof options == "string") {
			return $.fn.exmayTextbox.methods[options](this, data);
		}
		
		this.each(function() {
			var $this = $(this);
			var opts = null;
			var cache = $this.data("exmayTextbox");
			if (cache) {
				opts = $.extend(cache.options, options);
				cache.options = opts;
				//exmayShowTextbox(this);
			} else {
				opts = $.extend( {}, $.fn.exmayTextbox.defaults, $.fn.exmayTextbox.parseOptions($this), options);
				$this.data("exmayTextbox", {
					options : opts
				});
				initExmayTextbox(this);
			}
			// 支持多重事件绑定
			bindExmayTextboxEvents(this, opts);
		});

	};

	// 插件方法
	$.fn.exmayTextbox.methods = {

	};

	// 解析插件属性
	$.fn.exmayTextbox.parseOptions = function(target) {
		var $target = $(target);
		return {
			width : $target.outerWidth(),
			height : $target.outerHeight(),
			left : $target.offset().left,
			top : $target.offset().top,
			icon : $target.attr("icon"),
			event : $target.attr("event")
			
		}
	};

	$.fn.exmayTextbox.defaults = {
		theme : "blue",
		border : 5,
		width : null,
		height: null,
		left : null,
		top : null,
		maxWidth : 300,
		maxHeigh : 600,
		icon : "",
		event : ""
	};

})(jQuery);