/**
 *************************************************************************************
 * [标题：ExmayUI JQuery Tip 插件]<br>
 *************************************************************************************
 * [描述：ExmayUI JQuery Tip 插件]<br>
 *************************************************************************************
 * @author Exmay Team / 亿美团队
 *************************************************************************************
 * @version Version 1.0.1 Beta / v1.0.1 测试版
 *************************************************************************************
 */

/*
 * ***********************************************************************************
 * 版权：Copyright © 2012 Exmay Inc. All Rights Reserved. 长沙亿美软件有限公司　版权所有
 * ***********************************************************************************
 * 企业文化：专注　创新　分享　共赢
 * ***********************************************************************************
 * 官方网站：http://www.exmay.com
 * ***********************************************************************************
 * 官方邮箱：service@exmay.com
 * ***********************************************************************************
 */

(function($) {

	// 初始化Tip
	function initExmayTip(target) {
		var $target = $(target);
		var opts = $target.data("exmayTip").options;
		
		var $tip = $('<div class="exmayui-tip-body" style="top:-20px;"></div>').appendTo("body");
		$tip.css({"zIndex":100});	
        $tip.append(exmayGetTipMsg(target));
		$tip.exmayPanel( {
			title : "&nbsp;",
			fullScreen : false,
			collapsible : false,
			minimizable : false,
			maximizable : false,
			shadow : false,
			draggable : false,
			resizable : false,
			closable : false
		});
		var $panel = $tip.exmayPanel("exmayPanel");
		$panel.addClass("exmayui-tip").addClass("exmayui-tip-" + opts.theme);
		$panel.find(".exmayui-panel-header").css( {
			height : opts.border
		});
		$panel.find(".exmayui-panel-title-left").css( {
			height : opts.border
		});
		$panel.find(".exmayui-panel-title-middle").css( {
			height : opts.border
		});
		$panel.find(".exmayui-panel-title-word").hide();
		$panel.find(".exmayui-panel-title").hide();
		$panel.find(".exmayui-panel-title-right").css( {
			height : opts.border
		});
		$panel.find(".exmayui-panel-status-left").css( {
			height : opts.border
		});
		$panel.find(".exmayui-panel-status-middle").css( {
			height : opts.border
		});
		$panel.find(".exmayui-panel-status-bar").css( {
			height : opts.border
		});
		$panel.find(".exmayui-panel-status-right").css( {
			height : opts.border
		});
		$panel.find(".exmayui-panel-content-left").css( {
			width : opts.border
		});
		$panel.find(".exmayui-panel-content-right").css( {
			width : opts.border
		});
		$target.data("exmayTip", {
				options : opts,
				tip : $tip
		});
		if(opts.corner) {
			var $corner = $('<div class="exmayui-tip-corner"></div>').appendTo($tip.exmayPanel("exmayPanel"));
			$corner.css( {
				width : 8,
				height : 11,
				left : -4,
				top : 10
			});
		}
		/*var position = {
			width : width,
			height : "auto",
			left : opts.left + opts.width + 10,
			top : opts.top
		}*/
		exmayResizeTip(target);
	};

	// 事件绑定
	function bindExmayTipEvents(target, options) {
		var $target = $(target);
		$(window).resize(function(){
			opts = $.extend( {}, $.fn.exmayTip.defaults, $.fn.exmayTip.parseOptions($target), options);
			//$(target).data("exmayTip").tip.exmayPanel("exmayPanel").("move",{left:opts.left + opts.width + 10,top:opts.top});
		});
		$(".exmay-ui-scrollable").scroll(function(){
			var top = ($(this).scrollTop());
			exmayMoveTip(target,null,top);
		});
	
		$(".exmayui-tip-body").click(function(){
			exmayHideTip(target);			
		});
		
//		$(".exmayui-tip-body").mouseover(function(){
//			$(this).css({"zIndex":120});
//		});
		
	};
	
	function exmayMoveTip(target,position,top){
		var $target = $(target);
		var cache = $target.data("exmayTip");
		var opts = cache.options;

		if(!position) {
			if(top) {
				top = opts.top - top;
			}
			position = {
				left : opts.left + opts.width + 10,
				top : top
			}
		}
		cache.tip.exmayPanel("move", position);
	}
	
	// 获取Tip信息
	function exmayGetTipMsg(target) {
		var msg = null;
		var opts = $(target).data("exmayTip").options;
		msg = opts.msg;
		if(msg == null || msg.replace(/(^\s*)|(\s*$)/g, "") == "") { // 非空判断
			return false;
		}
		return msg;
	};
	
	// 获取Tip信息宽度
	function exmayGetTipMsgSize(target) {
		var opts = $(target).data("exmayTip").options;
		var $span = $('<span>' + exmayGetTipMsg(target) + '</span>')
		var $tipProxy = $('<div style="max-width:'+ (opts.maxWidth - 10 - opts.border * 2) +'px;"></div>').html($span).appendTo("body");
		var width = $span.outerWidth();
		var height = $span.outerHeight();
		$tipProxy.remove();
		return {width : width, height: height};
	};
	
	// 设置Tip大小
	function exmayResizeTip(target, position){
		var $target = $(target);
		var cache = $target.data("exmayTip");
		var opts = cache.options;
		
		var $tip = exmayGetTipMsgSize(target);
		var width = $tip.width;
		var height = $tip.height;
		
		/*if(opts.height){
			height = opts.height;
		}*/
		
		if (width > opts.maxWidth) {
			width = opts.maxWidth;
		} else {
			width = width + 10 + opts.border * 2;
		};
		
		if (height > opts.maxHeight) {
			height = opts.maxHeight;
		} else {
			height = height + 10 + opts.border * 2;
		};

		position = $.extend({
			width : width,
			height : height,
			left : opts.left + opts.width + 10,
			top : opts.top
		}, position);
		
		//$("#exmay-debug").append(" " + position.width + " " + position.height + " " + position.left + " " + position.top);
		
		cache.tip.exmayPanel("resize", position);
	};
	
	// 显示
	function exmayShowTip(target, options) {
		var $target = $(target);
		var cache = $target.data("exmayTip");
		if(cache) {
			if(options != null) {
				var opts = $.extend(cache.options, options);
				var $tip = cache.tip;
				var $panel = $tip.exmayPanel("exmayPanel");
				var tipClass = $panel.attr("class").replace(/(exmayui-tip-\w*)/,"");
				$panel.removeClass().addClass(tipClass).addClass("exmayui-tip-" + opts.theme);
				$panel.find("div.exmayui-panel-content-middle").html(opts.msg);
				$target.data("exmayTip", {
						options : opts,
						tip : $tip
				});
			}
			$tip.exmayPanel("open");
			exmayResizeTip(target);
		} else {
			$target.exmayTip(options);
		}
	};
	
	// 隐藏Tip
	function exmayHideTip(target) {
		var $tip = $(target).data("exmayTip").tip;
		$tip.exmayPanel("close");
	};
	
	// 提示
	$.fn.exmayTip = function(options, data) {

		// 方法调用
		if (typeof options == "string") {
			return $.fn.exmayTip.methods[options](this, data);
		}
		
		this.each(function() {
			var $this = $(this);
			var opts = null;
			var cache = $this.data("exmayTip");
			if (cache) {
				opts = $.extend(cache.options, options);
				cache.options = opts;
				//exmayShowTip(this);
			} else {
				opts = $.extend( {}, $.fn.exmayTip.defaults, $.fn.exmayTip.parseOptions($this), options);
				$this.data("exmayTip", {
					options : opts
				});
				initExmayTip(this);
			}
			// 支持多重事件绑定
			bindExmayTipEvents(this, opts);
		});

	};

	// 插件方法
	$.fn.exmayTip.methods = {
		info : function(target, data){//提示
			if(data == "hide") {
				exmayHideTip(target);
			} else {
				exmayShowTip(target, {theme : "blue", msg:data.msg});
			}
		},
		success :  function(target, data) {// 成功
			if(data == "hide") {
				exmayHideTip(target);
			} else {
				exmayShowTip(target, {theme : "green", msg:data.msg});
			}
		},
		warning : function(target, data){//警告
			if(data == "hide") {
				exmayHideTip(target);
			} else {
				exmayShowTip(target, {theme : "yellow", msg:data.msg});
			}
		},
		error : function(target, data){ //失败
			if(data == "hide") {
				exmayHideTip(target);
			} else {
				exmayShowTip(target, {theme : "red", msg:data.msg});
			}
		}
	};

	// 解析插件属性
	$.fn.exmayTip.parseOptions = function(target) {
		var $target = $(target);
		return {
			width : $target.outerWidth(),
			height : $target.outerHeight(),
			left : $target.offset().left,
			top : $target.offset().top
			
		}
	};

	$.fn.exmayTip.defaults = {
		event : "mouseover",
		theme : "blue",
		tip : "em",
		msg : "Exmay Tip",
		border : 5,
		width : null,
		height: null,
		left : null,
		top : null,
		maxWidth : 300,
		maxHeigh : 600,
		corner : true
	};

})(jQuery);