﻿/**
 *************************************************************************************
 * [标题：ExmayUI JQuery Treegrid 插件]<br>
 *************************************************************************************
 * [描述：ExmayUI JQuery Treegrid 插件]<br>
 *************************************************************************************
 * @author Exmay Team / 亿美团队
 *************************************************************************************
 * @version Version 1.0.1 Beta / v1.0.1 测试版
 *************************************************************************************
 */

/*
 * ***********************************************************************************
 * 版权：Copyright © 2012 Exmay Inc. All Rights Reserved. 长沙亿美软件有限公司　版权所有
 * ***********************************************************************************
 * 企业文化：专注　创新　分享　共赢
 * ***********************************************************************************
 * 官方网站：http://www.exmay.com
 * ***********************************************************************************
 * 官方邮箱：service@exmay.com
 * ***********************************************************************************
 */

(function($) {
	
	function initExmayTreegrid(target) {
		var $target = $(target);
		var opts = $target.data("exmayTree").options;
		initExmayTreegridTbody(target);

	};

	function initExmayTreegridThead(target) {
		var $target = $(target);
		var opts = $target.data("exmayTree").options;
		var $thead = $("<thead></thead>");
		var $tr = $("<tr></tr>");
		$thead.prependTo($target);
		$tr.appendTo($thead);

		if(opts.checkboxIndex) {
			var $checkbox = $('<input type="checkbox" class="exmayui-checkbox-all exmay-ui-id" names="ids" title="全选" />');
			$("<th></th>").append($checkbox).appendTo($tr);
			$checkbox.exmayCheckbox();
		}
		
		var columns = opts.columns;
		for ( var i = 0; i < columns.length; i++) {
			var $th = $("<th></th>");
			$th.html(columns[i].title).appendTo($tr);
		}
		
		if(opts.operates) {
			var $th = $("<th></th>");
			$th.html("操作").appendTo($tr);
		}
	}
	
	;

	function initExmayTreegridTbody(target) {
		var $target = $(target);
		var opts = $target.data("exmayTree").options;

		var $tbody = $("tbody", $target);
		if ($tbody == null || $tbody == undefined || $tbody.html() == null) {
			 $tbody = $("<tbody></tbody>").appendTo($target);
		}
		$tbody.attr("id", "exmay-sortable");
		$tbody.attr("cc", "exmay-ui-id");
		$tbody.addClass("exmayui-treegrid-body exmayui-selectable");

		//$tbody.appendTo($target);

		initExmayTreegridLoading($tbody);

		initExmayTreegridThead(target);
		initExmayTreegridTfoot(target);

		if (opts.url) {
			exmayLoadData(target, $target);
		} else {
			bindExmayTreeEvents(target);
		}
	}
	;

	function initExmayTreegridLoading($tbody) {
		var $loading = $('<tr id="exmay-treegrid-loading"><td class="exmayui-treegrid-loading" colspan="10"></td></tr>');
		$loading.css( {
			"background-repeat" : "no-repeat",
			"background-position" : "center center"
		});
		$loading.appendTo($tbody);
	}

	function initExmayTreegridTfoot(target) {
		var $target = $(target);
		var opts = $target.data("exmayTree").options;
		var $tfoot = $('<tfoot></tfoot>');
		$tfoot.appendTo($target);
		var $tr = $('<tr></tr>');
		var $th = $('<th colspan="10"></th>');
		$tr.appendTo($tfoot);
		$th.appendTo($tr);
		if(opts.checkboxIndex) {
			var $checkbox = $('<input type="checkbox" class="exmayui-checkbox-invert exmay-ui-id" names="ids" title="反选"/>');
			$checkbox.appendTo($th);
			$checkbox.exmayCheckbox();
		}
	};

	// 加载远程数据到UL标签内
	function exmayLoadData(target, ul, param) {
		var opts = $(target).data("exmayTree").options;
		if (!opts.url)
			return;

		param = param || {};

		//var folder = $(ul).prev("tr").find('span.exmayui-treegrid-folder');
		var folder = $(ul).find('span.exmayui-treegrid-folder');

		folder.addClass('exmayui-treegrid-loading');
		var $tbody = $('<tbody><tr><td>ABCFDSFA</td><tr></tbody>');
		// AJAX加载JSON数据
		$.ajax( {
			type : 'post',
			url : opts.url,
			data : param,
			dataType : 'json',
			beforeSend : function() {
				//$tbody.append($(ul));
		},
		success : function(data) {
			folder.removeClass('exmayui-treegrid-loading');
			// 加载JSON数据
			initExmayTreeFromJSON(target, ul, data[opts.entity]);
			// 绑定事件
			bindExmayTreeEvents(target);
			if(opts.selectable) {
				$(".exmayui-selectable").exmaySelectable();
			}
			//				$(".exmayui-treegrid").exmaySortable({
			//						accepter:".exmayui-selectable",
			//						target:".exmayui-treegrid-row",
			//						beforDrag : function() {
			//							
			//						}
			//				});
			if($.fn.exmayWritable) {
				$(".exmayui-writable").exmayWritable();
			}
			if (opts.onLoadSuccess) {
				opts.onLoadSuccess.apply(this, arguments);
			}
		},
		error : function() {
			folder.removeClass('exmayui-treegrid-loading');
			if (opts.onLoadError) {
				opts.onLoadError.apply(this, arguments);
			}
		}
		});
	}
	;

	// 加载JSON数据
	function initExmayTreeFromJSON(obj, ul, data) {
		// 当为根时清除内容
		if (obj == ul) {
			$(obj).empty();
		}


		var opts = $(obj).data("exmayTree").options;

		// 获取父缩进
		//var depth = $(ul).prev("tr").find('span.exmayui-treegrid-indent,span.exmayui-treegrid-hit').length;
		var depth = $(ul).find('span.exmayui-treegrid-indent,span.exmayui-treegrid-hit').length;

		var columns = opts.columns;
		/*var $thead = $("<thead></thead>");
		var $tr = $("<tr></tr>");
		$tr.appendTo($thead).appendTo($(ul));
		for(var a=0;a<columns.length;a++){
			$('<th>' + columns[a].title + '</th>').appendTo($tr);
		}*/
		
		var checkeds = null;
		var typeIds = null;
		if(opts.globals) {
			checkeds = opts.checkeds;
			var globals = opts.globals;
			typeIds = globals.substring(0,globals.length-1);
		}	
		
		exmayAppendNodes(ul, data, depth);

		function exmayAppendNodes(ul, children, depth) {

			var privLi;

			// 子节点递归
			for ( var i = 0; i < children.length; i++) {

				var li = $('<tr class="exmay-ui-selectable-item exmay-ui-sortable-item  cc="exmay-ui-id"></tr>');

				//var li = $('<tr></tr>').appendTo(ul);
				var item = children[i];

				if (i == 0) {
					if (depth == 0) {
						var $tbody = $(".exmayui-treegrid-body", obj);
						li.appendTo(($tbody).appendTo($(ul)));
					} else {
						li.insertAfter(ul);
					}
				} else {
					li.insertAfter(privLi);
				}
				li.addClass("exmayui-treegrid-row");
				privLi = li;

				li.attr("id", item.id);

				if(opts.checkboxIndex) {
					var $checkbox = $('<input type="checkbox" name="ids" class="exmayui-checkbox exmay-ui-id" />');
					var $td = $('<td></td>');
					$checkbox.appendTo($td);
					$td.appendTo(li);
					$checkbox.val(item.id);
					$checkbox.exmayCheckbox({
						onChange : function(hasChecked){
						
						}
					});
				}
				
				if(opts.globals) {
					var $inputHidden = '<input class="exmayui-tree-checkbox-value" type="hidden" name="'+opts.globals+'" value="'+item.id+'" />';
					$td.append($inputHidden);
				}
				
				/*
				$('<td>' + item["id"] + '</td>').appendTo(li);
				$('<td class="exmayui-writable">' + item["code"] + '</td>').appendTo(li);
				 */
				
				//var columns = opts.columns;
				for ( var k = 0; k < columns.length; k++) {

					if (opts.text == columns[k].field) {

						// 打开还是关闭
						if (item.state != 'open' && item.state != 'closed') {
							item.state = 'open';
						}

						var node = $('<td class="exmayui-treegrid-node"></td>').appendTo(li);
						node.attr('node-id', item.id);
						var parentId = 0;
						if (depth != 0) {
							parentId = $(ul).attr("parent-node-id") + "-" + $(ul).find("td.exmayui-treegrid-node").attr("node-id");
						}
						li.attr('parent-node-id', parentId);

						// 缓存节点属性
						node.data("tree-node", {
							id : item.id,
							text : item[columns[k].field],
							img : item.img,
							icon : item.icon,
							attributes : item.attributes
						});

						// 树标题
						$('<span class="exmayui-treegrid-title"></span>').html(item[columns[k].field]).appendTo(node);

						// 单选复选
						if (opts.checkbox) {
							if (item.checked) {
								$('<span class="exmayui-treegrid-checkbox exmayui-treegrid-checkbox1 exmay-ui-id"></span>').prependTo(node);
							} else {
								$('<span class="exmayui-treegrid-checkbox exmayui-treegrid-checkbox0 exmay-ui-id"></span>').prependTo(node);
							}
						} else {
							if (opts.radio) {
								$('<span class="exmayui-treegrid-radio exmayui-treegrid-radio-0"></span>').prependTo(node);
							}
						}

						// 子节点
						/** [children] **/
						if (item.children) {
							var subul = $('<ul></ul>').insertBefore(li);
							if (item.state == 'open') {
								$('<span class="exmayui-treegrid-file-icon exmay-ui-png exmayui-treegrid-folder exmayui-treegrid-folder-open"></span>').addClass(item.icon).prependTo(node);
								$('<span class="exmayui-treegrid-hit exmayui-treegrid-expanded"></span>').prependTo(node);
							} else {
								$('<span class="exmayui-treegrid-file-icon exmay-ui-png exmayui-treegrid-folder"></span>').addClass(item.icon).prependTo(node);
								$('<span class="exmayui-treegrid-hit exmayui-treegrid-collapsed"></span>').prependTo(node);
								subul.css('display', 'none');
							}

							if (i == children.length - 1) {
								if (i != 0) {
									node.addClass("exmayui-treegrid-last-li");
								}
							} else {
								//li.addClass("exmayui-treegrid-li-li");
								//						node.addClass("exmayui-treegrid-li-li");
							}

							exmayAppendNodes(subul, item.children, depth + 1);

						} else {
							if (item.state == 'closed') {
								$('<span class="exmayui-treegrid-file-icon exmay-ui-png exmayui-treegrid-folder"></span>').addClass(item.icon).prependTo(node);
								$('<span class="exmayui-treegrid-hit exmayui-treegrid-collapsed"></span>').prependTo(node);
							} else {
								//						$('<input type="checkbox" style="vertical-align:bottom;margin:0;height:18px;">').prependTo(node);
								$('<span class="exmayui-treegrid-file-icon exmay-ui-png exmayui-treegrid-file"></span>').addClass(item.icon).prependTo(node);
							}
							if (i == children.length - 1) {
								if (item.state != 'closed') { // 如果节点不属于关闭类型 // 有子节点的末节点
									$('<span class="exmayui-treegrid-last-li"></span>').prependTo(node);
								}
							} else {
								if (item.state != 'closed') {
									$('<span class="exmayui-treegrid-li"></span>').prependTo(node);
								}
								//li.addClass("exmayui-treegrid-li-li");
								//						node.addClass("exmayui-treegrid-li-li");
							}
						}
						/** [/children] **/

						for ( var j = 0; j < depth; j++) {
							$('<span class="exmayui-treegrid-indent"></span>').prependTo(node);
						}

						// 遍历列
						//return false;
					} else {
						var text = item[columns[k].field];
						if(columns[k].type) {
							if(columns[k].type == "checkbox") {
								//text = '<input type="checkbox" class="exmayui-checkbox" name="'+columns[k].field+'" />';
								//$(text).exmayCheckbox();
								var field = columns[k].field;
									field = field.substring(0,field.length-1);
								var checkboxClass = "exmayui-checkbox-unchecked";
								var checkboxValue = "-1";
								for(var c=0;c<checkeds.length;c++) {
									if((checkeds[c][typeIds]) == item.id && checkeds[c][field] == 1) {
										checkboxClass = "exmayui-checkbox-checked";
										checkboxValue = "1";
									}
								}
								text = '<span class="exmayui-tree-checkbox '+checkboxClass+'"></span>'
										+ '<input class="exmayui-tree-checkbox-value" type="hidden" name="'+columns[k].field+'" value="'+checkboxValue+'" />';
							}
						}
						var $td = $('<td>' + text + '</td>').appendTo(li);
						$td.find(".exmayui-tree-checkbox").click(function(){
							if ($(this).hasClass("exmayui-checkbox-unchecked")) {
								$(this).removeClass("exmayui-checkbox-unchecked").addClass("exmayui-checkbox-checked");
								$(this).next(".exmayui-tree-checkbox-value").val("1");
							} else if ($(this).hasClass("exmayui-checkbox-checked")) {
								$(this).removeClass("exmayui-checkbox-checked").addClass("exmayui-checkbox-unchecked");
								$(this).next(".exmayui-tree-checkbox-value").val("-1");
							}
						});
						if (columns[k].field == opts.sortable) {
							$td.addClass("exmay-ui-sortable");
							/*var $checkbox = $('<input type="checkbox" name="ids" value="" class="exmayui-checkbox exmay-ui-id" />').appendTo(li);
							$checkbox.val(item[columns[k].field]);
							$checkbox.exmayCheckbox();*/
						}
					}
				}
				if(opts.operates) {
					var $td = $('<td>' + opts.operates + '</td>').appendTo(li);
				}
				/*$('<td class="exmayui-writable">' + item["domainName"] + '</td>').appendTo(li);
				$('<td>' + item["type"] + '</td>').appendTo(li);
				$('<td>' + item["status"] + '</td>').appendTo(li);
				
				$('<td><a href="" onclick="exmayAdd();return false;">添加</a> <a href="javascript:;" onclick="exmayEdit();">编辑</a> <a href="javascript:;" onclick="exmayDelete();">删除</a> <a href="javascript:;" onclick="exmayDisable();">禁用</a></td>').appendTo(li);
				 */
			}
		}

		$("#exmay-treegrid-loading", obj).remove();

		//$(".exmay-ui-sortable-item").exmaySortable();
		
		/*$(".exmay-ui-list-table").exmaySortable({
			accepter:"#exmay-sortable",
			target:".exmay-ui-sortable-item",
			handle:".exmay-ui-sortable"
		});*/
		

	};

	// 绑定树事件
	function bindExmayTreeEvents(obj) {
		var $obj = $(obj);
		var opts = $obj.data("exmayTree").options;
		var $tree = $obj.data("exmayTree").exmayTree;

		// 展开或收缩事件绑定
		$(".exmayui-treegrid-hit", $tree).unbind(".exmayTreegrid").bind("click.exmayTreegrid", function() {
			var $node = $(this).parent("td");
				exmayToggleNode(obj, $node[0]);
				return false;
			}).bind("mouseover.exmayTreegrid", function() {
			//			if ($(this).hasClass("tree-expanded")){
				//				$(this).addClass("tree-expanded-hover");
				//			} else {
				//				$(this).addClass("tree-collapsed-hover");
				//			}
			}).bind("mouseout.exmayTreegrid", function() {
			//			if ($(this).hasClass("tree-expanded")){
				//				$(this).removeClass("tree-expanded-hover");
				//			} else {
				//				$(this).removeClass("tree-collapsed-hover");
				//			}
			});

		$('.exmayui-treegrid-file-icon', $tree).unbind('.exmayTreegrid').bind("click.exmayTreegrid", function() {
			$('.exmayui-treegrid-node-selected', $tree).removeClass('exmayui-treegrid-node-selected');
			$(this).siblings(".exmayui-treegrid-title").addClass('exmayui-treegrid-node-selected');
		}).bind('dblclick.exmayTreegrid', function() {
			$(this).siblings(".exmayui-treegrid-hit").trigger("click");

			if (opts.onDblClick) {
				var data = $(this).parent(".exmayui-treegrid-node").data("tree-node");
				opts.onDblClick.call(this, {
					id : data.id,
					text : data.text,
					img : data.img,
					icon : data.icon,
					attributes : data.attributes,
					obj : this
				});
			}
			return false;
		});

		// 标题点击事件
		$(".exmayui-treegrid-title", $tree).unbind(".exmayTreegrid").bind('click.exmayTreegrid', function() { // 单击
					$('.exmayui-treegrid-node-selected', $tree).removeClass('exmayui-treegrid-node-selected');
					$(this).addClass('exmayui-treegrid-node-selected');

					if (opts.onClick) {
						var data = $(this).parent(".exmayui-treegrid-node").data("tree-node");
						opts.onClick.call(this, {
							id : data.id,
							text : data.text,
							img : data.img,
							icon : data.icon,
							attributes : data.attributes,
							obj : this
						});

					}

					return false;
				}).bind('mouseover.exmayTreegrid', function() { // 鼠标悬停
					$(this).addClass('exmayui-treegrid-node-hover');
					return false;
				}).bind('mouseout.exmayTreegrid', function() { // 鼠标离开
					$(this).removeClass('exmayui-treegrid-node-hover');
					return false;
				});

		$(".exmayui-treegrid-row", $tree).unbind(".exmayTreegrid").bind("mouseover.exmayTreegrid", function() {
			//$(this).addClass("exmayui-treegrid-row-over");
			}).bind("mouseout.exmayTreegrid", function() {
			//$(this).removeClass("exmayui-treegrid-row-over");
			}).bind("mouseup.exmayTreegrid", function(e) {
			$(".exmayui-treegrid-row", $tree).removeClass("exmayui-treegrid-row-selected");
			//$(this).addClass("exmayui-treegrid-row-selected");
				if (e.which == 3) {
					if (opts.onRowContextMenu) {
						document.oncontextmenu = function() {
							return false;
						};
						var data = $(this).find(".exmayui-treegrid-node").data("tree-node");
						opts.onRowContextMenu.call(this, {
							id : data.id,
							text : data.text,
							img : data.img,
							icon : data.icon,
							attributes : data.attributes,
							obj : this
						}, {
							pageX : e.pageX,
							pageY : e.pageY
						});
					}
				}
			});
	};

	function exmayGetId(){
		return $(".exmay-ui-list-table").find("tr.exmayui-selected").attr("id");
	}
	
	// 处理节点
	function exmayToggleNode(obj, $node) {
		var $hit = $(">span.exmayui-treegrid-hit", $node);
		if ($hit.length == 0)
			return; // is a leaf node

		if ($hit.hasClass("exmayui-treegrid-expanded")) {
			exmayCollapseNode(obj, $node);
		} else {
			exmayExpandNode(obj, $node);
		}
	}
	;

	// 展开节点
	function exmayExpandNode(obj, node) {
		var $obj = $(obj);
		var opts = $obj.data("exmayTree").options;

		var $hit = $(">span.exmayui-treegrid-hit", node);
		if ($hit.length == 0)
			return; // is a leaf node

		if ($hit.hasClass("exmayui-treegrid-collapsed")) {
			$hit.removeClass("exmayui-treegrid-collapsed exmayui-treegrid-collapsed-hover").addClass("exmayui-treegrid-expanded");
			$hit.next().addClass("exmayui-treegrid-folder-open");
			var parentId = $(node).parent("tr").attr("parent-node-id") + "-" + $(node).attr("node-id");
			var $ul = $(node).parent("tr").siblings("tr[parent-node-id=" + parentId + "]");
			if ($ul.length) {
				// 是否有动画效果
				if (opts.animate) {
					//$ul.find("tr").slideDown();
					$ul.slideDown();
				} else {
					//$ul.find("tr").css("display","block");
					//$ul.css("display","block");
					$ul.css("display", "");
				}
				$ul.each(function() {
					exmayChangeChildrenDisplay($(this));
				});
				//				$ul.find("tr").next("div").find("tr").css("display","none");
				//				$ul.find("tr").next("div").find("tr").find("span.exmayui-treegrid-hit").removeClass("exmayui-treegrid-folder-open").addClass("exmayui-treegrid-collapsed");
			} else {
				var id = $(node).data("tree-node").id;
				//var $subUl = $('<div style="width:100%"></div>').insertAfter($(node).parent("tr"));
				exmayLoadData(obj, $(node).parent("tr"), {
					id : id
				}); // request children nodes data
			}
		}
		function exmayChangeChildrenDisplay($node) {
			var flag = $node.find("span.exmayui-treegrid-hit").hasClass("exmayui-treegrid-expanded")
			if (flag) {//下级节点是展开的，则需要显示出来
				var parentId = $node.attr("parent-node-id") + "-" + $node.find("td.exmayui-treegrid-node").attr("node-id")
				var $nodes = $("tr[parent-node-id=" + parentId + "]");
				//$nodes.css("display", "block");
				$nodes.css("display", "");
				$nodes.each(function() {
					exmayChangeChildrenDisplay($(this));
				});
			}
		}
	}
	;

	// 收缩节点
	function exmayCollapseNode(obj, node) {
		var $obj = $(obj);
		var opts = $obj.data("exmayTree").options;

		var $hit = $(">span.exmayui-treegrid-hit", node);
		if ($hit.length == 0)
			return; // is a leaf node

		if ($hit.hasClass("exmayui-treegrid-expanded")) {
			$hit.removeClass("exmayui-treegrid-expanded exmayui-treegrid-expanded-hover").addClass("exmayui-treegrid-collapsed");
			$hit.next().removeClass("exmayui-treegrid-folder-open");
			var parentId = $(node).parent("tr").attr("parent-node-id");
			var $ul = $(node).parent("tr").siblings("tr[parent-node-id=" + parentId + "-" + $(node).attr("node-id") + "]");
			var $ul2 = $(node).parent("tr").siblings("tr[parent-node-id^=" + parentId + "-" + $(node).attr("node-id") + "-]");
			// 是否有动画效果
			if (opts.animate) {
				$ul.slideUp();
				$ul2.slideUp();
				//$(node).parent("tr").next("div").find("tr").slideUp();
			} else {
				//$(node).parent("tr").next("div").css("display","none");
				$ul.each(function() {
					$(this).css("display", "none");
				});
				$ul2.each(function() {
					$(this).css("display", "none");
				});
			}
		}
	}
	;

	function exmayGetOptions($obj) {
		return {
			url : $obj.attr("url"),
			checkbox : ($obj.attr("checkbox") ? $obj.attr("checkbox") == "true" : undefined),
			animate : ($obj.attr("animate") ? $obj.attr("animate") == "true" : undefined)
		}
	}
	;

	$.fn.exmayTreegrid = function(options, param) {
		if (typeof options == "string") {
			switch (options) {
			case "options":
				return $.data(this[0], "exmayTree").options;
			case "reload":
				return this.each(function() {
					//$(this).empty();
						exmayLoadData(this, this);
					});
			case "getParent":
				return exmayGetParentNode(this[0], param);
			case "id":return exmayGetId();
			case "getChecked":
				return exmayGetCheckedNode(this[0]);
			case "getSelected":
				return exmayGetSelectedNode(this[0]);
			case "exmayIsLeaf":
				return exmayIsLeaf(this[0], param); // param is the node object
			case "select":
				return this.each(function() {
					exmaySelectNode(this, param);
				});
			case "collapse":
				return this.each(function() {
					exmayCollapseNode(this, $(param)); // param is the node object
					});
			case "expand":
				return this.each(function() {
					exmayExpandNode(this, $(param)); // param is the node object
					});
			case "append":
				return this.each(function() {
					exmayAppendNodes(this, param);
				});
			case "toggle":
				return this.each(function() {
					exmayToggleNode(this, $(param));
				});
			case "remove":
				return this.each(function() {
					exmayRemoveNode(this, param);
				});
			}
		}

		var options = options || {};

		return this.each(function() {
			var $this = $(this);
			var cache = $this.data("exmayTree");
			var opts = null;
			if (cache) {
				opts = $.extend(cache.options, options);
				cache.options = opts;
				if(!opts.cache) {
					$this.empty();
					initExmayTreegrid(this);
				}
			} else {
				opts = $.extend( {}, $.fn.exmayTreegrid.defaults, exmayGetOptions($this), options);
				$this.data("exmayTree", {
					//tree: initTree(this, opts),
						options : opts
					});
				//				exmayLoadData(this, this);
				initExmayTreegrid(this);
			}

		});
	};

	$.fn.exmayTreegrid.defaults = {
		url : null, // URL
		animate : false, // 特效
		radio : false, // 是否单选
		checkboxIndex : true,
		checkbox : false, // 是否复选
		showDeep : 1, // 展示深度
		entity : "items", // 实体
		text : "name", // 名称
		columns : [], // 列
		operates : null, // 操作
		sortable : "id",
		selectable : true,
		globals : null,
		checkeds : null,
		cache : true,
		onLoadSuccess : function() {
		}, // 数据加载成功
		onLoadError : function() {
		}, // 数据加载失败
		onClick : function(node) {
		}, // node: id,text,attributes,target
		onDblClick : function(node) {
		}, // node: id,text,attributes,target
		onRowContextMenu : function(node) {
		}
	};

})(jQuery);
