/**
 *************************************************************************************
 * [标题：ExmayUI JQuery Validator 插件]<br>
 *************************************************************************************
 * [描述：ExmayUI JQuery Validator 插件]<br>
 *************************************************************************************
 * @author Exmay Team / 亿美团队
 *************************************************************************************
 * @version Version 1.0.1 Beta / v1.0.1 测试版
 *************************************************************************************
 */

/*
 * ***********************************************************************************
 * 版权：Copyright © 2012 Exmay Inc. All Rights Reserved. 长沙亿美软件有限公司　版权所有
 * ***********************************************************************************
 * 企业文化：专注　创新　分享　共赢
 * ***********************************************************************************
 * 官方网站：http://www.exmay.com
 * ***********************************************************************************
 * 官方邮箱：service@exmay.com
 * ***********************************************************************************
 */

(function($) {
	
	var keywordRegex = /[\\~\[\]`!@#\$\%\^&\*\(\)-\+=\{\}:;<>,\.\?\|\"\/！￥·……（）——【】、；。，“‘？》《]*/ig;
	
	// 初始化验证器
	function initExmayValidator(target) {
		var $target = $(target);
		$("tr",$target).each(function(){
			$(this).addClass("exmay-ui-row");
			$(this).find("th").addClass("exmay-ui-text");
		});
		
		// 初始化友好星号提示$target===>formObj
		var form_required = exmayBooleanToString($target.attr("exmayRequired"));
		if (form_required != undefined && form_required == "true") {
			var $required = $('<span class="exmay-ui-required">*</span>');
			var $text = $(".exmay-ui-text", $target);
			$required.prependTo($text);
			$target.find("[exmayRequired]").each(function() {
				if (exmayBooleanToString($(this).attr("exmayRequired")) == "false") {
					$(".exmay-ui-required", $(this).parents(".exmay-ui-row")).remove();
				}
			});
		} else {
			$target.find("[exmayRequired]").each(function() {
				var $required = $('<span class="exmay-ui-required">*</span>');
				/*$(this).attr("exmayRequired"))在IE的类型是：string在firefox下是:boolean 需要转型*/
				if (exmayBooleanToString($(this).attr("exmayRequired")) == "true") {
					var $text = $(".exmay-ui-text", $(this).parents(".exmay-ui-row"));
					$required.prependTo($text);
				}
			});
		}
		;
		
		initExmayValidatorFromBack(target);
		
	};
	
	// 初始化后台验证
	function initExmayValidatorFromBack(target){
		$(target).find("[reg],[url]:not([reg]),[required],[validator],.exmay-ui-input-text,.exmay-ui-validator-textarea,textarea").each(function() {
			var name = $(this).attr("name");
			if(name!=undefined) {
				if(exmayValidateMessage[name] !=undefined){
					if(exmayValidateMessage[name].errors !=undefined){
						var errors = exmayValidateMessage[name].errors;
						if(errors!=undefined && errors!="") {
							var msg = {msg : errors};
							exmayChangeErrorStyle($(this), "add");
							exmayChangeTip($(this), "error", msg);
						}
					}
				}
			}
		});
	}

	//var myBool = !!"true"; 
	function exmayBooleanToString(booleanString){
		if(booleanString==undefined || booleanString=='undefined')return eval(booleanString);
		return booleanString.toString();
	};
	
	function exmayBooleanToStr(booleanString){
		if(booleanString==undefined || booleanString=='undefined')return eval(booleanString);
		return String(booleanString);
	};
	
	function exmayStringToBooleanEval(string){
		if(string==undefined || string=='undefined')return eval(string);
		return eval(string); 
	};
	
	function ExmayBooleanParse(string) { 
		if(string==undefined || string=='undefined')return eval(string);
		switch (string.toLowerCase ()) {   
			case "true": case "yes": case "1": return true;     
			case "false": case "no": case "0": case null: return false;        
			default:   return Boolean(string);  
		}
	}; 
	
	// 兼容
	function exmayGetETarget(eTarget) {
		var $eTarget = $(eTarget).parent();
		if(!$eTarget.hasClass("exmayui-textbox")) {
			$eTarget = $(eTarget);
		}
		return $eTarget;
	}
	
	function bindExmayValidatorEvents(target) {
		var $target = $(target);
		var opts = $target.data("exmayValidator").options;
		// 事件绑定
		$(target).find("[reg],[url]:not([reg]),[required],[validator],.exmay-ui-input-text,.exmay-ui-validator-textarea").each(function() {
			  /*悬浮显示提示框*/
			  $(this).hover(function() {
				var $eTarget = exmayGetETarget(this);
				if (!$eTarget.hasClass("exmayui-validator-info")) {
					var vmsg = exmayValidateMessage[$(this).attr("name")];
					if(vmsg !=undefined ) {
						var msg = vmsg.info;
						$eTarget.addClass("exmayui-validator-info");
						if(msg!="" && msg!=undefined){
							$eTarget.exmayTip("info",{msg:msg});
						}
					}
				}
			}, function() {
					var $eTarget = exmayGetETarget(this);
					var vmsg = exmayValidateMessage[$(this).attr("name")];
					if (vmsg != undefined) {
						var msg = vmsg.info;
						$eTarget.removeClass("exmayui-validator-info");
						if (msg != "" && msg != undefined) {
							$eTarget.exmayTip("info", "hide");
						}
					}
			});
		
			$(this).focus(function() {
				var $eTarget = exmayGetETarget(this);
				$eTarget.addClass("exmayui-validator-focus");
			});
			
			/*失去焦点时校验*/
			$(this).blur(function() {
				var $eTarget = exmayGetETarget(this);
				$eTarget.removeClass("exmayui-validator-focus");
				return exmayValidator($(target), $(this));
			});
			
			/*键盘粘贴和鼠标右键粘贴事件监听*/
			$(this).bind('paste', 
				function (e){
					var flags = [];
					var flag = false;
					var validator = $(this).attr("validator");
					if(contains(validator, "number", true)){
						var txt = exmayGetClipboard();
						flags.push(/\d+/.test(txt));
					}
					
					if(contains(validator, "english", true)){
						var txt = exmayGetClipboard();
						flags.push(/[a-zA-Z]+/.test(txt));
					}
					
					if(contains(validator, "ceusername", true)){
						var txt = exmayGetClipboard();
						flags.push(/^([\u4e00-\u9fa5]|[a-zA-Z])+$/.test(txt));
					}
					
					if(exmayBooleanToString($(this).attr("illegal")) == "true"){
						$(this).val($(this).val().replace(keywordRegex,""));
					}
					for(var i = 0; i < flags.length; i++) {
						if(flags[i] == true) {
							flag = true;
							break;
						}
					}
					if(!flag) {
						exmaySetClipboard("");
						exmaySetTimeout(exmayStartFocus,10,$(this));
					}
				}
			); 
			/*如果你验证的数字，那么屏蔽除数字以外的所有键盘码*/
			$(this).keypress(function(evt){
				var $this = $(this);	 
				 var myEvent = (evt) ? evt : ((window.event) ? window.event : "");
			 	 var key =myEvent.keyCode||myEvent.which||myEvent.charCode;
			 	 var validator =$(this).attr("validator");
			 	 if(validator == "number"){
			 		if(key > 47 && key <58 || key == 8 ){
			 			return true;
			 		}else{
			 			return false;
			 		}		 
			 	 }
			 	 
			 	 if(validator == "english"){
			 		 if(key >= 97 && key <=122 || key >=65 && key <=90 ){
			 			return true;
			 		}else{
			 			return false;
			 		}		 
			 	 }
			});
			
			$(this).keyup(function(evt) { // 失去焦点时校验
				var myEvent = (evt) ? evt : ((window.event) ? window.event : "");
			 	var key =myEvent.keyCode||myEvent.which||myEvent.charCode;
			 	var validator =$(this).attr("validator");
			 	
				if(key != 35 && key!=36 && key!=37 && key!=39){
				 	var $this = $(this);	
				 	var $eTarget = exmayGetETarget(this);
					$eTarget.removeClass("exmayui-validator-focus");
					
					if(validator == "number"){
						$this.val($this.val().replace(/\D/g,""));
					}
					
					if(validator == "chinese"){
						$this.val($this.val().replace(/[^\u4e00-\u9fa5|\w]/g,""));
					}
					
					if(validator == "english"){
						$this.val($this.val().replace(/[^a-zA-Z]/g,""));
					}
					
					if(validator == "illegal"){
						$this.val($this.val().replace(keywordRegex,""));
					}
				}
			});
		});
		
		if($(target).find("#exmay-ui-submit").html() == null){
			/*提交事件监听*/
			$(target).submit(function() {
				return exmayValidating(target);
			});
		}
		
		/*鼠标光标落到文本内容之后*/
		if($(target).hasClass(opts.focus)){
			setIndexLastWord(opts.focus);
		}
	};
	
	function setIndexLastWord(focusClass) {
	 	var tar = $("."+focusClass).get(0);
	 	if(tar.setSelectionRange) {
	 		tar.setSelectionRange(tar.value.length , tar.value.length);
	 	} else {
	 		var range = tar.createTextRange();
	 		range.moveStart("character",tar.value.length);
			range.moveEnd("character",tar.value.length);
			range.select();
	 	}
	 	tar.focus();
	}
	
	function exmayStartFocus($target){
		$target.focus();
	};
	
 	
	function exmayValidating(target) {
		var isSubmit = true;
		$(target).find("[reg],[url]:not([reg]),[required],[validator],.exmay-ui-input-text,.exmay-ui-validator-textarea").each(function() {
			if(!$(this).parents("tr").is(":hidden")){
				var submit = exmayValidator($(target), $(this));
				if (!submit) {
					isSubmit = false;
				}
			}
		});
		
		
		return isSubmit;
	}
	

	// 校验器
	function exmayValidator($form, $target) {
		var isSubmit = true;
		// 必填字段校验
		var form_required = exmayBooleanToString($form.attr("exmayRequired"));
		if (form_required!="" &&  form_required !=undefined &&  form_required == "true") { // 表单整体校验，显式声明除外
			if (exmayBooleanToString($target.attr("exmayRequired")) != "false") {
				if (!exmayRequired($target)) {
					return false;
				}
			}
		} else {
			if (exmayBooleanToString($target.attr("exmayRequired")) == "true") { // 非空判断
				if (!exmayRequired($target)) {
					return false;
				}
			}
		};
		
		if (!exmayLength($target)) {
			return false;
		}
		
		if (!exmayValidatePassword($target)) {
			return false;
		}
		
		// AJAX校验
		 if ($target.attr("reg") != undefined) {
			if (!exmayValidate($target)) {
				isSubmit = false;
			}
		} else if ($target.attr("validator") != undefined) {
			if($target.val() != ""){
				if($.fn.exmayValidator.methods[$target.attr("validator")] !=undefined){
					if (!$.fn.exmayValidator.methods[$target.attr("validator")]($target[0])) {
						isSubmit = false;
					}
				}
			}
			;
		} else if ($target.attr("equalTo") != undefined) {
			return exmayEqualTo($target, $target.attr("equalTo"));
		}
		 if (isSubmit && !$target.hasClass("exmayui-combobox") &&  $target.attr("url") != undefined) {
			if (!exmayAjaxValidate($target)) {
				isSubmit = false;
			}
		}
		return isSubmit;
	}
	;

	// 普通验证$target 
	function exmayValidate($target, reg, msg) {
		var exmayValidator = $target.parents("form").data("exmayValidator");
		if(exmayValidator != undefined && $target.attr("validator") != undefined) {
			return formValidator();
		} else {
			return singleValidator();
		}
		function singleValidator(){
			var targetValue = $target.attr("value");
			if (reg == null) {
				reg = new RegExp($target.attr("reg"));
			}
			if (!reg.test(targetValue)) {
				return false;
			} else {
				if ($target.attr("url") == undefined) {
					return true;
				} else {
					return exmayAjaxValidate($target);
				}
			}			
		}
		function formValidator() {
			var opts = exmayValidator.options;
			if (reg == null) {
				reg = new RegExp($target.attr("reg"));
			}
			var targetValue = $target.attr("value");
			if (!reg.test(targetValue)) {
				exmayChangeErrorStyle($target, "add");
				exmayChangeTip($target, "error", msg);
				return false;
			} else {
				if ($target.attr("url") == undefined) {
					exmayChangeErrorStyle($target, "remove");
					exmayChangeTip($target, "remove", msg);
					var dataMsg  = "";
					if(exmayValidateMessage[$target.attr("name")]!=undefined && exmayValidateMessage[$target.attr("name")].success!=undefined){
						dataMsg= exmayValidateMessage[$target.attr("name")].success;
						if(dataMsg == "" || dataMsg==undefined || dataMsg=="undefined"){
							dataMsg = opts.success;
						}
					}else{
						dataMsg = opts.success;
					}
					var $eTarget = exmayGetETarget($target[0]);
					$eTarget.exmayTip("success", {"msg":dataMsg});
					return true;
				} else {
					return exmayAjaxValidate($target);
				}
			}
		}	
	};

	// AJAX验证
	function exmayAjaxValidate($target) {
		var opts = $target.parents("form").data("exmayValidator").options;
		var url = $target.attr("url")+"?ajax=true";
		if (url.indexOf("?") != -1) {
			url = url + "&" + $target.attr("name") + "=" + $target.attr("value");
		} else {
			url = url + "?" + $target.attr("name") + "=" + $target.attr("value");
		}
		if($target.attr("param")!=undefined && $target.attr("param")!=''){
			url = url+"&"+$target.attr("param")+"="+$target.attr("value");
		}
		url = encodeURI(url);
		url = encodeURI(url);
		var data = $.ajax( {
			url : url,
			cache : false,
			async : false
		}).responseText;
		data = data.replace(/(^\s*)|(\s*$)/g, "");
		var d = eval("("+data+")");
		if (d.exmay == "fail") {
			exmayChangeErrorStyle($target, "success");
			exmayChangeTip($target, "success", {msg : opts.success});
			return true;
		} else {
			exmayChangeErrorStyle($target, "error");
			var tipMsg = $target.val()+"已经存在！";
			if($target.attr("tip")!=undefined && $target.attr("tip")!=""){
				tipMsg = $target.val()+$target.attr("tip"); 
			}
			exmayChangeTip($target, "error", {msg :tipMsg});
			return false;
		}
	}
	;

	// 非空校验
	function exmayRequired($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /[^(^\s*)|(\s*$)]/, {
			msg : text+"不允许为空！"
		});
	}

	function exmayEqualTo($target, target) {
		if (!$target.valueOf($(target).val())) {
			exmayChangeErrorStyle($target, "remove");
			exmayChangeTip($target, null, "remove");
			return false;
		}
	}

	// 表单错误样式
	function exmayChangeErrorStyle($target, action) {
		var $eTarget = exmayGetETarget($target[0]);
		if (action == "add") { // 失败
			$eTarget.addClass("exmayui-validator-error");
		} else if (action == "warning") {
			$eTarget.removeClass("exmayui-validator-error");
			$eTarget.addClass("exmayui-validator-warning");
		} else if (action == "error") {
			$eTarget.addClass("exmayui-validator-error");
		} else {// 成功
			$eTarget.removeClass("exmayui-validator-error");
			$eTarget.addClass("exmayui-validator-success");
		}
	}
	;

	function exmayChangeTip($target, action, data) {
		var $eTarget = exmayGetETarget($target[0]);
		if (action == "add") {
		} else if (action == "error") { // 成功
			if(data == "")data = {msg : exmayValidateMessage[$target.attr("name")].error };
			$eTarget.exmayTip("error", data);
		} else if (action == "warning") {
			if(data=="")data = {msg : exmayValidateMessage[$target.attr("name")].warning };
			$eTarget.exmayTip("warning", data);
		} else if (action == "success") { // 成功
			if(data=="")data = {msg : exmayValidateMessage[$target.attr("name")].success };
			$eTarget.exmayTip("success", data);
		}else{
			
		}
	};
	
	/*
	*
	*string:原始字符串
	*substr:子字符串
	*isIgnoreCase:忽略大小写
	*/

	function contains(string, substr, isIgnoreCase) {
		if (isIgnoreCase) {
			string = string.toLowerCase();
			substr = substr.toLowerCase();
		}
		var startChar = substr.substring(0, 1);
		var strLen = substr.length;
		for ( var j = 0; j < string.length - strLen + 1; j++) {
			if (string.charAt(j) == startChar)// 如果匹配起始字符,开始查找
			{
				if (string.substring(j, j + strLen) == substr)// 如果从j开始的字符与str匹配，那ok
				{
					return true;
				}
			}
		}
		return false;
	}
	
	function exmayKeyword($target){
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /[\\~\[\]`!@#\$\%\^&\*\(\)-\+=\{\}:;\'<>,\.\?\|\"\/！￥·……（）——【】、；。，“‘？》《]+/, {
			msg : text+"存在非法字符！！"
		});
	};
	
	/*验证中文*/
	function exmayChinese($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /[\u4e00-\u9fa5]/, {
			msg : text+"格式不正确！请输入中文字符！"
		});
	};
	
	/*纯字母*/	
	function exmayEnglish($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /^[A-Za-z]+$/, {
			msg : text+"格式不正确！只允许输入英文字符！"
		});
		;
	};
	
	/*纯中文或者英文*/
	function exmayChineseOrEnglish($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target,/^([\u4e00-\u9fa5]|[\w])+$/, {
			msg : text+"格式不正确！请输入中文字符或者纯英文字符！"
		});
	};
	
	function exmayCeUsername($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
			return exmayValidate($target,/^[\u4e00-\u9fa5_a-zA-Z][\u4e00-\u9fa5\w]+$/, {
			msg : text+"格式不正确！由中文、大小写英文字母、数字、下划线组成，不能以数字开头！"
		});
	};	
	
	function exmayTitle($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /^([\u4e00-\u9fa5][\w])+$/, {
			msg : text+"格式不正确！！"
		});
	};
	
	/*验证日期*/
	function exmayDate($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /^(((([0-9]{2}(([2468][048])|([02468][48])|([13579][26])))|((([02468][048])|([13579][26]))(00)))(-)(2|02)(-)(([0]?[1-9])|([1-2][0-9])))|((([0-9]{2}([02468][1235679])|([13579][0133445789]))|((([02468][1235679])|([13579][01345789]))(00)))(-)(2|02)(-)(([0]?[1-9])|([1][0-9])|([2][0-8])))|(([0-9]{4})(-)(((([0]?(1|3|5|7|8))|(10|12))(-)(([0]?[1-9])|([1-2][0-9])|30|31))|(((([0]?(4|6))|11))(-)(([0]?[1-9])|([1-2][0-9])|30)))))$/, {
			msg : text+"格式不正确！"
		});
	};
	
	/**验证生日**/
	function exmayBirthday($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target,/^((((1[6-9]|[2-9]\d)\d{2})-(0?[13578]|1[02])-(0?[1-9]|[12]\d|3[01]))|(((1[6-9]|[2-9]\d)\d{2})-(0?[13456789]|1[012])-(0?[1-9]|[12]\d|30))|(((1[6-9]|[2-9]\d)\d{2})-0?2-(0?[1-9]|1\d|2[0-8]))|(((1[6-9]|[2-9]\d)(0[48]|[2468][048]|[13579][26])|((16|[2468][048]|[3579][26])00))-0?2-29-))$/,{
			msg : "请正确输入"+text+"！"
		});	 
	}
	
	/*传真*/
	function exmayFax($target){
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target,/^[+]{0,1}(\d){1,3}[ ]?([-]?((\d)|[ ]){1,12})+$/,{
			msg : "请正确输入"+text+"！"
		});	
	};
	
	/*域名*/
	function exmayDomain($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /^([\w-]+\.)+((com)|(net)|(org)|(gov\.cn)|(info)|(cc)|(com\.cn)|(net\.cn)|(org\.cn)|(name)|(biz)|(tv)|(cn)|(mobi)|(name)|(sh)|(ac)|(io)|(tw)|(com\.tw)|(hk)|(com\.hk)|(ws)|(travel)|(us)|(tm)|(la)|(me\.uk)|(org\.uk)|(ltd\.uk)|(plc\.uk)|(in)|(eu)|(it)|(jp))$/, {
			msg : text+"格式不正确！"
		});
	};
	
	/*邮箱*/
	function exmayEmail($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return  exmayValidate($target, /^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?$/i, {
			msg : text+"格式不正确！请重新输入必须含有@符号！"
		});
	};
	/*身份证*/
	function exmayIdcard($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /^\d{15}(\d{2}[A-Za-z0-9])?$/, {
			msg : text+"格式不正确！"
		});
	};
	/*正整数*/
	function exmayInteger($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /^[-\+]?\d+$/, {
			msg : text+"格式不正确！只允许输入整数！"
		});
		;
	};
	/*IP*/
	function exmayIp($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /^\d+.\d+.\d+.\d+$/, {
			msg : text+"格式不正确！"
		});
	}
	;
	/*浮点数*/
	function exmayDouble($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /^[-\+]?\d+(\.\d+)?$/, {
			msg : text+"格式不正确！只允许输入双精度腹浮点数！"
		});
		;
	};
	/*普通邮箱验证*/
	function exmayEmailNormal($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$/, {
			msg : text+"格式不正确！请重新输入！"
		});
		;
	};

	/*手机号码*/
	function exmayMobile($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /^(13|15|18)\d{9}$/, {
			msg : text+"格式不正确！"
		});
	};
	
	/*金额*/
	function exmayMoney($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /^-?\d+\.{0,}\d{0,}$/, {
			msg : text+"格式不正确！请重新输入金额！"
		});
	};
	/*数字*/
	function exmayNumber($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /^\d{1,}$/, {
			msg : text+"格式不正确！！"
		});
	};
	/*验证后缀是否为html stml htm*/
	function exmayHtml($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /(.htm|.html|.shtml)$/, {
			msg : text+"格式不正确！"
		});
	};
	/*是否包含html标签*/
	function exmayHtmlTag() {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /<(.*)>.*<\/>|<(.*) \/>/, {
			msg : text+"格式不正确！不允许包含HTML标记！"
		});
	};
	
	function exmayCode($target){
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /^[\w-]{1,20}$/, {
			msg : text+"代号输入不正！(由数字字母组成下划线(1-20位)！)"
		});
	}
	/*图片后缀*/
	function exmayImg($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /(.jpg|.gif|.bmp|.png|.img|.swf)$/, {
			msg : text+"图片格式不正确！"
		});
	};
	/*gif png小图标验证*/
	function exmayPngOrGif($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /(.gif|.png)$/, {
			msg : text+"小图标格式不正确！格式为(gif,png)大小:(16 x 16)"
		});
	};
	
	/*验证密码*/
	function exmayPassword($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /^[\dA-Za-z(!@#$%&)]{4,16}$/, {
			msg : text+"以输入数字，字母)组合[4-16位]！"
		});
	};
	
	/*固定电话*/
	function exmayPhone($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target,/^((\d{3,4})|\d{3,4}-)?\d{7,8}$/, {
			msg : text+"格式不正确！请重新输入！"
		});
	};
	
	/*用户名*/
	function exmayUsername($target) {
		var reg = new RegExp();
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /^[a-zA-Z][a-zA-Z0-9_-]{4,15}$/, {
			msg : "请正确填写"+text+"！(字母开头，允许5-16字节，允许字母数字下划线)！"
		});
		;
	};
	
	/*链接验证(URL)*/
	function exmayUrl($target){
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		if($target.val()!=""){
			return exmayValidate($target, /^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i, {
				msg : text+"格式不正确！请重新输入！(请遵循HTTP协议！)"
			});
		}
	};

	/* 匹配腾讯QQ号*/
	function exmayQq($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /^[1-9]*[1-9][0-9]*$/, {
			msg : text+"格式不正确！请重新输入！"
		});
	};
	
		/* 匹配腾讯Msn号*/
	function exmayMSN($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/, {
			msg : text+"格式不正确！请重新输入！"
		});
	};

	/* 邮编*/
	function exmayZip($target) {
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /^\d{1,}$/, {
			msg : text+"格式不正确！请重新输入！"
		});
	};
	
		
	/*只能输入非零整数*/
	function exmayCheckNumberInteger($target){
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /^[1-9][0-9]*$/, {
			msg : text+"只能输入非零整数！"
		});
	};
	
	/*只能输入非零负数*/
	function exmayCheckNumberNegative($target){
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /^-[1-9][0-9]*$/, {
			msg : text+"只能输入非零负数！"
		});
	};
	
	/*备案号*/
	function exmayICP($target){
		var text = $target.parents("tr.exmay-ui-row").find(".exmay-ui-text").text().replace(/^(\*)/,"");
		return exmayValidate($target, /[\u4e00-\u9fa5\d-]+$/, {
			msg : "请正确填写"+text+"！"
		});
	};
	
	
	/* 长度注意这个$target是form对象.*/
	function exmayLength($target) {
		var max = $target.attr("max");
		var min = $target.attr("min");
		var value = $target.val();
		var text = $(".exmay-ui-text", $target.parents(".exmay-ui-row")).text().replace(/^(\*)/,"");
		var isSubmit = true;
		if(max!="" && max!=undefined && max !="undefined" && !isNaN(max)){
			if(value.length > max && value!=""){
				exmayChangeErrorStyle($target, "add");
				exmayChangeTip($target, "error",{msg :text+"长度不能超过"+max+"个!"});
				isSubmit =  false;
			}
		}
		
		if(min!=""&&  min !=undefined && min !="undefined" && !isNaN(min)){
			if(value.length < min && value!=""){
				exmayChangeErrorStyle($target, "add");
				exmayChangeTip($target, "error",{msg :text+"长度不能少于"+min+"个!"});
				isSubmit = false;
			}
		}
		return isSubmit;
	};
	
	function exmayValidateIllegal($target){
		if($target.val()!=""){
			if(exmayBooleanToString($target.attr("illegal")) == "true"){
				var confirmText = $(".exmay-ui-text", $target.parents(".exmay-ui-row")).text().replace(/^(\*)/,"");
				if(keywordRegex.test($target.val())){
					exmayChangeErrorStyle($target, "add");
					exmayChangeTip($target, "error",{msg :confirmText+"存在非法关键字！"});
					isSubmit = false;
				}
			}
		}
	};
	
	/*密码验证*/
	function exmayValidatePassword($target) {
		var isSubmit = true;
		var pname = 	$target.attr("to");
		var confirmText = $(".exmay-ui-text", $target.parents(".exmay-ui-row")).text();
		if(pname!=undefined){
			var pwdText = $(".exmay-ui-text", $("input[name='"+pname+"']").parents(".exmay-ui-row")).text().replace(/^(\*)/,"");	
			var pwd = $("input[name='"+pname+"']").val();
			var confirmPwd = $target.val();
			if(pwd != confirmPwd && pwd!="" && confirmPwd!=""){
				exmayChangeErrorStyle($target, "add");
				exmayChangeTip($target, "error",{msg :confirmText+"与"+pwdText+"不一致,请重新输入！"});
				isSubmit = false;
			}
		}
		return isSubmit;
	};
	

	// 长度验证
	function exmayVerifyLength($target, data) {
		var maxChars = $target.attr("maxlength");
		var contentValue = $target.val();
		var contentLength = contentValue.length;

		var inputLenght = null;
		var residueLength = null;
		if (data == undefined || data.type == undefined || data.type == null) {
			inputLenght = contentLength;
			residueLength = maxChars - contentLength;
		} else {
			for ( var i = Math.floor(maxChars / 2); i < contentLength; i++) {
				var content = contentValue.substring(0, i);
				if (content.replace(/([\u0391-\uFFE5])/ig, '111').length >= maxChars) {
					contentValue = contentValue.substring(0, i);
					document.getElementById(name + "-length").innerHTML = curr.toString(0);
					break;
				}
			}
			var input = contentValue.replace(/([\u0391-\uFFE5])/ig, '111');
			var inputLenght = input.length;
			var residueLength = maxChars - input.length;
		}
		var id = $target.attr("id");
		var $currentLength = $("#" + id + "-length");
		var $residueLength = $("#" + id + "-residue-length");
		if ($currentLength.html() != null) {
			$currentLength.html(inputLenght);
		}
		if ($residueLength.html() != null) {
			$residueLength.html(residueLength);
		}
	}
	;

	// 客户端校验器
	$.fn.exmayValidator = function(options, data) {
		// 方法调用
		if (typeof options == "string") {
			return $.fn.exmayValidator.methods[options](this, data);
		}
		this.each(function() {
			var $this = $(this);
			var opts = null;
			var cache = $this.data("exmayValidator");
			if (cache) {
				opts = $.extend(cache.options, options);
				cache.options = opts;
			} else {
				opts = $.extend( {}, $.fn.exmayValidator.defaults, $.fn.exmayValidator.parseOptions($this), options);
				$this.data("exmayValidator", {
					options : opts
				});
				initExmayValidator(this);
				bindExmayValidatorEvents(this);
			}
		});

	};

	// 插件方法
	$.fn.exmayValidator.methods = {
		chinese : function(target, data) {
			return exmayChinese($(target));
		},
		chineseName : function(target, data) {
			return exmayChineseName($(target));
		},
		doubler : function(target, data) {
			return exmayDouble($(target));
		},
		domain : function(target, data) {
			return exmayDomain($(target));
		},
		keyword:function(target,data){
			return exmayKeyword($(target));	
		},
		english : function(target, data) {
			return exmayEnglish($(target));
		},
		icp:function(target, data) {
			return exmayICP($(target));
		},
		email : function(target, data) {
			return exmayEmail($(target));
		},
		mobile : function(target, data) {
			return exmayMobile($(target));
		},
		money : function(target, data) {
			return exmayMoney($(target));
		},
		number : function(target, data) {
			return exmayNumber($(target));
		},
		html : function(target, data) {
			return exmayHtml($(target));
		},
		htmlTag : function(target, data) {
			return exmayHtmlTag($(target));
		},
		idcard : function(target, data) {
			return exmayIdcard($(target));
		},
		code:function(target,data){
			return exmayCode($(target));
		},
		img : function(target, data) {
			return exmayImg($(target));
		},
		integer : function(target, data) {
			return exmayInteger($(target));
		},
		ip : function(target, data) {
			return exmayIp($(target));
		},
		fax : function(target,data){
			return exmayFax($(target));	
		},
		password : function(target, data) {
			return exmayPassword($(target));
		},
		phone : function(target, data) {
			return exmayPhone($(target));
		},
		url : function(target, data) {
			return exmayUrl($(target));
		},
		ceusername:function(target, data) {
			return exmayCeUsername($(target));
		},
		title : function(target, data) {
			return exmayTitle($(target));
		},
		username : function(target, data) {
			return exmayUsername($(target));
		},
		date : function(target,data){
			return exmayDate($(target));
		},
		birthday : function(target, data) {
			return exmayBirthday($(target));
		},
		qq : function(target, data) {
			return exmayQq($(target));
		},
		zip : function(target, data) {
			return exmayZip($(target));
		},
		png :  function(target, data) {
			return exmayPngOrGif($(target));
		},
		msn:function(target,data){
			return exmayMSN($(target));
		},
		verifyLength : function(target, data) {
			$(target).each(function(){
				$(this).exmayChangable( {
					onChange : function() {
						exmayVerifyLength($(this));
					}
				});
			});
		},
		validate : function (target, data) {
			return exmayValidating(target);
		}
	};

	// 解析插件属性
	$.fn.exmayValidator.parseOptions = function(target) {
		var $target = $(target);
		return {
			required : $target.attr("exmayRequired"),
			reg : $target.attr("reg")
		}
	};

	$.fn.exmayValidator.defaults = {
		required : false,
		success :"输入正确",
		focus:"exmay-ui-focus"
	};

})(jQuery);