/* This is an example of how to cancel all the files queued up.  It's made somewhat generic.  Just pass your SWFUpload
object in to this method and it loops through cancelling the uploads. */
function cancelQueue(instance) {
	alert(instance);
	//document.getElementById(instance.customSettings.cancelButtonId).disabled = true;
	/* [exmay button @1] */
	$("#exmay-upload-start").exmayButton("disable");
	$("#"+instance.customSettings.cancelButtonId).exmayButton("disable");
	instance.stopUpload();
	var stats;
	do {
		stats = instance.getStats();
		instance.cancelUpload();
	} while (stats.files_queued !== 0);
}

/* **********************
   Event Handlers
   These are my custom event handlers to make my
   web application behave the way I went when SWFUpload
   completes different tasks.  These aren't part of the SWFUpload
   package.  They are part of my application.  Without these none
   of the actions SWFUpload makes will show up in my application.
   ********************** */
function fileDialogStart() {
	/* I don't need to do anything here */
	//$("#thunmimg").html("");
}
function fileQueued(file) {
	try {
		// You might include code here that prevents the form from being submitted while the upload is in
		// progress.  Then you'll want to put code in the Queue Complete handler to "unblock" the form
		var progress = new FileProgress(file, this.customSettings.progressTarget);
		progress.setStatus("准备上传...");
		progress.toggleCancel(true, this);

	} catch (ex) {
		this.debug(ex);
	}
}

function fileDialogComplete(numFilesSelected, numFilesQueued) {
	try {
		if (this.getStats().files_queued > 0) {
			//document.getElementById(this.customSettings.cancelButtonId).disabled = false;
			/* [exmay button @2] */
			$("#exmay-upload-start").exmayButton("enable");
			$("#"+this.customSettings.cancelButtonId).exmayButton("enable");
			
		}
		//this.startUpload();
	} catch (ex)  {
        this.debug(ex);
	}
}

/* 上传开始 */
function uploadStart(file) {
	try {
		/* I don't want to do any file validation or anything,  I'll just update the UI and return true to indicate that the upload should start */
		var progress = new FileProgress(file, this.customSettings.progressTarget);
		progress.setStatus("上传中...");
		progress.toggleCancel(true, this);
	}
	catch (ex) {
	}
	
	return true;
}

/* 上传进度 */
function uploadProgress(file, bytesLoaded, bytesTotal) {

	try {
		var percent = Math.ceil((bytesLoaded / bytesTotal) * 100);
		var progress = new FileProgress(file, this.customSettings.progressTarget);
		progress.setProgress(percent);
		progress.setStatus("正在上传...");
	} catch (ex) {
		this.debug(ex);
	}
};

function exmayUploadAttachmentSuccess(serverData){
	var data = eval("(" + serverData + ")"); 
	var ext = data.ext;
	var path = data.path;
	ext = ext.toLowerCase();
	if(!isValidImage(ext)){
		path = Exmay.path.img+"/file/ext/"+ext+".png";
	}
	Exmay.file.id = "exmay-attachment-"+exmayYMD();
	Exmay.file.path = data.path;
	Exmay.file.ext = ext;
	Exmay.file.name = data.fileName;
	Exmay.file.alias = data.alias;
	Exmay.file.size = data.size;
	Exmay.file.url = path;
	Exmay.file.views = data.downloadCount;
	Exmay.file.type = "server";
	exmayGetParentWindow().exmayGetCacheMap().push(exmayGetCache(Exmay.file));
	$("#exmay-attachment").append(exmayAppendAttachment(Exmay.file,"local"));/*追加数据到表格*/
};


function exmayUploadPictureSuccess(serverData){
	var data = eval("(" + serverData + ")"); 
	var imgId = "exmay-picture-"+exmayYMD();
	$("#exmay-picture-store-img").prepend(exmayData(data.path,imgId));
	$(".exmay-ui-file-group").bind("mousedown", function() {selectImg = $(this).attr("src");selectId = $(this).attr("id");});
	$('#exmay-menu').exmayMenu( {contextMenu : true,target : ".exmay-ui-file-group"});
	/*放入到图片数组中*/
	exmayGetParentWindow().exmayGetImgCacheMap().push("{url:'"+data.path+"',id:'"+imgId+"',status:'server'}");
	exmayGetParentWindow().exmayInsertImgToEditor(data.path,imgId);
};

/*多媒体*/
function exmayUploadMediaSuccess(serverData){
	var data = eval("(" + serverData + ")"); 
	var imgId = "exmay-media-"+exmayYMD();
	/*上传成功后截图(默认截取视频中第一秒的图片)*/
	data.id = imgId;
	data.url = Exmay.path.img+"/file/ext/"+data.ext+".png";
	exmayGetParentWindow().exmayGetMediaCacheMap().push(exmayGetCache(data));
	$("#exmay-media-store-img").prepend(exmayAddMediaData(data));
	$('#exmay-media-menu').exmayMenu( {contextMenu : true,target : ".exmay-ui-midea-group"});
}


function exmayUploadDownLoadSuccess(serverData){
	var data = eval("(" + serverData + ")"); 
	var imgId = "exmay-picture-"+exmayYMD();
	$("#exmay-picture-store-img").show().prepend(exmayData(data.path,imgId));
	$(".exmay-ui-file-group").bind("mousedown", function() {selectImg = $(this).attr("src");selectId = $(this).attr("id");});
	$('#exmay-menu').exmayMenu( {contextMenu : true,target : ".exmay-ui-file-group"});
};

function uploadSuccess(file, serverData) {
	try {
		var progress = new FileProgress(file, this.customSettings.progressTarget);
		
		progress.setComplete();
		progress.setStatus("上传完毕！");
		progress.toggleCancel(false);
		
		var library = $("#exmay-tabs").attr("library");
		if(library==undefined || library == "" || library=="undefined"){
			library = $("#library").val();
		}
		//alert(library);
		if(library!="" && library!=undefined && library!='single'){
			switch(library){
				case "image":exmayUploadPictureSuccess(serverData);break;
				case "attachment":exmayUploadAttachmentSuccess(serverData);break;
				case "media" : exmayUploadMediaSuccess(serverData);break;
				case "jpg" : exmayAddPictureGroupData(serverData);exmaySetThumbNailImg();break;
				case "downJpg" : exmayDownJpgData(serverData);break;
				case "download" : exmayDownloadData(serverData);break;
				case "pictureGroup" : exmayPictureGroupEdit(serverData);break;
				case "resource" : exmayResourceUpload(serverData);break;
			}
		}else{
			if(exmayUploadSuccess instanceof Function) {
				exmayUploadSuccess(serverData);
			}
		}
		
	} catch (ex) {
		this.debug(ex);
	}
};

/* 上传完成 */
function uploadComplete(file) {
	try {
		/*  I want the next upload to continue automatically so I'll call startUpload here */
		if (this.getStats().files_queued === 0) {
			/* [exmay button @3] */
			$("#exmay-upload-start").exmayButton("disable");
			$("#"+this.customSettings.cancelButtonId).exmayButton("disable");
			$("#exmay-picture-upload").hide();
			if($("#library").val()=='resource'){
				exmayRefreshRecycle();				
			}
			if(exmayUploadComplete instanceof Function) {
				exmayUploadComplete(file);
			}
			//document.getElementById(this.customSettings.cancelButtonId).disabled = true;
		} else {	
			this.startUpload();
		}
	} catch (ex) {
		this.debug(ex);
	}

};

function uploadError(file, errorCode, message) {
	var msg;
	switch (errorCode)
	{
		case SWFUpload.UPLOAD_ERROR.HTTP_ERROR:
			msg = "上传错误: " + message;
			break;
		case SWFUpload.UPLOAD_ERROR.UPLOAD_FAILED:
			msg = "上传错误";
			break;
		case SWFUpload.UPLOAD_ERROR.IO_ERROR:
			msg = "服务器 I/O 错误";
			break;
		case SWFUpload.UPLOAD_ERROR.SECURITY_ERROR:
			msg = "服务器安全认证错误";
			break;
		case SWFUpload.UPLOAD_ERROR.FILE_VALIDATION_FAILED:
			msg = "附件安全检测失败，上传终止";
			break;
		case SWFUpload.UPLOAD_ERROR.FILE_CANCELLED:
			msg = '上传取消';
			if (this.getStats().files_queued === 0) {
				//document.getElementById(this.customSettings.cancelButtonId).disabled = true;
				/* [exmay button @4] */
				$("#exmay-upload-start").exmayButton("disable");
				$("#"+this.customSettings.cancelButtonId).exmayButton("disable");
			}
			break;
		case SWFUpload.UPLOAD_ERROR.UPLOAD_STOPPED:
			msg = '上传终止';
			break;
		case SWFUpload.UPLOAD_ERROR.UPLOAD_LIMIT_EXCEEDED:
			msg = '单次上传文件数限制为 '+swfu.settings.file_upload_limit+' 个';
			break;
		default:
			msg = message;
			break;
		}
	var progress = new FileProgress(file,this.customSettings.progressTarget);
	progress.setError();
	progress.setStatus(msg);
}

function fileQueueError(file, errorCode, message)
{
	var errormsg;
	switch (errorCode) {
	case SWFUpload.QUEUE_ERROR.ZERO_BYTE_FILE:
		errormsg = "请不要上传空文件";
		break;
	case SWFUpload.QUEUE_ERROR.QUEUE_LIMIT_EXCEEDED:
		errormsg = "队列文件数量超过设定值";
		$.exmayMessagebox.alert("上传提示", errormsg ,"warning");
		return;
		break;
	case SWFUpload.QUEUE_ERROR.FILE_EXCEEDS_SIZE_LIMIT:
		errormsg = "文件尺寸超过设定值";
		break;
	case SWFUpload.QUEUE_ERROR.INVALID_FILETYPE:
		errormsg = "文件类型不合法";
	default:
		errormsg = '上传错误，请与管理员联系！';
		break;
	}

	var progress = new FileProgress('file',this.customSettings.progressTarget);
	progress.setError();
	progress.setStatus(errormsg);

}

/* 上传失败
function uploadError(file, errorCode, message) {
	try {
		var progress = new FileProgress(file, this.customSettings.progressTarget);
		progress.setError();
		progress.toggleCancel(false);

		switch (errorCode) {
		case SWFUpload.UPLOAD_ERROR.HTTP_ERROR:
			progress.setStatus("Upload Error: " + message);
			this.debug("Error Code: HTTP Error, File name: " + file.name + ", Message: " + message);
			break;
		case SWFUpload.UPLOAD_ERROR.MISSING_UPLOAD_URL:
			progress.setStatus("Configuration Error");
			this.debug("Error Code: No backend file, File name: " + file.name + ", Message: " + message);
			break;
		case SWFUpload.UPLOAD_ERROR.UPLOAD_FAILED:
			progress.setStatus("Upload Failed.");
			this.debug("Error Code: Upload Failed, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		case SWFUpload.UPLOAD_ERROR.IO_ERROR:
			progress.setStatus("Server (IO) Error");
			this.debug("Error Code: IO Error, File name: " + file.name + ", Message: " + message);
			break;
		case SWFUpload.UPLOAD_ERROR.SECURITY_ERROR:
			progress.setStatus("Security Error");
			this.debug("Error Code: Security Error, File name: " + file.name + ", Message: " + message);
			break;
		case SWFUpload.UPLOAD_ERROR.UPLOAD_LIMIT_EXCEEDED:
			progress.setStatus("Upload limit exceeded.");
			this.debug("Error Code: Upload Limit Exceeded, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		case SWFUpload.UPLOAD_ERROR.SPECIFIED_FILE_ID_NOT_FOUND:
			progress.setStatus("File not found.");
			this.debug("Error Code: The file was not found, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		case SWFUpload.UPLOAD_ERROR.FILE_VALIDATION_FAILED:
			progress.setStatus("Failed Validation.  Upload skipped.");
			this.debug("Error Code: File Validation Failed, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		case SWFUpload.UPLOAD_ERROR.FILE_CANCELLED:
			if (this.getStats().files_queued === 0) {
				//document.getElementById(this.customSettings.cancelButtonId).disabled = true;
				$("#"+this.customSettings.cancelButtonId).exmayButton("disable");
			}
			progress.setStatus("Cancelled");
			progress.setCancelled();
			break;
		case SWFUpload.UPLOAD_ERROR.UPLOAD_STOPPED:
			progress.setStatus("Stopped");
			break;
		default:
			progress.setStatus("Unhandled Error: " + error_code);
			this.debug("Error Code: " + errorCode + ", File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		}
	} catch (ex) {
        this.debug(ex);
    }
}


function fileQueueError(file, errorCode, message) {
	try {
		if (errorCode === SWFUpload.QUEUE_ERROR.QUEUE_LIMIT_EXCEEDED) {
			alert("You have attempted to queue too many files.\n" + (message === 0 ? "You have reached the upload limit." : "You may select " + (message > 1 ? "up to " + message + " files." : "one file.")));
			return;
		}
		var progress = new FileProgress(file, this.customSettings.progressTarget);
		progress.setError();
		progress.toggleCancel(false);

		switch (errorCode) {
		case SWFUpload.QUEUE_ERROR.FILE_EXCEEDS_SIZE_LIMIT:
			progress.setStatus("File is too big.");
			this.debug("Error Code: File too big, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		case SWFUpload.QUEUE_ERROR.ZERO_BYTE_FILE:
			progress.setStatus("Cannot upload Zero Byte files.");
			this.debug("Error Code: Zero byte file, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		case SWFUpload.QUEUE_ERROR.INVALID_FILETYPE:
			progress.setStatus("Invalid File Type.");
			this.debug("Error Code: Invalid File Type, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		case SWFUpload.QUEUE_ERROR.QUEUE_LIMIT_EXCEEDED:
			alert("You have selected too many files.  " +  (message > 1 ? "You may only add " +  message + " more files" : "You cannot add any more files."));
			break;
		default:
			if (file !== null) {
				progress.setStatus("Unhandled Error");
			}
			this.debug("Error Code: " + errorCode + ", File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		}
	} catch (ex) {
        this.debug(ex);
    }
}

 */