function Group(imgs){
	this.imgs = imgs;				// 图片列表

	this.total = imgs.length;  		// 图片数量
	this.imgNo = 1;					// 当前图片序号 1 开始
    this.lastImgNo = 0;				// 上一次访问的图片id

	this.imgId = "";				// 当前图片idimgName
	this.prevImgId = "";			// 上一张图片id
	this.nextImgId = "";			// 下一张图片id
	this.imgUrl = "";				// 当前图片地址
	this.imgName = "";				// 当前的图片名称
    this.imgAuthor = "";				// 当前的图片作者
    this.imgSource = "";				// 当前图片的车辆提供
    this.imgSourceUrl = "";				// 当前图片的提供人链接
	this.imgDescription = "";		// 当前图片的描述
	this.source = "";             // 当前图片原图地址
    this.url = "";					// 当前的浏览器url

	this.sliderImgUrls = "";		// 当前滑动导航的小图列表
	this.slideSize = 6;
	this.prevGroupUrl = "";			// 上一组图片地址
	this.nextGroupUrl = "";			// 下一组图片地址

    this.prevGroupTotal = 0;          //上一组有多少张图片(上翻时定位到组图尾部)

	this.autoPlay = 0; 				// 0 - 不播放, 1 - 播放

	this.prew = function(rgExp,replaceText) {
		var imgs = this.imgs;
		for (var i = 0; i < imgs.length; i++) {
			this.imgs[i].imgUrl = imgs[i].imgUrl.replace(rgExp,replaceText);
		    this.imgs[i].smallImgUrl = imgs[i].smallImgUrl.replace(rgExp,replaceText);
		}
	};

	this.init = function() {
	    this.imgId = this.imgs[this.imgNo - 1].imgId;
		this.imgUrl = this.imgs[this.imgNo - 1].imgUrl;
		this.imgName = this.imgs[this.imgNo - 1].imgName;
        this.imgAuthor = this.imgs[this.imgNo - 1].imgAuthor;
        this.imgSource = this.imgs[this.imgNo - 1].imgSource;
        this.imgSourceUrl = this.imgs[this.imgNo - 1].imgSourceUrl;
		//this.imgDescription = this.imgs[this.imgNo - 1].imgDescription;
        //document.getElementById("pcounter").innerHTML  = "<strong style='color:#BBB;font-size:14px;'>("+this.imgNo +" / "+ this.total+")</strong>";
		//document.getElementById("msg").innerHTML ="<p>"+this.imgs[this.imgNo - 1].imgDescription+"</p>";  
		this.source = this.imgs[this.imgNo - 1].source;
		this.changeUrl();
		this.changeSlider();
		if (this.imgNo > 1) {
			this.prevImgId = this.imgs[this.imgNo - 2].imgId;
		} else {
			this.prevImgId = "";
		}
		if (this.imgNo < this.imgs.length) {
			this.nextImgId = this.imgs[this.imgNo].imgId;
		} else {
			this.nextImgId = "";
		}
	};

	// 更新当前图片序号(用在group.html中)
//	this.updateImgNo = function(currentImgNo) {
//		this.imgNo = currentImgNo;
//		if (this.imgNo > 1) {
//			this.prevImgId = this.imgs[this.imgNo - 2].imgId;
//		} else {
//			this.prevImgId = "";
//		}
//		if (this.imgNo < this.imgs.length) {
//			this.nextImgId = this.imgs[this.imgNo].imgId;
//		} else {
//			this.nextImgId = "";
//		}
//	}

	// 下一组
	this.nextGroup = function(){
		if(this.nextGroupUrl != ""){
			this.url = this.nextGroupUrl;
		}
		return this.url;
	};

	// 上一组
	this.prevGroup = function(){
		if(this.prevGroupUrl != ""){
			this.url = this.prevGroupUrl;
		}
		return this.url;
	};

	// 下一页
	this.nextPage = function() {
		if(this.imgNo >= this.total){
			this.nextGroup();
		} else {
            this.lastImgNo = this.imgNo;
			this.imgNo++;
			this.init();
		}
	};

	//上一页
	this.prevPage = function() {
		if(this.imgNo <= 1){
			if(this.prevGroupUrl != ""){
				this.url  = this.prevGroupUrl + "#id=" + (this.prevGroupTotal);
			}
		} else {
            this.lastImgNo = this.imgNo;
			this.imgNo--;
			this.init();
		}
	};

	// 按任意一张缩略图
	this.changeImg = function(pageNo) {
        this.lastImgNo = this.imgNo;
		this.imgNo = pageNo + 1 ;
		this.init();
	};

	// 改变当前 url
	this.changeUrl = function() {
		var pos = this.url.indexOf("#");
		if (pos == -1) {
			this.url += "#id=" + this.imgNo;
		} else {
			this.url = this.url.substr(0, pos + 1) + "id=" + this.imgNo;
		}
	};

	// 滑动指定图片
	this.slide = function(forward){
		var page_prev_group;
		var page_next_group;
		var page = this.imgNo;
		var display = page + 1;
		var total = this.total;
		var step = this.slideSize;
		if (forward) { // 向后滑动
			if (page < (Math.ceil((total - 1) / step) - 1) * step) {
				page_next_group = (Math.ceil( display / step)) * step;
			} else {
				if(page < total - 1 && page > total - 1 - step) {
					page_next_group = total - 1;
				} else {
					page_next_group = 'false';
				}
			}
			if(page_next_group != 'false') {
				this.changeImg(page_next_group);
			} else {
				this.nextPage();
			}
		} else { // 向前滑动
			if (page >= step) {
				page_prev_group = (Math.floor( display / step ) - 1) * step;
			} else {
				if (page > 0 && page < step) {
					page_prev_group = -1;
				} else {
					page_prev_group = 'false';
				}
			}
			if (page_prev_group != 'false') {
				if (page_prev_group == -1){
					if(this.prevGroupUrl != "") {
						this.url  = this.prevGroupUrl + "#id=" + (this.prevGroupTotal - step + 1);
					}
				} else {
					this.changeImg(page_prev_group);
				}
			} else {
				this.prevPage();
			}
		}
	};

	this.changeSlider = function() {
//        var last = this.lastImgNo - 1;
//        last = Math.max(Math.min(last, this.total-1), 0);
		var current = this.imgNo - 1;
		if( current < 0 ) {
            current = 0;
        }
		if( current > this.total - 1) {
            current = this.total - 1;
        }

		var page_start = 0;
		var page_end = this.total;
//		var max_start = this.total - 1 - this.slideSize;

		if(this.total > this.slideSize) { // 图片超过 5 张, 不足 5 张使用缺省值
            page_start = parseInt(current/this.slideSize)*this.slideSize;
            page_end = parseInt(current/this.slideSize)*this.slideSize+this.slideSize;
            if (page_end > this.total) {
                page_end = this.total;
            }
		}

		var html = '';
		for(var i = page_start; i < page_end; i++) {
			var count = i + 1;
            var cls = '';
            if (i == current) {
                cls += 'on';
            }
            if (i == page_end-1){
                cls += ' own';
            }
            html += '<div class="'+cls+'"><a onclick="if(autoPlayer)autoPlayer.stop();return changeImg('+i+');" href="#id='+count+'" id="img_'+i+'"><img src="'+this.imgs[i].smallImgUrl+'"/></a></div>';
		}
		this.sliderImgUrls = html;
	};

}
function AutoPlay() {
	this._flag = 0; //播放标志
	this._pause = 0; //暂停标志
	this._speed = 5; //播放速度，单位秒
	this._func = null; //回调函数
//	this._img_start = "images/play.gif";
//	this._img_stop = "images/stop.gif";
	this._interval_obj = null; //时钟对象
	this._cookie_obj = new Cookie(document, "comic_auto_play", 24*60*60, '/');
	this._nextGroup = "";
	this._currentGroupImgCount = "";
	this._currentImgNo = 1;

	//初始化
	this.init = function() {
		if(this._cookie_obj.load()) {
			//播放速度
			if(this._cookie_obj.speed) {
				this.debug('[init]this._cookie_obj.speed='+this._cookie_obj.speed);
				this._speed = this._cookie_obj.speed;
			}
            //fix
            if (this.get_speed() == 3) {
                this.set_speed(2);
            }
			//播放标志
			if( this._cookie_obj.flag ) {
				this.debug('[init]this._cookie_obj.flag='+this._cookie_obj.flag);
				this._flag = this._cookie_obj.flag;
                var play_btn = document.getElementById("auto_play_button");
                if (this._flag == 1) {
                    play_btn.value = "停止播放";
                }else {
                    play_btn.value = "自动播放";
                }
			}
		}

		//是播放状态
		//if( this._flag ) this.start();
		this.debug('[init]speed='+this._speed);
		this.debug('[init]flag='+this._flag);
	};

	//调试
	this.debug = function(str) {
		try	{
			//console.debug(str);
		} catch (e){}
	};

	//播放/暂停
	this.play = function() {
		if(this._flag == 1){
            this.stop();
        }
		else{
            this.start();
        }
	};

	//开始播放
	this.start = function() {
		this._cookie_obj.flag = this._flag = 1;
		this._cookie_obj.speed = this._speed;
		this._cookie_obj.store();

        var play_btn = document.getElementById("auto_play_button");
        play_btn.value = "停止播放";
		this.next();
		this.debug('[start]');
	};

	//停止播放
	this.stop = function() {
		this._cookie_obj.flag = this._flag = 0;
		this._cookie_obj.store();

		var play_btn = document.getElementById("auto_play_button");
		play_btn.value = "自动播放";
		if( this._interval_obj ) {
            window.clearTimeout(this._interval_obj);
        }
		this.debug('[stop]');

		//if( Qcount ) Qcount.json_case.src.params.auto = 0;
	};

	//恢复暂停
	this.resume = function() {
		if( this._flag == 1 ) {
//			var auto_play_button = document.getElementById("auto_play_button");
			var on_img = document.getElementById("on_img");
//			auto_play_button.src = this._img_stop;
			on_img.alt = '点击翻页';
			on_img.title = '点击翻页';
			//this._interval_obj = window.setInterval( this._func,this._speed*1000 );
			this._pause = 0;
			this.next();
			this.debug('[resume]pause='+this._pause);
		}
	};

	//暂停播放
	this.pause = function()	{
		if( this._flag == 1 ) {
			var auto_play_button = document.getElementById("auto_play_button");
			var on_img = document.getElementById("on_img");
			auto_play_button.src = this._img_start;
			on_img.alt = '鼠标离开大图，继续自动播放';
			on_img.title = '鼠标离开大图，继续自动播放';
			if( this._interval_obj ) {
                window.clearTimeout(this._interval_obj);
            }
			this._pause = 1;
			this.debug('[pause]pause='+this._pause);
		}
	};

	//到下一张
	this.next = function() {
		if( this._flag == 1 && this._pause == 0 ) {
			this._currentImgNo ++;
//			var play_img = document.getElementById("auto_play_button");
//			if (play_img != null) {
//				play_img.src = this._img_stop;
//			}
			if(this._currentImgNo>=this._currentGroupImgCount && this._nextGroup=="") {
				this.stop();
			}
            if( this._interval_obj ) {
                window.clearTimeout(this._interval_obj);
            }
			this._interval_obj = window.setTimeout(this._func, this._speed * 1000);
		}
	};

	//设置播放速度
	this.set_speed = function(speed) {
		this._cookie_obj.speed = this._speed = speed;
		this._cookie_obj.store();

		this.debug('[set_speed]speed='+speed);
	};

	//获取播放速度
	this.get_speed = function() {
		return this._speed;
	};
}
 //使用cookie时的一个工具类（面向对象，原型）
 //构造函数：用指定的名字和可选的性质为指定的文档创建一个cookie对象。
 //参数：
 //document:保存cookie的Document对象，必须的。
 //name:指定cookie名的字符串。必须的。
 //seconds:一个可选的数字，指定从现在起到过期时间的秒
 //path:一个可选的字符串，指定了cookie的路径性质
 //domain:一个可选的字符串，指定了cookie的域性质
 //secure:一个可选的布尔值，为true ，需要一个安全的cookie

function Cookie(document, name, seconds, path, domain, secure) {
    // 该对象的所有预定义的属性都以'$'开头。
    // 这是为了与存储在cookie中的属性值区分开。
    this.$document = document;
    this.$name = name;
    if (seconds) {
        //当字符串为空时，为false, 不为空时，为true
        this.$expiration = new Date((new Date()).getTime() + seconds*1000);
    }
    else this.$expiration = null;
    if (path) {this.$path = path;} else {this.$path = null;}
    if (domain) {this.$domain = domain;} else {this.$domain = null;}
    if (secure) {this.$secure = true;} else {this.$secure = false;}
}

// 该函数是cookie对象的 store() 方法。
Cookie.prototype.store = function () {
    // 首先，遍历cookie对象的属性，并且将cookie值连接起来。
    // 由于cookie将等号和分号作为分隔符。
    // 所以我们使用冒号和&来分隔存储在单个cookie值中的状态变量。
    // 注意：我们对每个状态变量的值进行了转义，以防它含有标点符号或其它非法字符。
    var cookieval = "";
    for(var prop in this) {
        // 忽略所有名字以$开头的属性和所有方法（typeof的用法）
        if ((prop.charAt(0) == '$') || ((typeof this[prop]) == 'function')){
            continue;
        }
        if (cookieval != "") {
            cookieval += '&';
        }
        cookieval += prop + ':' + escape(this[prop]);
    }

    // 既然我们已经有了cookie只，就可以连接完成的cookie串。
 //其中包括名字和创建cookie对象时指定的各种性质.
    var cookie = this.$name + '=' + cookieval;
    if (this.$expiration){ cookie += '; expires=' + this.$expiration.toGMTString();}
    if (this.$path) {cookie += '; path=' + this.$path;}
    if (this.$domain) {cookie += '; domain=' + this.$domain;}
    if (this.$secure) {cookie += '; secure';}

    // 下面设置Document.cookie属性来保存cookie
    this.$document.cookie = cookie;
};


// 该函数是cookie对象的load()方法
Cookie.prototype.load = function() {
    // 首先得到属于该文档的所有cookie的列表,
    // 通过读Document.cookie属性可以实现这一点.
    var allcookies = this.$document.cookie;
    if (allcookies == "") {
        return false;
    }

    // 下面从该列表中提取已命名的cookie.
    var start = allcookies.indexOf(this.$name + '=');
    if (start == -1) {
        return false;   // 该页未定义cookie
    }
    start += this.$name.length + 1;  // 跳过名字和等号.
    var end = allcookies.indexOf(';', start);
    if (end == -1) {
        end = allcookies.length;
    }
    var cookieval = allcookies.substring(start, end);

    // 既然我们已经提取出了已命名的cookie 的值,就可以把它分割存储到状态变量名和值.
 // 名字/值对由&分隔,名字和值之间则由冒号分隔.
 //我们使用split()方法解析所有数据.
    var a = cookieval.split('&');//a 表示一个数组了    // 分隔成名字/值对.
    for(var i=0; i < a.length; i++)  // 把每对值存入数组.
        a[i] = a[i].split(':'); //a表示二维数组

    // 既然我们已经解析了cookie值
    // 就可以设置cookie对象中的状态变量的名字和值.
    // 注意我们对属性值调用了unescape(),因为存储它们时调用了escape()方法.
    for(var i = 0; i < a.length; i++) {
        this[a[i][0]] = unescape(a[i][1]);  //a[][]参数从0开始.
    }

    // 返回成功
    return true;
};

// 该函数是cookie对象的remove() 方法.
Cookie.prototype.remove = function() {
    var cookie;
    cookie = this.$name + '=';
    if (this.$path) {cookie += '; path=' + this.$path;}
    if (this.$domain) {cookie += '; domain=' + this.$domain;}
    cookie += '; expires=Fri, 02-Jan-1970 00:00:00 GMT';

    this.$document.cookie = cookie;  //原来的被覆盖了.
};

function resizeImg(img, _w, _h) {
	//如果图片设定了宽度和高度就移除他们设定的宽度和高度
    img.removeAttribute('width');
    img.removeAttribute('height');
    
    var v = img.width / img.height;
    if (img.width / img.height > _w / _h) {
        if (img.width > _w) {
            img.width = _w;
        }
        else {
            img.width = img.width;
        }
        img.height = img.width / v;
    } else {
        if (img.height > _h) {
            img.height = _h;
        }
        else {
            img.height = img.height;
        }
        img.width = img.height * v;
    }
}


function copyToClipboard(txt){
    try{
        window.clipboardData.clearData();
        window.clipboardData.setData('text',txt);
        alert('已复制本地址,可以发送给您的好友');
    }catch(e){
        alert('您的浏览器不支持剪贴板复制,请直接复制地址栏内的URL发送给好友');
    }
}