Exmay.module = {
	section : {},
	tag : {}
};

/* Exmay Module Section */
Exmay.module.section = {
	exmaySelect : function(options) {
		var opts = options;
		$.exmayDialog( {
			title : "推荐内容",
			url : Exmay.path.admin + "/module/section/position/",
			width : 680,
			height : 500,
			messagebar : {
				image : Exmay.path.framework + "/common/images/exmay_window.gif",
				title : "推荐内容",
				message : "将内容推荐至推荐位下"
			},
			buttons : [ {
				text : "确定",
				icon : "icon-ok",
				handler : function() {
					var $checkeds = getIFrameWindow(getDialog(this)).exmayGetChecked();
					var ids = [];
					$checkeds.each(function(){
						var id = $(this).parents("li").attr("id");
						if(id.indexOf("position") != -1) {
							id = id.replace("position-","");
							ids.push(id);
						}
					});
					if(opts.onSubmit) {
						opts.onSubmit.call(this,ids);
					}
					getDialog(this).exmayDialog("destroy");
				}
			}, {
				text : "取消",
				icon : "icon-cancel",
				handler : function() {
					getDialog(this).exmayDialog("destroy");
				}
			} ]
		});
	},
	exmaySave : function(options){
		var opts = options;
	}
};

/** Exmay Tag **/
Exmay.module.tag = {
	exmaySelect : function(options) {
		var opts = options;
		$.exmayDialog( {
			title : "选择Tag",
			url : Exmay.path.admin + "/module/tag/select/",
			width : 780,
			height : 560,
			messagebar : {
				image : Exmay.path.framework + "/common/images/exmay_window.gif",
				title : "选择Tag",
				message : "将内容用Tag自动关联"
			},
			buttons : [ {
				text : "确定",
				icon : "icon-ok",
				handler : function() {
					var $checkeds = getIFrameWindow(getDialog(this)).exmayGetChecked();
					if($checkeds == null || $checkeds.length == undefined)return;
					var names = [];
					$checkeds.each(function(){
						names.push($(this).val());
					});
					if(opts.onSubmit) {
						opts.onSubmit.call(this,names.join(" "));
					}
					getDialog(this).exmayDialog("destroy");
				}
			}, {
				text : "取消",
				icon : "icon-cancel",
				handler : function() {
					getDialog(this).exmayDialog("destroy");
				}
			} ]
		});
	},
	exmayRelatedCount : function(options) {
		var opts = options;
		var tags = opts.tags;
		/*if (Exmay.string.isEmpty(tags)) {
			return false;
		}*/
		$.ajax( {
			url : Exmay.path.admin + "/module/tag/related-count/",
			type : "post",
			dataType : "json",
			data : {
				tags : tags
			},
			timeout : 20000,
			error : function() {
				$.exmayMessagebox.alert("获取Tag相关内容总数", "请求失败!", "error");
			},
			success : function(data) {
				opts.success.call(this,data.relatedCount);
			}
		});
	}
};


/*前台收藏(front)*/
Exmay.module.favorite = {
	save:function(contentId,contentType){
		$.ajax({
			type:"get",
			async:false, 
		    dataType: 'jsonp', 
		    jsonp: 'callback', 
			url:Exmay.path.site+"/module/favorite/save/?ajax=true",
			data:{"contentId":contentId,"contentType":contentType},
			success:function(data){
				if(data.exmay == 'login'){
					$.exmayMessagebox.alert("登录","请<a href='"+Exmay.path.site+"/login/' target='_blank' style='text-decoration: underline;'>登录</a>","warning");
				}
				if(data.exmay == 'success'){
					$.exmayMessagebox.alert("提示","收藏成功!，<br/>进入["+data.username+"]会员中心查看收藏详情！.","info");
				}
				if(data.exmay == 'fail'){
					$.exmayMessagebox.alert("提示","该文章你已经收藏!，<br/>进入["+data.username+"]会员中心查看收藏详情！.","warning");
				}
			}
		});
	}
}

Exmay.plugin.folder = {
	exmaySelect : function(options) {
		var opts = {
			width : 500,
			height : 320,
			title : "选择路径",
			params : ""
		};
		opts = $.extend({}, opts, options);
		var params = "";
		if(Exmay.string.isNotEmpty(opts.params)) {
			params = "?" + opts.params;
		}
  		var $dialog = $.exmayDialog( {
			width : opts.width,
			height : opts.height,
			title : opts.title,
			url : Exmay.path.admin + '/file/folder/select/'+params,
			buttons : [ {
				text : "确定",
				icon : "icon-ok",
				handler : function() {
					var path = getIFrameWindow(getDialog(this)).exmayGetSelected();
					if(path == null)return;
					if(opts.onSubmit) {
						opts.onSubmit.call(this,path);
					}
					getDialog(this).exmayDialog("destroy");
				}
			}, {
				text : "取消",
				icon : "icon-cancel",
				handler : function() {
					getDialog(this).exmayDialog("destroy");
				}
			} ]
		});
  		return $dialog;
	}
	
};

Exmay.module.upload = {
	exmayLoadResources : function() {
		document.write('<link href="' + Exmay.path.framework + '/swfupload/swfupload.css" rel="stylesheet" type="text/css" />');
		document.write('<script type="text/javascript" src="' + Exmay.path.framework + '/swfupload/swfupload.js"></script>');
		document.write('<script type="text/javascript" src="' + Exmay.path.framework + '/swfupload/swfupload.queue.js"></script>');
		document.write('<script type="text/javascript" src="' + Exmay.path.framework + '/swfupload/fileprogress.js"></script>');
		document.write('<script type="text/javascript" src="' + Exmay.path.framework + '/swfupload/handler.js"></script>');
//		$.exmayLoader.load(Exmay.path.framework + "/swfupload/swfupload.css");
//		$.exmayLoader.load(Exmay.path.framework + "/swfupload/swfupload.js");
//		$.exmayLoader.load(Exmay.path.framework + "/swfupload/fileprogress.js");
//		$.exmayLoader.load(Exmay.path.framework + "/swfupload/handler.js");
	},
	exmaySingle : function(options) {
		var opts = {
			width : 500,
			height : 320,
			title : "上传文件",
			params : ""
		};
		opts = $.extend({}, opts, options);
		var params = "";
		if(Exmay.string.isNotEmpty(opts.params)) {
			params = "?" + opts.params;
		}
  		var $dialog = $.exmayDialog( {
			width : opts.width,
			height : opts.height,
			title : opts.title,
			url : Exmay.path.admin + '/file/upload/single/'+params
		});
  		return $dialog;
	},
	exmayAttachment : function(ids){
		$.exmayDialog({
			width:640,
			height:580,
			title:"附件库",
			url : Exmay.path.site+'/exmay/admin/file/attachment/small/?library=downJpg&type=radio&minLimit=1&maxLimit=50',
			buttons:[{
				text:'刷新',
				iconCls:'icon-ok',
				handler:function(){
					getDialog(this).find("#exmay-panel-frame")[0].contentWindow.location.reload();
				}
			    },{
				text:'确定',
				iconCls:'icon-ok',
				handler:function(){
					var $dialog = getDialog(this);
					getIFrameWindow($dialog).exmaySelect($dialog,ids);
				}
				},{
				text:'取消',
				iconCls:'icon-ok',
				handler:function(){
					getDialog(this).exmayDialog("destroy");
				}
			  }
			]
		});
	},
	exmayUpload : function(options){
		var opts = {
			result : "message",
			fileTypes : "*",
			fileSize : 1,
			minLimit:1,
			maxLimit:1,
			library:"single",
			text : "选择文件",
			startButton : "#exmay-upload-start",
			cancelButton : "#exmay-upload-cancel"
		};
		opts = $.extend({}, opts, options);
		var base = Exmay.path.admin;
		if(base == undefined || Exmay.string.isEmpty(base)) {
			base = Exmay.path.site + "/exmay"
		}
		var upload = new SWFUpload( {
				// Flash Settings
				flash_url : Exmay.path.framework + "/swfupload/swfupload.swf",
				//upload_url : base + "/file/attachment/exmay/?type=checkbox;jsessionid=" + options.sessionId,
				upload_url : base + "/file/attachment/exmay/;jsessionid=" + options.sessionId,
//				upload_url : base + "/file/upload/exmay/;jsessionid=" + options.sessionId,
				post_params : {"library" : opts.library,"result":opts.result},
				file_post_name : "doc",
				file_size_limit : opts.fileSize + " MB", // 2MB
				file_types : opts.fileTypes,
				file_types_description:"All Files",
				
				file_upload_limit : opts.maxLimit,
				file_queue_limit : opts.minLimit,
				
				button_placeholder_id : "exmay-place-holder",
				button_placeholder : "Not Set",
				button_image_url : Exmay.path.framework + "/swfupload/images/upload.jpg", /*正常、鼠标悬停、按下、禁用*/
				button_width : 90,
				button_height : 26,
				button_text : '<span class="exmay-ui-upload"><span class="buttonSmall">'+opts.text+'</span></span>',
				button_text_style : ".exmay-ui-upload { font-family: Helvetica, Arial, sans-serif; font-size: 12pt;cursor:pointer; } .buttonSmall { font-size: 12pt; cursor:pointer;}",
				button_text_top_padding : 0,
				button_text_left_padding : 30,
				button_action : 0,
				button_cursor : -2,
				button_disabled : false,
				custom_settings : {progressTarget : "exmay-upload-progress",cancelButtonId : "exmay-upload-cancel"},
				file_dialog_start_handler : fileDialogStart,
				file_queued_handler : fileQueued,
				file_queue_error_handler : fileQueueError,
				file_dialog_complete_handler : fileDialogComplete,
				upload_start_handler : uploadStart,
				upload_progress_handler : uploadProgress,
				upload_error_handler : uploadError,
				upload_success_handler : uploadSuccess,
				upload_complete_handler : uploadComplete
			});
			$(opts.startButton).click(function(){
				upload.startUpload();
			});
			$(opts.cancelButton).click(function(){
				cancelQueue(upload);
			});
			return upload;
		}
};

Exmay.module.download = {
	exmayDownload : function(options) {
		var opts = {
			url : "",
			$currentButton : ".exmay-ui-iexmay"
		};
		opts = $.extend({}, opts, options);
		var base = Exmay.path.admin;
		$(opts.$currentButton).exmayButton("disable");
		$("body", top.document).exmayLoading( {msg : "正在下载安装文件，请稍候！",show : true});
		$.ajax( {
			url : base + "/file/download/exmay/",
			type : "post",
			dataType : "json",
			data : {url : opts.url},
		    error : function() {
	    		$("body", top.document).exmayLoading("hide");
	    		$(opts.$currentButton).exmayButton("enable");
		    	$.exmayMessagebox.alert("验证插件包", "请求失败！", "error");
		    },
			success : function(data) {
		    	$("body", top.document).exmayLoading( {msg : "下载成功！",show : true,timeout:3000});
		    	$(opts.$currentButton).exmayButton("enable");
				if(opts.onSuccess) {
					opts.onSuccess.call(this,data);
				}
			}
		});
	}
};