Exmay.plugin = {
	keyword : {},
	dataguard : {},
	pinyin : {},
	translate : {},
	seo : {},
	watermark : {},
	vote:{},
	upload:{}
}; 

/** Exmay Keyword Plugin **/
Exmay.plugin.keyword = {
	exmayAutoKeyword : function(options) {
		var opts = options;
		var content = opts.content;
		if (Exmay.string.isEmpty(content)) {
			$.exmayMessagebox.alert("自动提取关键字", "请输入标题和内容!", "warning");
			return false;
		}
		$.ajax( {
			url : Exmay.path.admin + "/plugin/keyword/auto-keyword/",
			type : "post",
			dataType : "json",
			data : {
				content : content
			},
			timeout : 20000,
			beforeSend : function() {
				$("body", top.document).exmayLoading( {
					msg : "正在提取，请稍候...",
					show : true
				});
			},
			error : function() {
				$("body", top.document).exmayLoading("hide");
				$.exmayMessagebox.alert("自动提取关键字", "请求失败!", "error");
			},
			success : function(data) {
				$("body", top.document).exmayLoading("hide");
				$(opts.input).val(data.keywords);
				$.exmayMessagebox.alert("自动提取关键字", "自动提取关键字成功!", "info");
			}
		});
	},
	exmayAutoSummary : function(options) {
		var opts = options;
		var content = opts.content;
		if (Exmay.string.isEmpty(content)) {
			$.exmayMessagebox.alert("自动提取关键字", "请输入标题和内容!", "warning");
			return false;
		}
		$.ajax( {
			url : Exmay.path.admin + "/plugin/keyword/auto-summary/",
			type : "post",
			dataType : "json",
			data : {
				content : content
			},
			timeout : 20000,
			beforeSend : function() {
				$("body", top.document).exmayLoading( {
					msg : "正在提取，请稍候...",
					show : true
				});
			},
			error : function() {
				$("body", top.document).exmayLoading("hide");
				$.exmayMessagebox.alert("自动提取摘要", "请求失败!", "error");
			},
			success : function(data) {
				$("body", top.document).exmayLoading("hide");
				$(opts.input).val(data.summary);
				$.exmayMessagebox.alert("自动提取摘要", "自动提取摘要成功!", "info");
			}
		});
	},
	exmaySelect : function(options) {
		var opts = options;
		$.exmayDialog( {
			title : "选择关键字",
			url : Exmay.path.admin + "/plugin/keyword/select/",
			width : 780,
			height : 560,
			messagebar : {
				image : Exmay.path.framework + "/common/images/exmay_window.gif",
				title : "选择关键字",
				message : "将内容用关键字自动关联"
			},
			buttons : [ {
				text : "确定",
				icon : "icon-ok",
				handler : function() {
					var $checkeds = getIFrameWindow(getDialog(this)).exmayGetChecked();
					if($checkeds == null || $checkeds.length == undefined)return;
					var names = [];
					$checkeds.each(function(){
						names.push($(this).val());
					});
					if(opts.onSubmit) {
						opts.onSubmit.call(this,names.join(" "));
					}
					getDialog(this).exmayDialog("destroy");
				}
			}, {
				text : "取消",
				icon : "icon-cancel",
				handler : function() {
					getDialog(this).exmayDialog("destroy");
				}
			} ]
		});
	},
	exmaySave : function() {

	},
	exmayAutoComplement : function() {

	}
};

/** Exmay author **/
Exmay.plugin.author = {
	exmaySelect : function(options) {
		var opts = options;
		$.exmayDialog( {
			title : "选择作者",
			url : Exmay.path.admin + "/plugin/author/select/",
			width : 780,
			height : 560,
			messagebar : {
				image : Exmay.path.framework + "/common/images/exmay_window.gif",
				title : "选择作者",
				message : "将内容用作者自动关联"
			},
			buttons : [ {
				text : "确定",
				icon : "icon-ok",
				handler : function() {
					var $checkeds = getIFrameWindow(getDialog(this)).exmayGetChecked();
					if($checkeds == null || $checkeds.length == undefined)return;
					var names = [];
					$checkeds.each(function(){
						names.push($(this).val());
					});
					if(opts.onSubmit) {
						opts.onSubmit.call(this,names.join(" "));
					}
					getDialog(this).exmayDialog("destroy");
				}
			}, {
				text : "取消",
				icon : "icon-cancel",
				handler : function() {
					getDialog(this).exmayDialog("destroy");
				}
			} ]
		});
	}
};

/** Exmay source **/
Exmay.plugin.source = {
	exmaySelect : function(options) {
		var opts = options;
		$.exmayDialog( {
			title : "选择来源",
			url : Exmay.path.admin + "/plugin/source/select/",
			width : 780,
			height : 560,
			messagebar : {
				image : Exmay.path.framework + "/common/images/exmay_window.gif",
				title : "选择来源",
				message : "将内容用关键字自动关联"
			},
			buttons : [ {
				text : "确定",
				icon : "icon-ok",
				handler : function() {
					var $checkeds = getIFrameWindow(getDialog(this)).exmayGetChecked();
					if($checkeds == null || $checkeds.length == undefined)return;
					var names = [];
					$checkeds.each(function(){
						names.push($(this).val());
					});
					if(opts.onSubmit) {
						opts.onSubmit.call(this,names.join(" "));
					}
					getDialog(this).exmayDialog("destroy");
				}
			}, {
				text : "取消",
				icon : "icon-cancel",
				handler : function() {
					getDialog(this).exmayDialog("destroy");
				}
			} ]
		});
	}
};

/** Exmay Dataguard Plugin **/
Exmay.plugin.dataguard = {
	exmayAutoSave : function(options) {
		var opts = options;
		var title = opts.title;
		var content = opts.content;
		if (Exmay.string.isEmpty(content) || content == "<P>&nbsp;</P>") {
			return false;
		}

		$.ajax( {
			url : Exmay.path.admin + "/plugin/dataguard/auto-save/",
			type : "post",
			dataType : "json",
			data : {
				title : title,
				content : content
			},
			timeout : 20000,
			error : function() {
				$.exmayMessagebox.alert("自动保存草稿", "请求失败!", "error");
			},
			success : function(data) {
				$("#exmay-auto-save-tip").html(data.dateTime);
			}
		});
	},
	exmayDataList : function(options) {
		var opts = options;
		var $target = $(opts.target);
		var $draft = $("#exmay-auto-save-draft");
		var $pagination = $("#exmay-pagination", $draft);
		$.ajax( {
			url : Exmay.path.admin + "/plugin/dataguard/auto-draft-list/",
			type : "post",
			dataType : "json",
			data : {
				ajax : true,
				pageNo : opts.pageNo,
				pageSize : opts.pageSize
			},
			timeout : 20000,
			beforeSend : function() {
				$("body", top.document).exmayLoading( {
					show : true
				});
				$pagination.exmayPagination( {
					loading : true
				});
			},
			error : function() {
				$("body", top.document).exmayLoading("hide");
				$.exmayMessagebox.alert("获取数据列表信息", "请求失败!", "error");
				$pagination.exmayPagination( {
					loading : false
				});
			},
			success : function(data) {
				var $ul = $draft.find("ul")
				$ul.empty();
				for ( var i = 0; i < data.drafts.length; i++) {
					var dateTime = data.drafts[i].dateTime;
					var title = data.drafts[i].title;
					var exmay = data.drafts[i].exmay;
					var $li = $('<li style="line-height:22px;"><a href="javascript:;">' + dateTime + '&nbsp;&nbsp;' + title + '</a>' + '<a href="javascript:;" class="exmay-ui-delete" style="width:16px;height:16px;margin-left:20px;">删除</a>' + '<input type="checkbox" name="titles" value="' + exmay + '" class="exmayui-checkbox" /></li>');
					$li.attr("exmay", exmay);
					$li.appendTo($ul);
				}

				$(".exmayui-checkbox", $ul).exmayCheckbox( {
					onClick : function(item) {
						var size = $(document).exmayCheckbox("checkedSize", "titles");
						if (size == 0) {
							$(".exmay-ui-batch").exmayButton("disable");
						} else {
							$(".exmay-ui-batch").exmayButton("enable");
						}
					}
				});

				$("li", $ul).click(function() {
					exmayDataRecovery($(this).attr("exmay"));
				}).hover(function() {
					$(this).css( {
						"background-color" : "#FFE8E8"
					})
				}, function() {
					$(this).css( {
						"background-color" : "#FFF"
					})
				});
				$("li", $ul).find(".exmay-ui-delete").click(function() {
					Exmay.plugin.dataguard.exmayDataDelete( {
						title : $(this).parent().attr("exmay")
					});
					return false;
				});
				$pagination.exmayPagination( {
					totalCount : data.totalCount,
					pageNo : data.pageNo,
					pageSize : data.pageSize,
					pageList : 15,
					onChangePage : function(pageNo, pageSize) {
						opts.pageNo = pageNo;
						opts.pageSize = pageSize;
						Exmay.plugin.dataguard.exmayDataList(opts)
					}
				});
				$pagination.hover(function() {
					recovery = true;
				}, function() {
					recovery = false;
				});
				$draft.css( {
					left : $target.offset().left - $draft.outerWidth() + $target.outerWidth(),
					top : $target.offset().top - $draft.outerHeight() - 10
				});
				$pagination.exmayPagination( {
					loading : false
				});
				$("body", top.document).exmayLoading("hide");
				$draft.show();
			}
		});
	},
	exmayDataRecovery : function(options) {
		var opts = options;
		var title = opts.title;
		if(title == undefined) {
			title = opts;
		}
		$.ajax( {
			url : Exmay.path.admin + "/plugin/dataguard/data-recovery/",
			type : "post",
			dataType : "json",
			data : {
				ajax : true,
				title : title
			},
			timeout : 20000,
			error : function() {
				$.exmayMessagebox.alert("数据恢复", "请求失败!", "error");
			},
			success : function(data) {
				if (opts.exmaySetData) {
					opts.exmaySetData.call(this, data);
				}
			}
		});
	},
	exmayDataDelete : function(options) {
		var opts = options;
		var title = opts.title;
		if (title == undefined) {
			title = opts;
		}
		$.ajax( {
			url : Exmay.path.admin + "/plugin/dataguard/data-delete/",
			type : "post",
			dataType : "json",
			data : {
				title : title
			},
			timeout : 20000,
			error : function() {
				$.exmayMessagebox.alert("数据恢复", "请求失败!", "error");
			},
			success : function(data) {
				var $pagination = $("#exmay-pagination", $("#exmay-auto-save-draft"));
				$pagination.exmayPagination("refresh");
				$.exmayMessagebox.alert("数据删除", "草稿删除成功!", "info");
			}
		});
	},
	exmayDataBatchDelete : function(options) {
		var opts = options;
		var titles = opts.titles;
		if (titles == undefined) {
			titles = opts;
		}
		$.ajax( {
			url : Exmay.path.admin + "/plugin/dataguard/data-delete/",
			type : "post",
			dataType : "json",
			data : titles.serialize(),
			timeout : 20000,
			error : function() {
				$.exmayMessagebox.alert("数据批量删除", "请求失败!", "error");
			},
			success : function(data) {
				var $pagination = $("#exmay-pagination", $("#exmay-auto-save-draft"));
				$pagination.exmayPagination("refresh");
				$.exmayMessagebox.alert("数据批量删除", "批量草稿删除成功!", "info");
			}
		});
	}
};

/** Exmay Pinyin Plugin **/
Exmay.plugin.pinyin = {
	exmayHaizi2pinyin : function(options) {
		var opts = options;
		var content = opts.content;
		if (Exmay.string.isEmpty(content)) {
			$.exmayMessagebox.alert("中文转英文", "请输入标题!", "warning");
			return false;
		}
		$.ajax( {
			url : Exmay.path.admin + "/plugin/pinyin/haizi2pinyin/",
			type : "post",
			dataType : "json",
			data : {
				content : content
			},
			timeout : 20000,
			error : function() {
				$.exmayMessagebox.alert("汉字转拼音", "请求失败!", "error");
			},
			success : function(data) {
				$(opts.input).val(data.content);
			}
		});
	}
};

/** Exmay Translate Plugin **/
Exmay.plugin.translate = {
	exmayChinese2english : function(options) {
		var opts = options;
		var content = opts.content;
		if (Exmay.string.isEmpty(content)) {
			$.exmayMessagebox.alert("中文转英文", "请输入标题!", "warning");
			return false;
		}
		$.ajax( {
			url : Exmay.path.admin + "/plugin/translate/chinese2english/",
			type : "post",
			dataType : "json",
			data : {
				content : content
			},
			timeout : 20000,
			error : function() {
				$.exmayMessagebox.alert("中文转英文", "请求失败!", "error");
			},
			success : function(data) {
				$(opts.input).val(data.content);
			}
		});
	}
};

/** Exmay SEO Plugin **/
Exmay.plugin.seo = {
	exmayPath : function(options) {
		var opts = options;
		var title = opts.title;
		var type = opts.type;
		var separator = opts.separator;
		if (Exmay.string.isEmpty(title)) {
			$.exmayMessagebox.alert("自定义路径", "请输入标题!", "warning");
			return false;
		}
		$.ajax( {
			url : Exmay.path.admin + "/plugin/seo/path/",
			type : "post",
			dataType : "json",
			data : {
				title : title,
				type : type,
				separator : separator
			},
			timeout : 20000,
			error : function() {
				$.exmayMessagebox.alert("自定义路径", "请求失败!", "error");
			},
			success : function(data) {
				$(opts.input).val(data.title);
			}
		});
	}
};

/** Exmay Watermark **/
Exmay.plugin.watermark = {
	exmayGenerate : function(options){
		$.ajax( {
			url : Exmay.path.admin + "/plugin/watermark/generate/",
			type : "post",
			dataType : "json",
			data : options,
			timeout : 20000,
			error : function() {
				$.exmayMessagebox.alert("生成水印", "请求失败!", "error");
			},
			success : function(data) {
				$.exmayMessagebox.alert("生成水印", "水印生成成功!", "info");
			}
		});
	} 
};

/** Exmay Extract **/
Exmay.plugin.extract = {
	exmayUpzip : function(options){
		var opts = {
			onSuccess : function (){}
		};
		opts = $.extend({}, opts, options);
		$.ajax( {
			url : Exmay.path.admin + "/plugin/extract/upzip/",
			type : "post",
			dataType : "json",
			error : function() {
				$.exmayMessagebox.alert("解压文件", "请求失败!", "error");
			},
			success : function(data) {
				if(opts.onSuccess) {
					opts.onSuccess.call();
				}
			}
		});
	} 
};


/*前台投票(front)*/
Exmay.plugin.vote = {
	join:function(id){
		var arr = new Array();
		var len = $("input[type='checkbox']:checked").length;
		var rlen = $("input[type='radio']:checked").length;
		if($("#type").val()=='checkbox'){		
			if(len==0){	
				$.exmayMessagebox.alert("提示","请选择一项进行投票！","warning");
				return;
			}	
			if(len > parseInt($("#maxNum").val())){
				$.exmayMessagebox.alert("提示","你最多为"+$("#maxNum").val()+"个进行投票","warning");
				$("input[type='checkbox']").attr("checked",false);
				return;
			}
			
			if(len < parseInt($("#minNum").val())){
				$.exmayMessagebox.alert("提示","你至少为"+$("#minNum").val()+"个进行投票","warning");
				$("input[type='checkbox']").attr("checked",false);
				return;
			}
		}else {
			if(rlen==0){
				$.exmayMessagebox.alert("提示","请选择一项进行投票！","warning");
				return;
			}	
		}		

		$.ajax({
			type:"get",
			async:false, 
		    dataType: 'jsonp', 
		    jsonp: 'callback', 
			url:Exmay.path.site+"/admin/ims/vote/update/?ajax=true&vote.id="+id,
			data:$(".optionClass:checked").serialize(),
			success:function(data){	
				$.exmayMessagebox.alert("提示",data.message,"info");
				$("input[type='checkbox']").attr("checked",false);
				$("#Loading").html('');
			}	
		});
	}
};


/*前台顶踩(front)*/
Exmay.plugin.digg = {
	join:function (type,id,ctype){
	   $.ajax({
		type:'get',
		async:false, 
		dataType: 'jsonp', 
		jsonp: 'callback', 
		url:Exmay.path.site+"/ims/digg/save/?ajax=true",
		data:{"type":type,"contentType":ctype,"contentId":id},
		beforeSend:function(){},
		error:function(){},
		success:function(data){
			if(data.exmay=='login'){
				$.exmayMessagebox.alert("登录","请<a href='"+Exmay.path.site+"/login/' target='_blank' style='text-decoration: underline;'>登录</a>","warning");
				return;
			} 
			if(data.exmay!='false'){
				$("#digg_"+type).find(".digg_num").text("("+data.exmay+")");
				if(type=='up'){
					$("#digg_"+type).find(".digg_percent_bar").children().css("width",data.percentUp);
					$("#digg_"+type).find(".digg_percent_num").text(data.percentUp);
					$("#digg_down").find(".digg_percent_bar").children().css("width",data.percentDown);
					$("#digg_down").find(".digg_percent_num").text(data.percentDown);
				}
				if(type=='down'){
					$("#digg_"+type).find(".digg_percent_bar").children().css("width",data.percentDown);
					$("#digg_"+type).find(".digg_percent_num").text(data.percentDown);
					$("#digg_up").find(".digg_percent_bar").children().css("width",data.percentUp);
					$("#digg_up").find(".digg_percent_num").text(data.percentUp);
				}
			}else{
				var m = "";
				if(data.message == "down")m = "顶";
				if(data.message == "up")m = "踩";
				$.exmayMessagebox.alert('顶踩提醒',"你已经"+m+"过了！.","warning");
				return;
			}
		}
	});
  }
};

/*前台心情(front)*/
Exmay.plugin.mood = {
	join:function (obj){
	var json = $(obj).attr("json");
	var opts = eval("("+json+")");
	$.ajax({
		type:"get",
		async:false, 
	    dataType: 'jsonp', 
	    jsonp: 'callback', 
		url:Exmay.path.site+"/ims/mood/save/?ajax=true",
		data:{"optionId":opts.id,"contentId":opts.contentId,"contentType":opts.type},
		success:function(data){
			if(data.exmay=='login'){
				$.exmayMessagebox.alert("登录","请<a href='"+Exmay.path.site+"/login/' target='_blank' style='text-decoration: underline;'>登录</a>","warning");
			}
			if(data.exmay == "false"){
				$.exmayMessagebox.alert("心情提示","你已经表过态了！","warning");
				setTimeout("exmayReback()",data.flag);
			}
			
			if(data.exmay == "true"){
				$("#moodZool").show();
				$("#mood_total").text(data.total);
				var dataObj = eval("("+data.flag+")");
				for(var i=0;i<dataObj.length;i++){
					var moodData = dataObj[i];
					$("#m"+moodData.id+"_li").find("em").text(moodData.count);
					$("#m"+moodData.id+"_bar").css("height",moodData.percent);
				}
				$("input[type='radio'][name='moodradio']").hide();
				setTimeout("exmayReback()",5000);
			}
		}
	});
   }
};
function exmayReback() {$("#moodZool").hide();$("input[type='radio'][name='moodradio']").attr("checked",false).show();};


Exmay.plugin.icon = function(options){
	var opts = options;
	$.exmayDialog( {
		title : "选择来源",
		url : Exmay.path.admin + "/file/resource/icon/",
		width : 960,
		height : 560
		/*messagebar : {
			image : Exmay.path.framework + "/common/images/exmay_window.gif",
			title : "选择图片",
			message : "美化页面结构"
		}
		,
		buttons : [ {
			text : "确定",
			icon : "icon-ok",
			handler : function() {
				var $checkeds = getIFrameWindow(getDialog(this)).exmayGetChecked();
				if($checkeds == null || $checkeds.length == undefined)return;
				var names = [];
				$checkeds.each(function(){
					names.push($(this).val());
				});
				if(opts.onSubmit) {
					opts.onSubmit.call(this,names.join(" "));
				}
				getDialog(this).exmayDialog("destroy");
			}
		}, {
			text : "取消",
			icon : "icon-cancel",
			handler : function() {
				getDialog(this).exmayDialog("destroy");
			}
		} ]*/
	});
};

function exmaySetThumnailAndMasterMap(json,ids){
	var data = eval("("+json+")");
	var tn = "";
	var mp= "";
	for(var i=0;i<data.length;i++){
		var dataObj = data[i];
		tn += dataObj.thumn+",";
		mp +=  dataObj.masterMap+",";
	}
	tn = tn.substring(0,tn.length-1);
	mp = mp.substring(0,mp.length-1);
	var vid = ids.split(",");
	$("#"+vid[0]).val(tn);
	if(vid.length>1){
		$("#"+vid[1]).val(mp);
	}
}


