<?php

$dname = 'simple-blue';

add_action( 'after_setup_theme', 'dtheme_setup' );

include('option/dtheme.php');

function dopt($e){
	return stripslashes(get_option($e));
}

function dtheme_setup(){
	
	//去除头部冗余代码
	remove_action( 'wp_head',   'feed_links_extra', 3 ); 
	remove_action( 'wp_head',   'rsd_link' ); 
	remove_action( 'wp_head',   'wlwmanifest_link' ); 
	remove_action( 'wp_head',   'index_rel_link' ); 
	remove_action( 'wp_head',   'start_post_rel_link', 10, 0 ); 
	remove_action( 'wp_head',   'wp_generator' ); 
	
	add_action('wp_head', 		'dtheme_keywords');			//关键字
	add_action('wp_head', 		'dtheme_description');		//页面描述
	add_action('init', 			'dtheme_gzip');				//Gzip压缩
	add_action('comment_post', 	'comment_mail_notify');		//评论回复邮件通知
	add_action('comment_form', 	'dtheme_add_checkbox');		//自动勾选评论回复邮件通知，不勾选则注释掉
	add_filter('smilies_src',	'dtheme_smilies_src',1,10);	//评论表情改造，如需更换表情，images/smilies/下替换
	wp_deregister_script( 'l10n' );							//去除自带js
    add_editor_style('editor-style.css');					//为后台编辑器添加样式
	
	//remove_action('wp_head','wp_shortlink_wp_head',10,0);	//去除短链接

    if( dopt('d_admin_links_b')!='' ){
	add_filter( 'pre_option_link_manager_enabled', '__return_true' );
	//3.5.x版本后台显示友情链接模块（免插件）
	}
	
    if( dopt('d_hide_admin_bar_b')!='' ){
	//隐藏admin Bar
	function hide_admin_bar($flag) {
		return false;
	}
	add_filter('show_admin_bar','hide_admin_bar');
	}

    //阻止站内PingBack
    if( dopt('d_pingback_b') != '' ){
        add_action('pre_ping','dtheme_noself_ping');   
    }

	//头像缓存
	if(dopt('d_avatar_b')!=''){
	   add_filter('get_avatar','dtheme_avatar');
	}

    //移除自动保存和修订版本
    if( dopt('d_autosave_b') != '' ){
        add_action('wp_print_scripts','dtheme_disable_autosave' );
        remove_action('pre_post_update','wp_save_post_revision' );
    }

	//修改默认发信地址
	add_filter('wp_mail_from', 'dtheme_res_from_email');
	add_filter('wp_mail_from_name', 'dtheme_res_from_name');
	
	//定义菜单
	if (function_exists('register_nav_menus')){
		register_nav_menus( array(
            'nav' => __('网站导航'),
            'menu' => __('顶部右侧导航'),
			'footlink' => __('底部导航链接'),
		) );
	}

}

//取消原有jQuery
if ( !is_admin() ) { // 后台不用
  if ( $localhost == 0 ) { // 本地调试不用
	function my_init_method() {
	  wp_deregister_script( 'jquery' ); // 取消原有的 jquery 定义
	}	
  add_action('init', 'my_init_method'); // 加入功能, 前台使用 wp_enqueue_script( '名称' ) 加載
  }
}

    if( dopt('d_single-share_b') != '' ){
//百度分享模块
$dHasShare = false;
function dtheme_share(){
  echo '<div class="share"><div id="bdshare" class="bdshare_t bds_tools get-codes-bdshare"><span class="share-tit">分享到：</span><a class="bds_tsina"></a><a class="bds_qzone"></a><a class="bds_tqq"></a><a class="bds_renren"></a><a class="bds_kaixin001"></a><a class="bds_copy"></a><span class="bds_more">更多</span><a class="shareCount"></a></div></div>';
  global $dHasShare;
  $dHasShare = true;
}
    }

//avatar头像模块
function dtheme_avatar_url($mail){ 
  $p = get_bloginfo('template_directory').'/images/default.png';
  if($mail=='') return $p;
  preg_match("/src='(.*?)'/i", get_avatar( $mail,'36',$p ), $matches);
  return $matches[1];
}

//中英混合标题截断    
 function cut_str($src_str,$cut_length)    
{    
 $return_str='';    
 $i=0;    
 $n=0;    
$str_length=strlen($src_str);    
while (($n<$cut_length) && ($i<=$str_length))    
{    
$tmp_str=substr($src_str,$i,1);    
$ascnum=ord($tmp_str);    
if ($ascnum>=224)    
{    
$return_str=$return_str.substr($src_str,$i,3);    
$i=$i+3;    
$n=$n+2;    
}    
elseif ($ascnum>=192)    
{    
$return_str=$return_str.substr($src_str,$i,2);    
$i=$i+2;    
$n=$n+2;    
}    
elseif ($ascnum>=65 && $ascnum<=90)    
{    
$return_str=$return_str.substr($src_str,$i,1);    
$i=$i+1;    
$n=$n+2;    
}    
else    
{    
$return_str=$return_str.substr($src_str,$i,1);    
$i=$i+1;    
$n=$n+1;    
}    
}    
if ($i<$str_length)    
{    
$return_str = $return_str . '';    
}    
if (get_post_status() == 'private')    
{    
$return_str = $return_str . '（private）';    
}    
return $return_str;    
}

//关键字
function dtheme_keywords() {
  global $s, $post;
  $keywords = '';
  if ( is_single() ) {
	if ( get_the_tags( $post->ID ) ) {
	  foreach ( get_the_tags( $post->ID ) as $tag ) $keywords .= $tag->name . ', ';
	}
	foreach ( get_the_category( $post->ID ) as $category ) $keywords .= $category->cat_name . ', ';//获取文章所在分类栏目名称
	$keywords = substr_replace( $keywords , '' , -2);
  } elseif ( is_home () )	 { $keywords = dopt('d_keywords');
  } elseif ( is_tag() )	     { $keywords = single_tag_title('', false);
  } elseif ( is_category() ) { $keywords = single_cat_title('', false);
  } elseif ( is_search() )   { $keywords = esc_html( $s, 1 );
  } else { $keywords = trim( wp_title('', false) );
  }
  if ( $keywords ) {
	echo "<meta name=\"keywords\" content=\"$keywords\">\n";
  }
}

//网站描述
function dtheme_description() {
  global $s, $post;
  $description = '';
  $blog_name = get_bloginfo('name');
  if ( is_singular() ) {
	if( !empty( $post->post_excerpt ) ) {
	  $text = $post->post_excerpt;
	} else {
	  $text = $post->post_content;
	}
	$description = trim( str_replace( array( "\r\n", "\r", "\n", "　", " "), " ", str_replace( "\"", "'", strip_tags( $text ) ) ) );
	if ( !( $description ) ) $description = $blog_name . " - " . trim( wp_title('', false) );
  } elseif ( is_home () )	 { $description = dopt('d_description'); // 首頁要自己加
  } elseif ( is_tag() )	     { $description = $blog_name . "有关 '" . single_tag_title('', false) . "' 的文章";
  } elseif ( is_category() ) { $description = category_description();
  } elseif ( is_archive() )  { $description = $blog_name . "在: '" . trim( wp_title('', false) ) . "' 的文章";
  } elseif ( is_search() )   { $description = $blog_name . ": '" . esc_html( $s, 1 ) . "' 的搜索結果";
  } else { $description = $blog_name . "'" . trim( wp_title('', false) ) . "'";
  }
  $description = mb_substr( $description, 0, 200, 'utf-8' ) . '..';
  echo "<meta name=\"description\" content=\"$description\">\n";
}

//去掉分类描述里的换行
function deletehtml($description) {
$description = trim($description);
$description = strip_tags($description,"");
return ($description);
}
add_filter('category_description', 'deletehtml');

//最新发布加new 单位'小时'
function dtheme_new($timer='48'){
  $t=( strtotime( date("Y-m-d H:i:s") )-strtotime( $post->post_date ) )/3600; 
  if( $t < $timer ) echo "<i>new</i>";
}

//评论头像缓存
function dtheme_avatar($avatar) {
  $tmp = strpos($avatar, 'http');
  $g = substr($avatar, $tmp, strpos($avatar, "'", $tmp) - $tmp);
  $tmp = strpos($g, 'avatar/') + 7;
  $f = substr($g, $tmp, strpos($g, "?", $tmp) - $tmp);
  $w = get_bloginfo('wpurl');
  $e = ABSPATH .'avatar/'. $f .'.png';
  $t = dopt('d_avatarDate')*24*60*60; 
  if ( !is_file($e) || (time() - filemtime($e)) > $t ) 
    copy(htmlspecialchars_decode($g), $e);
  else  
    $avatar = strtr($avatar, array($g => $w.'/avatar/'.$f.'.png'));
  if ( filesize($e) < 500 ) 
    copy(get_bloginfo('template_directory').'/images/default.png', $e);
  return $avatar;
}

//缩略图获取
function the_thumbnail() {  
    global $post;  
    if ( has_post_thumbnail() ) {   
    $domsxe = simplexml_load_string(get_the_post_thumbnail());
    $thumbnailsrc = $domsxe->attributes()->src;  
    echo '<img width="140" height="98" src="'.$thumbnailsrc.'" alt="'.trim(strip_tags( $post->post_title )).'" />';
    } else {
        $content = $post->post_content;  
        preg_match_all('/<img.*?(?: |\\t|\\r|\\n)?src=[\'"]?(.+?)[\'"]?(?:(?: |\\t|\\r|\\n)+.*?)?>/sim', $content, $strResult, PREG_PATTERN_ORDER);  
        $n = count($strResult[1]);  
        if($n > 0){
            echo '<img width="140" height="98" src="'.$strResult[1][0].'" alt="'.trim(strip_tags( $post->post_title )).'" />';  
        }else {
            echo '<img width="140" height="98" src="'.get_bloginfo('template_url').'/images/thumbnail.png" alt="'.trim(strip_tags( $post->post_title )).'" />';  
        }  
    }  
}

//阻止站内文章Pingback 
function dtheme_noself_ping( &$links ) {
  $home = get_option( 'home' );
  foreach ( $links as $l => $link )
  if ( 0 === strpos( $link, $home ) )
  unset($links[$l]);
}

//移除自动保存
function dtheme_disable_autosave() {
  wp_deregister_script('autosave');
}

//修改评论表情调用路径
function dtheme_smilies_src ($img_src, $img, $siteurl){
	return get_bloginfo('template_directory').'/images/smilies/'.$img;
}

//评论表情
function dtheme_smilies(){
  $a = array( 'mrgreen','razz','sad','smile','oops','grin','eek','???','cool','lol','mad','twisted','roll','wink','idea','arrow','neutral','cry','?','evil','shock','!' );
  $b = array( 'mrgreen','razz','sad','smile','redface','biggrin','surprised','confused','cool','lol','mad','twisted','rolleyes','wink','idea','arrow','neutral','cry','question','evil','eek','exclaim' );
  for( $i=0;$i<22;$i++ ){
    echo '
	<a title="'.$a[$i].'" href="javascript:grin('."':".$a[$i].":'".')"><img src="'.get_bloginfo('template_directory').'/images/smilies/icon_'.$b[$i].'.gif" id="wp-smiley" /></a>';
  }
}

//垃圾评论拦截
class anti_spam {
  function anti_spam() {
    if ( !current_user_can('level_0') ) {
      add_action('template_redirect', array($this, 'w_tb'), 1);
      add_action('init', array($this, 'gate'), 1);
      add_action('preprocess_comment', array($this, 'sink'), 1);
    }
  }
  function w_tb() {
    if ( is_singular() ) {
      ob_start(create_function('$input','return preg_replace("#textarea(.*?)name=([\"\'])comment([\"\'])(.+)/textarea>#",
      "textarea$1name=$2w$3$4/textarea><textarea name=\"comment\" cols=\"100%\" rows=\"4\" style=\"display:none\"></textarea>",$input);') );
    }
  }
  function gate() {
    if ( !empty($_POST['w']) && empty($_POST['comment']) ) {
      $_POST['comment'] = $_POST['w'];
    } else {
      $request = $_SERVER['REQUEST_URI'];
      $spamcom = isset($_POST['comment'])        ? $_POST['comment']                : null;
      $_POST['spam_confirmed'] = "$spamcom";
    }
  }

  function sink( $comment ) {
  $email = $comment['comment_author_email'];
  $g = 'http://www.gravatar.com/avatar/'. md5( strtolower( $email ) ). '?d=404';
  $headers = @get_headers( $g );
    if ( !preg_match("|200|", $headers[0]) ) {
      add_filter('pre_comment_approved', create_function('', 'return "0";'));
    }
    if ( !empty($_POST['spam_confirmed']) ) {
      if ( in_array( $comment['comment_type'], array('pingback', 'trackback') ) ) return $comment; 
      die();
      add_filter('pre_comment_approved', create_function('', 'return "spam";'));
      $comment['comment_content'] = $_POST['spam_confirmed'];
    }
    return $comment;
  }
}
$anti_spam = new anti_spam();

//Gzip压缩
function dtheme_gzip() {
  if ( strstr($_SERVER['REQUEST_URI'], '/js/tinymce') )
	return false;
  if ( ( ini_get('zlib.output_compression') == 'On' || ini_get('zlib.output_compression_level') > 0 ) || ini_get('output_handler') == 'ob_gzhandler' )
	return false;
  if (extension_loaded('zlib') && !ob_start('ob_gzhandler'))
	ob_start();
}

//修改默认发信地址
function dtheme_res_from_email($email) {
	$wp_from_email = get_option('admin_email');
	return $wp_from_email;
}
function dtheme_res_from_name($email){
	$wp_from_name = get_option('blogname');
	return $wp_from_name;
}

//评论回应邮件通知
function comment_mail_notify($comment_id) {
  $admin_notify = '1'; // admin 要不要收回复通知 ( '1'=要 ; '0'=不要 )
  $admin_email = get_bloginfo ('admin_email'); // $admin_email 可改为你指定的 e-mail.
  $comment = get_comment($comment_id);
  $comment_author_email = trim($comment->comment_author_email);
  $parent_id = $comment->comment_parent ? $comment->comment_parent : '';
  global $wpdb;
  if ($wpdb->query("Describe {$wpdb->comments} comment_mail_notify") == '')
    $wpdb->query("ALTER TABLE {$wpdb->comments} ADD COLUMN comment_mail_notify TINYINT NOT NULL DEFAULT 0;");
  if (($comment_author_email != $admin_email && isset($_POST['comment_mail_notify'])) || ($comment_author_email == $admin_email && $admin_notify == '1'))
    $wpdb->query("UPDATE {$wpdb->comments} SET comment_mail_notify='1' WHERE comment_ID='$comment_id'");
  $notify = $parent_id ? get_comment($parent_id)->comment_mail_notify : '0';
  $spam_confirmed = $comment->comment_approved;
  if ($parent_id != '' && $spam_confirmed != 'spam' && $notify == '1') {
    $wp_email = 'no-reply@' . preg_replace('#^www\.#', '', strtolower($_SERVER['SERVER_NAME'])); // e-mail 发出点, no-reply 可改为可用的 e-mail.
    $to = trim(get_comment($parent_id)->comment_author_email);
    $subject = 'Hi，您在 [' . get_option("blogname") . '] 的留言有新回应啦！';
    $message = '		<table width="100%" border="0" bgcolor="#ffffff" cellpadding="0" cellspacing="0">
		<!--by www.haote.asia-->
			<tr>
				<td align="center">
				<table width="700" border="0" cellpadding="0" cellspacing="0" bgcolor="#f5fbfe" style="border:1px solid #c0e7fc">
					<tr>
						<td height="9" align="center" valign="top"></td>
					</tr>
					<tr>
						<td height="59">
						<table border="0" cellpadding="0" cellspacing="0" height="59">
							<tr>
								<td bgcolor="#f5fbfe" valign="top" border="0" width="20"></td>
								<td bgcolor="#f5fbfe" valign="top" border="0" width="700">
									<table border="0" cellpadding="0" cellspacing="0">
										<tr>
											<td bgcolor="#f5fbfe" height="10"><div style="height:10px;"></div></td>
										</tr>
										<tr>
											<td align="left">
												<font style="font-weight:bold;font-family:Microsoft YaHei, SimSun, Arial, Helvetica, sans-serif; font-size:36px; color:#333333;">'.get_option("blogname").' </font>
												<font style="font-size:36px;color:#666666;"> | </font>
												<font style="font-family:Microsoft YaHei, SimSun, Arial, Helvetica, sans-serif; font-size:36px; color:#666666;"> 回复提醒</font>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table></td>
					</tr>
					<tr><td bgcolor="#f5fbfe" height="10"><div style="height:10px;"></div></td></tr>
					<tr>
						<td bgcolor="#eaf4f9" valign="top">
						<table border="0" cellpadding="0" cellspacing="0" width="700">
							<tr>
								<td style="width:19px;background-color:#f5fbfe;"></td>
								<td>
									<table border="0" cellpadding="0" cellspacing="0" width="662" bgcolor="#ffffff" style="position:relative;font-size:12px;font-family:微软雅黑, Arial;height:auto;border-left:1px solid #c0e7fc;border-right:1px solid #c0e7fc;border-bottom:1px solid #c0e7fc;">
										<tr valign="top" height="4">
											<td valign="top" width="30" bgcolor="#d20000"></td>
											<td valign="top" width="276" bgcolor="#f60"></td>
											<td valign="top" width="331" bgcolor="#0858b7"></td>
										</tr>
										<tr>
											<td colspan="4" height="30"></td>
										</tr>
										<tr>
											<td></td><td colspan="2" align="left"><font style="font-size:15px; font-weight: bolder;">您在[<a style="text-decoration:none; color:#000;font-weight:600;" href="'.get_option('home').'"><strong>'.get_option("blogname").'</strong></a>]博客上</font></td><td></td>
										</tr>
										<tr><td colspan="4" height="15"><div style="height:15px;"></div></td></tr>
										<tr>
											<td></td><td colspan="2" align="left"><font style="font-size:15px; font-weight: bolder;"><strong>《'.get_the_title($comment->comment_post_ID).'》</strong>有一个评论回复</font></td><td></td>
										</tr>
										<tr><td colspan="4" height="15"><div style="height:15px;"></div></td></tr>
										<tr>
											<td></td>
											<td colspan="2" align="left">
											<font style="float:left;color:#333333;">您留下的评论是：</font>
											</td>
										</tr>
										<tr><td colspan="4" height="10"><div style="height:10px;"></div></td></tr>
										<tr>
											<td></td>
											<td colspan="2" align="left">
											<font style="float:left;color:#333333;background-color: #EEE;border: 1px solid #DDD;padding: 10px 20px;margin: 10px 0;">'.nl2br(get_comment($parent_id)->comment_content).'</font>
											</td><td></td>
										</tr>
										<tr><td colspan="4" height="10"><div style="height:10px;"></div></td></tr>
										<tr>
											<td></td><td colspan="2" align="left">
											<font style="color:#333;"><b>'.trim($comment->comment_author).'</b> 给您的新回复如下：</font>
											</td>
										</tr>
										<tr><td colspan="4" height="10"><div style="height:10px;"></div></td></tr>
										<tr>
											<td></td>
											<td colspan="2" align="left">
											<font style="float:left;color:#333;background-color: #EEE;border: 1px solid #DDD;padding: 10px 20px;margin: 10px 0;">'.nl2br($comment->comment_content).'</font>
											</td><td></td>
										</tr>
										<tr><td colspan="4" height="10"><div style="height:10px;"></div></td></tr>
										<tr>
											<td></td>
											<td colspan="2" align="left">
											<font style="float:left;color:#333;">您可以 “<a style="color:#0066cc;" href="'.htmlspecialchars(get_comment_link($parent_id)).'">点击这里</a>” 查看评论</font>
											</td>
										</tr>
										<tr><td colspan="4" height="15"><div style="height:15px;"></div></td></tr>
										<tr>
											<td></td>
											<td colspan="2" align="left">
											<font style="float:left;color:#333;">如果你不能点击上面的链接可以把下面的链接复制到地址栏中访问</font>
											</td>
										</tr>
										<tr><td colspan="4" height="10"><div style="height:10px;"></div></td></tr>
										<tr>
											<td></td>
											<td colspan="2" align="left">
											<font style="float:left;background-color: #EEE;border: 1px solid #DDD;padding: 10px 20px;margin: 10px 0;"><a style="color:#0066cc;" href="' . htmlspecialchars(get_comment_link($parent_id)) . '">'.htmlspecialchars(get_comment_link($parent_id)).'</a></font>
											</td><td></td>
										</tr>
										<tr><td colspan="4" height="18"><div style="height:18px;"></div></td></tr>
									</table>
								</td>
								<td bgcolor="#f5fbfe" width="19"><div style="width:19px;"></div></td>
							</tr>
						</table></td>
					</tr>
						<tr><td bgcolor="#f5fbfe" height="15"><div style="height:15px;"></div></td></tr>
					<tr>
						<td bgcolor="#f5fbfe" height="13">
						<table border="0" cellpadding="0" cellspacing="0" width="700">
							<tr>
								<td width="350" style="padding-left:20px;float:left;"><font style="font-size:12px;color:#333333;">( 注意：此邮件由系统发出，请勿回复！)</font></td>
								<td style="padding-right:20px;float:right;"><font style="font-size:12px;color:#333333;">欢迎再次光临</font> : <a style="font-size:12px;color:#0066cc;" href="'.get_option('home').'">'.get_option('blogname').'</a></td>
								<td></td>
							</tr>
						</table>
						</td>
					</tr>
					<tr><td bgcolor="#f5fbfe" height="15"><div style="height:15px;"></div></td></tr>
				</table></td>
			</tr>
		</table>';
    $from = "From: \"" . get_option('blogname') . "\" <$wp_email>";
    $headers = "$from\nContent-Type: text/html; charset=" . get_option('blog_charset') . "\n";
    wp_mail( $to, $subject, $message, $headers );
    //echo 'mail to ', $to, '<br/> ' , $subject, $message; // for testing
  }
}

//自动勾选 
function dtheme_add_checkbox() {
  echo '<label for="comment_mail_notify"><input type="checkbox" name="comment_mail_notify" id="comment_mail_notify" value="comment_mail_notify" checked="checked"/>有人回复时邮件通知我</label>';
}

//评论者近期评论数目
function WelcomeCommentAuthorBack($email = ''){
  if(empty($email)){
    return;
  }
  global $wpdb;

  $past_30days = gmdate('Y-m-d H:i:s',((time()-(24*60*60*90))+(get_option('gmt_offset')*3600)));
  $sql = "SELECT count(comment_author_email) AS times FROM $wpdb->comments
          WHERE comment_approved = '1'
          AND comment_author_email = '$email'
          AND comment_date >= '$past_30days'";
  $times = $wpdb->get_results($sql);
  $times = ($times[0]->times) ? $times[0]->times : 0;
  $message = $times ? sprintf(__('Hi，一个月内您评论了<strong>%1$s</strong>次，继续加油哦！' ), $times) : '您很久都没有留言了，给力点！！！';

  return $message;
}

function dtheme_rss_postrelated(){
    $exclude_id = $post->ID; 
    $posttags = get_the_tags(); 
    $i = 0;
    $limit = 6 ;
    if ( $posttags ) { 
      $tags = ''; foreach ( $posttags as $tag ) $tags .= $tag->name . ',';
      $args = array(
        'post_status' => 'publish',
        'tag_slug__in' => explode(',', $tags), 
        'post__not_in' => explode(',', $exclude_id), 
        'caller_get_posts' => 1, 
        'orderby' => 'comment_date', 
        'posts_per_page' => $limit
      );
      query_posts($args); 
      while( have_posts() ) { the_post();
        $output .= '<li><a href="'.get_permalink().'">'.get_the_title().'</a></li>';
        $exclude_id .= ',' . $post->ID; $i ++;
      };
      return '<h4 style="font-size:14px;margin:10px 0;border-bottom:solid 1px #ddd;">继续阅读相关文章：</h4><ul style="line-height:20px;">'.$output.'</ul>';
      wp_reset_query();
    }
}

//时间显示方式‘xx以前’
function time_ago( $type = 'commennt', $day = 7 ) {
  $d = $type == 'post' ? 'get_post_time' : 'get_comment_time';
  if (time() - $d('U') > 60*60*24*$day) return;
  echo ' (', human_time_diff($d('U'), strtotime(current_time('mysql', 0))), '前)';
}

//评论样式
function dtheme_comment_list($comment, $args, $depth) {
  $GLOBALS['comment'] = $comment;
	global $commentcount,$wpdb, $post;
	if(!$commentcount) { //初始化楼层计数器
		$comments = $wpdb->get_results("SELECT * FROM $wpdb->comments WHERE comment_post_ID = $post->ID AND comment_type = '' AND comment_approved = '1' AND !comment_parent");
		$cnt = count($comments);//获取主评论总数量
		$page = get_query_var('cpage');//获取当前评论列表页码
		$cpp=get_option('comments_per_page');//获取每页评论显示数量
		if (ceil($cnt / $cpp) == 1 || ($page > 1 && $page  == ceil($cnt / $cpp))) {
			$commentcount = $cnt + 1;//如果评论只有1页或者是最后一页，初始值为主评论总数
		} else {
			$commentcount = $cpp * $page + 1;
		}
	}

	echo '<li '; comment_class(); echo ' id="comment-'.get_comment_ID().'">';
	//楼层
	if(!$parent_id = $comment->comment_parent) {
		echo '<div class="c-floor"><a href="#comment-'.get_comment_ID().'">'; switch ($commentcount){ case 2 :echo "<font color=#333>沙发</font>";--$commentcount;break; case 3 :echo "<font color=#666>板凳</font>";--$commentcount;break; case 4 :echo "<font color=#999>地板</font>";--$commentcount;break; default:printf('%1$s楼', --$commentcount); } echo '</a></div>';
	}
	//头像
	echo '<div class="c-avatar">';
	echo '<img class="avatar" src="'.dtheme_avatar_url($comment->comment_author_email).'" width="36" height="36">';
	echo '</div>';
	//内容
	echo '<div class="c-main" id="div-comment-'.get_comment_ID().'">';
		echo comment_text();
		if ($comment->comment_approved == '0'){
			echo '<span class="c-approved">您的评论正在审核中，请稍后！</span><br />';
		}
		//信息
		echo '<div class="c-meta">';
			 echo '<span class="c-author">';
			 echo get_comment_author_link();
    if( dopt('d_comment-admin_b')!='' ){
		if ($comment->user_id == '1')
			echo '<img src="'.get_bloginfo('template_directory').'/images/vip_mark.png" id="comment_is_admin" title="本站博主">';
	}
			 echo '</span>';
			 echo get_comment_time('Y-m-d H:i '); echo time_ago();
			if ($comment->comment_approved !== '0'){
				echo comment_reply_link( array_merge( $args, array('add_below' => 'div-comment', 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) );
				echo edit_comment_link(__('[编辑]'),' - ','');
			}
		echo '</div>';
	echo '</div>';
}

//完整的编辑器
function enable_more_buttons($buttons) {
$buttons[] = 'hr';
$buttons[] = 'fontselect';
$buttons[] = 'fontsizeselect';
$buttons[] = 'sup';
$buttons[] = 'sub';
$buttons[] = 'del';
$buttons[] = 'cleanup';
$buttons[] = 'styleselect';
 
return $buttons;
}
//add_filter("mce_buttons", "enable_more_buttons"); //默认将新添加的按钮追加在工具栏的第一行
//add_filter("mce_buttons_2", "enable_more_buttons");  //添加到工具栏的第二行
add_filter("mce_buttons_3", "enable_more_buttons");  //添加到工具栏的第三行


if( dopt('d_words-count_b')!='' ){
//字数统计
function count_words ($text) {
global $post;
if ( '' == $text ) {
   $text = $post->post_content;
   if (mb_strlen($output, 'UTF-8') < mb_strlen($text, 'UTF-8')) $output .= mb_strlen(preg_replace('/\s/','',html_entity_decode(strip_tags($post->post_content))),'UTF-8') . '字';
   return $output;
   }
  }
}


/****************************************************
功能：更新当前浏览文章的浏览量。必须处于主循环当中。
参数：$post_id:    当前文章的ID
返回：无
****************************************************/

function phsy_set_post_views($postID) {
    $the_ID = "arc".$postID;
    if(isset($_SESSION[$the_ID]) || $_SESSION[$the_ID] == 1)
    return;
    $_SESSION[$the_ID] = 1;
    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '1');
    }else{
        //administrator的浏览量不统计
        if(!current_user_can("administrator")&& !current_user_can("editor")&& !current_user_can("author")){
            $count++;
            update_post_meta($postID, $count_key, $count);
        }
    }
}
/****************************************************
功能：获取当前文章的浏览量。必须处于主循环当中。
参数：$postID: 当前文章的ID
返回：浏览数量
****************************************************/
	function phsy_get_post_views($postID){
		$count_key = 'post_views_count';
		$count = get_post_meta($postID, $count_key, true);
		if($count==''){
			delete_post_meta($postID, $count_key);
			add_post_meta($postID, $count_key, '0');
			return "0";
		}
		return $count;
	}


if( dopt('d_reply_to_read_b')!='' ){
//文章内容回复可见
add_shortcode('reply', 'reply_to_read');
}

function reply_to_read($atts, $content=null) {
extract(shortcode_atts(array("notice" => '<p class="reply-to-read">温馨提示：此处内容需要<a href="#respond" title="说点什么吧！">评论本文</a>后才能查看。</p>'), $atts));
$email = null;
$user_ID = (int) wp_get_current_user()->ID;
if ($user_ID > 0) {
$email = get_userdata($user_ID)->user_email;
//对博主直接显示内容
$admin_email = get_bloginfo ('admin_email'); //<span style="color: #0000ff;">博主Email</span>
if ($email == $admin_email) {
return $content;
}
} else if (isset($_COOKIE['comment_author_email_' . COOKIEHASH])) {
$email = str_replace('%40', '@', $_COOKIE['comment_author_email_' . COOKIEHASH]);
} else {
return $notice;
}
if (empty($email)) {
return $notice;
}
global $wpdb;
$post_id = get_the_ID();
$query = "SELECT `comment_ID` FROM {$wpdb->comments} WHERE `comment_post_ID`={$post_id} and `comment_approved`='1' and `comment_author_email`='{$email}' LIMIT 1";
if ($wpdb->get_results($query)) {
return do_shortcode($content);
} else {
return $notice;
}
}


if( dopt('d_article-index_b')!='' ){
//文章章节目录
add_filter( "the_content", "article_index" );
}

function article_index($content) {
	$matches = array();
	$ul_li = '';

    $r = "/<h2(.*?)<\\/h2>/im";

    if (preg_match_all($r, $content, $matches)) {
        foreach ($matches[1] as $num => $title) {
            $title_txt = substr($title,1);
            $title_txt = preg_replace('/<.*?>/', '', $title_txt);/*干掉h2内标签*/
            $title_txt = preg_replace('/.*?>/', '', $title_txt);/*干掉h2属性*/
            $content = str_replace($matches[0][$num], '<h2 id="title-'.$num.'"'.$title.'</h2>', $content);
            $ul_li .= '<li><a href="#title-'.$num.'" title="'.$title_txt.'">'.$title_txt."</a></li>\n";
        }
		$content = "\n<div id=\"article-index\">
				<p>[章节目录]</p>
				<ul id=\"index-ul\">\n" . $ul_li . "</ul>
			</div>\n" . $content;
    }

	return $content;
}

if( dopt('d_wp-login-logo_b')!='' ){
//后台登录页面修改
add_filter('login_headerurl', create_function(false,"return get_bloginfo( 'siteurl' );")); //修改链接地址
add_filter('login_headertitle', create_function(false,"return get_bloginfo( 'description' );")); //修改标题提示

function login_enqueue_scripts(){ echo '<div class="background-cover"></div>
<link rel="stylesheet" type="text/css" href="'.get_bloginfo('template_directory').'/images/wp-login.css" />'."\n";}
add_action( 'login_enqueue_scripts', 'login_enqueue_scripts' );
}

?>