﻿package org.papervision3d.cameras
{
    import flash.geom.*;
    import flash.utils.*;
    import org.papervision3d.core.culling.*;
    import org.papervision3d.core.math.*;
    import org.papervision3d.core.proto.*;
    import org.papervision3d.core.render.data.*;
    import org.papervision3d.objects.*;

    public class Camera3D extends CameraObject3D
    {
        protected var _prevZoom:Number;
        protected var _prevOrthoProjection:Boolean;
        protected var _prevHeight:Number;
        protected var _prevFocus:Number;
        protected var _prevUseProjection:Boolean;
        protected var _focusFix:Matrix3D;
        protected var _prevOrtho:Boolean;
        protected var _prevWidth:Number;
        protected var _projection:Matrix3D;

        public function Camera3D(param1:Number = 60, param2:Number = 10, param3:Number = 5000, param4:Boolean = false, param5:Boolean = false)
        {
            super(param2, 40);
            this.fov = param1;
            _prevFocus = 0;
            _prevZoom = 0;
            _prevOrtho = false;
            _prevUseProjection = false;
            _useCulling = param4;
            _useProjectionMatrix = param5;
            _far = param3;
            _focusFix = Matrix3D.IDENTITY;
            return;
        }// end function

        override public function projectFaces(param1:Array, param2:DisplayObject3D, param3:RenderSessionData) : Number
        {
            var _loc_4:Matrix3D;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:Number;
            var _loc_10:Number;
            var _loc_11:Number;
            var _loc_12:Number;
            var _loc_13:Number;
            var _loc_14:Number;
            var _loc_15:Number;
            var _loc_16:Number;
            var _loc_17:Number;
            var _loc_18:Number;
            var _loc_19:Number;
            var _loc_20:Number;
            var _loc_21:Number;
            var _loc_22:Number;
            var _loc_23:Number;
            var _loc_24:Vertex3D;
            var _loc_25:Vertex3DInstance;
            var _loc_26:Number;
            var _loc_27:int;
            var _loc_28:Number;
            var _loc_29:Number;
            var _loc_30:Number;
            var _loc_31:Number;
            var _loc_32:Number;
            var _loc_33:Number;
            var _loc_34:Array;
            var _loc_35:Number;
            var _loc_36:Triangle3D;
            _loc_4 = param2.view;
            _loc_5 = _loc_4.n11;
            _loc_6 = _loc_4.n12;
            _loc_7 = _loc_4.n13;
            _loc_8 = _loc_4.n21;
            _loc_9 = _loc_4.n22;
            _loc_10 = _loc_4.n23;
            _loc_11 = _loc_4.n31;
            _loc_12 = _loc_4.n32;
            _loc_13 = _loc_4.n33;
            _loc_14 = _loc_4.n41;
            _loc_15 = _loc_4.n42;
            _loc_16 = _loc_4.n43;
            _loc_27 = 0;
            _loc_28 = param3.camera.focus;
            _loc_29 = _loc_28 * param3.camera.zoom;
            _loc_30 = viewport.width / 2;
            _loc_31 = viewport.height / 2;
            _loc_32 = param3.camera.far;
            _loc_33 = _loc_32 - _loc_28;
            _loc_35 = getTimer();
            for each (_loc_36 in param1)
            {
                // label
                _loc_34 = _loc_36.vertices;
                _loc_27 = _loc_34.length;
                do
                {
                    // label
                    if (_loc_24.timestamp == _loc_35)
                    {
                    }
                    else
                    {
                        _loc_24.timestamp = _loc_35;
                        _loc_17 = _loc_24.x;
                        _loc_18 = _loc_24.y;
                        _loc_19 = _loc_24.z;
                        _loc_22 = _loc_17 * _loc_11 + _loc_18 * _loc_12 + _loc_19 * _loc_13 + _loc_4.n34;
                        _loc_25 = _loc_24.vertex3DInstance;
                        if (_useProjectionMatrix)
                        {
                            _loc_23 = _loc_17 * _loc_14 + _loc_18 * _loc_15 + _loc_19 * _loc_16 + _loc_4.n44;
                            _loc_22 = _loc_22 / _loc_23;
                            if (_loc_22 > 0)
                            {
                            }// end if
                            var _loc_39:* = _loc_22 < 1;
                            _loc_25.visible = _loc_22 < 1;
                            if (_loc_39)
                            {
                                _loc_20 = (_loc_17 * _loc_5 + _loc_18 * _loc_6 + _loc_19 * _loc_7 + _loc_4.n14) / _loc_23;
                                _loc_21 = (_loc_17 * _loc_8 + _loc_18 * _loc_9 + _loc_19 * _loc_10 + _loc_4.n24) / _loc_23;
                                _loc_25.x = _loc_20 * _loc_30;
                                _loc_25.y = _loc_21 * _loc_31;
                                _loc_25.z = _loc_22 * _loc_23;
                            }// end if
                        }
                        else
                        {
                            var _loc_39:* = _loc_28 + _loc_22 > 0;
                            _loc_25.visible = _loc_28 + _loc_22 > 0;
                            if (_loc_39)
                            {
                                _loc_20 = _loc_17 * _loc_5 + _loc_18 * _loc_6 + _loc_19 * _loc_7 + _loc_4.n14;
                                _loc_21 = _loc_17 * _loc_8 + _loc_18 * _loc_9 + _loc_19 * _loc_10 + _loc_4.n24;
                                _loc_26 = _loc_29 / (_loc_28 + _loc_22);
                                _loc_25.x = _loc_20 * _loc_26;
                                _loc_25.y = _loc_21 * _loc_26;
                                _loc_25.z = _loc_22;
                            }// end if
                        }// end else if
                    }// end else if
                    var _loc_39:* = _loc_34[--_loc_27];
                    _loc_24 = _loc_34[--_loc_27];
                }while (_loc_39)
            }// end of for each ... in
            return 0;
        }// end function

        override public function set far(param1:Number) : void
        {
            if (param1 > this.focus)
            {
                _far = param1;
                this.update(this.viewport);
            }// end if
            return;
        }// end function

        override public function projectVertices(param1:Array, param2:DisplayObject3D, param3:RenderSessionData) : Number
        {
            var _loc_4:Matrix3D;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:Number;
            var _loc_10:Number;
            var _loc_11:Number;
            var _loc_12:Number;
            var _loc_13:Number;
            var _loc_14:Number;
            var _loc_15:Number;
            var _loc_16:Number;
            var _loc_17:Number;
            var _loc_18:Number;
            var _loc_19:Number;
            var _loc_20:Number;
            var _loc_21:Number;
            var _loc_22:Number;
            var _loc_23:Number;
            var _loc_24:Vertex3D;
            var _loc_25:Vertex3DInstance;
            var _loc_26:Number;
            var _loc_27:int;
            var _loc_28:Number;
            var _loc_29:Number;
            var _loc_30:Number;
            var _loc_31:Number;
            var _loc_32:Number;
            var _loc_33:Number;
            _loc_4 = param2.view;
            _loc_5 = _loc_4.n11;
            _loc_6 = _loc_4.n12;
            _loc_7 = _loc_4.n13;
            _loc_8 = _loc_4.n21;
            _loc_9 = _loc_4.n22;
            _loc_10 = _loc_4.n23;
            _loc_11 = _loc_4.n31;
            _loc_12 = _loc_4.n32;
            _loc_13 = _loc_4.n33;
            _loc_14 = _loc_4.n41;
            _loc_15 = _loc_4.n42;
            _loc_16 = _loc_4.n43;
            _loc_27 = param1.length;
            _loc_28 = param3.camera.focus;
            _loc_29 = _loc_28 * param3.camera.zoom;
            _loc_30 = viewport.width / 2;
            _loc_31 = viewport.height / 2;
            _loc_32 = param3.camera.far;
            _loc_33 = _loc_32 - _loc_28;
            do
            {
                // label
                _loc_17 = _loc_24.x;
                _loc_18 = _loc_24.y;
                _loc_19 = _loc_24.z;
                _loc_22 = _loc_17 * _loc_11 + _loc_18 * _loc_12 + _loc_19 * _loc_13 + _loc_4.n34;
                _loc_25 = _loc_24.vertex3DInstance;
                if (_useProjectionMatrix)
                {
                    _loc_23 = _loc_17 * _loc_14 + _loc_18 * _loc_15 + _loc_19 * _loc_16 + _loc_4.n44;
                    _loc_22 = _loc_22 / _loc_23;
                    if (_loc_22 > 0)
                    {
                    }// end if
                    var _loc_34:* = _loc_22 < 1;
                    _loc_25.visible = _loc_22 < 1;
                    if (_loc_34)
                    {
                        _loc_20 = (_loc_17 * _loc_5 + _loc_18 * _loc_6 + _loc_19 * _loc_7 + _loc_4.n14) / _loc_23;
                        _loc_21 = (_loc_17 * _loc_8 + _loc_18 * _loc_9 + _loc_19 * _loc_10 + _loc_4.n24) / _loc_23;
                        _loc_25.x = _loc_20 * _loc_30;
                        _loc_25.y = _loc_21 * _loc_31;
                        _loc_25.z = _loc_22 * _loc_23;
                    }// end if
                }
                else
                {
                    var _loc_34:* = _loc_28 + _loc_22 > 0;
                    _loc_25.visible = _loc_28 + _loc_22 > 0;
                    if (_loc_34)
                    {
                        _loc_20 = _loc_17 * _loc_5 + _loc_18 * _loc_6 + _loc_19 * _loc_7 + _loc_4.n14;
                        _loc_21 = _loc_17 * _loc_8 + _loc_18 * _loc_9 + _loc_19 * _loc_10 + _loc_4.n24;
                        _loc_26 = _loc_29 / (_loc_28 + _loc_22);
                        _loc_25.x = _loc_20 * _loc_26;
                        _loc_25.y = _loc_21 * _loc_26;
                        _loc_25.z = _loc_22;
                    }// end if
                }// end else if
                var _loc_34:* = param1[--_loc_27];
                _loc_24 = param1[--_loc_27];
            }while (_loc_34)
            return 0;
        }// end function

        override public function transformView(param1:Matrix3D = null) : void
        {
            if (ortho != _prevOrtho || _prevUseProjection != _useProjectionMatrix || focus != _prevFocus || zoom != _prevZoom || viewport.width != _prevWidth || viewport.height != _prevHeight)
            {
                update(viewport);
            }// end if
            if (_target)
            {
                lookAt(_target);
            }
            else if (_transformDirty)
            {
                updateTransform();
            }// end else if
            if (_useProjectionMatrix)
            {
                super.transformView();
                this.eye.calculateMultiply4x4(_projection, this.eye);
            }
            else
            {
                _focusFix.copy(this.transform);
                _focusFix.n14 = _focusFix.n14 + focus * this.transform.n13;
                _focusFix.n24 = _focusFix.n24 + focus * this.transform.n23;
                _focusFix.n34 = _focusFix.n34 + focus * this.transform.n33;
                super.transformView(_focusFix);
            }// end else if
            if (culler is FrustumCuller)
            {
                FrustumCuller(culler).transform.copy(this.transform);
            }// end if
            return;
        }// end function

        override public function orbit(param1:Number, param2:Number, param3:Boolean = true, param4:DisplayObject3D = null) : void
        {
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:Number;
            var _loc_10:Number;
            var _loc_11:Number;
            if (!param4)
            {
            }// end if
            param4 = _target;
            if (!param4)
            {
            }// end if
            param4 = DisplayObject3D.ZERO;
            if (param3)
            {
                param1 = param1 * (Math.PI / 180);
                param2 = param2 * (Math.PI / 180);
            }// end if
            _loc_5 = param4.world.n14 - this.x;
            _loc_6 = param4.world.n24 - this.y;
            _loc_7 = param4.world.n34 - this.z;
            _loc_8 = Math.sqrt(_loc_5 * _loc_5 + _loc_6 * _loc_6 + _loc_7 * _loc_7);
            _loc_9 = Math.cos(param2) * Math.sin(param1);
            _loc_10 = Math.sin(param2) * Math.sin(param1);
            _loc_11 = Math.cos(param1);
            this.x = param4.world.n14 + _loc_9 * _loc_8;
            this.y = param4.world.n24 + _loc_11 * _loc_8;
            this.z = param4.world.n34 + _loc_10 * _loc_8;
            this.lookAt(param4);
            return;
        }// end function

        override public function set near(param1:Number) : void
        {
            if (param1 > 0)
            {
                this.focus = param1;
                this.update(this.viewport);
            }// end if
            return;
        }// end function

        public function update(param1:Rectangle) : void
        {
            if (!param1)
            {
                throw new Error("Camera3D#update: Invalid viewport rectangle! " + param1);
            }// end if
            this.viewport = param1;
            _prevFocus = this.focus;
            _prevZoom = this.zoom;
            _prevWidth = this.viewport.width;
            _prevHeight = this.viewport.height;
            if (_prevOrtho != this.ortho)
            {
                if (this.ortho)
                {
                    _prevOrthoProjection = this.useProjectionMatrix;
                    this.useProjectionMatrix = true;
                }
                else
                {
                    this.useProjectionMatrix = _prevOrthoProjection;
                }// end else if
            }
            else if (_prevUseProjection != _useProjectionMatrix)
            {
                this.useProjectionMatrix = this._useProjectionMatrix;
            }// end else if
            _prevOrtho = this.ortho;
            _prevUseProjection = _useProjectionMatrix;
            this.useCulling = _useCulling;
            return;
        }// end function

        override public function set orthoScale(param1:Number) : void
        {
            super.orthoScale = param1;
            this.useProjectionMatrix = this.useProjectionMatrix;
            _prevOrtho = !this.ortho;
            this.update(this.viewport);
            return;
        }// end function

        override public function set useProjectionMatrix(param1:Boolean) : void
        {
            var _loc_2:Number;
            var _loc_3:Number;
            if (param1)
            {
                if (this.ortho)
                {
                    _loc_2 = viewport.width / 2;
                    _loc_3 = viewport.height / 2;
                    _projection = createOrthoMatrix(-_loc_2, _loc_2, -_loc_3, _loc_3, -_far, _far);
                    _projection = Matrix3D.multiply(_orthoScaleMatrix, _projection);
                }
                else
                {
                    _projection = createPerspectiveMatrix(fov, viewport.width / viewport.height, this.focus, this.far);
                }// end else if
            }
            else if (this.ortho)
            {
                param1 = true;
            }// end else if
            super.useProjectionMatrix = param1;
            return;
        }// end function

        override public function set useCulling(param1:Boolean) : void
        {
            super.useCulling = param1;
            if (_useCulling)
            {
                if (!this.culler)
                {
                    this.culler = new FrustumCuller();
                }// end if
                FrustumCuller(this.culler).initialize(this.fov, this.viewport.width / this.viewport.height, this.focus / this.zoom, _far);
            }
            else
            {
                this.culler = null;
            }// end else if
            return;
        }// end function

        public static function createPerspectiveMatrix(param1:Number, param2:Number, param3:Number, param4:Number) : Matrix3D
        {
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            _loc_5 = param1 / 2 * (Math.PI / 180);
            _loc_6 = Math.tan(_loc_5);
            _loc_7 = 1 / _loc_6;
            return new Matrix3D([_loc_7 / param2, 0, 0, 0, 0, _loc_7, 0, 0, 0, 0, -(param3 + param4) / (param3 - param4), 2 * param4 * param3 / (param3 - param4), 0, 0, 1, 0]);
        }// end function

        public static function createOrthoMatrix(param1:Number, param2:Number, param3:Number, param4:Number, param5:Number, param6:Number) : Matrix3D
        {
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:Number;
            var _loc_10:Matrix3D;
            _loc_7 = (param2 + param1) / (param2 - param1);
            _loc_8 = (param4 + param3) / (param4 - param3);
            _loc_9 = (param6 + param5) / (param6 - param5);
            _loc_10 = new Matrix3D([2 / (param2 - param1), 0, 0, _loc_7, 0, 2 / (param4 - param3), 0, _loc_8, 0, 0, -2 / (param6 - param5), _loc_9, 0, 0, 0, 1]);
            _loc_10.calculateMultiply(Matrix3D.scaleMatrix(1, 1, -1), _loc_10);
            return _loc_10;
        }// end function

    }
}
