﻿package org.papervision3d.cameras
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    import flash.ui.*;
    import org.papervision3d.view.*;

    public class DebugCamera3D extends Camera3D
    {
        protected var targetRotationX:Number = 0;
        protected var targetRotationY:Number = 0;
        protected var startRotationY:Number;
        protected var startPoint:Point;
        protected var startRotationX:Number;
        protected var rotationYText:TextField;
        protected var forwardFactor:Number = 0;
        protected var zText:TextField;
        protected var rotationXText:TextField;
        protected var farText:TextField;
        protected var keyRight:Boolean = false;
        protected var keyLeft:Boolean = false;
        protected var yText:TextField;
        protected var keyForward:Boolean = false;
        protected var nearText:TextField;
        protected var keyBackward:Boolean = false;
        protected var _inertia:Number = 3;
        protected var _propertiesDisplay:Sprite;
        protected var sideFactor:Number = 0;
        protected var viewport3D:Viewport3D;
        protected var fovText:TextField;
        protected var xText:TextField;
        protected var rotationZText:TextField;
        protected var viewportStage:Stage;

        public function DebugCamera3D(param1:Viewport3D, param2:Number = 90, param3:Number = 10, param4:Number = 5000)
        {
            _inertia = 3;
            targetRotationY = 0;
            targetRotationX = 0;
            keyRight = false;
            keyLeft = false;
            keyForward = false;
            keyBackward = false;
            forwardFactor = 0;
            sideFactor = 0;
            super(param2, param3, param4, true);
            this.viewport3D = param1;
            this.viewport = param1.sizeRectangle;
            this.focus = this.viewport.height / 2 / Math.tan(param2 / 2 * (Math.PI / 180));
            this.zoom = this.focus / param3;
            this.focus = param3;
            this.far = param4;
            displayProperties();
            checkStageReady();
            return;
        }// end function

        protected function onEnterFrameHandler(param1:Event) : void
        {
            var _loc_2:Number;
            var _loc_3:Number;
            if (keyForward)
            {
                forwardFactor = forwardFactor + 50;
            }// end if
            if (keyBackward)
            {
                forwardFactor = forwardFactor + -50;
            }// end if
            if (keyLeft)
            {
                sideFactor = sideFactor + -50;
            }// end if
            if (keyRight)
            {
                sideFactor = sideFactor + 50;
            }// end if
            _loc_2 = this.rotationX + (targetRotationX - this.rotationX) / _inertia;
            _loc_3 = this.rotationY + (targetRotationY - this.rotationY) / _inertia;
            this.rotationX = Math.round(_loc_2 * 10) / 10;
            this.rotationY = Math.round(_loc_3 * 10) / 10;
            forwardFactor = forwardFactor + -forwardFactor / _inertia;
            sideFactor = sideFactor + -sideFactor / _inertia;
            if (forwardFactor > 0)
            {
                this.moveForward(forwardFactor);
            }
            else
            {
                this.moveBackward(-forwardFactor);
            }// end else if
            if (sideFactor > 0)
            {
                this.moveRight(sideFactor);
            }
            else
            {
                this.moveLeft(-sideFactor);
            }// end else if
            xText.text = "x:" + int(x);
            yText.text = "y:" + int(y);
            zText.text = "z:" + int(z);
            rotationXText.text = "rotationX:" + int(_loc_2);
            rotationYText.text = "rotationY:" + int(_loc_3);
            rotationZText.text = "rotationZ:" + int(rotationZ);
            fovText.text = "fov:" + Math.round(fov);
            nearText.text = "near:" + Math.round(near);
            farText.text = "far:" + Math.round(far);
            return;
        }// end function

        protected function mouseMoveHandler(param1:MouseEvent) : void
        {
            targetRotationY = startRotationY - (startPoint.x - viewportStage.mouseX) / 2;
            targetRotationX = startRotationX + (startPoint.y - viewportStage.mouseY) / 2;
            return;
        }// end function

        protected function mouseDownHandler(param1:MouseEvent) : void
        {
            viewportStage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
            startPoint = new Point(viewportStage.mouseX, viewportStage.mouseY);
            startRotationY = this.rotationY;
            startRotationX = this.rotationX;
            return;
        }// end function

        protected function keyDownHandler(param1:KeyboardEvent) : void
        {
            switch(param1.keyCode)
            {
                case "W".charCodeAt():
                case Keyboard.UP:
                {
                    keyForward = true;
                    keyBackward = false;
                    break;
                }// end case
                case "S".charCodeAt():
                case Keyboard.DOWN:
                {
                    keyBackward = true;
                    keyForward = false;
                    break;
                }// end case
                case "A".charCodeAt():
                case Keyboard.LEFT:
                {
                    keyLeft = true;
                    keyRight = false;
                    break;
                }// end case
                case "D".charCodeAt():
                case Keyboard.RIGHT:
                {
                    keyRight = true;
                    keyLeft = false;
                    break;
                }// end case
                case "Q".charCodeAt():
                {
                    rotationZ--;
                    break;
                }// end case
                case "E".charCodeAt():
                {
                    rotationZ++;
                    break;
                }// end case
                case "F".charCodeAt():
                {
                    fov--;
                    break;
                }// end case
                case "R".charCodeAt():
                {
                    fov++;
                    break;
                }// end case
                case "G".charCodeAt():
                {
                    near = near - 10;
                    break;
                }// end case
                case "T".charCodeAt():
                {
                    near = near + 10;
                    break;
                }// end case
                case "H".charCodeAt():
                {
                    far = far - 10;
                    break;
                }// end case
                case "Y".charCodeAt():
                {
                    far = far + 10;
                    break;
                }// end case
                default:
                {
                    break;
                }// end default
            }// end switch
            return;
        }// end function

        private function checkStageReady() : void
        {
            if (viewport3D.containerSprite.stage == null)
            {
                viewport3D.containerSprite.addEventListener(Event.ADDED_TO_STAGE, onAddedToStageHandler);
            }
            else
            {
                setupEvents();
            }// end else if
            return;
        }// end function

        public function set propsDisplay(param1:Sprite) : void
        {
            _propertiesDisplay = param1;
            return;
        }// end function

        protected function keyUpHandler(param1:KeyboardEvent) : void
        {
            switch(param1.keyCode)
            {
                case "W".charCodeAt():
                case Keyboard.UP:
                {
                    keyForward = false;
                    break;
                }// end case
                case "S".charCodeAt():
                case Keyboard.DOWN:
                {
                    keyBackward = false;
                    break;
                }// end case
                case "A".charCodeAt():
                case Keyboard.LEFT:
                {
                    keyLeft = false;
                    break;
                }// end case
                case "D".charCodeAt():
                case Keyboard.RIGHT:
                {
                    keyRight = false;
                    break;
                }// end case
                default:
                {
                    break;
                }// end default
            }// end switch
            return;
        }// end function

        public function get inertia() : Number
        {
            return _inertia;
        }// end function

        protected function mouseUpHandler(param1:MouseEvent) : void
        {
            viewportStage.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
            return;
        }// end function

        public function get propsDisplay() : Sprite
        {
            return _propertiesDisplay;
        }// end function

        protected function onAddedToStageHandler(param1:Event) : void
        {
            setupEvents();
            return;
        }// end function

        public function set inertia(param1:Number) : void
        {
            _inertia = param1;
            return;
        }// end function

        protected function displayProperties() : void
        {
            var _loc_1:TextFormat;
            var _loc_2:Array;
            var _loc_3:int;
            var _loc_4:Number;
            _propertiesDisplay = new Sprite();
            _propertiesDisplay.graphics.beginFill(0);
            _propertiesDisplay.graphics.drawRect(0, 0, 100, 100);
            _propertiesDisplay.graphics.endFill();
            _propertiesDisplay.x = 0;
            _propertiesDisplay.y = 0;
            _loc_1 = new TextFormat("_sans", 9);
            xText = new TextField();
            yText = new TextField();
            zText = new TextField();
            rotationXText = new TextField();
            rotationYText = new TextField();
            rotationZText = new TextField();
            fovText = new TextField();
            nearText = new TextField();
            farText = new TextField();
            _loc_2 = [xText, yText, zText, rotationXText, rotationYText, rotationZText, fovText, nearText, farText];
            _loc_3 = 10;
            _loc_4 = 0;
            while (_loc_4++ < _loc_2.length)
            {
                // label
                _loc_2[_loc_4].width = 100;
                _loc_2[_loc_4].selectable = false;
                _loc_2[_loc_4].textColor = 16776960;
                _loc_2[_loc_4].text = "";
                _loc_2[_loc_4].defaultTextFormat = _loc_1;
                _loc_2[_loc_4].y = _loc_3 * _loc_4;
                _propertiesDisplay.addChild(_loc_2[_loc_4]);
            }// end while
            viewport3D.addChild(_propertiesDisplay);
            return;
        }// end function

        protected function setupEvents() : void
        {
            viewportStage = viewport3D.containerSprite.stage;
            viewportStage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            viewportStage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
            viewportStage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
            viewportStage.addEventListener(KeyboardEvent.KEY_UP, keyUpHandler);
            viewportStage.addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
            return;
        }// end function

    }
}
