﻿package org.papervision3d.core.clipping.draw
{
    import org.papervision3d.core.render.command.*;

    public class RectangleClipping extends Clipping
    {

        public function RectangleClipping(param1:Number = -1000000, param2:Number = -1000000, param3:Number = 1000000, param4:Number = 1000000)
        {
            this.minX = param1;
            this.maxX = param3;
            this.minY = param2;
            this.maxY = param4;
            return;
        }// end function

        override public function rect(param1:Number, param2:Number, param3:Number, param4:Number) : Boolean
        {
            if (this.maxX < param1)
            {
                return false;
            }// end if
            if (this.minX > param3)
            {
                return false;
            }// end if
            if (this.maxY < param2)
            {
                return false;
            }// end if
            if (this.minY > param4)
            {
                return false;
            }// end if
            return true;
        }// end function

        override public function check(param1:RenderableListItem) : Boolean
        {
            if (param1.maxX < minX)
            {
                return false;
            }// end if
            if (param1.minX > maxX)
            {
                return false;
            }// end if
            if (param1.maxY < minY)
            {
                return false;
            }// end if
            if (param1.minY > maxY)
            {
                return false;
            }// end if
            return true;
        }// end function

        public function toString() : String
        {
            return "{minX:" + minX + " maxX:" + maxX + " minY:" + minY + " maxY:" + maxY + "}";
        }// end function

        override public function asRectangleClipping() : RectangleClipping
        {
            return this;
        }// end function

    }
}
