﻿package org.papervision3d.core.culling
{
    import org.papervision3d.core.math.*;
    import org.papervision3d.objects.*;

    public class FrustumCuller extends Object implements IObjectCuller
    {
        private var _tang:Number;
        private var _ratio:Number;
        private var _near:Number;
        private var _fov:Number;
        private var _far:Number;
        private var _nh:Number;
        private var _fh:Number;
        public var transform:Matrix3D;
        private var _sphereY:Number;
        private var _nw:Number;
        private var _sphereX:Number;
        private var _fw:Number;
        public static const OUTSIDE:int = -1;
        public static const INSIDE:int = 1;
        public static const INTERSECT:int = 0;

        public function FrustumCuller()
        {
            this.transform = Matrix3D.IDENTITY;
            this.initialize();
            return;
        }// end function

        public function get ratio() : Number
        {
            return _ratio;
        }// end function

        public function pointInFrustum(param1:Number, param2:Number, param3:Number) : int
        {
            var _loc_4:Matrix3D;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:Number;
            var _loc_10:Number;
            var _loc_11:Number;
            _loc_4 = this.transform;
            _loc_5 = param1 - _loc_4.n14;
            _loc_6 = param2 - _loc_4.n24;
            _loc_7 = param3 - _loc_4.n34;
            _loc_8 = _loc_5 * _loc_4.n13 + _loc_6 * _loc_4.n23 + _loc_7 * _loc_4.n33;
            if (_loc_8 > _far || _loc_8 < _near)
            {
                return OUTSIDE;
            }// end if
            _loc_9 = _loc_5 * _loc_4.n12 + _loc_6 * _loc_4.n22 + _loc_7 * _loc_4.n32;
            _loc_10 = _loc_8 * _tang;
            if (_loc_9 > _loc_10 || _loc_9 < -_loc_10)
            {
                return OUTSIDE;
            }// end if
            _loc_11 = _loc_5 * _loc_4.n11 + _loc_6 * _loc_4.n21 + _loc_7 * _loc_4.n31;
            _loc_10 = _loc_10 * _ratio;
            if (_loc_11 > _loc_10 || _loc_11 < -_loc_10)
            {
                return OUTSIDE;
            }// end if
            return INSIDE;
        }// end function

        public function initialize(param1:Number = 60, param2:Number = 1.333, param3:Number = 1, param4:Number = 5000) : void
        {
            var _loc_5:Number;
            var _loc_6:Number;
            _fov = param1;
            _ratio = param2;
            _near = param3;
            _far = param4;
            _loc_5 = Math.PI / 180 * _fov * 0.5;
            _tang = Math.tan(_loc_5);
            _nh = _near * _tang;
            _nw = _nh * _ratio;
            _fh = _far * _tang;
            _fw = _fh * _ratio;
            _loc_6 = Math.atan(_tang * _ratio);
            _sphereX = 1 / Math.cos(_loc_6);
            _sphereY = 1 / Math.cos(_loc_5);
            return;
        }// end function

        public function get fov() : Number
        {
            return _fov;
        }// end function

        public function set ratio(param1:Number) : void
        {
            this.initialize(_fov, param1, _near, _far);
            return;
        }// end function

        public function get far() : Number
        {
            return _far;
        }// end function

        public function set fov(param1:Number) : void
        {
            this.initialize(param1, _ratio, _near, _far);
            return;
        }// end function

        public function get near() : Number
        {
            return _near;
        }// end function

        public function set far(param1:Number) : void
        {
            this.initialize(_fov, _ratio, _near, param1);
            return;
        }// end function

        public function set near(param1:Number) : void
        {
            this.initialize(_fov, _ratio, param1, _far);
            return;
        }// end function

        public function sphereInFrustum(param1:DisplayObject3D, param2:BoundingSphere) : int
        {
            var _loc_3:Number;
            var _loc_4:Number;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:int;
            var _loc_9:Matrix3D;
            var _loc_10:Number;
            var _loc_11:Number;
            var _loc_12:Number;
            _loc_3 = param2.radius * Math.max(param1.scaleX, Math.max(param1.scaleY, param1.scaleZ));
            _loc_8 = INSIDE;
            _loc_9 = this.transform;
            _loc_10 = param1.world.n14 - _loc_9.n14;
            _loc_11 = param1.world.n24 - _loc_9.n24;
            _loc_12 = param1.world.n34 - _loc_9.n34;
            _loc_7 = _loc_10 * _loc_9.n13 + _loc_11 * _loc_9.n23 + _loc_12 * _loc_9.n33;
            if (_loc_7 > _far + _loc_3 || _loc_7 < _near - _loc_3)
            {
                return OUTSIDE;
            }// end if
            if (_loc_7 > _far - _loc_3 || _loc_7 < _near + _loc_3)
            {
                _loc_8 = INTERSECT;
            }// end if
            _loc_6 = _loc_10 * _loc_9.n12 + _loc_11 * _loc_9.n22 + _loc_12 * _loc_9.n32;
            _loc_4 = _sphereY * _loc_3;
            _loc_7 = _loc_7 * _tang;
            if (_loc_6 > _loc_7 + _loc_4 || _loc_6 < -_loc_7 - _loc_4)
            {
                return OUTSIDE;
            }// end if
            if (_loc_6 > _loc_7 - _loc_4 || _loc_6 < -_loc_7 + _loc_4)
            {
                _loc_8 = INTERSECT;
            }// end if
            _loc_5 = _loc_10 * _loc_9.n11 + _loc_11 * _loc_9.n21 + _loc_12 * _loc_9.n31;
            _loc_7 = _loc_7 * _ratio;
            _loc_4 = _sphereX * _loc_3;
            if (_loc_5 > _loc_7 + _loc_4 || _loc_5 < -_loc_7 - _loc_4)
            {
                return OUTSIDE;
            }// end if
            if (_loc_5 > _loc_7 - _loc_4 || _loc_5 < -_loc_7 + _loc_4)
            {
                _loc_8 = INTERSECT;
            }// end if
            return _loc_8;
        }// end function

        public function testObject(param1:DisplayObject3D) : int
        {
            var _loc_2:int;
            _loc_2 = INSIDE;
            if (!param1.geometry || !param1.geometry.vertices || !param1.geometry.vertices.length)
            {
                return _loc_2;
            }// end if
            switch(param1.frustumTestMethod)
            {
                case FrustumTestMethod.BOUNDING_SPHERE:
                {
                    _loc_2 = sphereInFrustum(param1, param1.geometry.boundingSphere);
                    break;
                }// end case
                case FrustumTestMethod.BOUNDING_BOX:
                {
                    _loc_2 = aabbInFrustum(param1, param1.geometry.aabb);
                    break;
                }// end case
                case FrustumTestMethod.NO_TESTING:
                {
                    break;
                }// end case
                default:
                {
                    break;
                    break;
                }// end default
            }// end switch
            return _loc_2;
        }// end function

        public function aabbInFrustum(param1:DisplayObject3D, param2:AxisAlignedBoundingBox, param3:Boolean = true) : int
        {
            var _loc_4:Vertex3D;
            var _loc_5:Number3D;
            var _loc_6:int;
            var _loc_7:int;
            var _loc_8:Array;
            _loc_6 = 0;
            _loc_7 = 0;
            _loc_8 = param2.getBoxVertices();
            for each (_loc_4 in _loc_8)
            {
                // label
                _loc_5 = _loc_4.toNumber3D();
                Matrix3D.multiplyVector(param1.world, _loc_5);
                if (pointInFrustum(_loc_5.x, _loc_5.y, _loc_5.z) == INSIDE)
                {
                    _loc_6++;
                    if (param3)
                    {
                        return INSIDE;
                    }// end if
                }
                else
                {
                    _loc_7++;
                }// end else if
                if (_loc_6 && _loc_7)
                {
                    return INTERSECT;
                }// end if
            }// end of for each ... in
            if (_loc_6)
            {
                return _loc_6 < 8 ? (INTERSECT) : (INSIDE);
            }
            else
            {
                return OUTSIDE;
            }// end else if
        }// end function

    }
}
