﻿package org.papervision3d.core.culling
{
    import flash.geom.*;
    import org.papervision3d.core.geom.renderables.*;
    import org.papervision3d.core.math.util.*;

    public class RectangleLineCuller extends Object implements ILineCuller
    {
        private var rectIntersection:Rectangle;
        private var lineBoundsRect:Rectangle;
        private var cullingRectangle:Rectangle;

        public function RectangleLineCuller(param1:Rectangle = null) : void
        {
            if (param1)
            {
                this.cullingRectangle = param1;
            }// end if
            lineBoundsRect = new Rectangle();
            rectIntersection = new Rectangle();
            return;
        }// end function

        public function testLine(param1:Line3D) : Boolean
        {
            var _loc_2:Number;
            var _loc_3:Number;
            var _loc_4:Number;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:Number;
            if (!param1.v0.vertex3DInstance.visible || !param1.v1.vertex3DInstance.visible)
            {
                return false;
            }// end if
            _loc_2 = param1.v0.vertex3DInstance.x;
            _loc_3 = param1.v0.vertex3DInstance.y;
            _loc_4 = param1.v1.vertex3DInstance.x;
            _loc_5 = param1.v1.vertex3DInstance.y;
            lineBoundsRect.width = Math.abs(_loc_4 - _loc_2);
            lineBoundsRect.height = Math.abs(_loc_5 - _loc_3);
            if (_loc_2 < _loc_4)
            {
                lineBoundsRect.x = _loc_2;
            }
            else
            {
                lineBoundsRect.x = _loc_4;
            }// end else if
            if (_loc_3 < _loc_5)
            {
                lineBoundsRect.y = _loc_3;
            }
            else
            {
                lineBoundsRect.y = _loc_5;
            }// end else if
            if (cullingRectangle.containsRect(lineBoundsRect))
            {
                return true;
            }// end if
            if (!FastRectangleTools.intersects(lineBoundsRect, cullingRectangle))
            {
                return false;
            }// end if
            rectIntersection = FastRectangleTools.intersection(lineBoundsRect, cullingRectangle);
            _loc_6 = (_loc_5 - _loc_3) / (_loc_4 - _loc_2);
            _loc_7 = _loc_3 - _loc_6 * _loc_2;
            _loc_8 = (cullingRectangle.top - _loc_7) / _loc_6;
            if (_loc_8 > rectIntersection.left && _loc_8 < rectIntersection.right)
            {
                return true;
            }// end if
            _loc_8 = (cullingRectangle.bottom - _loc_7) / _loc_6;
            if (_loc_8 > rectIntersection.left && _loc_8 < rectIntersection.right)
            {
                return true;
            }// end if
            _loc_9 = _loc_6 * cullingRectangle.left + _loc_7;
            if (_loc_9 > rectIntersection.top && _loc_9 < rectIntersection.bottom)
            {
                return true;
            }// end if
            _loc_9 = _loc_6 * cullingRectangle.right + _loc_7;
            if (_loc_9 > rectIntersection.top && _loc_9 < rectIntersection.bottom)
            {
                return true;
            }// end if
            return false;
        }// end function

    }
}
