﻿package org.papervision3d.core.geom
{
    import flash.utils.*;
    import org.papervision3d.core.geom.renderables.*;
    import org.papervision3d.core.math.*;
    import org.papervision3d.core.proto.*;
    import org.papervision3d.core.render.command.*;
    import org.papervision3d.core.render.data.*;
    import org.papervision3d.core.render.draw.*;
    import org.papervision3d.objects.*;

    public class TriangleMesh3D extends Vertices3D
    {
        private var _dtStore:Array;
        private var _dtActive:Array;
        private var _tri:RenderTriangle;

        public function TriangleMesh3D(param1:MaterialObject3D, param2:Array, param3:Array, param4:String = null)
        {
            _dtStore = new Array();
            _dtActive = new Array();
            super(param2, param4);
            if (!param3)
            {
            }// end if
            this.geometry.faces = new Array();
            if (!param1)
            {
            }// end if
            this.material = MaterialObject3D.DEFAULT;
            return;
        }// end function

        override public function project(param1:DisplayObject3D, param2:RenderSessionData) : Number
        {
            var _loc_3:int;
            var _loc_4:Array;
            var _loc_5:Triangle3D;
            var _loc_6:Array;
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:ITriangleCuller;
            var _loc_10:Vertex3DInstance;
            var _loc_11:Vertex3DInstance;
            var _loc_12:Vertex3DInstance;
            var _loc_13:Triangle3DInstance;
            var _loc_14:Triangle3D;
            var _loc_15:MaterialObject3D;
            var _loc_16:RenderTriangle;
            _dtStore = [];
            _dtActive = new Array();
            _loc_3 = this.geometry.vertices.length;
            _loc_4 = [];
            if (param2.clipping && this.useClipping && !this.culled)
            {
            }// end if
            if (param2.camera.useCulling ? (cullTest == 0) : (true))
            {
                super.projectEmpty(param1, param2);
                param2.clipping.setDisplayObject(this, param2);
                for each (_loc_5 in this.geometry.faces)
                {
                    // label
                    if (param2.clipping.testFace(_loc_5, this, param2))
                    {
                        param2.clipping.clipFace(_loc_5, this, _loc_15, param2, _loc_4);
                        continue;
                    }// end if
                    _loc_4.push(_loc_5);
                }// end of for each ... in
                super.project(param1, param2);
                param2.camera.projectFaces(_loc_4, this, param2);
            }
            else
            {
                super.project(param1, param2);
                _loc_4 = this.geometry.faces;
            }// end else if
            if (!this.culled)
            {
                _loc_6 = this.geometry.faces;
                _loc_7 = 0;
                _loc_8 = 0;
                _loc_9 = param2.triangleCuller;
                for each (_loc_14 in _loc_4)
                {
                    // label
                    _loc_15 = _loc_14.material ? (_loc_14.material) : (material);
                    _loc_10 = _loc_14.v0.vertex3DInstance;
                    _loc_11 = _loc_14.v1.vertex3DInstance;
                    _loc_12 = _loc_14.v2.vertex3DInstance;
                    if (_loc_9.testFace(_loc_14, _loc_10, _loc_11, _loc_12))
                    {
                        _loc_16 = _loc_14.renderCommand;
                        var _loc_19:* = setScreenZ(meshSort, _loc_10, _loc_11, _loc_12);
                        _loc_16.screenZ = setScreenZ(meshSort, _loc_10, _loc_11, _loc_12);
                        _loc_7 = _loc_7 + _loc_19;
                        _loc_16.renderer = _loc_15 as ITriangleDrawer;
                        _loc_16.v0 = _loc_10;
                        _loc_16.v1 = _loc_11;
                        _loc_16.v2 = _loc_12;
                        _loc_16.uv0 = _loc_14.uv0;
                        _loc_16.uv1 = _loc_14.uv1;
                        _loc_16.uv2 = _loc_14.uv2;
                        if (param2.quadrantTree)
                        {
                            if (_loc_16.create == null)
                            {
                                _loc_16.create = createRenderTriangle;
                            }// end if
                            _loc_16.update();
                            if (_loc_16.area < 0 && _loc_14.material.doubleSided || _loc_14.material.oneSide && _loc_14.material.opposite)
                            {
                                _loc_16.area = -_loc_16.area;
                            }// end if
                        }// end if
                        param2.renderer.addToRenderList(_loc_16);
                        continue;
                    }// end if
                    var _loc_19:* = param2.renderStatistics;
                    _loc_19.culledTriangles = param2.renderStatistics.culledTriangles++;
                }// end of for each ... in
                if (_loc_3)
                {
                    while (this.geometry.vertices.length > _loc_3)
                    {
                        // label
                        this.geometry.vertices.pop();
                    }// end while
                }// end if
                var _loc_17:* = _loc_7 / _loc_8++;
                this.screenZ = _loc_7 / _loc_8++;
                return _loc_17;
            }
            else
            {
                var _loc_17:* = param2.renderStatistics;
                _loc_17.culledObjects = param2.renderStatistics.culledObjects++;
            }// end else if
            return 0;
        }// end function

        override public function set material(param1:MaterialObject3D) : void
        {
            var _loc_2:Triangle3D;
            super.material = param1;
            for each (_loc_2 in geometry.faces)
            {
                // label
                _loc_2.material = param1;
            }// end of for each ... in
            return;
        }// end function

        public function mergeVertices() : void
        {
            var _loc_1:Dictionary;
            var _loc_2:Array;
            var _loc_3:Vertex3D;
            var _loc_4:Triangle3D;
            var _loc_5:Vertex3D;
            _loc_1 = new Dictionary();
            _loc_2 = new Array();
            for each (_loc_3 in this.geometry.vertices)
            {
                // label
                for each (_loc_5 in _loc_1)
                {
                    // label
                    if (_loc_3.x == _loc_5.x && _loc_3.y == _loc_5.y && _loc_3.z == _loc_5.z)
                    {
                        _loc_1[_loc_3] = _loc_5;
                        break;
                    }// end if
                }// end of for each ... in
                if (!_loc_1[_loc_3])
                {
                    _loc_1[_loc_3] = _loc_3;
                    _loc_2.push(_loc_3);
                }// end if
            }// end of for each ... in
            this.geometry.vertices = _loc_2;
            for each (_loc_4 in geometry.faces)
            {
                // label
                var _loc_8:* = _loc_1[_loc_4.v0];
                _loc_4.vertices[0] = _loc_1[_loc_4.v0];
                (_loc_7[_loc_6]).v0 = _loc_8;
                var _loc_8:* = _loc_1[_loc_4.v1];
                _loc_4.vertices[1] = _loc_1[_loc_4.v1];
                _loc_4.v1 = _loc_8;
                var _loc_8:* = _loc_1[_loc_4.v2];
                _loc_4.vertices[2] = _loc_1[_loc_4.v2];
                _loc_4.v2 = _loc_8;
            }// end of for each ... in
            return;
        }// end function

        public function quarterFaces() : void
        {
            var _loc_1:Array;
            var _loc_2:Array;
            var _loc_3:Array;
            var _loc_4:Triangle3D;
            var _loc_5:int;
            var _loc_6:Vertex3D;
            var _loc_7:Vertex3D;
            var _loc_8:Vertex3D;
            var _loc_9:Vertex3D;
            var _loc_10:Vertex3D;
            var _loc_11:Vertex3D;
            var _loc_12:NumberUV;
            var _loc_13:NumberUV;
            var _loc_14:NumberUV;
            var _loc_15:NumberUV;
            var _loc_16:NumberUV;
            var _loc_17:NumberUV;
            var _loc_18:Triangle3D;
            var _loc_19:Triangle3D;
            var _loc_20:Triangle3D;
            var _loc_21:Triangle3D;
            _loc_1 = new Array();
            _loc_2 = new Array();
            _loc_3 = this.geometry.faces;
            _loc_5 = _loc_3.length;
            do
            {
                // label
                _loc_6 = _loc_4.v0;
                _loc_7 = _loc_4.v1;
                _loc_8 = _loc_4.v2;
                _loc_9 = new Vertex3D((_loc_6.x + _loc_7.x) / 2, (_loc_6.y + _loc_7.y) / 2, (_loc_6.z + _loc_7.z) / 2);
                _loc_10 = new Vertex3D((_loc_7.x + _loc_8.x) / 2, (_loc_7.y + _loc_8.y) / 2, (_loc_7.z + _loc_8.z) / 2);
                _loc_11 = new Vertex3D((_loc_8.x + _loc_6.x) / 2, (_loc_8.y + _loc_6.y) / 2, (_loc_8.z + _loc_6.z) / 2);
                this.geometry.vertices.push(_loc_9, _loc_10, _loc_11);
                _loc_12 = _loc_4.uv[0];
                _loc_13 = _loc_4.uv[1];
                _loc_14 = _loc_4.uv[2];
                _loc_15 = new NumberUV((_loc_12.u + _loc_13.u) / 2, (_loc_12.v + _loc_13.v) / 2);
                _loc_16 = new NumberUV((_loc_13.u + _loc_14.u) / 2, (_loc_13.v + _loc_14.v) / 2);
                _loc_17 = new NumberUV((_loc_14.u + _loc_12.u) / 2, (_loc_14.v + _loc_12.v) / 2);
                _loc_18 = new Triangle3D(this, [_loc_6, _loc_9, _loc_11], _loc_4.material, [_loc_12, _loc_15, _loc_17]);
                _loc_19 = new Triangle3D(this, [_loc_9, _loc_7, _loc_10], _loc_4.material, [_loc_15, _loc_13, _loc_16]);
                _loc_20 = new Triangle3D(this, [_loc_11, _loc_10, _loc_8], _loc_4.material, [_loc_17, _loc_16, _loc_14]);
                _loc_21 = new Triangle3D(this, [_loc_9, _loc_10, _loc_11], _loc_4.material, [_loc_15, _loc_16, _loc_17]);
                _loc_2.push(_loc_18, _loc_19, _loc_20, _loc_21);
                var _loc_22:* = _loc_3[--_loc_5];
                _loc_4 = _loc_3[--_loc_5];
            }while (_loc_22)
            this.geometry.faces = _loc_2;
            this.mergeVertices();
            this.geometry.ready = true;
            return;
        }// end function

        override public function clone() : DisplayObject3D
        {
            var _loc_1:DisplayObject3D;
            var _loc_2:TriangleMesh3D;
            _loc_1 = super.clone();
            _loc_2 = new TriangleMesh3D(this.material, [], [], _loc_1.name);
            if (this.materials)
            {
                _loc_2.materials = this.materials.clone();
            }// end if
            if (_loc_1.geometry)
            {
                _loc_2.geometry = _loc_1.geometry.clone(_loc_2);
            }// end if
            _loc_2.copyTransform(this.transform);
            return _loc_2;
        }// end function

        protected function setScreenZ(param1:uint, param2:Vertex3DInstance, param3:Vertex3DInstance, param4:Vertex3DInstance) : Number
        {
            switch(param1)
            {
                case DisplayObject3D.MESH_SORT_CENTER:
                {
                    return (param2.z + param3.z + param4.z) / 3;
                }// end case
                case DisplayObject3D.MESH_SORT_FAR:
                {
                    return Math.max(param2.z, param3.z, param4.z);
                }// end case
                case DisplayObject3D.MESH_SORT_CLOSE:
                {
                    return Math.min(param2.z, param3.z, param4.z);
                }// end case
                default:
                {
                    break;
                }// end default
            }// end switch
            return 0;
        }// end function

        public function projectTexture(param1:String = "x", param2:String = "y") : void
        {
            var _loc_3:Array;
            var _loc_4:Object;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:MaterialObject3D;
            var _loc_10:String;
            var _loc_11:Triangle3D;
            var _loc_12:Array;
            var _loc_13:Vertex3D;
            var _loc_14:Vertex3D;
            var _loc_15:Vertex3D;
            var _loc_16:NumberUV;
            var _loc_17:NumberUV;
            var _loc_18:NumberUV;
            _loc_3 = this.geometry.faces;
            _loc_4 = this.boundingBox();
            _loc_5 = _loc_4.min[param1];
            _loc_6 = _loc_4.size[param1];
            _loc_7 = _loc_4.min[param2];
            _loc_8 = _loc_4.size[param2];
            _loc_9 = this.material;
            for (_loc_10 in _loc_3)
            {
                // label
                _loc_11 = _loc_3[Number(_loc_10)];
                _loc_12 = _loc_11.vertices;
                _loc_13 = _loc_12[0];
                _loc_14 = _loc_12[1];
                _loc_15 = _loc_12[2];
                _loc_16 = new NumberUV((_loc_13[param1] - _loc_5) / _loc_6, (_loc_13[param2] - _loc_7) / _loc_8);
                _loc_17 = new NumberUV((_loc_14[param1] - _loc_5) / _loc_6, (_loc_14[param2] - _loc_7) / _loc_8);
                _loc_18 = new NumberUV((_loc_15[param1] - _loc_5) / _loc_6, (_loc_15[param2] - _loc_7) / _loc_8);
                _loc_11.uv = [_loc_16, _loc_17, _loc_18];
            }// end of for ... in
            return;
        }// end function

        public function createRenderTriangle(param1:Triangle3D, param2:MaterialObject3D, param3:Vertex3DInstance, param4:Vertex3DInstance, param5:Vertex3DInstance, param6:NumberUV, param7:NumberUV, param8:NumberUV) : RenderTriangle
        {
            if (_dtStore.length)
            {
                var _loc_9:* = _dtStore.pop();
                _tri = _dtStore.pop();
                _dtActive.push(_loc_9);
            }
            else
            {
                var _loc_9:* = new RenderTriangle(param1);
                _tri = new RenderTriangle(param1);
                _dtActive.push(_loc_9);
            }// end else if
            _tri.instance = this;
            _tri.triangle = param1;
            _tri.renderableInstance = param1;
            _tri.renderer = param2;
            _tri.create = createRenderTriangle;
            _tri.v0 = param3;
            _tri.v1 = param4;
            _tri.v2 = param5;
            _tri.uv0 = param6;
            _tri.uv1 = param7;
            _tri.uv2 = param8;
            _tri.update();
            return _tri;
        }// end function

    }
}
