﻿package org.papervision3d.core.geom.renderables
{
    import flash.geom.*;
    import org.papervision3d.core.render.command.*;
    import org.papervision3d.materials.special.*;

    public class Particle extends AbstractRenderable implements IRenderable
    {
        public var size:Number;
        public var renderScale:Number;
        public var vertex3D:Vertex3D;
        public var renderRect:Rectangle;
        public var rotationZ:Number = 0;
        public var drawMatrix:Matrix;
        public var material:ParticleMaterial;
        public var renderCommand:RenderParticle;

        public function Particle(param1:ParticleMaterial, param2:Number = 1, param3:Number = 0, param4:Number = 0, param5:Number = 0)
        {
            rotationZ = 0;
            this.material = param1;
            this.size = param2;
            this.renderCommand = new RenderParticle(this);
            this.renderRect = new Rectangle();
            vertex3D = new Vertex3D(param3, param4, param5);
            drawMatrix = new Matrix();
            return;
        }// end function

        public function get y() : Number
        {
            return vertex3D.y;
        }// end function

        public function updateRenderRect() : void
        {
            material.updateRenderRect(this);
            return;
        }// end function

        public function set z(param1:Number) : void
        {
            vertex3D.z = param1;
            return;
        }// end function

        public function set x(param1:Number) : void
        {
            vertex3D.x = param1;
            return;
        }// end function

        public function set y(param1:Number) : void
        {
            vertex3D.y = param1;
            return;
        }// end function

        public function get z() : Number
        {
            return vertex3D.z;
        }// end function

        override public function getRenderListItem() : IRenderListItem
        {
            return renderCommand;
        }// end function

        public function get x() : Number
        {
            return vertex3D.x;
        }// end function

    }
}
