﻿package org.papervision3d.core.geom.renderables
{
    import org.papervision3d.core.math.*;
    import org.papervision3d.core.proto.*;
    import org.papervision3d.core.render.command.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.objects.*;

    public class Triangle3D extends AbstractRenderable implements IRenderable
    {
        public var vertices:Array;
        public var v1:Vertex3D;
        public var _uvArray:Array;
        public var visible:Boolean;
        public var id:Number;
        public var material:MaterialObject3D;
        public var renderCommand:RenderTriangle;
        public var screenZ:Number;
        public var uv0:NumberUV;
        public var uv1:NumberUV;
        public var uv2:NumberUV;
        public var faceNormal:Number3D;
        public var _materialName:String;
        public var v0:Vertex3D;
        public var v2:Vertex3D;
        private static var _totalFaces:Number = 0;

        public function Triangle3D(param1:DisplayObject3D, param2:Array, param3:MaterialObject3D = null, param4:Array = null)
        {
            this.instance = param1;
            faceNormal = new Number3D();
            if (param2 && param2.length == 3)
            {
                this.vertices = param2;
                v0 = param2[0];
                v1 = param2[1];
                v2 = param2[2];
                createNormal();
            }
            else
            {
                param2 = new Array();
                var _loc_5:* = new Vertex3D();
                param2[0] = new Vertex3D();
                v0 = _loc_5;
                var _loc_5:* = new Vertex3D();
                param2[1] = new Vertex3D();
                v1 = _loc_5;
                var _loc_5:* = new Vertex3D();
                param2[2] = new Vertex3D();
                v2 = _loc_5;
            }// end else if
            this.material = param3;
            this.uv = param4;
            this.id = _totalFaces++;
            this.renderCommand = new RenderTriangle(this);
            return;
        }// end function

        public function createNormal() : void
        {
            var _loc_1:Number3D;
            var _loc_2:Number3D;
            var _loc_3:Number3D;
            _loc_1 = v0.getPosition();
            _loc_2 = v1.getPosition();
            _loc_3 = v2.getPosition();
            _loc_2.minusEq(_loc_1);
            _loc_3.minusEq(_loc_1);
            faceNormal = Number3D.cross(_loc_2, _loc_3, faceNormal);
            faceNormal.normalize();
            return;
        }// end function

        public function set uv(param1:Array) : void
        {
            if (param1 && param1.length == 3)
            {
                uv0 = NumberUV(param1[0]);
                uv1 = NumberUV(param1[1]);
                uv2 = NumberUV(param1[2]);
            }// end if
            _uvArray = param1;
            return;
        }// end function

        public function reset(param1:DisplayObject3D, param2:Array, param3:MaterialObject3D, param4:Array) : void
        {
            var _loc_5:MaterialObject3D;
            this.instance = param1;
            this.renderCommand.instance = param1;
            this.renderCommand.renderer = param3;
            this.vertices = param2;
            updateVertices();
            this.material = param3;
            this.uv = param4;
            if (param3 is BitmapMaterial)
            {
                BitmapMaterial(param3).uvMatrices[this.renderCommand] = null;
            }// end if
            if (param3 is CompositeMaterial)
            {
                for each (_loc_5 in CompositeMaterial(param3).materials)
                {
                    // label
                    if (_loc_5 is BitmapMaterial)
                    {
                        BitmapMaterial(_loc_5).uvMatrices[this.renderCommand] = null;
                    }// end if
                }// end of for each ... in
            }// end if
            return;
        }// end function

        public function get uv() : Array
        {
            return _uvArray;
        }// end function

        public function updateVertices() : void
        {
            v0 = vertices[0];
            v1 = vertices[1];
            v2 = vertices[2];
            return;
        }// end function

        override public function getRenderListItem() : IRenderListItem
        {
            return renderCommand;
        }// end function

    }
}
