﻿package org.papervision3d.core.math
{

    public class Quaternion extends Object
    {
        private var _matrix:Matrix3D;
        public var w:Number;
        public var x:Number;
        public var y:Number;
        public var z:Number;
        public static const EPSILON:Number = 1e-006;
        public static const DEGTORAD:Number = 0.0174533;
        public static const RADTODEG:Number = 57.2958;

        public function Quaternion(param1:Number = 0, param2:Number = 0, param3:Number = 0, param4:Number = 1)
        {
            this.x = param1;
            this.y = param2;
            this.z = param3;
            this.w = param4;
            _matrix = Matrix3D.IDENTITY;
            return;
        }// end function

        public function setFromEuler(param1:Number, param2:Number, param3:Number, param4:Boolean = false) : void
        {
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:Number;
            var _loc_10:Number;
            var _loc_11:Number;
            var _loc_12:Number;
            if (param4)
            {
                param1 = param1 * DEGTORAD;
                param2 = param2 * DEGTORAD;
                param3 = param3 * DEGTORAD;
            }// end if
            _loc_5 = Math.sin(param1 * 0.5);
            _loc_6 = Math.cos(param1 * 0.5);
            _loc_7 = Math.sin(param2 * 0.5);
            _loc_8 = Math.cos(param2 * 0.5);
            _loc_9 = Math.sin(param3 * 0.5);
            _loc_10 = Math.cos(param3 * 0.5);
            _loc_11 = _loc_6 * _loc_8;
            _loc_12 = _loc_5 * _loc_7;
            this.x = _loc_9 * _loc_11 - _loc_10 * _loc_12;
            this.y = _loc_10 * _loc_5 * _loc_8 + _loc_9 * _loc_6 * _loc_7;
            this.z = _loc_10 * _loc_6 * _loc_7 - _loc_9 * _loc_5 * _loc_8;
            this.w = _loc_10 * _loc_11 + _loc_9 * _loc_12;
            return;
        }// end function

        public function setFromAxisAngle(param1:Number, param2:Number, param3:Number, param4:Number) : void
        {
            var _loc_5:Number;
            var _loc_6:Number;
            _loc_5 = Math.sin(param4 / 2);
            _loc_6 = Math.cos(param4 / 2);
            this.x = param1 * _loc_5;
            this.y = param2 * _loc_5;
            this.z = param3 * _loc_5;
            this.w = _loc_6;
            this.normalize();
            return;
        }// end function

        public function get matrix() : Matrix3D
        {
            var _loc_1:Number;
            var _loc_2:Number;
            var _loc_3:Number;
            var _loc_4:Number;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:Number;
            _loc_1 = x * x;
            _loc_2 = x * y;
            _loc_3 = x * z;
            _loc_4 = x * w;
            _loc_5 = y * y;
            _loc_6 = y * z;
            _loc_7 = y * w;
            _loc_8 = z * z;
            _loc_9 = z * w;
            _matrix.n11 = 1 - 2 * (_loc_5 + _loc_8);
            _matrix.n12 = 2 * (_loc_2 - _loc_9);
            _matrix.n13 = 2 * (_loc_3 + _loc_7);
            _matrix.n21 = 2 * (_loc_2 + _loc_9);
            _matrix.n22 = 1 - 2 * (_loc_1 + _loc_8);
            _matrix.n23 = 2 * (_loc_6 - _loc_4);
            _matrix.n31 = 2 * (_loc_3 - _loc_7);
            _matrix.n32 = 2 * (_loc_6 + _loc_4);
            _matrix.n33 = 1 - 2 * (_loc_1 + _loc_5);
            return _matrix;
        }// end function

        public function calculateMultiply(param1:Quaternion, param2:Quaternion) : void
        {
            this.x = param1.w * param2.x + param1.x * param2.w + param1.y * param2.z - param1.z * param2.y;
            this.y = param1.w * param2.y - param1.x * param2.z + param1.y * param2.w + param1.z * param2.x;
            this.z = param1.w * param2.z + param1.x * param2.y - param1.y * param2.x + param1.z * param2.w;
            this.w = param1.w * param2.w - param1.x * param2.x - param1.y * param2.y - param1.z * param2.z;
            return;
        }// end function

        public function toString() : String
        {
            return "Quaternion: x:" + this.x + " y:" + this.y + " z:" + this.z + " w:" + this.w;
        }// end function

        public function normalize() : void
        {
            var _loc_1:Number;
            var _loc_2:Number;
            _loc_1 = this.modulo;
            if (Math.abs(_loc_1) < EPSILON)
            {
                var _loc_3:int;
                z = 0;
                var _loc_3:* = _loc_3;
                y = _loc_3;
                x = _loc_3;
                w = 1;
            }
            else
            {
                _loc_2 = 1 / _loc_1;
                x = x * _loc_2;
                y = y * _loc_2;
                z = z * _loc_2;
                w = w * _loc_2;
            }// end else if
            return;
        }// end function

        public function get modulo() : Number
        {
            return Math.sqrt(x * x + y * y + z * z + w * w);
        }// end function

        public function toEuler() : Number3D
        {
            var _loc_1:Number3D;
            var _loc_2:Quaternion;
            var _loc_3:Number;
            var _loc_4:Number;
            var _loc_5:Number;
            var _loc_6:Number;
            _loc_1 = new Number3D();
            _loc_2 = this;
            _loc_3 = _loc_2.x * _loc_2.y + _loc_2.z * _loc_2.w;
            if (_loc_3 > 0.499)
            {
                _loc_1.x = 2 * Math.atan2(_loc_2.x, _loc_2.w);
                _loc_1.y = Math.PI / 2;
                _loc_1.z = 0;
                return _loc_1;
            }// end if
            if (_loc_3 < -0.499)
            {
                _loc_1.x = -2 * Math.atan2(_loc_2.x, _loc_2.w);
                _loc_1.y = (-Math.PI) / 2;
                _loc_1.z = 0;
                return _loc_1;
            }// end if
            _loc_4 = _loc_2.x * _loc_2.x;
            _loc_5 = _loc_2.y * _loc_2.y;
            _loc_6 = _loc_2.z * _loc_2.z;
            _loc_1.x = Math.atan2(2 * _loc_2.y * _loc_2.w - 2 * _loc_2.x * _loc_2.z, 1 - 2 * _loc_5 - 2 * _loc_6);
            _loc_1.y = Math.asin(2 * _loc_3);
            _loc_1.z = Math.atan2(2 * _loc_2.x * _loc_2.w - 2 * _loc_2.y * _loc_2.z, 1 - 2 * _loc_4 - 2 * _loc_6);
            return _loc_1;
        }// end function

        public function clone() : Quaternion
        {
            return new Quaternion(this.x, this.y, this.z, this.w);
        }// end function

        public function mult(param1:Quaternion) : void
        {
            var _loc_2:Number;
            var _loc_3:Number;
            var _loc_4:Number;
            var _loc_5:Number;
            _loc_2 = this.w;
            _loc_3 = this.x;
            _loc_4 = this.y;
            _loc_5 = this.z;
            x = _loc_2 * param1.x + _loc_3 * param1.w + _loc_4 * param1.z - _loc_5 * param1.y;
            y = _loc_2 * param1.y - _loc_3 * param1.z + _loc_4 * param1.w + _loc_5 * param1.x;
            z = _loc_2 * param1.z + _loc_3 * param1.y - _loc_4 * param1.x + _loc_5 * param1.w;
            w = _loc_2 * param1.w - _loc_3 * param1.x - _loc_4 * param1.y - _loc_5 * param1.z;
            return;
        }// end function

        public static function sub(param1:Quaternion, param2:Quaternion) : Quaternion
        {
            return new Quaternion(param1.x - param2.x, param1.y - param2.y, param1.z - param2.z, param1.w - param2.w);
        }// end function

        public static function add(param1:Quaternion, param2:Quaternion) : Quaternion
        {
            return new Quaternion(param1.x + param2.x, param1.y + param2.y, param1.z + param2.z, param1.w + param2.w);
        }// end function

        public static function createFromEuler(param1:Number, param2:Number, param3:Number, param4:Boolean = false) : Quaternion
        {
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:Number;
            var _loc_10:Number;
            var _loc_11:Number;
            var _loc_12:Number;
            var _loc_13:Quaternion;
            if (param4)
            {
                param1 = param1 * DEGTORAD;
                param2 = param2 * DEGTORAD;
                param3 = param3 * DEGTORAD;
            }// end if
            _loc_5 = Math.sin(param1 * 0.5);
            _loc_6 = Math.cos(param1 * 0.5);
            _loc_7 = Math.sin(param2 * 0.5);
            _loc_8 = Math.cos(param2 * 0.5);
            _loc_9 = Math.sin(param3 * 0.5);
            _loc_10 = Math.cos(param3 * 0.5);
            _loc_11 = _loc_6 * _loc_8;
            _loc_12 = _loc_5 * _loc_7;
            _loc_13 = new Quaternion;
            _loc_13.x = _loc_9 * _loc_11 - _loc_10 * _loc_12;
            _loc_13.y = _loc_10 * _loc_5 * _loc_8 + _loc_9 * _loc_6 * _loc_7;
            _loc_13.z = _loc_10 * _loc_6 * _loc_7 - _loc_9 * _loc_5 * _loc_8;
            _loc_13.w = _loc_10 * _loc_11 + _loc_9 * _loc_12;
            return _loc_13;
        }// end function

        public static function createFromMatrix(param1:Matrix3D) : Quaternion
        {
            var _loc_2:Quaternion;
            var _loc_3:Number;
            var _loc_4:Array;
            var _loc_5:int;
            var _loc_6:int;
            var _loc_7:int;
            var _loc_8:Number;
            var _loc_9:Array;
            var _loc_10:Array;
            _loc_2 = new Quaternion;
            _loc_4 = new Array(4);
            _loc_8 = param1.n11 + param1.n22 + param1.n33;
            if (_loc_8 > 0)
            {
                _loc_3 = Math.sqrt(_loc_8 + 1);
                _loc_2.w = _loc_3 / 2;
                _loc_3 = 0.5 / _loc_3;
                _loc_2.x = (param1.n32 - param1.n23) * _loc_3;
                _loc_2.y = (param1.n13 - param1.n31) * _loc_3;
                _loc_2.z = (param1.n21 - param1.n12) * _loc_3;
            }
            else
            {
                _loc_9 = [1, 2, 0];
                _loc_10 = [[param1.n11, param1.n12, param1.n13, param1.n14], [param1.n21, param1.n22, param1.n23, param1.n24], [param1.n31, param1.n32, param1.n33, param1.n34]];
                _loc_5 = 0;
                if (_loc_10[1][1] > _loc_10[0][0])
                {
                    _loc_5 = 1;
                }// end if
                if (_loc_10[2][2] > _loc_10[_loc_5][_loc_5])
                {
                    _loc_5 = 2;
                }// end if
                _loc_6 = _loc_9[_loc_5];
                _loc_7 = _loc_9[_loc_6];
                _loc_3 = Math.sqrt(_loc_10[_loc_5][_loc_5] - (_loc_10[_loc_6][_loc_6] + _loc_10[_loc_7][_loc_7]) + 1);
                _loc_4[_loc_5] = _loc_3 * 0.5;
                if (_loc_3 != 0)
                {
                    _loc_3 = 0.5 / _loc_3;
                }// end if
                _loc_4[3] = (_loc_10[_loc_7][_loc_6] - _loc_10[_loc_6][_loc_7]) * _loc_3;
                _loc_4[_loc_6] = (_loc_10[_loc_6][_loc_5] + _loc_10[_loc_5][_loc_6]) * _loc_3;
                _loc_4[_loc_7] = (_loc_10[_loc_7][_loc_5] + _loc_10[_loc_5][_loc_7]) * _loc_3;
                _loc_2.x = _loc_4[0];
                _loc_2.y = _loc_4[1];
                _loc_2.z = _loc_4[2];
                _loc_2.w = _loc_4[3];
            }// end else if
            return _loc_2;
        }// end function

        public static function dot(param1:Quaternion, param2:Quaternion) : Number
        {
            return param1.x * param2.x + param1.y * param2.y + param1.z * param2.z + param1.w * param2.w;
        }// end function

        public static function multiply(param1:Quaternion, param2:Quaternion) : Quaternion
        {
            var _loc_3:Quaternion;
            _loc_3 = new Quaternion;
            _loc_3.x = param1.w * param2.x + param1.x * param2.w + param1.y * param2.z - param1.z * param2.y;
            _loc_3.y = param1.w * param2.y - param1.x * param2.z + param1.y * param2.w + param1.z * param2.x;
            _loc_3.z = param1.w * param2.z + param1.x * param2.y - param1.y * param2.x + param1.z * param2.w;
            _loc_3.w = param1.w * param2.w - param1.x * param2.x - param1.y * param2.y - param1.z * param2.z;
            return _loc_3;
        }// end function

        public static function createFromAxisAngle(param1:Number, param2:Number, param3:Number, param4:Number) : Quaternion
        {
            var _loc_5:Quaternion;
            _loc_5 = new Quaternion;
            _loc_5.setFromAxisAngle(param1, param2, param3, param4);
            return _loc_5;
        }// end function

        public static function slerp(param1:Quaternion, param2:Quaternion, param3:Number) : Quaternion
        {
            var _loc_4:Number;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            _loc_4 = param1.w * param2.w + param1.x * param2.x + param1.y * param2.y + param1.z * param2.z;
            if (_loc_4 < 0)
            {
                param1.x = param1.x * -1;
                param1.y = param1.y * -1;
                param1.z = param1.z * -1;
                param1.w = param1.w * -1;
                _loc_4 = _loc_4 * -1;
            }// end if
            if (_loc_4 + 1 > EPSILON)
            {
                if (1 - _loc_4 >= EPSILON)
                {
                    _loc_7 = Math.acos(_loc_4);
                    _loc_8 = 1 / Math.sin(_loc_7);
                    _loc_5 = Math.sin(_loc_7 * (1 - param3)) * _loc_8;
                    _loc_6 = Math.sin(_loc_7 * param3) * _loc_8;
                }
                else
                {
                    _loc_5 = 1 - param3;
                    _loc_6 = param3;
                }// end else if
            }
            else
            {
                param2.y = -param1.y;
                param2.x = param1.x;
                param2.w = -param1.w;
                param2.z = param1.z;
                _loc_5 = Math.sin(Math.PI * (0.5 - param3));
                _loc_6 = Math.sin(Math.PI * param3);
            }// end else if
            return new Quaternion(_loc_5 * param1.x + _loc_6 * param2.x, _loc_5 * param1.y + _loc_6 * param2.y, _loc_5 * param1.z + _loc_6 * param2.z, _loc_5 * param1.w + _loc_6 * param2.w);
        }// end function

        public static function createFromOrthoMatrix(param1:Matrix3D) : Quaternion
        {
            var _loc_2:Quaternion;
            _loc_2 = new Quaternion;
            _loc_2.w = Math.sqrt(Math.max(0, 1 + param1.n11 + param1.n22 + param1.n33)) / 2;
            _loc_2.x = Math.sqrt(Math.max(0, 1 + param1.n11 - param1.n22 - param1.n33)) / 2;
            _loc_2.y = Math.sqrt(Math.max(0, 1 - param1.n11 + param1.n22 - param1.n33)) / 2;
            _loc_2.z = Math.sqrt(Math.max(0, 1 - param1.n11 - param1.n22 + param1.n33)) / 2;
            _loc_2.x = param1.n32 - param1.n23 < 0 ? (_loc_2.x < 0 ? (_loc_2.x) : (-_loc_2.x)) : (_loc_2.x < 0 ? (-_loc_2.x) : (_loc_2.x));
            _loc_2.y = param1.n13 - param1.n31 < 0 ? (_loc_2.y < 0 ? (_loc_2.y) : (-_loc_2.y)) : (_loc_2.y < 0 ? (-_loc_2.y) : (_loc_2.y));
            _loc_2.z = param1.n21 - param1.n12 < 0 ? (_loc_2.z < 0 ? (_loc_2.z) : (-_loc_2.z)) : (_loc_2.z < 0 ? (-_loc_2.z) : (_loc_2.z));
            return _loc_2;
        }// end function

        public static function conjugate(param1:Quaternion) : Quaternion
        {
            var _loc_2:Quaternion;
            _loc_2 = new Quaternion;
            _loc_2.x = -param1.x;
            _loc_2.y = -param1.y;
            _loc_2.z = -param1.z;
            _loc_2.w = param1.w;
            return _loc_2;
        }// end function

        public static function slerpOld(param1:Quaternion, param2:Quaternion, param3:Number) : Quaternion
        {
            var _loc_4:Quaternion;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:Number;
            _loc_4 = new Quaternion;
            _loc_5 = param1.w * param2.w + param1.x * param2.x + param1.y * param2.y + param1.z * param2.z;
            if (Math.abs(_loc_5) >= 1)
            {
                _loc_4.w = param1.w;
                _loc_4.x = param1.x;
                _loc_4.y = param1.y;
                _loc_4.z = param1.z;
                return _loc_4;
            }// end if
            _loc_6 = Math.acos(_loc_5);
            _loc_7 = Math.sqrt(1 - _loc_5 * _loc_5);
            if (Math.abs(_loc_7) < 0.001)
            {
                _loc_4.w = param1.w * 0.5 + param2.w * 0.5;
                _loc_4.x = param1.x * 0.5 + param2.x * 0.5;
                _loc_4.y = param1.y * 0.5 + param2.y * 0.5;
                _loc_4.z = param1.z * 0.5 + param2.z * 0.5;
                return _loc_4;
            }// end if
            _loc_8 = Math.sin((1 - param3) * _loc_6) / _loc_7;
            _loc_9 = Math.sin(param3 * _loc_6) / _loc_7;
            _loc_4.w = param1.w * _loc_8 + param2.w * _loc_9;
            _loc_4.x = param1.x * _loc_8 + param2.x * _loc_9;
            _loc_4.y = param1.y * _loc_8 + param2.y * _loc_9;
            _loc_4.z = param1.z * _loc_8 + param2.z * _loc_9;
            return _loc_4;
        }// end function

    }
}
