﻿package org.papervision3d.core.proto
{
    import flash.events.*;
    import flash.utils.*;
    import org.papervision3d.core.log.*;
    import org.papervision3d.objects.*;

    public class DisplayObjectContainer3D extends EventDispatcher
    {
        protected var _childrenByName:Object;
        private var _childrenTotal:int;
        public var root:DisplayObjectContainer3D;
        protected var _children:Dictionary;

        public function DisplayObjectContainer3D() : void
        {
            this._children = new Dictionary(false);
            this._childrenByName = new Dictionary(true);
            this._childrenTotal = 0;
            return;
        }// end function

        public function addChild(param1:DisplayObject3D, param2:String = null) : DisplayObject3D
        {
            if (param1.parent)
            {
                PaperLogger.error("DisplayObjectContainer.addChild : DisplayObject3D already has a parent, ie is already added to scene.");
            }// end if
            if (!(param2 || param1.name))
            {
            }// end if
            param2 = String(param1.id);
            this._children[param1] = param2;
            this._childrenByName[param2] = param1;
            var _loc_3:String;
            _loc_3._childrenTotal = this._childrenTotal++;
            param1.parent = this;
            param1.root = this.root;
            return param1;
        }// end function

        private function findChildByName(param1:String, param2:DisplayObject3D = null) : DisplayObject3D
        {
            var _loc_3:DisplayObject3D;
            var _loc_4:DisplayObject3D;
            if (!param2)
            {
            }// end if
            param2 = DisplayObject3D(this);
            if (!param2)
            {
                return null;
            }// end if
            if (param2.name == param1)
            {
                return param2;
            }// end if
            for each (_loc_3 in param2.children)
            {
                // label
                _loc_4 = findChildByName(param1, _loc_3);
                if (_loc_4)
                {
                    return _loc_4;
                }// end if
            }// end of for each ... in
            return null;
        }// end function

        public function getChildByName(param1:String, param2:Boolean = false) : DisplayObject3D
        {
            if (param2)
            {
                return findChildByName(param1);
            }// end if
            return this._childrenByName[param1];
        }// end function

        public function get numChildren() : int
        {
            return this._childrenTotal;
        }// end function

        public function removeChildByName(param1:String) : DisplayObject3D
        {
            return removeChild(getChildByName(param1));
        }// end function

        override public function toString() : String
        {
            return childrenList();
        }// end function

        public function addChildren(param1:DisplayObject3D) : DisplayObjectContainer3D
        {
            var _loc_2:DisplayObject3D;
            for each (_loc_2 in param1.children)
            {
                // label
                param1.removeChild(_loc_2);
                this.addChild(_loc_2);
            }// end of for each ... in
            return this;
        }// end function

        public function removeChild(param1:DisplayObject3D) : DisplayObject3D
        {
            if (param1 && _children[param1])
            {
                delete _childrenByName[this._children[param1]];
                delete _children[param1];
                param1.parent = null;
                param1.root = null;
                _childrenTotal--;
                return param1;
            }// end if
            return null;
        }// end function

        public function childrenList() : String
        {
            var _loc_1:String;
            var _loc_2:String;
            _loc_1 = "";
            for (_loc_2 in this._children)
            {
                // label
                _loc_1 = _loc_1 + (_loc_2 + "\n");
            }// end of for ... in
            return _loc_1;
        }// end function

        public function get children() : Object
        {
            return this._childrenByName;
        }// end function

    }
}
