﻿package org.papervision3d.core.proto
{
    import flash.events.*;
    import flash.utils.*;
    import org.papervision3d.core.geom.renderables.*;
    import org.papervision3d.core.math.*;
    import org.papervision3d.objects.*;

    public class GeometryObject3D extends EventDispatcher
    {
        protected var _boundingSphereDirty:Boolean = true;
        public var dirty:Boolean;
        protected var _aabbDirty:Boolean = true;
        public var _ready:Boolean = false;
        protected var _boundingSphere:BoundingSphere;
        public var faces:Array;
        private var _numInstances:uint = 0;
        public var vertices:Array;
        protected var _aabb:AxisAlignedBoundingBox;

        public function GeometryObject3D() : void
        {
            _boundingSphereDirty = true;
            _aabbDirty = true;
            _numInstances = 0;
            _ready = false;
            dirty = true;
            return;
        }// end function

        public function transformVertices(param1:Matrix3D) : void
        {
            var _loc_2:Number;
            var _loc_3:Number;
            var _loc_4:Number;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:Number;
            var _loc_10:Number;
            var _loc_11:Number;
            var _loc_12:Number;
            var _loc_13:Number;
            var _loc_14:int;
            var _loc_15:Vertex3D;
            var _loc_16:Number;
            var _loc_17:Number;
            var _loc_18:Number;
            var _loc_19:Number;
            var _loc_20:Number;
            var _loc_21:Number;
            _loc_2 = param1.n11;
            _loc_3 = param1.n12;
            _loc_4 = param1.n13;
            _loc_5 = param1.n21;
            _loc_6 = param1.n22;
            _loc_7 = param1.n23;
            _loc_8 = param1.n31;
            _loc_9 = param1.n32;
            _loc_10 = param1.n33;
            _loc_11 = param1.n14;
            _loc_12 = param1.n24;
            _loc_13 = param1.n34;
            _loc_14 = vertices.length;
            do
            {
                // label
                _loc_16 = _loc_15.x;
                _loc_17 = _loc_15.y;
                _loc_18 = _loc_15.z;
                _loc_19 = _loc_16 * _loc_2 + _loc_17 * _loc_3 + _loc_18 * _loc_4 + _loc_11;
                _loc_20 = _loc_16 * _loc_5 + _loc_17 * _loc_6 + _loc_18 * _loc_7 + _loc_12;
                _loc_21 = _loc_16 * _loc_8 + _loc_17 * _loc_9 + _loc_18 * _loc_10 + _loc_13;
                _loc_15.x = _loc_19;
                _loc_15.y = _loc_20;
                _loc_15.z = _loc_21;
                var _loc_22:* = vertices[--_loc_14];
                _loc_15 = vertices[--_loc_14];
            }while (_loc_22)
            return;
        }// end function

        public function flipFaces() : void
        {
            var _loc_1:Triangle3D;
            var _loc_2:Vertex3D;
            for each (_loc_1 in this.faces)
            {
                // label
                _loc_2 = _loc_1.v0;
                _loc_1.v0 = _loc_1.v2;
                _loc_1.v2 = _loc_2;
                _loc_1.uv = [_loc_1.uv2, _loc_1.uv1, _loc_1.uv0];
                _loc_1.createNormal();
            }// end of for each ... in
            this.ready = true;
            return;
        }// end function

        private function createVertexNormals() : void
        {
            var _loc_1:Dictionary;
            var _loc_2:Triangle3D;
            var _loc_3:Vertex3D;
            _loc_1 = new Dictionary(true);
            for each (_loc_2 in faces)
            {
                // label
                _loc_2.v0.connectedFaces[_loc_2] = _loc_2;
                _loc_2.v1.connectedFaces[_loc_2] = _loc_2;
                _loc_2.v2.connectedFaces[_loc_2] = _loc_2;
                _loc_1[_loc_2.v0] = _loc_2.v0;
                _loc_1[_loc_2.v1] = _loc_2.v1;
                _loc_1[_loc_2.v2] = _loc_2.v2;
            }// end of for each ... in
            for each (_loc_3 in _loc_1)
            {
                // label
                _loc_3.calculateNormal();
            }// end of for each ... in
            return;
        }// end function

        public function clone(param1:DisplayObject3D = null) : GeometryObject3D
        {
            var _loc_2:Dictionary;
            var _loc_3:Dictionary;
            var _loc_4:GeometryObject3D;
            var _loc_5:int;
            var _loc_6:MaterialObject3D;
            var _loc_7:Vertex3D;
            var _loc_8:Triangle3D;
            var _loc_9:Vertex3D;
            var _loc_10:Vertex3D;
            var _loc_11:Vertex3D;
            _loc_2 = new Dictionary(true);
            _loc_3 = new Dictionary(true);
            _loc_4 = new GeometryObject3D();
            _loc_4.vertices = new Array();
            _loc_4.faces = new Array();
            _loc_5 = 0;
            while (_loc_5 < this.vertices.length)
            {
                // label
                _loc_7 = this.vertices[_loc_5];
                _loc_3[_loc_7] = _loc_7.clone();
                _loc_4.vertices.push(_loc_3[_loc_7]);
                _loc_5++;
            }// end while
            _loc_5 = 0;
            while (_loc_5 < this.faces.length)
            {
                // label
                _loc_8 = this.faces[_loc_5];
                _loc_9 = _loc_3[_loc_8.v0];
                _loc_10 = _loc_3[_loc_8.v1];
                _loc_11 = _loc_3[_loc_8.v2];
                _loc_4.faces.push(new Triangle3D(param1, [_loc_9, _loc_10, _loc_11], _loc_8.material, _loc_8.uv));
                _loc_2[_loc_8.material] = _loc_8.material;
                _loc_5++;
            }// end while
            for each (_loc_6 in _loc_2)
            {
                // label
                if (_loc_6)
                {
                    _loc_6.registerObject(param1);
                }// end if
            }// end of for each ... in
            return _loc_4;
        }// end function

        public function set ready(param1:Boolean) : void
        {
            if (param1)
            {
                createVertexNormals();
                this.dirty = false;
            }// end if
            _ready = param1;
            return;
        }// end function

        public function get ready() : Boolean
        {
            return _ready;
        }// end function

        public function get aabb() : AxisAlignedBoundingBox
        {
            if (_aabbDirty)
            {
                _aabb = AxisAlignedBoundingBox.createFromVertices(vertices);
                _aabbDirty = false;
            }// end if
            return _aabb;
        }// end function

        public function get boundingSphere() : BoundingSphere
        {
            if (_boundingSphereDirty)
            {
                _boundingSphere = BoundingSphere.getFromVertices(vertices);
                _boundingSphereDirty = false;
            }// end if
            return _boundingSphere;
        }// end function

    }
}
