﻿package org.papervision3d.core.proto
{
    import org.papervision3d.core.math.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*;

    public class LightObject3D extends DisplayObject3D
    {
        private var displaySphere:Sphere;
        public var flipped:Boolean;
        public var lightMatrix:Matrix3D;
        private var _showLight:Boolean;

        public function LightObject3D(param1:Boolean = false, param2:Boolean = false)
        {
            this.lightMatrix = Matrix3D.IDENTITY;
            this.showLight = param1;
            this.flipped = param2;
            return;
        }// end function

        public function set showLight(param1:Boolean) : void
        {
            if (_showLight)
            {
                removeChild(displaySphere);
            }// end if
            if (param1)
            {
                displaySphere = new Sphere(new WireframeMaterial(16776960), 10, 3, 2);
                addChild(displaySphere);
            }// end if
            _showLight = param1;
            return;
        }// end function

        public function get showLight() : Boolean
        {
            return _showLight;
        }// end function

    }
}
