﻿package org.papervision3d.core.render.command
{
    import flash.display.*;
    import flash.geom.*;
    import org.papervision3d.core.geom.renderables.*;
    import org.papervision3d.core.math.*;
    import org.papervision3d.core.proto.*;
    import org.papervision3d.core.render.data.*;
    import org.papervision3d.core.render.draw.*;
    import org.papervision3d.materials.*;

    public class RenderTriangle extends RenderableListItem implements IRenderListItem
    {
        public var create:Function;
        public var triangle:Triangle3D;
        private var bzf:Number;
        private var det:Number;
        private var axf:Number;
        private var v12:Vertex3DInstance;
        private var faz:Number;
        private var position:Number3D;
        private var ayf:Number;
        private var au:Number;
        private var av:Number;
        private var ax:Number;
        private var ay:Number;
        private var v20:Vertex3DInstance;
        private var fbz:Number;
        private var az:Number;
        private var azf:Number;
        private var bu:Number;
        private var bv:Number;
        private var bx:Number;
        private var by:Number;
        private var bz:Number;
        private var fcz:Number;
        private var uv01:NumberUV;
        private var cv:Number;
        private var cx:Number;
        private var cy:Number;
        private var cz:Number;
        private var cu:Number;
        public var v0:Vertex3DInstance;
        public var v1:Vertex3DInstance;
        private var db:Number;
        private var dc:Number;
        private var uv12:NumberUV;
        public var v2:Vertex3DInstance;
        public var container:Sprite;
        private var cxf:Number;
        private var da:Number;
        protected var vx0:Vertex3DInstance;
        public var uv0:NumberUV;
        public var uv1:NumberUV;
        public var uv2:NumberUV;
        protected var vx1:Vertex3DInstance;
        protected var vx2:Vertex3DInstance;
        private var uv20:NumberUV;
        public var renderer:ITriangleDrawer;
        private var cyf:Number;
        private var czf:Number;
        private var bxf:Number;
        protected var vPointL:Vertex3DInstance;
        private var byf:Number;
        public var renderMat:MaterialObject3D;
        private var v01:Vertex3DInstance;
        static var resPA:Vertex3DInstance = new Vertex3DInstance();
        static var resBA:Vertex3DInstance = new Vertex3DInstance();
        static var vPoint:Vertex3DInstance = new Vertex3DInstance();
        static var resRA:Vertex3DInstance = new Vertex3DInstance();

        public function RenderTriangle(param1:Triangle3D) : void
        {
            position = new Number3D();
            this.triangle = param1;
            this.instance = param1.instance;
            renderableInstance = param1;
            renderable = Triangle3D;
            this.v0 = param1.v0.vertex3DInstance;
            this.v1 = param1.v1.vertex3DInstance;
            this.v2 = param1.v2.vertex3DInstance;
            this.uv0 = param1.uv0;
            this.uv1 = param1.uv1;
            this.uv2 = param1.uv2;
            this.renderer = param1.material;
            update();
            return;
        }// end function

        private function deepHitTest(param1:Triangle3D, param2:Vertex3DInstance, param3:RenderHitData) : RenderHitData
        {
            var _loc_4:Vertex3DInstance;
            var _loc_5:Vertex3DInstance;
            var _loc_6:Vertex3DInstance;
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:Number;
            var _loc_10:Number;
            var _loc_11:Number;
            var _loc_12:Number;
            var _loc_13:Number;
            var _loc_14:Number;
            var _loc_15:Number;
            var _loc_16:Number;
            var _loc_17:Number;
            var _loc_18:Number;
            var _loc_19:Number;
            var _loc_20:Number;
            var _loc_21:Number;
            var _loc_22:Number;
            var _loc_23:Number;
            var _loc_24:Number;
            var _loc_25:Number;
            var _loc_26:Number;
            var _loc_27:Number;
            var _loc_28:Number;
            var _loc_29:Number;
            var _loc_30:Array;
            var _loc_31:Number;
            var _loc_32:Number;
            var _loc_33:Number;
            var _loc_34:Number;
            var _loc_35:Number;
            var _loc_36:Number;
            var _loc_37:Number;
            var _loc_38:Number;
            var _loc_39:BitmapData;
            var _loc_40:Number;
            var _loc_41:Number;
            var _loc_42:Number;
            var _loc_43:Number;
            var _loc_44:MovieMaterial;
            var _loc_45:Rectangle;
            _loc_4 = param1.v0.vertex3DInstance;
            _loc_5 = param1.v1.vertex3DInstance;
            _loc_6 = param1.v2.vertex3DInstance;
            _loc_7 = _loc_6.x - _loc_4.x;
            _loc_8 = _loc_6.y - _loc_4.y;
            _loc_9 = _loc_5.x - _loc_4.x;
            _loc_10 = _loc_5.y - _loc_4.y;
            _loc_11 = param2.x - _loc_4.x;
            _loc_12 = param2.y - _loc_4.y;
            _loc_13 = _loc_7 * _loc_7 + _loc_8 * _loc_8;
            _loc_14 = _loc_7 * _loc_9 + _loc_8 * _loc_10;
            _loc_15 = _loc_7 * _loc_11 + _loc_8 * _loc_12;
            _loc_16 = _loc_9 * _loc_9 + _loc_10 * _loc_10;
            _loc_17 = _loc_9 * _loc_11 + _loc_10 * _loc_12;
            _loc_18 = 1 / (_loc_13 * _loc_16 - _loc_14 * _loc_14);
            _loc_19 = (_loc_16 * _loc_15 - _loc_14 * _loc_17) * _loc_18;
            _loc_20 = (_loc_13 * _loc_17 - _loc_14 * _loc_15) * _loc_18;
            _loc_21 = param1.v2.x - param1.v0.x;
            _loc_22 = param1.v2.y - param1.v0.y;
            _loc_23 = param1.v2.z - param1.v0.z;
            _loc_24 = param1.v1.x - param1.v0.x;
            _loc_25 = param1.v1.y - param1.v0.y;
            _loc_26 = param1.v1.z - param1.v0.z;
            _loc_27 = param1.v0.x + _loc_21 * _loc_19 + _loc_24 * _loc_20;
            _loc_28 = param1.v0.y + _loc_22 * _loc_19 + _loc_25 * _loc_20;
            _loc_29 = param1.v0.z + _loc_23 * _loc_19 + _loc_26 * _loc_20;
            _loc_30 = param1.uv;
            _loc_31 = _loc_30[0].u;
            _loc_32 = _loc_30[1].u;
            _loc_33 = _loc_30[2].u;
            _loc_34 = _loc_30[0].v;
            _loc_35 = _loc_30[1].v;
            _loc_36 = _loc_30[2].v;
            _loc_37 = (_loc_32 - _loc_31) * _loc_20 + (_loc_33 - _loc_31) * _loc_19 + _loc_31;
            _loc_38 = (_loc_35 - _loc_34) * _loc_20 + (_loc_36 - _loc_34) * _loc_19 + _loc_34;
            if (triangle.material)
            {
                renderMat = param1.material;
            }
            else
            {
                renderMat = param1.instance.material;
            }// end else if
            _loc_39 = renderMat.bitmap;
            _loc_40 = 1;
            _loc_41 = 1;
            _loc_42 = 0;
            _loc_43 = 0;
            if (renderMat is MovieMaterial)
            {
                _loc_44 = renderMat as MovieMaterial;
                _loc_45 = _loc_44.rect;
                if (_loc_45)
                {
                    _loc_42 = _loc_45.x;
                    _loc_43 = _loc_45.y;
                    _loc_40 = _loc_45.width;
                    _loc_41 = _loc_45.height;
                }// end if
            }
            else if (_loc_39)
            {
                _loc_40 = BitmapMaterial.AUTO_MIP_MAPPING ? (renderMat.widthOffset) : (_loc_39.width);
                _loc_41 = BitmapMaterial.AUTO_MIP_MAPPING ? (renderMat.heightOffset) : (_loc_39.height);
            }// end else if
            param3.displayObject3D = param1.instance;
            param3.material = renderMat;
            param3.renderable = param1;
            param3.hasHit = true;
            position.x = _loc_27;
            position.y = _loc_28;
            position.z = _loc_29;
            Matrix3D.multiplyVector(param1.instance.world, position);
            param3.x = position.x;
            param3.y = position.y;
            param3.z = position.z;
            param3.u = _loc_37 * _loc_40 + _loc_42;
            param3.v = _loc_41 - _loc_38 * _loc_41 + _loc_43;
            return param3;
        }// end function

        override public function hitTestPoint2D(param1:Point, param2:RenderHitData) : RenderHitData
        {
            renderMat = triangle.material;
            if (!renderMat)
            {
                renderMat = triangle.instance.material;
            }// end if
            if (renderMat && renderMat.interactive)
            {
                vPointL = RenderTriangle.vPoint;
                vPointL.x = param1.x;
                vPointL.y = param1.y;
                vx0 = triangle.v0.vertex3DInstance;
                vx1 = triangle.v1.vertex3DInstance;
                vx2 = triangle.v2.vertex3DInstance;
                if (sameSide(vPointL, vx0, vx1, vx2))
                {
                    if (sameSide(vPointL, vx1, vx0, vx2))
                    {
                        if (sameSide(vPointL, vx2, vx0, vx1))
                        {
                            return deepHitTest(triangle, vPointL, param2);
                        }// end if
                    }// end if
                }// end if
            }// end if
            return param2;
        }// end function

        public function fivepointcut(param1:Vertex3DInstance, param2:Vertex3DInstance, param3:Vertex3DInstance, param4:Vertex3DInstance, param5:Vertex3DInstance, param6:NumberUV, param7:NumberUV, param8:NumberUV, param9:NumberUV, param10:NumberUV) : Array
        {
            if (param1.distanceSqr(param4) < param2.distanceSqr(param5))
            {
                return [create(renderableInstance, renderer, param1, param2, param4, param6, param7, param9), create(renderableInstance, renderer, param2, param3, param4, param7, param8, param9), create(renderableInstance, renderer, param1, param4, param5, param6, param9, param10)];
            }// end if
            return [create(renderableInstance, renderer, param1, param2, param5, param6, param7, param10), create(renderableInstance, renderer, param2, param3, param4, param7, param8, param9), create(renderableInstance, renderer, param2, param4, param5, param7, param9, param10)];
        }// end function

        override public function render(param1:RenderSessionData, param2:Graphics) : void
        {
            renderer.drawTriangle(this, param2, param1);
            return;
        }// end function

        final override public function quarter(param1:Number) : Array
        {
            if (area < 20)
            {
                return null;
            }// end if
            v01 = Vertex3DInstance.median(v0, v1, param1);
            v12 = Vertex3DInstance.median(v1, v2, param1);
            v20 = Vertex3DInstance.median(v2, v0, param1);
            uv01 = NumberUV.median(uv0, uv1);
            uv12 = NumberUV.median(uv1, uv2);
            uv20 = NumberUV.median(uv2, uv0);
            return [create(renderableInstance, renderer, v0, v01, v20, uv0, uv01, uv20), create(renderableInstance, renderer, v1, v12, v01, uv1, uv12, uv01), create(renderableInstance, renderer, v2, v20, v12, uv2, uv20, uv12), create(renderableInstance, renderer, v01, v12, v20, uv01, uv12, uv20)];
        }// end function

        final override public function getZ(param1:Number, param2:Number, param3:Number) : Number
        {
            ax = v0.x;
            ay = v0.y;
            az = v0.z;
            bx = v1.x;
            by = v1.y;
            bz = v1.z;
            cx = v2.x;
            cy = v2.y;
            cz = v2.z;
            if (ax == param1 && ay == param2)
            {
                return az;
            }// end if
            if (bx == param1 && by == param2)
            {
                return bz;
            }// end if
            if (cx == param1 && cy == param2)
            {
                return cz;
            }// end if
            azf = az / param3;
            bzf = bz / param3;
            czf = cz / param3;
            faz = 1 + azf;
            fbz = 1 + bzf;
            fcz = 1 + czf;
            axf = ax * faz - param1 * azf;
            bxf = bx * fbz - param1 * bzf;
            cxf = cx * fcz - param1 * czf;
            ayf = ay * faz - param2 * azf;
            byf = by * fbz - param2 * bzf;
            cyf = cy * fcz - param2 * czf;
            det = axf * (byf - cyf) + bxf * (cyf - ayf) + cxf * (ayf - byf);
            da = param1 * (byf - cyf) + bxf * (cyf - param2) + cxf * (param2 - byf);
            db = axf * (param2 - cyf) + param1 * (cyf - ayf) + cxf * (ayf - param2);
            dc = axf * (byf - param2) + bxf * (param2 - ayf) + param1 * (ayf - byf);
            return (da * az + db * bz + dc * cz) / det;
        }// end function

        override public function update() : void
        {
            if (v0.x > v1.x)
            {
                if (v0.x > v2.x)
                {
                    maxX = v0.x;
                }
                else
                {
                    maxX = v2.x;
                }// end else if
            }
            else if (v1.x > v2.x)
            {
                maxX = v1.x;
            }
            else
            {
                maxX = v2.x;
            }// end else if
            if (v0.x < v1.x)
            {
                if (v0.x < v2.x)
                {
                    minX = v0.x;
                }
                else
                {
                    minX = v2.x;
                }// end else if
            }
            else if (v1.x < v2.x)
            {
                minX = v1.x;
            }
            else
            {
                minX = v2.x;
            }// end else if
            if (v0.y > v1.y)
            {
                if (v0.y > v2.y)
                {
                    maxY = v0.y;
                }
                else
                {
                    maxY = v2.y;
                }// end else if
            }
            else if (v1.y > v2.y)
            {
                maxY = v1.y;
            }
            else
            {
                maxY = v2.y;
            }// end else if
            if (v0.y < v1.y)
            {
                if (v0.y < v2.y)
                {
                    minY = v0.y;
                }
                else
                {
                    minY = v2.y;
                }// end else if
            }
            else if (v1.y < v2.y)
            {
                minY = v1.y;
            }
            else
            {
                minY = v2.y;
            }// end else if
            if (v0.z > v1.z)
            {
                if (v0.z > v2.z)
                {
                    maxZ = v0.z;
                }
                else
                {
                    maxZ = v2.z;
                }// end else if
            }
            else if (v1.z > v2.z)
            {
                maxZ = v1.z;
            }
            else
            {
                maxZ = v2.z;
            }// end else if
            if (v0.z < v1.z)
            {
                if (v0.z < v2.z)
                {
                    minZ = v0.z;
                }
                else
                {
                    minZ = v2.z;
                }// end else if
            }
            else if (v1.z < v2.z)
            {
                minZ = v1.z;
            }
            else
            {
                minZ = v2.z;
            }// end else if
            screenZ = (v0.z + v1.z + v2.z) / 3;
            area = 0.5 * (v0.x * (v2.y - v1.y) + v1.x * (v0.y - v2.y) + v2.x * (v1.y - v0.y));
            return;
        }// end function

        public function sameSide(param1:Vertex3DInstance, param2:Vertex3DInstance, param3:Vertex3DInstance, param4:Vertex3DInstance) : Boolean
        {
            Vertex3DInstance.subTo(param4, param3, resBA);
            Vertex3DInstance.subTo(param1, param3, resPA);
            Vertex3DInstance.subTo(param2, param3, resRA);
            return Vertex3DInstance.cross(resBA, resPA) * Vertex3DInstance.cross(resBA, resRA) >= 0;
        }// end function

    }
}
