﻿package org.papervision3d.core.render.data
{
    import flash.display.*;
    import flash.geom.*;
    import org.papervision3d.core.render.command.*;
    import org.papervision3d.objects.*;

    final public class QuadTreeNode extends Object
    {
        private var level:int;
        public var leftbottomFlag:Boolean;
        public var xdiv:Number;
        private var halfheight:Number;
        public var maxlevel:int = 4;
        private var render_center_length:int = -1;
        public var parent:QuadTreeNode;
        public var righttop:QuadTreeNode;
        public var righttopFlag:Boolean;
        public var rightbottom:QuadTreeNode;
        public var rightbottomFlag:Boolean;
        public var center:Array;
        public var onlysource:DisplayObject3D;
        public var onlysourceFlag:Boolean = true;
        public var lefttop:QuadTreeNode;
        private var render_center_index:int = -1;
        private var halfwidth:Number;
        public var ydiv:Number;
        public var leftbottom:QuadTreeNode;
        public var lefttopFlag:Boolean;
        public var create:Function;
        public var hasContent:Boolean = false;

        public function QuadTreeNode(param1:Number, param2:Number, param3:Number, param4:Number, param5:int, param6:QuadTreeNode = null, param7:uint = 4)
        {
            render_center_length = -1;
            render_center_index = -1;
            maxlevel = 4;
            onlysourceFlag = true;
            hasContent = false;
            this.level = param5;
            this.xdiv = param1;
            this.ydiv = param2;
            halfwidth = param3 / 2;
            halfheight = param4 / 2;
            this.parent = param6;
            this.maxlevel = param7;
            return;
        }// end function

        public function render(param1:Number, param2:RenderSessionData, param3:Graphics) : void
        {
            var _loc_4:RenderableListItem;
            if (render_center_length == -1)
            {
                if (center != null)
                {
                    render_center_length = center.length;
                    if (render_center_length > 1)
                    {
                        center.sortOn("screenZ", Array.DESCENDING | Array.NUMERIC);
                    }// end if
                }
                else
                {
                    render_center_length = 0;
                }// end else if
                render_center_index = 0;
            }// end if
            while (render_center_index < render_center_length)
            {
                // label
                _loc_4 = center[render_center_index];
                if (_loc_4.screenZ < param1)
                {
                    break;
                }// end if
                render_other(_loc_4.screenZ, param2, param3);
                _loc_4.render(param2, param3);
                param2.viewPort.lastRenderList.push(_loc_4);
                render_center_index++;
            }// end while
            if (render_center_index == render_center_length)
            {
                center = null;
            }// end if
            render_other(param1, param2, param3);
            return;
        }// end function

        public function push(param1:RenderableListItem) : void
        {
            hasContent = true;
            if (onlysourceFlag)
            {
                if (onlysource != null && onlysource != param1.instance)
                {
                    onlysourceFlag = false;
                }// end if
                onlysource = param1.instance;
            }// end if
            if (level < maxlevel)
            {
                if (param1.maxX <= xdiv)
                {
                    if (param1.maxY <= ydiv)
                    {
                        if (lefttop == null)
                        {
                            lefttopFlag = true;
                            lefttop = new QuadTreeNode(xdiv - halfwidth / 2, ydiv - halfheight / 2, halfwidth, halfheight, level + 1, this, maxlevel);
                        }
                        else if (!lefttopFlag)
                        {
                            lefttopFlag = true;
                            lefttop.reset(xdiv - halfwidth / 2, ydiv - halfheight / 2, halfwidth, halfheight, maxlevel);
                        }// end else if
                        lefttop.push(param1);
                        return;
                    }
                    else if (param1.minY >= ydiv)
                    {
                        if (leftbottom == null)
                        {
                            leftbottomFlag = true;
                            leftbottom = new QuadTreeNode(xdiv - halfwidth / 2, ydiv + halfheight / 2, halfwidth, halfheight, level + 1, this, maxlevel);
                        }
                        else if (!leftbottomFlag)
                        {
                            leftbottomFlag = true;
                            leftbottom.reset(xdiv - halfwidth / 2, ydiv + halfheight / 2, halfwidth, halfheight, maxlevel);
                        }// end else if
                        leftbottom.push(param1);
                        return;
                    }// end else if
                }
                else if (param1.minX >= xdiv)
                {
                    if (param1.maxY <= ydiv)
                    {
                        if (righttop == null)
                        {
                            righttopFlag = true;
                            righttop = new QuadTreeNode(xdiv + halfwidth / 2, ydiv - halfheight / 2, halfwidth, halfheight, level + 1, this, maxlevel);
                        }
                        else if (!righttopFlag)
                        {
                            righttopFlag = true;
                            righttop.reset(xdiv + halfwidth / 2, ydiv - halfheight / 2, halfwidth, halfheight, maxlevel);
                        }// end else if
                        righttop.push(param1);
                        return;
                    }
                    else if (param1.minY >= ydiv)
                    {
                        if (rightbottom == null)
                        {
                            rightbottomFlag = true;
                            rightbottom = new QuadTreeNode(xdiv + halfwidth / 2, ydiv + halfheight / 2, halfwidth, halfheight, level + 1, this, maxlevel);
                        }
                        else if (!rightbottomFlag)
                        {
                            rightbottomFlag = true;
                            rightbottom.reset(xdiv + halfwidth / 2, ydiv + halfheight / 2, halfwidth, halfheight, maxlevel);
                        }// end else if
                        rightbottom.push(param1);
                        return;
                    }// end if
                }// end else if
            }// end else if
            if (center == null)
            {
                center = new Array();
            }// end if
            center.push(param1);
            param1.quadrant = this;
            return;
        }// end function

        private function render_other(param1:Number, param2:RenderSessionData, param3:Graphics) : void
        {
            if (lefttopFlag)
            {
                lefttop.render(param1, param2, param3);
            }// end if
            if (leftbottomFlag)
            {
                leftbottom.render(param1, param2, param3);
            }// end if
            if (righttopFlag)
            {
                righttop.render(param1, param2, param3);
            }// end if
            if (rightbottomFlag)
            {
                rightbottom.render(param1, param2, param3);
            }// end if
            return;
        }// end function

        public function reset(param1:Number, param2:Number, param3:Number, param4:Number, param5:uint) : void
        {
            this.xdiv = param1;
            this.ydiv = param2;
            halfwidth = param3 / 2;
            halfheight = param4 / 2;
            lefttopFlag = false;
            leftbottomFlag = false;
            righttopFlag = false;
            rightbottomFlag = false;
            onlysourceFlag = true;
            onlysource = null;
            render_center_length = -1;
            render_center_index = -1;
            hasContent = false;
            maxlevel = param5;
            return;
        }// end function

        public function getRect() : Rectangle
        {
            return new Rectangle(xdiv, ydiv, halfwidth * 2, halfheight * 2);
        }// end function

    }
}
