﻿package org.papervision3d.core.render.data
{
    import org.papervision3d.core.geom.renderables.*;
    import org.papervision3d.core.proto.*;
    import org.papervision3d.objects.*;

    public class RenderHitData extends Object
    {
        public var y:Number;
        public var endTime:int = 0;
        public var displayObject3D:DisplayObject3D;
        public var startTime:int = 0;
        public var hasHit:Boolean = false;
        public var material:MaterialObject3D;
        public var renderable:IRenderable;
        public var u:Number;
        public var v:Number;
        public var x:Number;
        public var z:Number;

        public function RenderHitData() : void
        {
            startTime = 0;
            endTime = 0;
            hasHit = false;
            return;
        }// end function

        public function clear() : void
        {
            startTime = 0;
            endTime = 0;
            hasHit = false;
            displayObject3D = null;
            material = null;
            renderable = null;
            u = 0;
            v = 0;
            x = 0;
            y = 0;
            z = 0;
            return;
        }// end function

        public function clone() : RenderHitData
        {
            var _loc_1:RenderHitData;
            _loc_1 = new RenderHitData();
            _loc_1.startTime = startTime;
            _loc_1.endTime = endTime;
            _loc_1.hasHit = hasHit;
            _loc_1.displayObject3D = displayObject3D;
            _loc_1.material = material;
            _loc_1.renderable = renderable;
            _loc_1.u = u;
            _loc_1.v = v;
            _loc_1.x = x;
            _loc_1.y = y;
            _loc_1.z = z;
            return _loc_1;
        }// end function

        public function toString() : String
        {
            return displayObject3D + " " + renderable;
        }// end function

    }
}
