﻿package org.papervision3d.core.render.data
{
    import flash.display.*;
    import org.papervision3d.core.clipping.*;
    import org.papervision3d.core.culling.*;
    import org.papervision3d.core.proto.*;
    import org.papervision3d.core.render.*;
    import org.papervision3d.view.*;

    public class RenderSessionData extends Object
    {
        public var renderer:IRenderEngine;
        public var particleCuller:IParticleCuller;
        public var viewPort:Viewport3D;
        public var triangleCuller:ITriangleCuller;
        public var container:Sprite;
        public var clipping:DefaultClipping;
        public var quadrantTree:QuadTree;
        public var scene:SceneObject3D;
        public var renderStatistics:RenderStatistics;
        public var renderObjects:Array;
        public var camera:CameraObject3D;
        public var renderLayers:Array;
        public var sorted:Boolean;

        public function RenderSessionData() : void
        {
            this.renderStatistics = new RenderStatistics();
            return;
        }// end function

        public function destroy() : void
        {
            triangleCuller = null;
            particleCuller = null;
            viewPort = null;
            container = null;
            scene = null;
            camera = null;
            renderer = null;
            renderStatistics = null;
            renderObjects = null;
            renderLayers = null;
            clipping = null;
            quadrantTree = null;
            return;
        }// end function

        public function clone() : RenderSessionData
        {
            var _loc_1:RenderSessionData;
            _loc_1 = new RenderSessionData();
            _loc_1.triangleCuller = triangleCuller;
            _loc_1.particleCuller = particleCuller;
            _loc_1.viewPort = viewPort;
            _loc_1.container = container;
            _loc_1.scene = scene;
            _loc_1.camera = camera;
            _loc_1.renderer = renderer;
            _loc_1.renderStatistics = renderStatistics.clone();
            _loc_1.clipping = clipping;
            _loc_1.quadrantTree = quadrantTree;
            return _loc_1;
        }// end function

    }
}
