﻿package org.papervision3d.core.render.shader
{
    import flash.display.*;
    import flash.geom.*;
    import flash.utils.*;
    import org.papervision3d.core.geom.renderables.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.shaders.*;
    import org.papervision3d.objects.*;

    public class ShaderObjectData extends Object
    {
        public var shaderRenderer:ShaderRenderer;
        public var triangleUVS:Dictionary;
        public var renderTriangleUVS:Dictionary;
        public var lightMatrices:Dictionary;
        public var shadedMaterial:ShadedMaterial;
        public var uvMatrices:Dictionary;
        private var origin:Point;
        public var triangleRects:Dictionary;
        public var material:BitmapMaterial;
        protected var triangleBitmaps:Dictionary;
        public var object:DisplayObject3D;

        public function ShaderObjectData(param1:DisplayObject3D, param2:BitmapMaterial, param3:ShadedMaterial) : void
        {
            origin = new Point(0, 0);
            shaderRenderer = new ShaderRenderer();
            lightMatrices = new Dictionary();
            uvMatrices = new Dictionary();
            this.object = param1;
            this.material = param2;
            this.shadedMaterial = param3;
            triangleUVS = new Dictionary();
            renderTriangleUVS = new Dictionary();
            triangleBitmaps = new Dictionary();
            triangleRects = new Dictionary();
            return;
        }// end function

        public function getRectFor(param1:Triangle3D) : Rectangle
        {
            var _loc_2:Number;
            var _loc_3:Number;
            var _loc_4:Number;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:Number;
            var _loc_10:Number;
            var _loc_11:Number;
            var _loc_12:Number;
            var _loc_13:Number;
            var _loc_14:Number;
            var _loc_15:Number;
            if (!triangleRects[param1])
            {
                _loc_2 = material.bitmap.width;
                _loc_3 = material.bitmap.height;
                _loc_4 = param1.uv[0].u * _loc_2;
                _loc_5 = (1 - param1.uv[0].v) * _loc_3;
                _loc_6 = param1.uv[1].u * _loc_2;
                _loc_7 = (1 - param1.uv[1].v) * _loc_3;
                _loc_8 = param1.uv[2].u * _loc_2;
                _loc_9 = (1 - param1.uv[2].v) * _loc_3;
                _loc_10 = Math.min(Math.min(_loc_4, _loc_6), _loc_8);
                _loc_11 = Math.min(Math.min(_loc_5, _loc_7), _loc_9);
                _loc_12 = Math.max(Math.max(_loc_4, _loc_6), _loc_8);
                _loc_13 = Math.max(Math.max(_loc_5, _loc_7), _loc_9);
                _loc_14 = _loc_12 - _loc_10;
                _loc_15 = _loc_13 - _loc_11;
                if (_loc_14 <= 0)
                {
                    _loc_14 = 1;
                }// end if
                if (_loc_15 <= 0)
                {
                    _loc_15 = 1;
                }// end if
                var _loc_16:* = new Rectangle(_loc_10, _loc_11, _loc_14, _loc_15);
                triangleRects[param1] = new Rectangle(_loc_10, _loc_11, _loc_14, _loc_15);
                return _loc_16;
            }// end if
            return triangleRects[param1];
        }// end function

        private function perturbUVMatrix(param1:Matrix, param2:Triangle3D, param3:Number = 2) : void
        {
            var _loc_4:Number;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:Number;
            var _loc_10:Number;
            var _loc_11:Number;
            var _loc_12:Number;
            var _loc_13:Number;
            var _loc_14:Number;
            var _loc_15:Number;
            var _loc_16:Number;
            var _loc_17:Number;
            var _loc_18:Number;
            var _loc_19:Number;
            var _loc_20:Number;
            var _loc_21:Number;
            var _loc_22:Number;
            var _loc_23:Number;
            var _loc_24:Number;
            var _loc_25:Number;
            var _loc_26:Number;
            var _loc_27:Number;
            var _loc_28:Number;
            var _loc_29:Number;
            var _loc_30:Number;
            var _loc_31:Number;
            var _loc_32:Number;
            var _loc_33:Number;
            var _loc_34:Number;
            _loc_4 = material.bitmap.width;
            _loc_5 = material.bitmap.height;
            _loc_6 = param2.uv[0].u;
            _loc_7 = 1 - param2.uv[0].v;
            _loc_8 = param2.uv[1].u;
            _loc_9 = 1 - param2.uv[1].v;
            _loc_10 = param2.uv[2].u;
            _loc_11 = 1 - param2.uv[2].v;
            _loc_12 = _loc_6 * _loc_4;
            _loc_13 = _loc_7 * _loc_5;
            _loc_14 = _loc_8 * _loc_4;
            _loc_15 = _loc_9 * _loc_5;
            _loc_16 = _loc_10 * _loc_4;
            _loc_17 = _loc_11 * _loc_5;
            _loc_18 = (_loc_10 + _loc_8 + _loc_6) / 3;
            _loc_19 = (_loc_11 + _loc_9 + _loc_7) / 3;
            _loc_20 = _loc_6 - _loc_18;
            _loc_21 = _loc_7 - _loc_19;
            _loc_22 = _loc_8 - _loc_18;
            _loc_23 = _loc_9 - _loc_19;
            _loc_24 = _loc_10 - _loc_18;
            _loc_25 = _loc_11 - _loc_19;
            _loc_26 = _loc_20 < 0 ? (-_loc_20) : (_loc_20);
            _loc_27 = _loc_21 < 0 ? (-_loc_21) : (_loc_21);
            _loc_28 = _loc_22 < 0 ? (-_loc_22) : (_loc_22);
            _loc_29 = _loc_23 < 0 ? (-_loc_23) : (_loc_23);
            _loc_30 = _loc_24 < 0 ? (-_loc_24) : (_loc_24);
            _loc_31 = _loc_25 < 0 ? (-_loc_25) : (_loc_25);
            _loc_32 = _loc_26 > _loc_27 ? (1 / _loc_26) : (1 / _loc_27);
            _loc_33 = _loc_28 > _loc_29 ? (1 / _loc_28) : (1 / _loc_29);
            _loc_34 = _loc_30 > _loc_31 ? (1 / _loc_30) : (1 / _loc_31);
            _loc_12 = _loc_12 - (-_loc_20) * _loc_32 * param3;
            _loc_13 = _loc_13 - (-_loc_21) * _loc_32 * param3;
            _loc_14 = _loc_14 - (-_loc_22) * _loc_33 * param3;
            _loc_15 = _loc_15 - (-_loc_23) * _loc_33 * param3;
            _loc_16 = _loc_16 - (-_loc_24) * _loc_34 * param3;
            _loc_17 = _loc_17 - (-_loc_25) * _loc_34 * param3;
            param1.tx = _loc_12;
            param1.ty = _loc_13;
            param1.a = _loc_14 - _loc_12;
            param1.b = _loc_15 - _loc_13;
            param1.c = _loc_16 - _loc_12;
            param1.d = _loc_17 - _loc_13;
            return;
        }// end function

        public function getOutputBitmapFor(param1:Triangle3D) : BitmapData
        {
            var _loc_2:Rectangle;
            var _loc_3:BitmapData;
            var _loc_4:Rectangle;
            if (!triangleBitmaps[param1])
            {
                _loc_2 = getRectFor(param1);
                var _loc_5:* = new BitmapData(Math.ceil(_loc_2.width), Math.ceil(_loc_2.height), false, 0);
                triangleBitmaps[param1] = new BitmapData(Math.ceil(_loc_2.width), Math.ceil(_loc_2.height), false, 0);
                _loc_3 = _loc_5;
                _loc_4 = new Rectangle(0, 0, _loc_3.width, _loc_3.height);
                _loc_3.copyPixels(material.bitmap, _loc_4, origin);
            }
            else
            {
                _loc_2 = getRectFor(param1);
            }// end else if
            if (material.bitmap && _loc_2)
            {
                triangleBitmaps[param1].copyPixels(material.bitmap, _loc_2, origin);
            }// end if
            return triangleBitmaps[param1];
        }// end function

        public function updateBeforeRender() : void
        {
            return;
        }// end function

        public function getPerTriUVForShader(param1:Triangle3D) : Matrix
        {
            var _loc_2:Matrix;
            var _loc_3:Number;
            var _loc_4:Number;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:Number;
            var _loc_10:Number;
            var _loc_11:Rectangle;
            if (!renderTriangleUVS[param1])
            {
                var _loc_12:* = new Matrix();
                renderTriangleUVS[param1] = new Matrix();
                _loc_2 = _loc_12;
                _loc_3 = material.bitmap.width;
                _loc_4 = material.bitmap.height;
                _loc_5 = param1.uv[0].u * _loc_3;
                _loc_6 = (1 - param1.uv[0].v) * _loc_4;
                _loc_7 = param1.uv[1].u * _loc_3;
                _loc_8 = (1 - param1.uv[1].v) * _loc_4;
                _loc_9 = param1.uv[2].u * _loc_3;
                _loc_10 = (1 - param1.uv[2].v) * _loc_4;
                _loc_11 = getRectFor(param1);
                _loc_2.tx = _loc_5 - _loc_11.x;
                _loc_2.ty = _loc_6 - _loc_11.y;
                _loc_2.a = _loc_7 - _loc_5;
                _loc_2.b = _loc_8 - _loc_6;
                _loc_2.c = _loc_9 - _loc_5;
                _loc_2.d = _loc_10 - _loc_6;
            }// end if
            return renderTriangleUVS[param1];
        }// end function

        public function getPerTriUVForDraw(param1:Triangle3D) : Matrix
        {
            var _loc_2:Matrix;
            var _loc_3:Number;
            var _loc_4:Number;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:Number;
            var _loc_10:Number;
            var _loc_11:Rectangle;
            if (!triangleUVS[param1])
            {
                var _loc_12:* = new Matrix();
                triangleUVS[param1] = new Matrix();
                _loc_2 = _loc_12;
                _loc_3 = material.bitmap.width;
                _loc_4 = material.bitmap.height;
                _loc_5 = param1.uv[0].u * _loc_3;
                _loc_6 = (1 - param1.uv[0].v) * _loc_4;
                _loc_7 = param1.uv[1].u * _loc_3;
                _loc_8 = (1 - param1.uv[1].v) * _loc_4;
                _loc_9 = param1.uv[2].u * _loc_3;
                _loc_10 = (1 - param1.uv[2].v) * _loc_4;
                _loc_11 = getRectFor(param1);
                _loc_2.tx = _loc_5 - _loc_11.x;
                _loc_2.ty = _loc_6 - _loc_11.y;
                _loc_2.a = _loc_7 - _loc_5;
                _loc_2.b = _loc_8 - _loc_6;
                _loc_2.c = _loc_9 - _loc_5;
                _loc_2.d = _loc_10 - _loc_6;
                _loc_2.invert();
            }// end if
            return triangleUVS[param1];
        }// end function

        public function getUVMatrixForTriangle(param1:Triangle3D, param2:Boolean = false) : Matrix
        {
            var _loc_3:Matrix;
            var _loc_4:Number;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:Number;
            var _loc_10:Number;
            var _loc_11:Number;
            var _loc_12:* = uvMatrices[param1];
            _loc_3 = uvMatrices[param1];
            if (!_loc_12)
            {
                _loc_3 = new Matrix();
                if (param2)
                {
                    perturbUVMatrix(_loc_3, param1, 2);
                }
                else if (material.bitmap)
                {
                    _loc_4 = material.bitmap.width;
                    _loc_5 = material.bitmap.height;
                    _loc_6 = param1.uv[0].u * _loc_4;
                    _loc_7 = (1 - param1.uv[0].v) * _loc_5;
                    _loc_8 = param1.uv[1].u * _loc_4;
                    _loc_9 = (1 - param1.uv[1].v) * _loc_5;
                    _loc_10 = param1.uv[2].u * _loc_4;
                    _loc_11 = (1 - param1.uv[2].v) * _loc_5;
                    _loc_3.tx = _loc_6;
                    _loc_3.ty = _loc_7;
                    _loc_3.a = _loc_8 - _loc_6;
                    _loc_3.b = _loc_9 - _loc_7;
                    _loc_3.c = _loc_10 - _loc_6;
                    _loc_3.d = _loc_11 - _loc_7;
                }// end else if
                if (material.bitmap)
                {
                    uvMatrices[param1] = _loc_3;
                }// end if
            }// end if
            return _loc_3;
        }// end function

        public function destroy() : void
        {
            var _loc_1:Object;
            for each (_loc_1 in uvMatrices)
            {
                // label
                uvMatrices[_loc_1] = null;
            }// end of for each ... in
            uvMatrices = null;
            shaderRenderer.destroy();
            shaderRenderer = null;
            lightMatrices = null;
            return;
        }// end function

    }
}
