﻿package org.papervision3d.core.render.shader
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.utils.*;
    import org.papervision3d.core.render.data.*;
    import org.papervision3d.materials.shaders.*;

    public class ShaderRenderer extends EventDispatcher implements IShaderRenderer
    {
        public var container:Sprite;
        public var outputBitmap:BitmapData;
        public var bitmapContainer:Bitmap;
        public var shadeLayers:Dictionary;
        public var bitmapLayer:Sprite;
        private var _inputBitmapData:BitmapData;
        public var resizedInput:Boolean = false;

        public function ShaderRenderer()
        {
            resizedInput = false;
            container = new Sprite();
            bitmapLayer = new Sprite();
            bitmapContainer = new Bitmap();
            bitmapLayer.addChild(bitmapContainer);
            bitmapLayer.blendMode = BlendMode.NORMAL;
            shadeLayers = new Dictionary();
            container.addChild(bitmapLayer);
            return;
        }// end function

        public function destroy() : void
        {
            bitmapLayer = null;
            outputBitmap.dispose();
            return;
        }// end function

        public function getLayerForShader(param1:Shader) : Sprite
        {
            var _loc_2:Sprite;
            var _loc_3:Sprite;
            _loc_2 = new Sprite();
            shadeLayers[param1] = _loc_2;
            _loc_3 = new Sprite();
            _loc_2.addChild(_loc_3);
            if (inputBitmap != null)
            {
                _loc_3.graphics.beginFill(0, 0);
                _loc_3.graphics.drawRect(0, 0, inputBitmap.width, inputBitmap.height);
                _loc_3.graphics.endFill();
            }// end if
            container.addChild(_loc_2);
            _loc_2.blendMode = param1.layerBlendMode;
            return _loc_2;
        }// end function

        public function get inputBitmap() : BitmapData
        {
            return _inputBitmapData;
        }// end function

        public function clear() : void
        {
            var _loc_1:Sprite;
            for each (_loc_1 in shadeLayers)
            {
                // label
                if (inputBitmap && inputBitmap.width > 0 && inputBitmap.height > 0)
                {
                    _loc_1.graphics.clear();
                    _loc_1.graphics.beginFill(0, 1);
                    _loc_1.graphics.drawRect(0, 0, inputBitmap.width, inputBitmap.height);
                    _loc_1.graphics.endFill();
                }// end if
            }// end of for each ... in
            return;
        }// end function

        public function render(param1:RenderSessionData) : void
        {
            if (outputBitmap)
            {
                outputBitmap.fillRect(outputBitmap.rect, 0);
                bitmapContainer.bitmapData = inputBitmap;
                outputBitmap.draw(container, null, null, null, outputBitmap.rect, false);
                if (outputBitmap.transparent)
                {
                    outputBitmap.copyChannel(inputBitmap, outputBitmap.rect, new Point(0, 0), BitmapDataChannel.ALPHA, BitmapDataChannel.ALPHA);
                }// end if
            }// end if
            return;
        }// end function

        public function set inputBitmap(param1:BitmapData) : void
        {
            if (param1 != null)
            {
                if (_inputBitmapData != param1)
                {
                    _inputBitmapData = param1;
                    if (outputBitmap)
                    {
                        if (_inputBitmapData.width != outputBitmap.width || _inputBitmapData.height != outputBitmap.height)
                        {
                            resizedInput = true;
                            outputBitmap.dispose();
                            outputBitmap = _inputBitmapData.clone();
                        }// end if
                    }
                    else
                    {
                        resizedInput = true;
                        outputBitmap = _inputBitmapData.clone();
                    }// end if
                }// end if
            }// end else if
            return;
        }// end function

    }
}
