﻿package org.papervision3d.core.utils
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import org.papervision3d.core.geom.renderables.*;
    import org.papervision3d.core.proto.*;
    import org.papervision3d.core.render.data.*;
    import org.papervision3d.core.utils.virtualmouse.*;
    import org.papervision3d.events.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.view.*;

    public class InteractiveSceneManager extends EventDispatcher
    {
        public var container:Sprite;
        public var currentMousePos:Point;
        public var currentDisplayObject3D:DisplayObject3D;
        public var lastMousePos:Point;
        public var viewport:Viewport3D;
        public var currentMaterial:MaterialObject3D;
        public var debug:Boolean = false;
        public var mouse3D:Mouse3D;
        public var enableOverOut:Boolean = true;
        public var virtualMouse:VirtualMouse;
        public var _viewportRendered:Boolean = false;
        public var renderHitData:RenderHitData;
        public var currentMouseDO3D:DisplayObject3D = null;
        public static var MOUSE_IS_DOWN:Boolean = false;

        public function InteractiveSceneManager(param1:Viewport3D)
        {
            virtualMouse = new VirtualMouse();
            mouse3D = new Mouse3D();
            enableOverOut = true;
            currentMouseDO3D = null;
            debug = false;
            currentMousePos = new Point();
            lastMousePos = new Point();
            _viewportRendered = false;
            this.viewport = param1;
            this.container = param1.containerSprite;
            init();
            return;
        }// end function

        public function updateAfterRender() : void
        {
            _viewportRendered = true;
            return;
        }// end function

        protected function initVirtualMouse() : void
        {
            virtualMouse.stage = container.stage;
            virtualMouse.container = container;
            return;
        }// end function

        public function initListeners() : void
        {
            if (viewport.interactive)
            {
                container.addEventListener(MouseEvent.MOUSE_DOWN, handleMousePress, false, 0, true);
                container.addEventListener(MouseEvent.MOUSE_UP, handleMouseRelease, false, 0, true);
                container.addEventListener(MouseEvent.CLICK, handleMouseClick, false, 0, true);
                container.addEventListener(MouseEvent.DOUBLE_CLICK, handleMouseDoubleClick, false, 0, true);
                container.stage.addEventListener(Event.ENTER_FRAME, handleEnterFrame, false, 0, true);
            }// end if
            return;
        }// end function

        protected function handleMouseDoubleClick(param1:MouseEvent) : void
        {
            if (param1 is IVirtualMouseEvent)
            {
                return;
            }// end if
            if (renderHitData && renderHitData.hasHit)
            {
                dispatchObjectEvent(InteractiveScene3DEvent.OBJECT_DOUBLE_CLICK, currentDisplayObject3D);
            }// end if
            return;
        }// end function

        public function updateRenderHitData() : void
        {
            resolveRenderHitData();
            currentDisplayObject3D = renderHitData.displayObject3D;
            currentMaterial = renderHitData.material;
            manageOverOut();
            return;
        }// end function

        public function init() : void
        {
            if (container)
            {
                if (container.stage)
                {
                    initVirtualMouse();
                    initListeners();
                }
                else
                {
                    container.addEventListener(Event.ADDED_TO_STAGE, handleAddedToStage, false, 0, true);
                }// end if
            }// end else if
            return;
        }// end function

        protected function handleMouseClick(param1:MouseEvent) : void
        {
            if (param1 is IVirtualMouseEvent)
            {
                return;
            }// end if
            if (renderHitData && renderHitData.hasHit)
            {
                dispatchObjectEvent(InteractiveScene3DEvent.OBJECT_CLICK, currentDisplayObject3D);
            }// end if
            return;
        }// end function

        protected function handleMouseOut(param1:DisplayObject3D) : void
        {
            var _loc_2:MovieMaterial;
            if (!hasMouseMoved())
            {
                return;
            }// end if
            if (param1)
            {
                _loc_2 = param1.material as MovieMaterial;
                if (_loc_2)
                {
                    virtualMouse.exitContainer();
                }// end if
            }// end if
            dispatchObjectEvent(InteractiveScene3DEvent.OBJECT_OUT, param1);
            return;
        }// end function

        protected function manageOverOut() : void
        {
            if (!enableOverOut)
            {
                return;
            }// end if
            if (renderHitData && renderHitData.hasHit)
            {
                if (!currentMouseDO3D && currentDisplayObject3D)
                {
                    handleMouseOver(currentDisplayObject3D);
                    currentMouseDO3D = currentDisplayObject3D;
                }
                else if (currentMouseDO3D && currentMouseDO3D != currentDisplayObject3D)
                {
                    handleMouseOut(currentMouseDO3D);
                    handleMouseOver(currentDisplayObject3D);
                    currentMouseDO3D = currentDisplayObject3D;
                }// end else if
            }
            else if (currentMouseDO3D != null)
            {
                handleMouseOut(currentMouseDO3D);
                currentMouseDO3D = null;
            }// end else if
            return;
        }// end function

        protected function handleEnterFrame(param1:Event) : void
        {
            var _loc_2:Boolean;
            var _loc_3:MovieMaterial;
            _loc_2 = hasMouseMoved();
            if (_loc_2 || _viewportRendered)
            {
                updateRenderHitData();
                _viewportRendered = false;
                if (param1 is IVirtualMouseEvent)
                {
                    return;
                }// end if
                if (virtualMouse && renderHitData)
                {
                    _loc_3 = currentMaterial as MovieMaterial;
                    if (_loc_3)
                    {
                        virtualMouse.container = _loc_3.movie as Sprite;
                    }// end if
                    if (virtualMouse.container)
                    {
                        virtualMouse.setLocation(renderHitData.u, renderHitData.v);
                    }// end if
                    if (Mouse3D.enabled && renderHitData && renderHitData.hasHit)
                    {
                        mouse3D.updatePosition(renderHitData);
                    }// end if
                    dispatchObjectEvent(InteractiveScene3DEvent.OBJECT_MOVE, currentDisplayObject3D);
                }
                else if (renderHitData && renderHitData.hasHit)
                {
                    dispatchObjectEvent(InteractiveScene3DEvent.OBJECT_MOVE, currentDisplayObject3D);
                }// end if
            }// end else if
            lastMousePos.x = currentMousePos.x;
            lastMousePos.y = currentMousePos.y;
            return;
        }// end function

        protected function dispatchObjectEvent(param1:String, param2:DisplayObject3D) : void
        {
            var _loc_3:Number;
            var _loc_4:Number;
            var _loc_5:InteractiveScene3DEvent;
            if (renderHitData && renderHitData.hasHit)
            {
                _loc_3 = renderHitData.u ? (renderHitData.u) : (0);
                _loc_4 = renderHitData.v ? (renderHitData.v) : (0);
                _loc_5 = new InteractiveScene3DEvent(param1, param2, container, renderHitData.renderable as Triangle3D, _loc_3, _loc_4, renderHitData);
                _loc_5.renderHitData = renderHitData;
                dispatchEvent(_loc_5);
                param2.dispatchEvent(_loc_5);
            }
            else
            {
                dispatchEvent(new InteractiveScene3DEvent(param1, param2, container));
                if (param2)
                {
                    param2.dispatchEvent(new InteractiveScene3DEvent(param1, param2, container));
                }// end if
            }// end else if
            return;
        }// end function

        protected function hasMouseMoved() : Boolean
        {
            currentMousePos.x = container.mouseX;
            currentMousePos.y = container.mouseY;
            return !currentMousePos.equals(lastMousePos);
        }// end function

        protected function handleMouseOver(param1:DisplayObject3D) : void
        {
            if (hasMouseMoved())
            {
                dispatchObjectEvent(InteractiveScene3DEvent.OBJECT_OVER, param1);
            }// end if
            return;
        }// end function

        protected function resolveRenderHitData() : void
        {
            renderHitData = viewport.hitTestPoint2D(currentMousePos) as RenderHitData;
            return;
        }// end function

        protected function handleMousePress(param1:MouseEvent) : void
        {
            if (param1 is IVirtualMouseEvent)
            {
                return;
            }// end if
            MOUSE_IS_DOWN = true;
            if (virtualMouse)
            {
                virtualMouse.press();
            }// end if
            if (Mouse3D.enabled && renderHitData && renderHitData.renderable != null)
            {
                mouse3D.updatePosition(renderHitData);
            }// end if
            if (renderHitData && renderHitData.hasHit)
            {
                dispatchObjectEvent(InteractiveScene3DEvent.OBJECT_PRESS, currentDisplayObject3D);
            }// end if
            return;
        }// end function

        protected function handleMouseRelease(param1:MouseEvent) : void
        {
            if (param1 is IVirtualMouseEvent)
            {
                return;
            }// end if
            MOUSE_IS_DOWN = false;
            if (virtualMouse)
            {
                virtualMouse.release();
            }// end if
            if (Mouse3D.enabled && renderHitData && renderHitData.renderable != null)
            {
                mouse3D.updatePosition(renderHitData);
            }// end if
            if (renderHitData && renderHitData.hasHit)
            {
                dispatchObjectEvent(InteractiveScene3DEvent.OBJECT_RELEASE, currentDisplayObject3D);
            }// end if
            return;
        }// end function

        protected function handleAddedToStage(param1:Event) : void
        {
            container.removeEventListener(Event.ADDED_TO_STAGE, handleAddedToStage);
            initVirtualMouse();
            initListeners();
            return;
        }// end function

        public function destroy() : void
        {
            viewport = null;
            renderHitData = null;
            currentDisplayObject3D = null;
            currentMaterial = null;
            currentMouseDO3D = null;
            virtualMouse.stage = null;
            virtualMouse.container = null;
            container.removeEventListener(MouseEvent.MOUSE_DOWN, handleMousePress);
            container.removeEventListener(MouseEvent.MOUSE_UP, handleMouseRelease);
            container.removeEventListener(MouseEvent.CLICK, handleMouseClick);
            container.removeEventListener(MouseEvent.DOUBLE_CLICK, handleMouseDoubleClick);
            if (container.stage)
            {
                container.stage.removeEventListener(Event.ENTER_FRAME, handleEnterFrame);
            }// end if
            container = null;
            return;
        }// end function

    }
}
