﻿package org.papervision3d.core.utils.virtualmouse
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.utils.*;
    import org.papervision3d.core.log.*;

    public class VirtualMouse extends EventDispatcher
    {
        private var _container:Sprite;
        private var lastDownTarget:DisplayObject;
        private var target:InteractiveObject;
        private var updateMouseDown:Boolean = false;
        private var eventEvent:Class;
        private var _lastEvent:Event;
        private var mouseEventEvent:Class;
        private var location:Point;
        private var delta:int = 0;
        private var disabledEvents:Object;
        private var ignoredInstances:Dictionary;
        private var isLocked:Boolean = false;
        private var lastWithinStage:Boolean = true;
        private var lastLocation:Point;
        private var isDoubleClickEvent:Boolean = false;
        private var lastMouseDown:Boolean = false;
        private var altKey:Boolean = false;
        private var _useNativeEvents:Boolean = false;
        private var ctrlKey:Boolean = false;
        private var shiftKey:Boolean = false;
        private var _stage:Stage;
        public static const UPDATE:String = "update";
        private static var _mouseIsDown:Boolean = false;

        public function VirtualMouse(param1:Stage = null, param2:Sprite = null, param3:Number = 0, param4:Number = 0)
        {
            altKey = false;
            ctrlKey = false;
            shiftKey = false;
            delta = 0;
            isLocked = false;
            isDoubleClickEvent = false;
            disabledEvents = new Object();
            ignoredInstances = new Dictionary(true);
            lastMouseDown = false;
            updateMouseDown = false;
            lastWithinStage = true;
            _useNativeEvents = false;
            eventEvent = VirtualMouseEvent;
            mouseEventEvent = VirtualMouseMouseEvent;
            this.stage = param1;
            this.container = param2;
            location = new Point(param3, param4);
            lastLocation = location.clone();
            addEventListener(UPDATE, handleUpdate);
            update();
            return;
        }// end function

        public function get mouseIsDown() : Boolean
        {
            return _mouseIsDown;
        }// end function

        public function get stage() : Stage
        {
            return _stage;
        }// end function

        public function get container() : Sprite
        {
            return _container;
        }// end function

        public function exitContainer() : void
        {
            var _loc_1:Point;
            if (!container)
            {
                return;
            }// end if
            _loc_1 = target.globalToLocal(location);
            if (!disabledEvents[MouseEvent.MOUSE_OUT])
            {
                _lastEvent = new mouseEventEvent(MouseEvent.MOUSE_OUT, true, false, _loc_1.x, _loc_1.y, container, ctrlKey, altKey, shiftKey, _mouseIsDown, delta);
                container.dispatchEvent(new mouseEventEvent(MouseEvent.MOUSE_OUT, true, false, _loc_1.x, _loc_1.y, container, ctrlKey, altKey, shiftKey, _mouseIsDown, delta));
                dispatchEvent(new mouseEventEvent(MouseEvent.MOUSE_OUT, true, false, _loc_1.x, _loc_1.y, container, ctrlKey, altKey, shiftKey, _mouseIsDown, delta));
            }// end if
            if (!disabledEvents[MouseEvent.ROLL_OUT])
            {
                _lastEvent = new mouseEventEvent(MouseEvent.ROLL_OUT, false, false, _loc_1.x, _loc_1.y, container, ctrlKey, altKey, shiftKey, _mouseIsDown, delta);
                container.dispatchEvent(new mouseEventEvent(MouseEvent.ROLL_OUT, false, false, _loc_1.x, _loc_1.y, container, ctrlKey, altKey, shiftKey, _mouseIsDown, delta));
                dispatchEvent(new mouseEventEvent(MouseEvent.ROLL_OUT, false, false, _loc_1.x, _loc_1.y, container, ctrlKey, altKey, shiftKey, _mouseIsDown, delta));
            }// end if
            if (target != container)
            {
                if (!disabledEvents[MouseEvent.MOUSE_OUT])
                {
                    _lastEvent = new mouseEventEvent(MouseEvent.MOUSE_OUT, true, false, _loc_1.x, _loc_1.y, container, ctrlKey, altKey, shiftKey, _mouseIsDown, delta);
                    target.dispatchEvent(new mouseEventEvent(MouseEvent.MOUSE_OUT, true, false, _loc_1.x, _loc_1.y, container, ctrlKey, altKey, shiftKey, _mouseIsDown, delta));
                    dispatchEvent(new mouseEventEvent(MouseEvent.MOUSE_OUT, true, false, _loc_1.x, _loc_1.y, container, ctrlKey, altKey, shiftKey, _mouseIsDown, delta));
                }// end if
                if (!disabledEvents[MouseEvent.ROLL_OUT])
                {
                    _lastEvent = new mouseEventEvent(MouseEvent.ROLL_OUT, false, false, _loc_1.x, _loc_1.y, container, ctrlKey, altKey, shiftKey, _mouseIsDown, delta);
                    target.dispatchEvent(new mouseEventEvent(MouseEvent.ROLL_OUT, false, false, _loc_1.x, _loc_1.y, container, ctrlKey, altKey, shiftKey, _mouseIsDown, delta));
                    dispatchEvent(new mouseEventEvent(MouseEvent.ROLL_OUT, false, false, _loc_1.x, _loc_1.y, container, ctrlKey, altKey, shiftKey, _mouseIsDown, delta));
                }// end if
            }// end if
            target = _stage;
            return;
        }// end function

        public function release() : void
        {
            updateMouseDown = true;
            _mouseIsDown = false;
            if (!isLocked)
            {
                update();
            }// end if
            return;
        }// end function

        public function click() : void
        {
            press();
            release();
            return;
        }// end function

        public function disableEvent(param1:String) : void
        {
            disabledEvents[param1] = true;
            return;
        }// end function

        public function set container(param1:Sprite) : void
        {
            _container = param1;
            return;
        }// end function

        public function get y() : Number
        {
            return location.y;
        }// end function

        public function set x(param1:Number) : void
        {
            location.x = param1;
            if (!isLocked)
            {
                update();
            }// end if
            return;
        }// end function

        public function get lastEvent() : Event
        {
            return _lastEvent;
        }// end function

        private function handleUpdate(param1:Event) : void
        {
            var _loc_2:Point;
            var _loc_3:Array;
            var _loc_4:InteractiveObject;
            var _loc_5:DisplayObject;
            var _loc_6:int;
            var _loc_7:Point;
            var _loc_8:Point;
            var _loc_9:Boolean;
            if (!container)
            {
                return;
            }// end if
            if (container.scrollRect)
            {
                PaperLogger.warning("The container that virtualMouse is trying to test against has a scrollRect defined, and may cause an issue with finding objects under a defined point.  Use MovieMaterial.rect to set a rectangle area instead");
            }// end if
            _loc_2 = new Point();
            _loc_2.x = container.x;
            _loc_2.y = container.y;
            var _loc_10:int;
            container.y = 0;
            container.x = _loc_10;
            var _loc_10:* = container.getObjectsUnderPoint(location);
            _loc_3 = container.getObjectsUnderPoint(location);
            _loc_3 = _loc_10;
            container.x = _loc_2.x;
            container.y = _loc_2.y;
            _loc_6 = _loc_3.length;
            while (_loc_6--)
            {
                // label
                _loc_5 = _loc_3[_loc_6];
                while (_loc_5)
                {
                    // label
                    if (ignoredInstances[_loc_5])
                    {
                        _loc_4 = null;
                        break;
                    }// end if
                    if (_loc_4 && _loc_5 is SimpleButton)
                    {
                        _loc_4 = null;
                    }
                    else if (_loc_4 && !DisplayObjectContainer(_loc_5).mouseChildren)
                    {
                        _loc_4 = null;
                    }// end else if
                    if (!_loc_4 && _loc_5 is InteractiveObject && InteractiveObject(_loc_5).mouseEnabled)
                    {
                        _loc_4 = InteractiveObject(_loc_5);
                    }// end if
                    _loc_5 = _loc_5.parent;
                }// end while
                if (_loc_4)
                {
                    break;
                }// end if
            }// end while
            if (!_loc_4)
            {
                _loc_4 = container;
            }// end if
            _loc_7 = target.globalToLocal(location);
            _loc_8 = _loc_4.globalToLocal(location);
            if (lastLocation.x != location.x || lastLocation.y != location.y)
            {
                _loc_9 = false;
                if (stage)
                {
                    if (location.x >= 0 && location.y >= 0 && location.x <= stage.stageWidth)
                    {
                    }// end if
                    _loc_9 = location.y <= stage.stageHeight;
                }// end if
                if (!_loc_9 && lastWithinStage && !disabledEvents[Event.MOUSE_LEAVE])
                {
                    _lastEvent = new eventEvent(Event.MOUSE_LEAVE, false, false);
                    stage.dispatchEvent(_lastEvent);
                    dispatchEvent(_lastEvent);
                }// end if
                if (_loc_9 && !disabledEvents[MouseEvent.MOUSE_MOVE])
                {
                    _lastEvent = new mouseEventEvent(MouseEvent.MOUSE_MOVE, true, false, _loc_8.x, _loc_8.y, _loc_4, ctrlKey, altKey, shiftKey, _mouseIsDown, delta);
                    _loc_4.dispatchEvent(_lastEvent);
                    dispatchEvent(_lastEvent);
                }// end if
                lastWithinStage = _loc_9;
            }// end if
            if (_loc_4 != target)
            {
                if (!disabledEvents[MouseEvent.MOUSE_OUT])
                {
                    _lastEvent = new mouseEventEvent(MouseEvent.MOUSE_OUT, true, false, _loc_7.x, _loc_7.y, _loc_4, ctrlKey, altKey, shiftKey, _mouseIsDown, delta);
                    target.dispatchEvent(_lastEvent);
                    dispatchEvent(_lastEvent);
                }// end if
                if (!disabledEvents[MouseEvent.ROLL_OUT])
                {
                    _lastEvent = new mouseEventEvent(MouseEvent.ROLL_OUT, false, false, _loc_7.x, _loc_7.y, _loc_4, ctrlKey, altKey, shiftKey, _mouseIsDown, delta);
                    target.dispatchEvent(_lastEvent);
                    dispatchEvent(_lastEvent);
                }// end if
                if (!disabledEvents[MouseEvent.MOUSE_OVER])
                {
                    _lastEvent = new mouseEventEvent(MouseEvent.MOUSE_OVER, true, false, _loc_8.x, _loc_8.y, target, ctrlKey, altKey, shiftKey, _mouseIsDown, delta);
                    _loc_4.dispatchEvent(_lastEvent);
                    dispatchEvent(_lastEvent);
                }// end if
                if (!disabledEvents[MouseEvent.ROLL_OVER])
                {
                    _lastEvent = new mouseEventEvent(MouseEvent.ROLL_OVER, false, false, _loc_8.x, _loc_8.y, target, ctrlKey, altKey, shiftKey, _mouseIsDown, delta);
                    _loc_4.dispatchEvent(_lastEvent);
                    dispatchEvent(_lastEvent);
                }// end if
            }// end if
            if (updateMouseDown)
            {
                if (_mouseIsDown)
                {
                    if (!disabledEvents[MouseEvent.MOUSE_DOWN])
                    {
                        _lastEvent = new mouseEventEvent(MouseEvent.MOUSE_DOWN, true, false, _loc_8.x, _loc_8.y, _loc_4, ctrlKey, altKey, shiftKey, _mouseIsDown, delta);
                        _loc_4.dispatchEvent(_lastEvent);
                        dispatchEvent(_lastEvent);
                    }// end if
                    lastDownTarget = _loc_4;
                    updateMouseDown = false;
                }
                else
                {
                    if (!disabledEvents[MouseEvent.MOUSE_UP])
                    {
                        _lastEvent = new mouseEventEvent(MouseEvent.MOUSE_UP, true, false, _loc_8.x, _loc_8.y, _loc_4, ctrlKey, altKey, shiftKey, _mouseIsDown, delta);
                        _loc_4.dispatchEvent(_lastEvent);
                        dispatchEvent(_lastEvent);
                    }// end if
                    if (!disabledEvents[MouseEvent.CLICK] && _loc_4 == lastDownTarget)
                    {
                        _lastEvent = new mouseEventEvent(MouseEvent.CLICK, true, false, _loc_8.x, _loc_8.y, _loc_4, ctrlKey, altKey, shiftKey, _mouseIsDown, delta);
                        _loc_4.dispatchEvent(_lastEvent);
                        dispatchEvent(_lastEvent);
                    }// end if
                    lastDownTarget = null;
                    updateMouseDown = false;
                }// end if
            }// end else if
            if (isDoubleClickEvent && !disabledEvents[MouseEvent.DOUBLE_CLICK] && _loc_4.doubleClickEnabled)
            {
                _lastEvent = new mouseEventEvent(MouseEvent.DOUBLE_CLICK, true, false, _loc_8.x, _loc_8.y, _loc_4, ctrlKey, altKey, shiftKey, _mouseIsDown, delta);
                _loc_4.dispatchEvent(_lastEvent);
                dispatchEvent(_lastEvent);
            }// end if
            lastLocation = location.clone();
            lastMouseDown = _mouseIsDown;
            target = _loc_4;
            return;
        }// end function

        public function getLocation() : Point
        {
            return location.clone();
        }// end function

        public function get x() : Number
        {
            return location.x;
        }// end function

        public function lock() : void
        {
            isLocked = true;
            return;
        }// end function

        public function get useNativeEvents() : Boolean
        {
            return _useNativeEvents;
        }// end function

        public function setLocation(param1, param2 = null) : void
        {
            var _loc_3:Point;
            if (param1 is Point)
            {
                _loc_3 = param1 as Point;
                location.x = _loc_3.x;
                location.y = _loc_3.y;
            }
            else
            {
                location.x = Number(param1);
                location.y = Number(param2);
            }// end else if
            if (!isLocked)
            {
                update();
            }// end if
            return;
        }// end function

        private function keyHandler(param1:KeyboardEvent) : void
        {
            altKey = param1.altKey;
            ctrlKey = param1.ctrlKey;
            shiftKey = param1.shiftKey;
            return;
        }// end function

        public function unignore(param1:DisplayObject) : void
        {
            if (param1 in ignoredInstances)
            {
                delete ignoredInstances[param1];
            }// end if
            return;
        }// end function

        public function doubleClick() : void
        {
            if (isLocked)
            {
                release();
            }
            else
            {
                click();
                press();
                isDoubleClickEvent = true;
                release();
                isDoubleClickEvent = false;
            }// end else if
            return;
        }// end function

        public function update() : void
        {
            dispatchEvent(new Event(UPDATE, false, false));
            return;
        }// end function

        public function unlock() : void
        {
            isLocked = false;
            update();
            return;
        }// end function

        public function ignore(param1:DisplayObject) : void
        {
            ignoredInstances[param1] = true;
            return;
        }// end function

        public function enableEvent(param1:String) : void
        {
            if (param1 in disabledEvents)
            {
                delete disabledEvents[param1];
            }// end if
            return;
        }// end function

        public function press() : void
        {
            updateMouseDown = true;
            _mouseIsDown = true;
            if (!isLocked)
            {
                update();
            }// end if
            return;
        }// end function

        public function set useNativeEvents(param1:Boolean) : void
        {
            if (param1 == _useNativeEvents)
            {
                return;
            }// end if
            _useNativeEvents = param1;
            if (_useNativeEvents)
            {
                eventEvent = VirtualMouseEvent;
                mouseEventEvent = VirtualMouseMouseEvent;
            }
            else
            {
                eventEvent = Event;
                mouseEventEvent = MouseEvent;
            }// end else if
            return;
        }// end function

        public function set y(param1:Number) : void
        {
            location.y = param1;
            if (!isLocked)
            {
                update();
            }// end if
            return;
        }// end function

        public function set stage(param1:Stage) : void
        {
            var _loc_2:Boolean;
            if (_stage)
            {
                _loc_2 = true;
                _stage.removeEventListener(KeyboardEvent.KEY_DOWN, keyHandler);
                _stage.removeEventListener(KeyboardEvent.KEY_UP, keyHandler);
            }
            else
            {
                _loc_2 = false;
            }// end else if
            _stage = param1;
            if (_stage)
            {
                _stage.addEventListener(KeyboardEvent.KEY_DOWN, keyHandler);
                _stage.addEventListener(KeyboardEvent.KEY_UP, keyHandler);
                target = _stage;
                if (true)
                {
                    update();
                }// end if
            }// end if
            return;
        }// end function

    }
}
