﻿package org.papervision3d.materials
{
    import flash.display.*;
    import flash.geom.*;
    import flash.utils.*;
    import org.papervision3d.*;
    import org.papervision3d.core.geom.renderables.*;
    import org.papervision3d.core.log.*;
    import org.papervision3d.core.material.*;
    import org.papervision3d.core.proto.*;
    import org.papervision3d.core.render.command.*;
    import org.papervision3d.core.render.data.*;
    import org.papervision3d.materials.utils.*;

    public class BitmapMaterial extends TriangleMaterial implements ITriangleDrawer
    {
        protected var renderRecStorage:Array;
        private var b2:Number;
        private var c2:Number;
        protected var ax:Number;
        protected var az:Number;
        protected var ay:Number;
        protected var tempPreGrp:Graphics;
        protected var mcay:Number;
        protected var mcaz:Number;
        private var d2:Number;
        protected var bx:Number;
        protected var by:Number;
        protected var bz:Number;
        protected var mcax:Number;
        protected var cx:Number;
        protected var cy:Number;
        protected var cz:Number;
        protected var cullRect:Rectangle;
        protected var dmax:Number;
        private var dx:Number;
        private var dy:Number;
        protected var _perPixelPrecision:int = 8;
        private var x0:Number;
        private var x1:Number;
        private var x2:Number;
        protected var mbcy:Number;
        protected var mbcz:Number;
        protected var mbcx:Number;
        protected var tempPreBmp:BitmapData;
        private var y0:Number;
        private var y1:Number;
        private var y2:Number;
        protected var tempTriangleMatrix:Matrix;
        protected var focus:Number = 200;
        protected var mabz:Number;
        private var d2ab:Number;
        protected var dsab:Number;
        protected var mabx:Number;
        protected var maby:Number;
        protected var dcax:Number;
        protected var dcay:Number;
        protected var _precision:int = 8;
        protected var dsbc:Number;
        protected var _precise:Boolean;
        private var d2bc:Number;
        protected var faz:Number;
        public var uvMatrices:Dictionary;
        protected var dsca:Number;
        private var d2ca:Number;
        protected var fbz:Number;
        public var precisionMode:int;
        protected var fcz:Number;
        public var minimumRenderSize:Number = 4;
        protected var dbcx:Number;
        protected var dbcy:Number;
        protected var dabx:Number;
        protected var daby:Number;
        protected var tempPreRSD:RenderSessionData;
        protected var _texture:Object;
        private var a2:Number;
        static const DEFAULT_FOCUS:Number = 200;
        static var _triMatrix:Matrix = new Matrix();
        static var _triMap:Matrix;
        public static var AUTO_MIP_MAPPING:Boolean = false;
        public static var MIP_MAP_DEPTH:Number = 8;
        static var hitRect:Rectangle = new Rectangle();
        static var _localMatrix:Matrix = new Matrix();

        public function BitmapMaterial(param1:BitmapData = null, param2:Boolean = false)
        {
            focus = 200;
            _precision = 8;
            _perPixelPrecision = 8;
            minimumRenderSize = 4;
            precisionMode = PrecisionMode.ORIGINAL;
            uvMatrices = new Dictionary();
            tempTriangleMatrix = new Matrix();
            if (param1)
            {
                texture = param1;
            }// end if
            this.precise = param2;
            createRenderRecStorage();
            return;
        }// end function

        public function transformUVRT(param1:RenderTriangle) : Matrix
        {
            var _loc_2:Number;
            var _loc_3:Number;
            var _loc_4:Number;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:Number;
            var _loc_10:Number;
            var _loc_11:Number;
            var _loc_12:Number;
            var _loc_13:Number;
            var _loc_14:Matrix;
            var _loc_15:Matrix;
            if (bitmap)
            {
                _loc_2 = bitmap.width * maxU;
                _loc_3 = bitmap.height * maxV;
                _loc_4 = _loc_2 * param1.uv0.u;
                _loc_5 = _loc_3 * (1 - param1.uv0.v);
                _loc_6 = _loc_2 * param1.uv1.u;
                _loc_7 = _loc_3 * (1 - param1.uv1.v);
                _loc_8 = _loc_2 * param1.uv2.u;
                _loc_9 = _loc_3 * (1 - param1.uv2.v);
                if (_loc_4 == _loc_6 && _loc_5 == _loc_7 || _loc_4 == _loc_8 && _loc_5 == _loc_9)
                {
                    _loc_4 = _loc_4 - (_loc_4 > 0.05 ? (0.05) : (-0.05));
                    _loc_5 = _loc_5 - (_loc_5 > 0.07 ? (0.07) : (-0.07));
                }// end if
                if (_loc_8 == _loc_6 && _loc_9 == _loc_7)
                {
                    _loc_8 = _loc_8 - (_loc_8 > 0.05 ? (0.04) : (-0.04));
                    _loc_9 = _loc_9 - (_loc_9 > 0.06 ? (0.06) : (-0.06));
                }// end if
                _loc_10 = _loc_6 - _loc_4;
                _loc_11 = _loc_7 - _loc_5;
                _loc_12 = _loc_8 - _loc_4;
                _loc_13 = _loc_9 - _loc_5;
                _loc_14 = new Matrix(_loc_10, _loc_11, _loc_12, _loc_13, _loc_4, _loc_5);
                if (Papervision3D.useRIGHTHANDED)
                {
                    _loc_14.scale(-1, 1);
                    _loc_14.translate(_loc_2, 0);
                }// end if
                _loc_14.invert();
                var _loc_16:* = _loc_14.clone();
                uvMatrices[param1] = _loc_14.clone();
                _loc_15 = _loc_16;
                _loc_15.a = _loc_14.a;
                _loc_15.b = _loc_14.b;
                _loc_15.c = _loc_14.c;
                _loc_15.d = _loc_14.d;
                _loc_15.tx = _loc_14.tx;
                _loc_15.ty = _loc_14.ty;
            }
            else
            {
                PaperLogger.error("MaterialObject3D: transformUV() material.bitmap not found!");
            }// end else if
            return _loc_15;
        }// end function

        public function resetUVS() : void
        {
            uvMatrices = new Dictionary(false);
            return;
        }// end function

        protected function correctBitmap(param1:BitmapData) : BitmapData
        {
            var _loc_2:BitmapData;
            var _loc_3:Number;
            var _loc_4:Number;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Boolean;
            _loc_3 = 1 << MIP_MAP_DEPTH;
            _loc_4 = param1.width / _loc_3;
            _loc_4 = _loc_4 == uint(_loc_4) ? (_loc_4) : (uint(_loc_4) + 1);
            _loc_5 = param1.height / _loc_3;
            _loc_5 = _loc_5 == uint(_loc_5) ? (_loc_5) : (uint(_loc_5) + 1);
            _loc_6 = _loc_3 * _loc_4;
            _loc_7 = _loc_3 * _loc_5;
            _loc_8 = true;
            if (_loc_6 > 2880)
            {
                _loc_6 = param1.width;
                _loc_8 = false;
            }// end if
            if (_loc_7 > 2880)
            {
                _loc_7 = param1.height;
                _loc_8 = false;
            }// end if
            if (true)
            {
                PaperLogger.warning("Material " + this.name + ": Texture too big for mip mapping. Resizing recommended for better performance and quality.");
            }// end if
            if (param1 && param1.width % _loc_3 != 0 || param1.height % _loc_3 != 0)
            {
                _loc_2 = new BitmapData(_loc_6, _loc_7, param1.transparent, 0);
                widthOffset = param1.width;
                heightOffset = param1.height;
                this.maxU = param1.width / _loc_6;
                this.maxV = param1.height / _loc_7;
                _loc_2.draw(param1);
                extendBitmapEdges(_loc_2, param1.width, param1.height);
            }
            else
            {
                var _loc_9:int;
                this.maxV = 1;
                this.maxU = _loc_9;
                _loc_2 = param1;
            }// end else if
            return _loc_2;
        }// end function

        public function get precise() : Boolean
        {
            return _precise;
        }// end function

        public function set texture(param1:Object) : void
        {
            if (param1 is BitmapData == false)
            {
                PaperLogger.error("BitmapMaterial.texture requires a BitmapData object for the texture");
                return;
            }// end if
            bitmap = createBitmap(BitmapData(param1));
            _texture = param1;
            return;
        }// end function

        override public function toString() : String
        {
            return "Texture:" + this.texture + " lineColor:" + this.lineColor + " lineAlpha:" + this.lineAlpha;
        }// end function

        public function get precision() : int
        {
            return _precision;
        }// end function

        public function resetMapping() : void
        {
            uvMatrices = new Dictionary();
            return;
        }// end function

        public function get pixelPrecision() : int
        {
            return _perPixelPrecision;
        }// end function

        public function set precise(param1:Boolean) : void
        {
            _precise = param1;
            return;
        }// end function

        protected function extendBitmapEdges(param1:BitmapData, param2:Number, param3:Number) : void
        {
            var _loc_4:Rectangle;
            var _loc_5:Point;
            var _loc_6:int;
            _loc_4 = new Rectangle();
            _loc_5 = new Point();
            if (param1.width > param2)
            {
                _loc_4.x = param2--;
                _loc_4.y = 0;
                _loc_4.width = 1;
                _loc_4.height = param3;
                _loc_5.y = 0;
                _loc_6 = param2;
                while (_loc_6 < param1.width)
                {
                    // label
                    _loc_5.x = _loc_6;
                    param1.copyPixels(param1, _loc_4, _loc_5);
                    _loc_6++;
                }// end while
            }// end if
            if (param1.height > param3)
            {
                _loc_4.x = 0;
                _loc_4.y = param3--;
                _loc_4.width = param1.width;
                _loc_4.height = 1;
                _loc_5.x = 0;
                _loc_6 = param3;
                while (_loc_6 < param1.height)
                {
                    // label
                    _loc_5.y = _loc_6;
                    param1.copyPixels(param1, _loc_4, _loc_5);
                    _loc_6++;
                }// end while
            }// end if
            return;
        }// end function

        public function set precision(param1:int) : void
        {
            _precision = param1;
            return;
        }// end function

        public function transformUV(param1:Triangle3D) : Matrix
        {
            var _loc_2:Array;
            var _loc_3:Number;
            var _loc_4:Number;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            var _loc_9:Number;
            var _loc_10:Number;
            var _loc_11:Number;
            var _loc_12:Number;
            var _loc_13:Number;
            var _loc_14:Number;
            var _loc_15:Matrix;
            var _loc_16:Matrix;
            if (!param1.uv)
            {
                PaperLogger.error("MaterialObject3D: transformUV() uv not found!");
            }
            else if (bitmap)
            {
                _loc_2 = param1.uv;
                _loc_3 = bitmap.width * maxU;
                _loc_4 = bitmap.height * maxV;
                _loc_5 = _loc_3 * param1.uv0.u;
                _loc_6 = _loc_4 * (1 - param1.uv0.v);
                _loc_7 = _loc_3 * param1.uv1.u;
                _loc_8 = _loc_4 * (1 - param1.uv1.v);
                _loc_9 = _loc_3 * param1.uv2.u;
                _loc_10 = _loc_4 * (1 - param1.uv2.v);
                if (_loc_5 == _loc_7 && _loc_6 == _loc_8 || _loc_5 == _loc_9 && _loc_6 == _loc_10)
                {
                    _loc_5 = _loc_5 - (_loc_5 > 0.05 ? (0.05) : (-0.05));
                    _loc_6 = _loc_6 - (_loc_6 > 0.07 ? (0.07) : (-0.07));
                }// end if
                if (_loc_9 == _loc_7 && _loc_10 == _loc_8)
                {
                    _loc_9 = _loc_9 - (_loc_9 > 0.05 ? (0.04) : (-0.04));
                    _loc_10 = _loc_10 - (_loc_10 > 0.06 ? (0.06) : (-0.06));
                }// end if
                _loc_11 = _loc_7 - _loc_5;
                _loc_12 = _loc_8 - _loc_6;
                _loc_13 = _loc_9 - _loc_5;
                _loc_14 = _loc_10 - _loc_6;
                _loc_15 = new Matrix(_loc_11, _loc_12, _loc_13, _loc_14, _loc_5, _loc_6);
                if (Papervision3D.useRIGHTHANDED)
                {
                    _loc_15.scale(-1, 1);
                    _loc_15.translate(_loc_3, 0);
                }// end if
                _loc_15.invert();
                var _loc_17:* = _loc_15.clone();
                uvMatrices[param1] = _loc_15.clone();
                _loc_16 = _loc_17;
                _loc_16.a = _loc_15.a;
                _loc_16.b = _loc_15.b;
                _loc_16.c = _loc_15.c;
                _loc_16.d = _loc_15.d;
                _loc_16.tx = _loc_15.tx;
                _loc_16.ty = _loc_15.ty;
            }
            else
            {
                PaperLogger.error("MaterialObject3D: transformUV() material.bitmap not found!");
            }// end else if
            return _loc_16;
        }// end function

        protected function renderRec(param1:Matrix, param2:Vertex3DInstance, param3:Vertex3DInstance, param4:Vertex3DInstance, param5:Number) : void
        {
            var _loc_6:int;
            var _loc_7:RenderRecStorage;
            var _loc_8:Matrix;
            az = param2.z;
            bz = param3.z;
            cz = param4.z;
            if (az <= 0 && bz <= 0 && cz <= 0)
            {
                return;
            }// end if
            cx = param4.x;
            cy = param4.y;
            bx = param3.x;
            by = param3.y;
            ax = param2.x;
            ay = param2.y;
            if (cullRect)
            {
                hitRect.x = bx < ax ? (bx < cx ? (bx) : (cx)) : (ax < cx ? (ax) : (cx));
                hitRect.width = (bx > ax ? (bx > cx ? (bx) : (cx)) : (ax > cx ? (ax) : (cx))) + (hitRect.x < 0 ? (-hitRect.x) : (hitRect.x));
                hitRect.y = by < ay ? (by < cy ? (by) : (cy)) : (ay < cy ? (ay) : (cy));
                hitRect.height = (by > ay ? (by > cy ? (by) : (cy)) : (ay > cy ? (ay) : (cy))) + (hitRect.y < 0 ? (-hitRect.y) : (hitRect.y));
                if (!(hitRect.right < cullRect.left || hitRect.left > cullRect.right))
                {
                    if (!(hitRect.bottom < cullRect.top || hitRect.top > cullRect.bottom))
                    {
                    }
                    else
                    {
                        return;
                    }// end else if
                }
                else
                {
                    return;
                }// end if
            }// end else if
            if (param5 >= 100 || hitRect.width < minimumRenderSize || hitRect.height < minimumRenderSize || focus == Infinity)
            {
                a2 = param3.x - param2.x;
                b2 = param3.y - param2.y;
                c2 = param4.x - param2.x;
                d2 = param4.y - param2.y;
                tempTriangleMatrix.a = param1.a * a2 + param1.b * c2;
                tempTriangleMatrix.b = param1.a * b2 + param1.b * d2;
                tempTriangleMatrix.c = param1.c * a2 + param1.d * c2;
                tempTriangleMatrix.d = param1.c * b2 + param1.d * d2;
                tempTriangleMatrix.tx = param1.tx * a2 + param1.ty * c2 + param2.x;
                tempTriangleMatrix.ty = param1.tx * b2 + param1.ty * d2 + param2.y;
                if (lineAlpha)
                {
                    tempPreGrp.lineStyle(lineThickness, lineColor, lineAlpha);
                }// end if
                tempPreGrp.beginBitmapFill(tempPreBmp, tempTriangleMatrix, tiled, smooth);
                tempPreGrp.moveTo(param2.x, param2.y);
                tempPreGrp.lineTo(param3.x, param3.y);
                tempPreGrp.lineTo(param4.x, param4.y);
                tempPreGrp.endFill();
                if (lineAlpha)
                {
                    tempPreGrp.lineStyle();
                }// end if
                var _loc_9:* = tempPreRSD.renderStatistics;
                _loc_9.triangles = tempPreRSD.renderStatistics.triangles++;
                return;
            }// end if
            faz = focus + az;
            fbz = focus + bz;
            fcz = focus + cz;
            mabz = 2 / (faz + fbz);
            mbcz = 2 / (fbz + fcz);
            mcaz = 2 / (fcz + faz);
            mabx = (ax * faz + bx * fbz) * mabz;
            maby = (ay * faz + by * fbz) * mabz;
            mbcx = (bx * fbz + cx * fcz) * mbcz;
            mbcy = (by * fbz + cy * fcz) * mbcz;
            mcax = (cx * fcz + ax * faz) * mcaz;
            mcay = (cy * fcz + ay * faz) * mcaz;
            dabx = ax + bx - mabx;
            daby = ay + by - maby;
            dbcx = bx + cx - mbcx;
            dbcy = by + cy - mbcy;
            dcax = cx + ax - mcax;
            dcay = cy + ay - mcay;
            dsab = dabx * dabx + daby * daby;
            dsbc = dbcx * dbcx + dbcy * dbcy;
            dsca = dcax * dcax + dcay * dcay;
            _loc_6 = param5 + 1;
            _loc_7 = RenderRecStorage(renderRecStorage[int(param5)]);
            _loc_8 = _loc_7.mat;
            if (dsab <= _precision && dsca <= _precision && dsbc <= _precision)
            {
                a2 = param3.x - param2.x;
                b2 = param3.y - param2.y;
                c2 = param4.x - param2.x;
                d2 = param4.y - param2.y;
                tempTriangleMatrix.a = param1.a * a2 + param1.b * c2;
                tempTriangleMatrix.b = param1.a * b2 + param1.b * d2;
                tempTriangleMatrix.c = param1.c * a2 + param1.d * c2;
                tempTriangleMatrix.d = param1.c * b2 + param1.d * d2;
                tempTriangleMatrix.tx = param1.tx * a2 + param1.ty * c2 + param2.x;
                tempTriangleMatrix.ty = param1.tx * b2 + param1.ty * d2 + param2.y;
                if (lineAlpha)
                {
                    tempPreGrp.lineStyle(lineThickness, lineColor, lineAlpha);
                }// end if
                tempPreGrp.beginBitmapFill(tempPreBmp, tempTriangleMatrix, tiled, smooth);
                tempPreGrp.moveTo(param2.x, param2.y);
                tempPreGrp.lineTo(param3.x, param3.y);
                tempPreGrp.lineTo(param4.x, param4.y);
                tempPreGrp.endFill();
                if (lineAlpha)
                {
                    tempPreGrp.lineStyle();
                }// end if
                var _loc_9:* = tempPreRSD.renderStatistics;
                _loc_9.triangles = tempPreRSD.renderStatistics.triangles++;
                return;
            }// end if
            if (dsab > _precision && dsca > _precision && dsbc > _precision)
            {
                _loc_8.a = param1.a * 2;
                _loc_8.b = param1.b * 2;
                _loc_8.c = param1.c * 2;
                _loc_8.d = param1.d * 2;
                _loc_8.tx = param1.tx * 2;
                _loc_8.ty = param1.ty * 2;
                _loc_7.v0.x = mabx * 0.5;
                _loc_7.v0.y = maby * 0.5;
                _loc_7.v0.z = (az + bz) * 0.5;
                _loc_7.v1.x = mbcx * 0.5;
                _loc_7.v1.y = mbcy * 0.5;
                _loc_7.v1.z = (bz + cz) * 0.5;
                _loc_7.v2.x = mcax * 0.5;
                _loc_7.v2.y = mcay * 0.5;
                _loc_7.v2.z = (cz + az) * 0.5;
                renderRec(_loc_8, param2, _loc_7.v0, _loc_7.v2, _loc_6);
                _loc_8.tx--;
                renderRec(_loc_8, _loc_7.v0, param3, _loc_7.v1, _loc_6);
                _loc_8.ty--;
                _loc_8.tx = param1.tx * 2;
                renderRec(_loc_8, _loc_7.v2, _loc_7.v1, param4, _loc_6);
                _loc_8.a = (-param1.a) * 2;
                _loc_8.b = (-param1.b) * 2;
                _loc_8.c = (-param1.c) * 2;
                _loc_8.d = (-param1.d) * 2;
                _loc_8.tx = (-param1.tx) * 2 + 1;
                _loc_8.ty = (-param1.ty) * 2 + 1;
                renderRec(_loc_8, _loc_7.v1, _loc_7.v2, _loc_7.v0, _loc_6);
                return;
            }// end if
            if (precisionMode == PrecisionMode.ORIGINAL)
            {
                d2ab = dsab;
                d2bc = dsbc;
                d2ca = dsca;
                dmax = dsca > dsbc ? (dsca > dsab ? (dsca) : (dsab)) : (dsbc > dsab ? (dsbc) : (dsab));
            }
            else
            {
                dx = param2.x - param3.x;
                dy = param2.y - param3.y;
                d2ab = dx * dx + dy * dy;
                dx = param3.x - param4.x;
                dy = param3.y - param4.y;
                d2bc = dx * dx + dy * dy;
                dx = param4.x - param2.x;
                dy = param4.y - param2.y;
                d2ca = dx * dx + dy * dy;
                dmax = d2ca > d2bc ? (d2ca > d2ab ? (d2ca) : (d2ab)) : (d2bc > d2ab ? (d2bc) : (d2ab));
            }// end else if
            if (d2ab == dmax)
            {
                _loc_8.a = param1.a * 2;
                _loc_8.b = param1.b;
                _loc_8.c = param1.c * 2;
                _loc_8.d = param1.d;
                _loc_8.tx = param1.tx * 2;
                _loc_8.ty = param1.ty;
                _loc_7.v0.x = mabx * 0.5;
                _loc_7.v0.y = maby * 0.5;
                _loc_7.v0.z = (az + bz) * 0.5;
                renderRec(_loc_8, param2, _loc_7.v0, param4, _loc_6);
                _loc_8.a = param1.a * 2 + param1.b;
                _loc_8.c = 2 * param1.c + param1.d;
                _loc_8.tx = (param1.tx * 2 + param1.ty)--;
                renderRec(_loc_8, _loc_7.v0, param3, param4, _loc_6);
                return;
            }// end if
            if (d2ca == dmax)
            {
                _loc_8.a = param1.a;
                _loc_8.b = param1.b * 2;
                _loc_8.c = param1.c;
                _loc_8.d = param1.d * 2;
                _loc_8.tx = param1.tx;
                _loc_8.ty = param1.ty * 2;
                _loc_7.v2.x = mcax * 0.5;
                _loc_7.v2.y = mcay * 0.5;
                _loc_7.v2.z = (cz + az) * 0.5;
                renderRec(_loc_8, param2, param3, _loc_7.v2, _loc_6);
                _loc_8.b = _loc_8.b + param1.a;
                _loc_8.d = _loc_8.d + param1.c;
                _loc_8.ty = _loc_8.ty + param1.tx--;
                renderRec(_loc_8, _loc_7.v2, param3, param4, _loc_6);
                return;
            }// end if
            _loc_8.a = param1.a - param1.b;
            _loc_8.b = param1.b * 2;
            _loc_8.c = param1.c - param1.d;
            _loc_8.d = param1.d * 2;
            _loc_8.tx = param1.tx - param1.ty;
            _loc_8.ty = param1.ty * 2;
            _loc_7.v1.x = mbcx * 0.5;
            _loc_7.v1.y = mbcy * 0.5;
            _loc_7.v1.z = (bz + cz) * 0.5;
            renderRec(_loc_8, param2, param3, _loc_7.v1, _loc_6);
            _loc_8.a = param1.a * 2;
            _loc_8.b = param1.b - param1.a;
            _loc_8.c = param1.c * 2;
            _loc_8.d = param1.d - param1.c;
            _loc_8.tx = param1.tx * 2;
            _loc_8.ty = param1.ty - param1.tx;
            renderRec(_loc_8, param2, _loc_7.v1, param4, _loc_6);
            return;
        }// end function

        protected function createRenderRecStorage() : void
        {
            var _loc_1:int;
            this.renderRecStorage = new Array();
            _loc_1 = 0;
            while (_loc_1 <= 100)
            {
                // label
                this.renderRecStorage[_loc_1] = new RenderRecStorage();
                _loc_1++;
            }// end while
            return;
        }// end function

        public function set pixelPrecision(param1:int) : void
        {
            _precision = param1 * param1 * 1.4;
            _perPixelPrecision = param1;
            return;
        }// end function

        public function get texture() : Object
        {
            return this._texture;
        }// end function

        protected function createBitmap(param1:BitmapData) : BitmapData
        {
            var _loc_2:BitmapData;
            resetMapping();
            if (AUTO_MIP_MAPPING)
            {
                _loc_2 = correctBitmap(param1);
            }
            else
            {
                var _loc_3:int;
                this.maxV = 1;
                this.maxU = _loc_3;
                _loc_2 = param1;
            }// end else if
            return _loc_2;
        }// end function

        override public function clone() : MaterialObject3D
        {
            var _loc_1:MaterialObject3D;
            _loc_1 = super.clone();
            _loc_1.maxU = this.maxU;
            _loc_1.maxV = this.maxV;
            return _loc_1;
        }// end function

        override public function drawTriangle(param1:RenderTriangle, param2:Graphics, param3:RenderSessionData, param4:BitmapData = null, param5:Matrix = null) : void
        {
            if (!uvMatrices[param1])
            {
            }// end if
            _triMap = param5 ? (param5) : (if (uvMatrices[param1]) goto 4, transformUVRT(param1));
            if (!_precise || !_triMap)
            {
                if (lineAlpha)
                {
                    param2.lineStyle(lineThickness, lineColor, lineAlpha);
                }// end if
                if (bitmap)
                {
                    x0 = param1.v0.x;
                    y0 = param1.v0.y;
                    x1 = param1.v1.x;
                    y1 = param1.v1.y;
                    x2 = param1.v2.x;
                    y2 = param1.v2.y;
                    _triMatrix.a = x1 - x0;
                    _triMatrix.b = y1 - y0;
                    _triMatrix.c = x2 - x0;
                    _triMatrix.d = y2 - y0;
                    _triMatrix.tx = x0;
                    _triMatrix.ty = y0;
                    _localMatrix.a = _triMap.a;
                    _localMatrix.b = _triMap.b;
                    _localMatrix.c = _triMap.c;
                    _localMatrix.d = _triMap.d;
                    _localMatrix.tx = _triMap.tx;
                    _localMatrix.ty = _triMap.ty;
                    _localMatrix.concat(_triMatrix);
                    param2.beginBitmapFill(param4 ? (param4) : (bitmap), _localMatrix, tiled, smooth);
                }// end if
                param2.moveTo(x0, y0);
                param2.lineTo(x1, y1);
                param2.lineTo(x2, y2);
                param2.lineTo(x0, y0);
                if (bitmap)
                {
                    param2.endFill();
                }// end if
                if (lineAlpha)
                {
                    param2.lineStyle();
                }// end if
                var _loc_6:* = param3.renderStatistics;
                _loc_6.triangles = param3.renderStatistics.triangles++;
            }
            else if (bitmap)
            {
                focus = param3.camera.focus;
                tempPreBmp = param4 ? (param4) : (bitmap);
                tempPreRSD = param3;
                tempPreGrp = param2;
                cullRect = param3.viewPort.cullingRectangle;
                renderRec(_triMap, param1.v0, param1.v1, param1.v2, 0);
            }// end else if
            return;
        }// end function

        override public function copy(param1:MaterialObject3D) : void
        {
            super.copy(param1);
            this.maxU = param1.maxU;
            this.maxV = param1.maxV;
            return;
        }// end function

        override public function destroy() : void
        {
            super.destroy();
            if (uvMatrices)
            {
                uvMatrices = null;
            }// end if
            if (bitmap)
            {
                bitmap.dispose();
            }// end if
            this.renderRecStorage = null;
            return;
        }// end function

    }
}
