﻿package org.papervision3d.materials
{
    import flash.display.*;
    import flash.geom.*;
    import org.papervision3d.core.log.*;
    import org.papervision3d.core.render.command.*;
    import org.papervision3d.core.render.data.*;

    public class MovieMaterial extends BitmapMaterial implements ITriangleDrawer, IUpdateBeforeMaterial, IUpdateAfterMaterial
    {
        public var movieTransparent:Boolean;
        private var materialIsUsed:Boolean = false;
        private var autoClipRect:Rectangle;
        private var userClipRect:Rectangle;
        protected var recreateBitmapInSuper:Boolean;
        private var movieAnimated:Boolean;
        private var stage:Stage;
        private var quality:String;
        public var movie:DisplayObject;
        public var allowAutoResize:Boolean = false;

        public function MovieMaterial(param1:DisplayObject = null, param2:Boolean = false, param3:Boolean = false, param4:Boolean = false, param5:Rectangle = null)
        {
            materialIsUsed = false;
            allowAutoResize = false;
            movieTransparent = param2;
            this.animated = param3;
            this.precise = param4;
            userClipRect = param5;
            if (param1)
            {
                texture = param1;
            }// end if
            return;
        }// end function

        public function updateAfterRender(param1:RenderSessionData) : void
        {
            if (movieAnimated == true && materialIsUsed == true)
            {
                drawBitmap();
                if (recreateBitmapInSuper)
                {
                    bitmap = super.createBitmap(bitmap);
                    recreateBitmapInSuper = false;
                }// end if
            }// end if
            return;
        }// end function

        override public function set texture(param1:Object) : void
        {
            if (param1 is DisplayObject == false)
            {
                PaperLogger.error("MovieMaterial.texture requires a Sprite to be passed as the object");
                return;
            }// end if
            bitmap = createBitmapFromSprite(DisplayObject(param1));
            _texture = param1;
            return;
        }// end function

        public function setQuality(param1:String, param2:Stage, param3:Boolean = true) : void
        {
            this.quality = param1;
            this.stage = param2;
            if (param3)
            {
                createBitmapFromSprite(movie);
            }// end if
            return;
        }// end function

        protected function initBitmap(param1:DisplayObject) : void
        {
            if (bitmap)
            {
                bitmap.dispose();
            }// end if
            if (userClipRect)
            {
                bitmap = new BitmapData(int(userClipRect.width + 0.5), int(userClipRect.height + 0.5), movieTransparent, fillColor);
            }
            else if (param1.width == 0 || param1.height == 0)
            {
                bitmap = new BitmapData(256, 256, movieTransparent, fillColor);
            }
            else
            {
                bitmap = new BitmapData(int(param1.width + 0.5), int(param1.height + 0.5), movieTransparent, fillColor);
            }// end else if
            return;
        }// end function

        protected function createBitmapFromSprite(param1:DisplayObject) : BitmapData
        {
            movie = param1;
            initBitmap(movie);
            drawBitmap();
            bitmap = super.createBitmap(bitmap);
            return bitmap;
        }// end function

        override public function get texture() : Object
        {
            return this._texture;
        }// end function

        public function set animated(param1:Boolean) : void
        {
            movieAnimated = param1;
            return;
        }// end function

        public function updateBeforeRender(param1:RenderSessionData) : void
        {
            var _loc_2:int;
            var _loc_3:int;
            materialIsUsed = false;
            if (movieAnimated)
            {
                if (userClipRect)
                {
                    _loc_2 = int(userClipRect.width + 0.5);
                    _loc_3 = int(userClipRect.height + 0.5);
                }
                else
                {
                    _loc_2 = int(movie.width + 0.5);
                    _loc_3 = int(movie.height + 0.5);
                }// end else if
                if (allowAutoResize && _loc_2 != bitmap.width || _loc_3 != bitmap.height)
                {
                    initBitmap(movie);
                    recreateBitmapInSuper = true;
                }// end if
            }// end if
            return;
        }// end function

        override public function drawTriangle(param1:RenderTriangle, param2:Graphics, param3:RenderSessionData, param4:BitmapData = null, param5:Matrix = null) : void
        {
            materialIsUsed = true;
            super.drawTriangle(param1, param2, param3, param4, param5);
            return;
        }// end function

        public function drawBitmap() : void
        {
            var _loc_1:Rectangle;
            var _loc_2:Matrix;
            var _loc_3:String;
            bitmap.fillRect(bitmap.rect, fillColor);
            if (stage && quality)
            {
                _loc_3 = stage.quality;
                stage.quality = quality;
            }// end if
            _loc_1 = rect;
            _loc_2 = new Matrix(1, 0, 0, 1, -_loc_1.x, -_loc_1.y);
            bitmap.draw(movie, _loc_2, movie.transform.colorTransform, null);
            if (!userClipRect)
            {
                autoClipRect = movie.getBounds(movie);
            }// end if
            if (stage && quality)
            {
                stage.quality = _loc_3;
            }// end if
            return;
        }// end function

        public function get animated() : Boolean
        {
            return movieAnimated;
        }// end function

        public function set rect(param1:Rectangle) : void
        {
            userClipRect = param1;
            createBitmapFromSprite(movie);
            return;
        }// end function

        public function get rect() : Rectangle
        {
            var _loc_1:Rectangle;
            if (!userClipRect)
            {
            }// end if
            _loc_1 = autoClipRect;
            if (!_loc_1 && movie)
            {
                _loc_1 = movie.getBounds(movie);
            }// end if
            return _loc_1;
        }// end function

    }
}
