﻿package org.papervision3d.materials.shaders
{
    import flash.display.*;
    import flash.geom.*;
    import flash.utils.*;
    import org.papervision3d.core.log.*;
    import org.papervision3d.core.material.*;
    import org.papervision3d.core.render.command.*;
    import org.papervision3d.core.render.data.*;
    import org.papervision3d.core.render.shader.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.*;

    public class ShadedMaterial extends TriangleMaterial implements ITriangleDrawer, IUpdateBeforeMaterial, IUpdateAfterMaterial
    {
        private var _shaderCompositeMode:int;
        public var material:BitmapMaterial;
        public var shader:Shader;
        public var shaderObjectData:Dictionary;
        private static var bmp:BitmapData;

        public function ShadedMaterial(param1:BitmapMaterial, param2:Shader, param3:int = 0)
        {
            this.shader = param2;
            this.material = param1;
            shaderCompositeMode = param3;
            init();
            return;
        }// end function

        override public function drawTriangle(param1:RenderTriangle, param2:Graphics, param3:RenderSessionData, param4:BitmapData = null, param5:Matrix = null) : void
        {
            var _loc_6:ShaderObjectData;
            _loc_6 = ShaderObjectData(shaderObjectData[param1.renderableInstance.instance]);
            if (shaderCompositeMode == ShaderCompositeModes.PER_LAYER)
            {
                material.drawTriangle(param1, param2, param3, _loc_6.shaderRenderer.outputBitmap);
                shader.renderLayer(param1.triangle, param3, _loc_6);
            }
            else if (shaderCompositeMode == ShaderCompositeModes.PER_TRIANGLE_IN_BITMAP)
            {
                bmp = _loc_6.getOutputBitmapFor(param1.triangle);
                material.drawTriangle(param1, param2, param3, bmp, _loc_6.triangleUVS[param1.triangle] ? (_loc_6.triangleUVS[param1.triangle]) : (_loc_6.getPerTriUVForDraw(param1.triangle)));
                shader.renderTri(param1.triangle, param3, _loc_6, bmp);
            }// end else if
            return;
        }// end function

        override public function destroy() : void
        {
            var _loc_1:ShaderObjectData;
            super.destroy();
            for each (_loc_1 in shaderObjectData)
            {
                // label
                _loc_1.destroy();
            }// end of for each ... in
            material = null;
            shader = null;
            return;
        }// end function

        private function init() : void
        {
            shaderObjectData = new Dictionary();
            return;
        }// end function

        public function updateBeforeRender(param1:RenderSessionData) : void
        {
            var _loc_2:ShaderObjectData;
            var _loc_3:ILightShader;
            for each (_loc_2 in shaderObjectData)
            {
                // label
                _loc_2.shaderRenderer.inputBitmap = material.bitmap;
                if (shaderCompositeMode == ShaderCompositeModes.PER_LAYER)
                {
                    if (_loc_2.shaderRenderer.resizedInput)
                    {
                        _loc_2.shaderRenderer.resizedInput = false;
                        _loc_2.uvMatrices = new Dictionary();
                    }// end if
                    _loc_2.shaderRenderer.clear();
                }// end if
                if (shader is ILightShader)
                {
                    _loc_3 = shader as ILightShader;
                    _loc_3.updateLightMatrix(_loc_2, param1);
                }// end if
            }// end of for each ... in
            return;
        }// end function

        public function updateAfterRender(param1:RenderSessionData) : void
        {
            var _loc_2:ShaderObjectData;
            for each (_loc_2 in shaderObjectData)
            {
                // label
                shader.updateAfterRender(param1, _loc_2);
                if (shaderCompositeMode == ShaderCompositeModes.PER_LAYER)
                {
                    _loc_2.shaderRenderer.render(param1);
                }// end if
            }// end of for each ... in
            return;
        }// end function

        override public function unregisterObject(param1:DisplayObject3D) : void
        {
            var _loc_2:ShaderObjectData;
            super.unregisterObject(param1);
            _loc_2 = shaderObjectData[param1];
            _loc_2.destroy();
            delete shaderObjectData[param1];
            return;
        }// end function

        public function set shaderCompositeMode(param1:int) : void
        {
            _shaderCompositeMode = param1;
            return;
        }// end function

        override public function registerObject(param1:DisplayObject3D) : void
        {
            var _loc_2:ShaderObjectData;
            super.registerObject(param1);
            var _loc_3:* = new ShaderObjectData(param1, material, this);
            shaderObjectData[param1] = new ShaderObjectData(param1, material, this);
            _loc_2 = _loc_3;
            _loc_2.shaderRenderer.inputBitmap = material.bitmap;
            shader.setContainerForObject(param1, _loc_2.shaderRenderer.getLayerForShader(shader));
            return;
        }// end function

        public function getOutputBitmapDataFor(param1:DisplayObject3D) : BitmapData
        {
            var _loc_2:ShaderObjectData;
            if (shaderCompositeMode == ShaderCompositeModes.PER_LAYER)
            {
                if (shaderObjectData[param1])
                {
                    _loc_2 = ShaderObjectData(shaderObjectData[param1]);
                    return _loc_2.shaderRenderer.outputBitmap;
                }// end if
                PaperLogger.warning("object not registered with shaded material");
            }
            else
            {
                PaperLogger.warning("getOutputBitmapDataFor only works on per layer mode");
            }// end else if
            return null;
        }// end function

        public function get shaderCompositeMode() : int
        {
            return _shaderCompositeMode;
        }// end function

    }
}
