﻿package org.papervision3d.materials.special
{
    import flash.display.*;
    import org.papervision3d.core.geom.renderables.*;
    import org.papervision3d.core.log.*;
    import org.papervision3d.core.proto.*;
    import org.papervision3d.core.render.data.*;

    public class ParticleMaterial extends MaterialObject3D implements IParticleDrawer
    {
        public var shape:int;
        public var scale:Number;
        public static var SHAPE_SQUARE:int = 0;
        public static var SHAPE_CIRCLE:int = 1;

        public function ParticleMaterial(param1:Number, param2:Number, param3:int = 0, param4:Number = 1)
        {
            this.shape = param3;
            this.fillAlpha = param2;
            this.fillColor = param1;
            this.scale = param4;
            return;
        }// end function

        public function updateRenderRect(param1:Particle) : void
        {
            var _loc_2:Rectangle;
            _loc_2 = param1.renderRect;
            if (param1.size == 0)
            {
                _loc_2.width = 1;
                _loc_2.height = 1;
            }
            else
            {
                _loc_2.width = param1.renderScale * param1.size * scale;
                _loc_2.height = param1.renderScale * param1.size * scale;
            }// end else if
            _loc_2.x = param1.vertex3D.vertex3DInstance.x - _loc_2.width / 2;
            _loc_2.y = param1.vertex3D.vertex3DInstance.y - _loc_2.width / 2;
            return;
        }// end function

        public function drawParticle(param1:Particle, param2:Graphics, param3:RenderSessionData) : void
        {
            var _loc_4:Rectangle;
            param2.beginFill(fillColor, fillAlpha);
            _loc_4 = param1.renderRect;
            if (shape == SHAPE_SQUARE)
            {
                param2.drawRect(_loc_4.x, _loc_4.y, _loc_4.width, _loc_4.height);
            }
            else if (shape == SHAPE_CIRCLE)
            {
                param2.drawCircle(_loc_4.x + _loc_4.width / 2, _loc_4.y + _loc_4.width / 2, _loc_4.width / 2);
            }
            else
            {
                PaperLogger.warning("Particle material has no valid shape - Must be ParticleMaterial.SHAPE_SQUARE or ParticleMaterial.SHAPE_CIRCLE");
            }// end else if
            param2.endFill();
            var _loc_5:* = param3.renderStatistics;
            _loc_5.particles = param3.renderStatistics.particles++;
            return;
        }// end function

    }
}
