﻿package org.papervision3d.materials.utils
{
    import flash.utils.*;
    import org.papervision3d.core.proto.*;

    public class MaterialsList extends Object
    {
        protected var _materials:Dictionary;
        public var materialsByName:Dictionary;
        private var _materialsTotal:int;

        public function MaterialsList(param1 = null) : void
        {
            var _loc_2:String;
            var _loc_3:String;
            this.materialsByName = new Dictionary(true);
            this._materials = new Dictionary(false);
            this._materialsTotal = 0;
            if (param1)
            {
                if (param1 is Array)
                {
                    for (_loc_2 in param1)
                    {
                        // label
                        this.addMaterial(param1[_loc_2]);
                    }// end of for ... in
                }
                else if (param1 is Object)
                {
                    for (_loc_3 in param1)
                    {
                        // label
                        this.addMaterial(param1[_loc_3], _loc_3);
                    }// end of for ... in
                }// end if
            }// end else if
            return;
        }// end function

        public function get numMaterials() : int
        {
            return _materialsTotal;
        }// end function

        public function addMaterial(param1:MaterialObject3D, param2:String = null) : MaterialObject3D
        {
            if (!(param2 || param1.name))
            {
            }// end if
            param2 = String(param1.id);
            this._materials[param1] = param2;
            this.materialsByName[param2] = param1;
            var _loc_3:String;
            _loc_3._materialsTotal = this._materialsTotal++;
            return param1;
        }// end function

        public function removeMaterial(param1:MaterialObject3D) : MaterialObject3D
        {
            if (this._materials[param1])
            {
                delete this.materialsByName[this._materials[param1]];
                delete this._materials[param1];
                _materialsTotal--;
            }// end if
            return param1;
        }// end function

        public function toString() : String
        {
            var _loc_1:String;
            var _loc_2:MaterialObject3D;
            _loc_1 = "";
            for each (_loc_2 in this.materialsByName)
            {
                // label
                _loc_1 = _loc_1 + (this._materials[_loc_2] + "\n");
            }// end of for each ... in
            return _loc_1;
        }// end function

        public function removeMaterialByName(param1:String) : MaterialObject3D
        {
            return removeMaterial(getMaterialByName(param1));
        }// end function

        public function clone() : MaterialsList
        {
            var _loc_1:MaterialsList;
            var _loc_2:MaterialObject3D;
            _loc_1 = new MaterialsList();
            for each (_loc_2 in this.materialsByName)
            {
                // label
                _loc_1.addMaterial(_loc_2.clone(), this._materials[_loc_2]);
            }// end of for each ... in
            return _loc_1;
        }// end function

        public function getMaterialByName(param1:String) : MaterialObject3D
        {
            return this.materialsByName[param1] ? (this.materialsByName[param1]) : (this.materialsByName["all"]);
        }// end function

    }
}
