﻿package org.papervision3d.objects
{
    import flash.display.*;
    import org.papervision3d.*;
    import org.papervision3d.core.culling.*;
    import org.papervision3d.core.data.*;
    import org.papervision3d.core.log.*;
    import org.papervision3d.core.material.*;
    import org.papervision3d.core.math.*;
    import org.papervision3d.core.proto.*;
    import org.papervision3d.core.render.data.*;
    import org.papervision3d.materials.shaders.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.view.*;
    import org.papervision3d.view.layer.*;

    public class DisplayObject3D extends DisplayObjectContainer3D
    {
        public var extra:Object;
        public var materials:MaterialsList;
        private var _zAxis:Number3D;
        private var _scaleDirty:Boolean = false;
        private var _tempScale:Number3D;
        private var _numClones:uint = 0;
        public var screen:Number3D;
        private var _qPitch:Quaternion;
        public var geometry:GeometryObject3D;
        public var visible:Boolean;
        protected var _useOwnContainer:Boolean = false;
        private var _material:MaterialObject3D;
        public var name:String;
        private var _position:Number3D;
        public var container:ViewportLayer;
        public var view:Matrix3D;
        public var parent:DisplayObjectContainer3D;
        private var _yAxis:Number3D;
        public var flipLightDirection:Boolean = false;
        private var _rotation:Number3D;
        private var _rotationDirty:Boolean = false;
        public var parentContainer:DisplayObject3D;
        public var testQuad:Boolean = true;
        public var frustumTestMethod:int = 0;
        private var _rot:Quaternion;
        public var id:int;
        private var _rotationY:Number;
        private var _rotationZ:Number;
        private var _lookatTarget:Number3D;
        private var _rotationX:Number;
        public var meshSort:uint = 1;
        private var _qYaw:Quaternion;
        public var cullTest:Number = 0;
        private var _xAxis:Number3D;
        private var _autoCalcScreenCoords:Boolean = false;
        public var alpha:Number = 1;
        public var useClipping:Boolean = true;
        private var _scaleX:Number;
        public var screenZ:Number;
        private var _scaleZ:Number;
        public var transform:Matrix3D;
        protected var _userData:UserData;
        private var _scaleY:Number;
        private var _localRotationX:Number = 0;
        private var _qRoll:Quaternion;
        private var _localRotationZ:Number = 0;
        public var culled:Boolean;
        public var world:Matrix3D;
        public var blendMode:String = "normal";
        private var _localRotationY:Number = 0;
        protected var _scene:SceneObject3D = null;
        public var faces:Array;
        protected var _sorted:Array;
        protected var _transformDirty:Boolean = false;
        public var filters:Array;
        private static var entry_count:uint = 0;
        private static var _newID:int = 0;
        public static const MESH_SORT_CENTER:uint = 1;
        private static const LEFT:Number3D = new Number3D(-1, 0, 0);
        public static const MESH_SORT_CLOSE:uint = 3;
        private static var _tempMatrix:Matrix3D = Matrix3D.IDENTITY;
        public static var sortedArray:Array = new Array();
        private static const BACKWARD:Number3D = new Number3D(0, 0, -1);
        private static const FORWARD:Number3D = new Number3D(0, 0, 1);
        public static const MESH_SORT_FAR:uint = 2;
        private static const DOWN:Number3D = new Number3D(0, -1, 0);
        public static var faceLevelMode:Boolean;
        private static var _tempQuat:Quaternion = new Quaternion();
        private static const UP:Number3D = new Number3D(0, 1, 0);
        private static var toRADIANS:Number = 0.0174533;
        private static var toDEGREES:Number = 57.2958;
        private static const RIGHT:Number3D = new Number3D(1, 0, 0);

        public function DisplayObject3D(param1:String = null, param2:GeometryObject3D = null) : void
        {
            var _loc_3:Number;
            faces = new Array();
            meshSort = MESH_SORT_CENTER;
            alpha = 1;
            blendMode = BlendMode.NORMAL;
            filters = [];
            flipLightDirection = false;
            frustumTestMethod = FrustumTestMethod.BOUNDING_SPHERE;
            screen = new Number3D();
            cullTest = 0;
            useClipping = true;
            testQuad = true;
            _transformDirty = false;
            _useOwnContainer = false;
            _scene = null;
            _position = Number3D.ZERO;
            _lookatTarget = Number3D.ZERO;
            _zAxis = Number3D.ZERO;
            _xAxis = Number3D.ZERO;
            _yAxis = Number3D.ZERO;
            _rotation = Number3D.ZERO;
            _rotationDirty = false;
            _scaleDirty = false;
            _numClones = 0;
            _rot = new Quaternion();
            _qPitch = new Quaternion();
            _qYaw = new Quaternion();
            _qRoll = new Quaternion();
            _localRotationX = 0;
            _localRotationY = 0;
            _localRotationZ = 0;
            _autoCalcScreenCoords = false;
            if (param1 != null)
            {
                PaperLogger.info("DisplayObject3D: " + param1);
            }// end if
            this.culled = false;
            this.transform = Matrix3D.IDENTITY;
            this.world = Matrix3D.IDENTITY;
            this.view = Matrix3D.IDENTITY;
            this.x = 0;
            this.y = 0;
            this.z = 0;
            rotationX = 0;
            rotationY = 0;
            rotationZ = 0;
            var _loc_4:int;
            _localRotationZ = 0;
            var _loc_4:* = _loc_4;
            _localRotationY = _loc_4;
            _localRotationX = _loc_4;
            _loc_3 = Papervision3D.usePERCENT ? (100) : (1);
            scaleX = _loc_3;
            scaleY = _loc_3;
            scaleZ = _loc_3;
            _tempScale = new Number3D();
            this.visible = true;
            this.id = _newID++;
            if (!param1)
            {
            }// end if
            this.name = String(this.id);
            _numClones = 0;
            if (param2)
            {
                addGeometry(param2);
            }// end if
            return;
        }// end function

        public function setChildMaterialByName(param1:String, param2:MaterialObject3D) : void
        {
            setChildMaterial(getChildByName(param1, true), param2);
            return;
        }// end function

        public function moveDown(param1:Number) : void
        {
            translate(param1, DOWN);
            return;
        }// end function

        public function get userData() : UserData
        {
            return _userData;
        }// end function

        public function set userData(param1:UserData) : void
        {
            _userData = param1;
            return;
        }// end function

        protected function setParentContainer(param1:DisplayObject3D, param2:Boolean = true) : void
        {
            var _loc_3:DisplayObject3D;
            if (param2 && param1 != this)
            {
                parentContainer = param1;
            }// end if
            for each (_loc_3 in children)
            {
                // label
                _loc_3.setParentContainer(param1, param2);
            }// end of for each ... in
            return;
        }// end function

        public function calculateScreenCoords(param1:CameraObject3D) : void
        {
            var _loc_2:Number;
            var _loc_3:Number;
            var _loc_4:Number;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            if (param1.useProjectionMatrix)
            {
                _loc_2 = 0;
                _loc_3 = 0;
                _loc_4 = 0;
                _loc_5 = _loc_2 * view.n41 + _loc_3 * view.n42 + _loc_4 * view.n43 + view.n44;
                _loc_6 = param1.viewport.width / 2;
                _loc_7 = param1.viewport.height / 2;
                screen.x = (_loc_2 * view.n11 + _loc_3 * view.n12 + _loc_4 * view.n13 + view.n14) / _loc_5;
                screen.y = (_loc_2 * view.n21 + _loc_3 * view.n22 + _loc_4 * view.n23 + view.n24) / _loc_5;
                screen.z = _loc_2 * view.n31 + _loc_3 * view.n32 + _loc_4 * view.n33 + view.n34;
                screen.x = screen.x * _loc_6;
                screen.y = screen.y * _loc_7;
            }
            else
            {
                _loc_8 = param1.focus * param1.zoom / (param1.focus + view.n34);
                screen.x = view.n14 * _loc_8;
                screen.y = view.n24 * _loc_8;
                screen.z = view.n34;
            }// end else if
            return;
        }// end function

        public function addGeometry(param1:GeometryObject3D = null) : void
        {
            if (param1)
            {
                this.geometry = param1;
            }// end if
            return;
        }// end function

        public function moveUp(param1:Number) : void
        {
            translate(param1, UP);
            return;
        }// end function

        public function get scaleY() : Number
        {
            if (Papervision3D.usePERCENT)
            {
                return this._scaleY * 100;
            }// end if
            return this._scaleY;
        }// end function

        public function get scaleZ() : Number
        {
            if (Papervision3D.usePERCENT)
            {
                return this._scaleZ * 100;
            }// end if
            return this._scaleZ;
        }// end function

        public function set position(param1:Number3D) : void
        {
            this.x = param1.x;
            this.y = param1.y;
            this.z = param1.z;
            return;
        }// end function

        public function get scaleX() : Number
        {
            if (Papervision3D.usePERCENT)
            {
                return this._scaleX * 100;
            }// end if
            return this._scaleX;
        }// end function

        public function hitTestObject(param1:DisplayObject3D, param2:Number = 1) : Boolean
        {
            var _loc_3:Number;
            var _loc_4:Number;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            _loc_3 = this.x - param1.x;
            _loc_4 = this.y - param1.y;
            _loc_5 = this.z - param1.z;
            _loc_6 = _loc_3 * _loc_3 + _loc_4 * _loc_4 + _loc_5 * _loc_5;
            _loc_7 = this.geometry ? (this.geometry.boundingSphere.maxDistance) : (0);
            _loc_8 = param1.geometry ? (param1.geometry.boundingSphere.maxDistance) : (0);
            _loc_7 = _loc_7 * param2;
            return _loc_7 + _loc_8 > _loc_6;
        }// end function

        public function set material(param1:MaterialObject3D) : void
        {
            if (_material)
            {
                _material.unregisterObject(this);
            }// end if
            _material = param1;
            if (_material)
            {
                _material.registerObject(this);
            }// end if
            return;
        }// end function

        public function yaw(param1:Number) : void
        {
            param1 = Papervision3D.useDEGREES ? (param1 * toRADIANS) : (param1);
            if (_transformDirty)
            {
                updateTransform();
            }// end if
            _qYaw.setFromAxisAngle(transform.n12, transform.n22, transform.n32, param1);
            transform.calculateMultiply3x3(_qYaw.matrix, transform);
            _localRotationY = _localRotationY + param1;
            _rotationDirty = true;
            return;
        }// end function

        override public function toString() : String
        {
            return this.name + ": x:" + Math.round(this.x) + " y:" + Math.round(this.y) + " z:" + Math.round(this.z);
        }// end function

        public function get autoCalcScreenCoords() : Boolean
        {
            return _autoCalcScreenCoords;
        }// end function

        public function get z() : Number
        {
            return this.transform.n34;
        }// end function

        public function roll(param1:Number) : void
        {
            param1 = Papervision3D.useDEGREES ? (param1 * toRADIANS) : (param1);
            if (_transformDirty)
            {
                updateTransform();
            }// end if
            _qRoll.setFromAxisAngle(transform.n13, transform.n23, transform.n33, param1);
            transform.calculateMultiply3x3(_qRoll.matrix, transform);
            _localRotationZ = _localRotationZ + param1;
            _rotationDirty = true;
            return;
        }// end function

        public function get x() : Number
        {
            return this.transform.n14;
        }// end function

        public function get scene() : SceneObject3D
        {
            return _scene;
        }// end function

        public function get y() : Number
        {
            return this.transform.n24;
        }// end function

        public function set scale(param1:Number) : void
        {
            if (this._rotationDirty)
            {
                updateRotation();
            }// end if
            if (Papervision3D.usePERCENT)
            {
                param1 = param1 / 100;
            }// end if
            var _loc_2:* = param1;
            this._scaleZ = param1;
            var _loc_2:* = _loc_2;
            this._scaleY = _loc_2;
            this._scaleX = _loc_2;
            this._transformDirty = true;
            return;
        }// end function

        public function getMaterialByName(param1:String) : MaterialObject3D
        {
            var _loc_2:MaterialObject3D;
            var _loc_3:DisplayObject3D;
            _loc_2 = this.materials ? (this.materials.getMaterialByName(param1)) : (null);
            if (_loc_2)
            {
                return _loc_2;
            }// end if
            for each (_loc_3 in this._childrenByName)
            {
                // label
                _loc_2 = _loc_3.getMaterialByName(param1);
                if (_loc_2)
                {
                    return _loc_2;
                }// end if
            }// end of for each ... in
            return null;
        }// end function

        public function get rotationY() : Number
        {
            if (this._rotationDirty)
            {
                updateRotation();
            }// end if
            return Papervision3D.useDEGREES ? (this._rotationY * toDEGREES) : (this._rotationY);
        }// end function

        public function get rotationZ() : Number
        {
            if (this._rotationDirty)
            {
                updateRotation();
            }// end if
            return Papervision3D.useDEGREES ? (this._rotationZ * toDEGREES) : (this._rotationZ);
        }// end function

        public function set scaleY(param1:Number) : void
        {
            if (this._rotationDirty)
            {
                updateRotation();
            }// end if
            if (Papervision3D.usePERCENT)
            {
                this._scaleY = param1 / 100;
            }
            else
            {
                this._scaleY = param1;
            }// end else if
            this._transformDirty = true;
            return;
        }// end function

        public function set scaleZ(param1:Number) : void
        {
            if (this._rotationDirty)
            {
                updateRotation();
            }// end if
            if (Papervision3D.usePERCENT)
            {
                this._scaleZ = param1 / 100;
            }
            else
            {
                this._scaleZ = param1;
            }// end else if
            this._transformDirty = true;
            return;
        }// end function

        public function set scaleX(param1:Number) : void
        {
            if (this._rotationDirty)
            {
                updateRotation();
            }// end if
            if (Papervision3D.usePERCENT)
            {
                this._scaleX = param1 / 100;
            }
            else
            {
                this._scaleX = param1;
            }// end else if
            this._transformDirty = true;
            return;
        }// end function

        public function get rotationX() : Number
        {
            if (this._rotationDirty)
            {
                updateRotation();
            }// end if
            return Papervision3D.useDEGREES ? (this._rotationX * toDEGREES) : (this._rotationX);
        }// end function

        public function createViewportLayer(param1:Viewport3D, param2:Boolean = true) : ViewportLayer
        {
            var _loc_3:ViewportLayer;
            _loc_3 = param1.getChildLayer(this, true);
            if (param2)
            {
                addChildrenToLayer(this, _loc_3);
            }// end if
            return _loc_3;
        }// end function

        public function updateTransform() : void
        {
            _rot.setFromEuler(_rotationY, _rotationZ, _rotationX);
            this.transform.copy3x3(_rot.matrix);
            _tempMatrix.reset();
            _tempMatrix.n11 = this._scaleX;
            _tempMatrix.n22 = this._scaleY;
            _tempMatrix.n33 = this._scaleZ;
            this.transform.calculateMultiply(this.transform, _tempMatrix);
            _transformDirty = false;
            return;
        }// end function

        public function get useOwnContainer() : Boolean
        {
            return _useOwnContainer;
        }// end function

        public function moveRight(param1:Number) : void
        {
            translate(param1, RIGHT);
            return;
        }// end function

        public function moveBackward(param1:Number) : void
        {
            translate(param1, BACKWARD);
            return;
        }// end function

        public function set localRotationX(param1:Number) : void
        {
            param1 = Papervision3D.useDEGREES ? (param1 * toRADIANS) : (param1);
            if (this._transformDirty)
            {
                updateTransform();
            }// end if
            _qPitch.setFromAxisAngle(transform.n11, transform.n21, transform.n31, _localRotationX - param1);
            this.transform.calculateMultiply3x3(_qPitch.matrix, transform);
            _localRotationX = param1;
            _rotationDirty = true;
            return;
        }// end function

        public function set localRotationY(param1:Number) : void
        {
            param1 = Papervision3D.useDEGREES ? (param1 * toRADIANS) : (param1);
            if (_transformDirty)
            {
                updateTransform();
            }// end if
            _qYaw.setFromAxisAngle(transform.n12, transform.n22, transform.n32, _localRotationY - param1);
            transform.calculateMultiply3x3(_qYaw.matrix, transform);
            _localRotationY = param1;
            _rotationDirty = true;
            return;
        }// end function

        public function set autoCalcScreenCoords(param1:Boolean) : void
        {
            _autoCalcScreenCoords = param1;
            return;
        }// end function

        public function set localRotationZ(param1:Number) : void
        {
            param1 = Papervision3D.useDEGREES ? (param1 * toRADIANS) : (param1);
            if (_transformDirty)
            {
                updateTransform();
            }// end if
            _qRoll.setFromAxisAngle(transform.n13, transform.n23, transform.n33, _localRotationZ - param1);
            transform.calculateMultiply3x3(_qRoll.matrix, transform);
            _localRotationZ = param1;
            _rotationDirty = true;
            return;
        }// end function

        public function materialsList() : String
        {
            var _loc_1:String;
            var _loc_2:String;
            var _loc_3:DisplayObject3D;
            _loc_1 = "";
            for (_loc_2 in this.materials)
            {
                // label
                _loc_1 = _loc_1 + (_loc_2 + "\n");
            }// end of for ... in
            for each (_loc_3 in this._childrenByName)
            {
                // label
                for (_loc_2 in _loc_3.materials.materialsByName)
                {
                    // label
                    _loc_1 = _loc_1 + ("+ " + _loc_2 + "\n");
                }// end of for ... in
            }// end of for each ... in
            return _loc_1;
        }// end function

        public function set x(param1:Number) : void
        {
            this.transform.n14 = param1;
            return;
        }// end function

        public function set y(param1:Number) : void
        {
            this.transform.n24 = param1;
            return;
        }// end function

        public function set z(param1:Number) : void
        {
            this.transform.n34 = param1;
            return;
        }// end function

        override public function addChild(param1:DisplayObject3D, param2:String = null) : DisplayObject3D
        {
            param1 = super.addChild(param1, param2);
            if (param1.scene == null)
            {
                param1.scene = scene;
            }// end if
            if (this.useOwnContainer)
            {
                param1.parentContainer = this;
            }// end if
            return param1;
        }// end function

        public function project(param1:DisplayObject3D, param2:RenderSessionData) : Number
        {
            var _loc_3:Number;
            var _loc_4:Number;
            var _loc_5:DisplayObject3D;
            if (this._transformDirty)
            {
                updateTransform();
            }// end if
            this.world.calculateMultiply(param1.world, this.transform);
            if (param2.camera.culler)
            {
                if (param2.camera === this)
                {
                    this.culled = true;
                }
                else
                {
                    this.culled = param2.camera.culler.testObject(this) < 0;
                }// end else if
                if (this.culled)
                {
                    var _loc_6:* = param2.renderStatistics;
                    _loc_6.culledObjects = param2.renderStatistics.culledObjects++;
                    return 0;
                }// end if
            }
            else
            {
                this.culled = false;
            }// end else if
            if (param1 !== param2.camera)
            {
                if (param2.camera.useProjectionMatrix)
                {
                    this.view.calculateMultiply4x4(param1.view, this.transform);
                }
                else
                {
                    this.view.calculateMultiply(param1.view, this.transform);
                }// end else if
            }
            else if (param2.camera.useProjectionMatrix)
            {
                this.view.calculateMultiply4x4(param2.camera.eye, this.transform);
            }
            else
            {
                this.view.calculateMultiply(param2.camera.eye, this.transform);
            }// end else if
            if (_autoCalcScreenCoords)
            {
                calculateScreenCoords(param2.camera);
            }// end if
            _loc_3 = 0;
            _loc_4 = 0;
            for each (_loc_5 in this._childrenByName)
            {
                // label
                if (_loc_5.visible)
                {
                    _loc_3 = _loc_3 + _loc_5.project(this, param2);
                }// end if
            }// end of for each ... in
            var _loc_6:* = _loc_3 / _loc_4++;
            this.screenZ = _loc_3 / _loc_4++;
            return _loc_6;
        }// end function

        public function set scene(param1:SceneObject3D) : void
        {
            var _loc_2:DisplayObject3D;
            _scene = param1;
            for each (_loc_2 in this._childrenByName)
            {
                // label
                if (_loc_2.scene == null)
                {
                    _loc_2.scene = _scene;
                }// end if
            }// end of for each ... in
            return;
        }// end function

        public function setChildMaterial(param1:DisplayObject3D, param2:MaterialObject3D, param3:MaterialObject3D = null) : void
        {
            var _loc_4:Triangle3D;
            if (!param1)
            {
                return;
            }// end if
            if (!param3 || param1.material === param3)
            {
                param1.material = param2;
            }// end if
            if (param1.geometry && param1.geometry.faces)
            {
                for each (_loc_4 in param1.geometry.faces)
                {
                    // label
                    if (!param3 || _loc_4.material === param3)
                    {
                        _loc_4.material = param2;
                    }// end if
                }// end of for each ... in
            }// end if
            return;
        }// end function

        public function get material() : MaterialObject3D
        {
            return _material;
        }// end function

        public function get position() : Number3D
        {
            _position.reset(this.x, this.y, this.z);
            return _position;
        }// end function

        public function lookAt(param1:DisplayObject3D, param2:Number3D = null) : void
        {
            var _loc_3:DisplayObject3D;
            var _loc_4:Matrix3D;
            if (this is CameraObject3D)
            {
                _position.reset(this.x, this.y, this.z);
            }
            else
            {
                _loc_3 = this.parent as DisplayObject3D;
                if (_loc_3)
                {
                    world.calculateMultiply(_loc_3.world, transform);
                }
                else
                {
                    world.copy(transform);
                }// end else if
                _position.reset(world.n14, world.n24, world.n34);
            }// end else if
            if (param1 is CameraObject3D)
            {
                _lookatTarget.reset(param1.x, param1.y, param1.z);
            }
            else
            {
                _loc_3 = param1.parent as DisplayObject3D;
                if (_loc_3)
                {
                    param1.world.calculateMultiply(_loc_3.world, param1.transform);
                }
                else
                {
                    param1.world.copy(param1.transform);
                }// end else if
                _lookatTarget.reset(param1.world.n14, param1.world.n24, param1.world.n34);
            }// end else if
            _zAxis.copyFrom(_lookatTarget);
            _zAxis.minusEq(_position);
            _zAxis.normalize();
            if (_zAxis.modulo > 0.1)
            {
                if (!param2)
                {
                }// end if
                _xAxis = Number3D.cross(_zAxis, UP, _xAxis);
                _xAxis.normalize();
                _yAxis = Number3D.cross(_zAxis, _xAxis, _yAxis);
                _yAxis.normalize();
                _loc_4 = this.transform;
                _loc_4.n11 = _xAxis.x * _scaleX;
                _loc_4.n21 = _xAxis.y * _scaleX;
                _loc_4.n31 = _xAxis.z * _scaleX;
                _loc_4.n12 = (-_yAxis.x) * _scaleY;
                _loc_4.n22 = (-_yAxis.y) * _scaleY;
                _loc_4.n32 = (-_yAxis.z) * _scaleY;
                _loc_4.n13 = _zAxis.x * _scaleZ;
                _loc_4.n23 = _zAxis.y * _scaleZ;
                _loc_4.n33 = _zAxis.z * _scaleZ;
                var _loc_5:int;
                _localRotationZ = 0;
                var _loc_5:* = _loc_5;
                _localRotationY = _loc_5;
                _localRotationX = _loc_5;
                this._transformDirty = false;
                this._rotationDirty = true;
            }
            else
            {
                PaperLogger.error("lookAt error");
            }// end else if
            return;
        }// end function

        public function set rotationX(param1:Number) : void
        {
            this._rotationX = Papervision3D.useDEGREES ? (param1 * toRADIANS) : (param1);
            this._transformDirty = true;
            return;
        }// end function

        public function set rotationY(param1:Number) : void
        {
            this._rotationY = Papervision3D.useDEGREES ? (param1 * toRADIANS) : (param1);
            this._transformDirty = true;
            return;
        }// end function

        public function set rotationZ(param1:Number) : void
        {
            this._rotationZ = Papervision3D.useDEGREES ? (param1 * toRADIANS) : (param1);
            this._transformDirty = true;
            return;
        }// end function

        public function pitch(param1:Number) : void
        {
            param1 = Papervision3D.useDEGREES ? (param1 * toRADIANS) : (param1);
            if (this._transformDirty)
            {
                updateTransform();
            }// end if
            _qPitch.setFromAxisAngle(transform.n11, transform.n21, transform.n31, param1);
            this.transform.calculateMultiply3x3(_qPitch.matrix, transform);
            _localRotationX = _localRotationX + param1;
            _rotationDirty = true;
            return;
        }// end function

        public function get sceneX() : Number
        {
            return this.world.n14;
        }// end function

        public function translate(param1:Number, param2:Number3D) : void
        {
            var _loc_3:Number3D;
            _loc_3 = param2.clone();
            if (this._transformDirty)
            {
                updateTransform();
            }// end if
            Matrix3D.rotateAxis(transform, _loc_3);
            this.x = this.x + param1 * _loc_3.x;
            this.y = this.y + param1 * _loc_3.y;
            this.z = this.z + param1 * _loc_3.z;
            return;
        }// end function

        public function distanceTo(param1:DisplayObject3D) : Number
        {
            var _loc_2:Number;
            var _loc_3:Number;
            var _loc_4:Number;
            _loc_2 = this.x - param1.x;
            _loc_3 = this.y - param1.y;
            _loc_4 = this.z - param1.z;
            return Math.sqrt(_loc_2 * _loc_2 + _loc_3 * _loc_3 + _loc_4 * _loc_4);
        }// end function

        public function get sceneZ() : Number
        {
            return this.world.n34;
        }// end function

        public function get sceneY() : Number
        {
            return this.world.n24;
        }// end function

        public function clone() : DisplayObject3D
        {
            var _loc_1:String;
            var _loc_2:DisplayObject3D;
            var _loc_3:DisplayObject3D;
            _loc_1 = this.name + "_" + _numClones++;
            _loc_2 = new DisplayObject3D(_loc_1);
            if (this.material)
            {
                _loc_2.material = this.material;
            }// end if
            if (this.materials)
            {
                _loc_2.materials = this.materials.clone();
            }// end if
            if (this.geometry)
            {
                _loc_2.geometry = this.geometry.clone(_loc_2);
                _loc_2.geometry.ready = true;
            }// end if
            _loc_2.copyTransform(this.transform);
            for each (_loc_3 in this.children)
            {
                // label
                _loc_2.addChild(_loc_3.clone());
            }// end of for each ... in
            return _loc_2;
        }// end function

        public function get scale() : Number
        {
            if (this._scaleX == this._scaleY && this._scaleX == this._scaleZ)
            {
                if (Papervision3D.usePERCENT)
                {
                    return this._scaleX * 100;
                }// end if
                return this._scaleX;
            }
            else
            {
                return NaN;
            }// end else if
        }// end function

        private function updateMaterials(param1:DisplayObject3D, param2:MaterialObject3D, param3:MaterialObject3D) : void
        {
            var _loc_4:DisplayObject3D;
            var _loc_5:Triangle3D;
            param2.unregisterObject(param1);
            if (param3 is AbstractLightShadeMaterial || param3 is ShadedMaterial)
            {
                param3.registerObject(param1);
            }// end if
            if (param1.material === param2)
            {
                param1.material = param3;
            }// end if
            if (param1.geometry && param1.geometry.faces && param1.geometry.faces.length)
            {
                for each (_loc_5 in param1.geometry.faces)
                {
                    // label
                    if (_loc_5.material === param2)
                    {
                        _loc_5.material = param3;
                    }// end if
                }// end of for each ... in
            }// end if
            for each (_loc_4 in param1.children)
            {
                // label
                updateMaterials(_loc_4, param2, param3);
            }// end of for each ... in
            return;
        }// end function

        public function replaceMaterialByName(param1:MaterialObject3D, param2:String) : void
        {
            var _loc_3:MaterialObject3D;
            if (!this.materials)
            {
                return;
            }// end if
            _loc_3 = this.materials.getMaterialByName(param2);
            if (!_loc_3)
            {
                return;
            }// end if
            if (this.material === _loc_3)
            {
                this.material = param1;
            }// end if
            _loc_3 = this.materials.removeMaterial(_loc_3);
            param1 = this.materials.addMaterial(param1, param2);
            updateMaterials(this, _loc_3, param1);
            return;
        }// end function

        private function updateRotation() : void
        {
            _tempScale.x = Papervision3D.usePERCENT ? (_scaleX * 100) : (_scaleX);
            _tempScale.y = Papervision3D.usePERCENT ? (_scaleY * 100) : (_scaleY);
            _tempScale.z = Papervision3D.usePERCENT ? (_scaleZ * 100) : (_scaleZ);
            _rotation = Matrix3D.matrix2euler(this.transform, _rotation, _tempScale);
            this._rotationX = _rotation.x * toRADIANS;
            this._rotationY = _rotation.y * toRADIANS;
            this._rotationZ = _rotation.z * toRADIANS;
            this._rotationDirty = false;
            return;
        }// end function

        public function get localRotationY() : Number
        {
            return Papervision3D.useDEGREES ? (_localRotationY * toDEGREES) : (_localRotationY);
        }// end function

        public function get localRotationZ() : Number
        {
            return Papervision3D.useDEGREES ? (_localRotationZ * toDEGREES) : (_localRotationZ);
        }// end function

        public function copyTransform(param1) : void
        {
            var _loc_2:Matrix3D;
            var _loc_3:Matrix3D;
            var _loc_4:DisplayObject3D;
            if (param1 is DisplayObject3D)
            {
                _loc_4 = DisplayObject3D(param1);
                if (_loc_4._transformDirty)
                {
                    _loc_4.updateTransform();
                }// end if
            }// end if
            _loc_2 = this.transform;
            _loc_3 = param1 is DisplayObject3D ? (param1.transform) : (param1);
            _loc_2.n11 = _loc_3.n11;
            _loc_2.n12 = _loc_3.n12;
            _loc_2.n13 = _loc_3.n13;
            _loc_2.n14 = _loc_3.n14;
            _loc_2.n21 = _loc_3.n21;
            _loc_2.n22 = _loc_3.n22;
            _loc_2.n23 = _loc_3.n23;
            _loc_2.n24 = _loc_3.n24;
            _loc_2.n31 = _loc_3.n31;
            _loc_2.n32 = _loc_3.n32;
            _loc_2.n33 = _loc_3.n33;
            _loc_2.n34 = _loc_3.n34;
            this._transformDirty = false;
            this._rotationDirty = true;
            return;
        }// end function

        public function moveLeft(param1:Number) : void
        {
            translate(param1, LEFT);
            return;
        }// end function

        public function get localRotationX() : Number
        {
            return Papervision3D.useDEGREES ? (_localRotationX * toDEGREES) : (_localRotationX);
        }// end function

        public function set useOwnContainer(param1:Boolean) : void
        {
            _useOwnContainer = param1;
            setParentContainer(this, true);
            return;
        }// end function

        public function moveForward(param1:Number) : void
        {
            translate(param1, FORWARD);
            return;
        }// end function

        public function addChildrenToLayer(param1:DisplayObject3D, param2:ViewportLayer) : void
        {
            var _loc_3:DisplayObject3D;
            for each (_loc_3 in param1.children)
            {
                // label
                param2.addDisplayObject3D(_loc_3);
                _loc_3.addChildrenToLayer(_loc_3, param2);
            }// end of for each ... in
            return;
        }// end function

        public function copyPosition(param1) : void
        {
            var _loc_2:Matrix3D;
            var _loc_3:Matrix3D;
            _loc_2 = this.transform;
            _loc_3 = param1 is DisplayObject3D ? (param1.transform) : (param1);
            _loc_2.n14 = _loc_3.n14;
            _loc_2.n24 = _loc_3.n24;
            _loc_2.n34 = _loc_3.n34;
            return;
        }// end function

        public function hitTestPoint(param1:Number, param2:Number, param3:Number) : Boolean
        {
            var _loc_4:Number;
            var _loc_5:Number;
            var _loc_6:Number;
            var _loc_7:Number;
            var _loc_8:Number;
            _loc_4 = this.x - param1;
            _loc_5 = this.y - param2;
            _loc_6 = this.z - param3;
            _loc_7 = _loc_4 * _loc_4 + _loc_5 * _loc_5 + _loc_6 * _loc_6;
            _loc_8 = this.geometry ? (this.geometry.boundingSphere.maxDistance) : (0);
            return _loc_8 > _loc_7;
        }// end function

        public static function get ZERO() : DisplayObject3D
        {
            return new DisplayObject3D;
        }// end function

    }
}
