﻿package org.papervision3d.render
{
    import flash.geom.*;
    import org.papervision3d.core.clipping.*;
    import org.papervision3d.core.proto.*;
    import org.papervision3d.core.render.*;
    import org.papervision3d.core.render.command.*;
    import org.papervision3d.core.render.data.*;
    import org.papervision3d.core.render.filter.*;
    import org.papervision3d.core.render.material.*;
    import org.papervision3d.core.render.project.*;
    import org.papervision3d.core.render.sort.*;
    import org.papervision3d.core.utils.*;
    import org.papervision3d.events.*;
    import org.papervision3d.view.*;

    public class BasicRenderEngine extends AbstractRenderEngine implements IRenderEngine
    {
        public var clipping:DefaultClipping;
        public var sorter:IRenderSorter;
        public var projectionPipeline:ProjectionPipeline;
        protected var renderDoneEvent:RendererEvent;
        protected var renderList:Array;
        protected var renderStatistics:RenderStatistics;
        protected var renderSessionData:RenderSessionData;
        protected var stopWatch:StopWatch;
        protected var projectionDoneEvent:RendererEvent;
        public var filter:IRenderFilter;
        protected var cleanRHD:RenderHitData;

        public function BasicRenderEngine() : void
        {
            cleanRHD = new RenderHitData();
            init();
            return;
        }// end function

        override public function removeFromRenderList(param1:IRenderListItem) : int
        {
            return renderList.splice(renderList.indexOf(param1), 1);
        }// end function

        protected function doRender(param1:RenderSessionData, param2:Array = null) : RenderStatistics
        {
            var _loc_3:RenderableListItem;
            var _loc_4:Viewport3D;
            var _loc_5:ViewportLayer;
            stopWatch.reset();
            stopWatch.start();
            MaterialManager.getInstance().updateMaterialsBeforeRender(param1);
            filter.filter(renderList);
            sorter.sort(renderList);
            _loc_4 = param1.viewPort;
            do
            {
                // label
                _loc_5 = _loc_4.accessLayerFor(_loc_3, true);
                _loc_3.render(param1, _loc_5.graphicsChannel);
                _loc_4.lastRenderList.push(_loc_3);
                _loc_5.processRenderItem(_loc_3);
                var _loc_6:* = renderList.pop();
                _loc_3 = renderList.pop();
            }while (_loc_6)
            MaterialManager.getInstance().updateMaterialsAfterRender(param1);
            param1.renderStatistics.renderTime = stopWatch.stop();
            param1.viewPort.updateAfterRender(param1);
            return renderStatistics;
        }// end function

        protected function init() : void
        {
            renderStatistics = new RenderStatistics();
            projectionPipeline = new BasicProjectionPipeline();
            stopWatch = new StopWatch();
            sorter = new BasicRenderSorter();
            filter = new BasicRenderFilter();
            renderList = new Array();
            clipping = null;
            renderSessionData = new RenderSessionData();
            renderSessionData.renderer = this;
            projectionDoneEvent = new RendererEvent(RendererEvent.PROJECTION_DONE, renderSessionData);
            renderDoneEvent = new RendererEvent(RendererEvent.RENDER_DONE, renderSessionData);
            return;
        }// end function

        override public function renderScene(param1:SceneObject3D, param2:CameraObject3D, param3:Viewport3D) : RenderStatistics
        {
            param2.viewport = param3.sizeRectangle;
            renderSessionData.scene = param1;
            renderSessionData.camera = param2;
            renderSessionData.viewPort = param3;
            renderSessionData.container = param3.containerSprite;
            renderSessionData.triangleCuller = param3.triangleCuller;
            renderSessionData.particleCuller = param3.particleCuller;
            renderSessionData.renderObjects = param1.objects;
            renderSessionData.renderLayers = null;
            renderSessionData.renderStatistics.clear();
            renderSessionData.clipping = clipping;
            if (clipping)
            {
                clipping.reset(renderSessionData);
            }// end if
            param3.updateBeforeRender(renderSessionData);
            projectionPipeline.project(renderSessionData);
            if (hasEventListener(RendererEvent.PROJECTION_DONE))
            {
                dispatchEvent(projectionDoneEvent);
            }// end if
            doRender(renderSessionData, null);
            if (hasEventListener(RendererEvent.RENDER_DONE))
            {
                dispatchEvent(renderDoneEvent);
            }// end if
            return renderSessionData.renderStatistics;
        }// end function

        public function hitTestPoint2D(param1:Point, param2:Viewport3D) : RenderHitData
        {
            return param2.hitTestPoint2D(param1);
        }// end function

        override public function addToRenderList(param1:RenderableListItem) : int
        {
            return renderList.push(param1);
        }// end function

        public function renderLayers(param1:SceneObject3D, param2:CameraObject3D, param3:Viewport3D, param4:Array = null) : RenderStatistics
        {
            renderSessionData.scene = param1;
            renderSessionData.camera = param2;
            renderSessionData.viewPort = param3;
            renderSessionData.container = param3.containerSprite;
            renderSessionData.triangleCuller = param3.triangleCuller;
            renderSessionData.particleCuller = param3.particleCuller;
            renderSessionData.renderObjects = getLayerObjects(param4);
            renderSessionData.renderLayers = param4;
            renderSessionData.renderStatistics.clear();
            renderSessionData.clipping = clipping;
            param3.updateBeforeRender(renderSessionData);
            projectionPipeline.project(renderSessionData);
            if (hasEventListener(RendererEvent.PROJECTION_DONE))
            {
                dispatchEvent(projectionDoneEvent);
            }// end if
            doRender(renderSessionData);
            if (hasEventListener(RendererEvent.RENDER_DONE))
            {
                dispatchEvent(renderDoneEvent);
            }// end if
            return renderSessionData.renderStatistics;
        }// end function

        private function getLayerObjects(param1:Array) : Array
        {
            var _loc_2:Array;
            var _loc_3:ViewportLayer;
            _loc_2 = new Array();
            for each (_loc_3 in param1)
            {
                // label
                _loc_2 = _loc_2.concat(_loc_3.getLayerObjects());
            }// end of for each ... in
            return _loc_2;
        }// end function

        public function destroy() : void
        {
            renderDoneEvent = null;
            projectionDoneEvent = null;
            projectionPipeline = null;
            sorter = null;
            filter = null;
            renderStatistics = null;
            renderList = null;
            renderSessionData.destroy();
            renderSessionData = null;
            cleanRHD = null;
            stopWatch = null;
            clipping = null;
            return;
        }// end function

    }
}
