﻿package org.papervision3d.view
{
    import flash.display.*;
    import flash.events.*;
    import org.papervision3d.core.proto.*;
    import org.papervision3d.render.*;
    import org.papervision3d.scenes.*;

    public class AbstractView extends Sprite implements IView
    {
        protected var _camera:CameraObject3D;
        protected var _height:Number;
        public var viewport:Viewport3D;
        public var scene:Scene3D;
        public var renderer:BasicRenderEngine;
        protected var _width:Number;

        public function AbstractView()
        {
            return;
        }// end function

        public function singleRender() : void
        {
            onRenderTick();
            return;
        }// end function

        public function get camera() : CameraObject3D
        {
            return _camera;
        }// end function

        public function startRendering() : void
        {
            addEventListener(Event.ENTER_FRAME, onRenderTick);
            viewport.containerSprite.cacheAsBitmap = false;
            return;
        }// end function

        public function get viewportHeight() : Number
        {
            return _height;
        }// end function

        public function set viewportWidth(param1:Number) : void
        {
            _width = param1;
            viewport.width = param1;
            return;
        }// end function

        protected function onRenderTick(param1:Event = null) : void
        {
            renderer.renderScene(scene, _camera, viewport);
            return;
        }// end function

        public function stopRendering(param1:Boolean = false, param2:Boolean = false) : void
        {
            removeEventListener(Event.ENTER_FRAME, onRenderTick);
            if (param1)
            {
                onRenderTick();
            }// end if
            if (param2)
            {
                viewport.containerSprite.cacheAsBitmap = true;
            }
            else
            {
                viewport.containerSprite.cacheAsBitmap = false;
            }// end else if
            return;
        }// end function

        public function get viewportWidth() : Number
        {
            return _width;
        }// end function

        public function set viewportHeight(param1:Number) : void
        {
            _height = param1;
            viewport.height = param1;
            return;
        }// end function

    }
}
