﻿package org.papervision3d.view
{
    import org.papervision3d.cameras.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.render.*;
    import org.papervision3d.scenes.*;

    public class BasicView extends AbstractView implements IView
    {

        public function BasicView(param1:Number = 640, param2:Number = 480, param3:Boolean = true, param4:Boolean = false, param5:String = "Target")
        {
            scene = new Scene3D();
            viewport = new Viewport3D(param1, param2, param3, param4);
            addChild(viewport);
            renderer = new BasicRenderEngine();
            switch(param5)
            {
                case CameraType.DEBUG:
                {
                    _camera = new DebugCamera3D(viewport);
                    break;
                }// end case
                case CameraType.TARGET:
                {
                    _camera = new Camera3D(60);
                    _camera.target = DisplayObject3D.ZERO;
                    break;
                }// end case
                case CameraType.SPRING:
                {
                    _camera = new SpringCamera3D();
                    _camera.target = DisplayObject3D.ZERO;
                    break;
                }// end case
                case CameraType.FREE:
                {
                }// end case
                default:
                {
                    _camera = new Camera3D(60);
                    break;
                    break;
                }// end default
            }// end switch
            cameraAsCamera3D.update(viewport.sizeRectangle);
            return;
        }// end function

        public function get cameraAsCamera3D() : Camera3D
        {
            return _camera as Camera3D;
        }// end function

        public function get cameraAsDebugCamera3D() : DebugCamera3D
        {
            return _camera as DebugCamera3D;
        }// end function

    }
}
