﻿package org.papervision3d.view
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.utils.*;
    import org.papervision3d.core.culling.*;
    import org.papervision3d.core.geom.renderables.*;
    import org.papervision3d.core.log.*;
    import org.papervision3d.core.render.*;
    import org.papervision3d.core.render.command.*;
    import org.papervision3d.core.render.data.*;
    import org.papervision3d.core.utils.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.view.layer.*;

    public class Viewport3D extends Sprite implements IViewport3D
    {
        protected var _interactive:Boolean;
        public var cullingRectangle:Rectangle;
        private var stageScaleModeSet:Boolean = false;
        protected var _viewportObjectFilter:ViewportObjectFilter;
        protected var _layerInstances:Dictionary;
        protected var _hWidth:Number;
        protected var _autoScaleToStage:Boolean;
        protected var _lastRenderer:IRenderEngine;
        protected var _containerSprite:ViewportBaseLayer;
        protected var _hHeight:Number;
        public var sizeRectangle:Rectangle;
        protected var renderHitData:RenderHitData;
        protected var _autoClipping:Boolean;
        protected var _height:Number;
        public var interactiveSceneManager:InteractiveSceneManager;
        public var lastRenderList:Array;
        public var lineCuller:ILineCuller;
        protected var _autoCulling:Boolean;
        public var particleCuller:IParticleCuller;
        protected var _width:Number;
        public var triangleCuller:ITriangleCuller;

        public function Viewport3D(param1:Number = 640, param2:Number = 480, param3:Boolean = false, param4:Boolean = false, param5:Boolean = true, param6:Boolean = true)
        {
            stageScaleModeSet = false;
            init();
            this.interactive = param4;
            this.viewportWidth = param1;
            this.viewportHeight = param2;
            this.autoClipping = param5;
            this.autoCulling = param6;
            this.autoScaleToStage = param3;
            this._layerInstances = new Dictionary(true);
            return;
        }// end function

        public function set autoCulling(param1:Boolean) : void
        {
            if (param1)
            {
                triangleCuller = new RectangleTriangleCuller(cullingRectangle);
                particleCuller = new RectangleParticleCuller(cullingRectangle);
                lineCuller = new RectangleLineCuller(cullingRectangle);
            }
            else if (!param1)
            {
                triangleCuller = new DefaultTriangleCuller();
                particleCuller = new DefaultParticleCuller();
                lineCuller = new DefaultLineCuller();
            }// end else if
            _autoCulling = param1;
            return;
        }// end function

        protected function onRemovedFromStage(param1:Event) : void
        {
            stage.removeEventListener(Event.RESIZE, onStageResize);
            return;
        }// end function

        public function hitTestMouse() : RenderHitData
        {
            var _loc_1:Point;
            _loc_1 = new Point(containerSprite.mouseX, containerSprite.mouseY);
            return hitTestPoint2D(_loc_1);
        }// end function

        protected function init() : void
        {
            this.renderHitData = new RenderHitData();
            lastRenderList = new Array();
            sizeRectangle = new Rectangle();
            cullingRectangle = new Rectangle();
            _containerSprite = new ViewportBaseLayer(this);
            _containerSprite.doubleClickEnabled = true;
            addChild(_containerSprite);
            addEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
            addEventListener(Event.REMOVED_FROM_STAGE, onRemovedFromStage);
            return;
        }// end function

        protected function onStageResize(param1:Event = null) : void
        {
            if (_autoScaleToStage)
            {
                viewportWidth = stage.stageWidth;
                viewportHeight = stage.stageHeight;
            }// end if
            return;
        }// end function

        public function set autoClipping(param1:Boolean) : void
        {
            if (param1)
            {
                scrollRect = sizeRectangle;
            }
            else
            {
                scrollRect = null;
            }// end else if
            _autoClipping = param1;
            return;
        }// end function

        public function updateAfterRender(param1:RenderSessionData) : void
        {
            var _loc_2:ViewportLayer;
            if (interactive)
            {
                interactiveSceneManager.updateAfterRender();
            }// end if
            if (param1.renderLayers)
            {
                for each (_loc_2 in param1.renderLayers)
                {
                    // label
                    _loc_2.updateInfo();
                    _loc_2.sortChildLayers();
                    _loc_2.updateAfterRender();
                }// end of for each ... in
            }
            else
            {
                containerSprite.updateInfo();
                containerSprite.updateAfterRender();
            }// end else if
            containerSprite.sortChildLayers();
            return;
        }// end function

        public function accessLayerFor(param1:RenderableListItem, param2:Boolean = false) : ViewportLayer
        {
            var _loc_3:DisplayObject3D;
            if (param1.renderableInstance)
            {
                _loc_3 = param1.renderableInstance.instance;
                _loc_3 = _loc_3.parentContainer ? (_loc_3.parentContainer) : (_loc_3);
                if (containerSprite.layers[_loc_3])
                {
                    if (param2)
                    {
                        _loc_3.container = containerSprite.layers[_loc_3];
                    }// end if
                    return containerSprite.layers[_loc_3];
                }
                else if (_loc_3.useOwnContainer)
                {
                    return containerSprite.getChildLayer(_loc_3, true, true);
                }// end if
            }// end else if
            return containerSprite;
        }// end function

        public function get viewportHeight() : Number
        {
            return _height;
        }// end function

        public function get autoCulling() : Boolean
        {
            return _autoCulling;
        }// end function

        public function updateBeforeRender(param1:RenderSessionData) : void
        {
            var _loc_2:ViewportLayer;
            lastRenderList.length = 0;
            if (param1.renderLayers)
            {
                for each (_loc_2 in param1.renderLayers)
                {
                    // label
                    _loc_2.updateBeforeRender();
                }// end of for each ... in
            }
            else
            {
                _containerSprite.updateBeforeRender();
            }// end else if
            _layerInstances = new Dictionary(true);
            return;
        }// end function

        protected function onAddedToStage(param1:Event) : void
        {
            if (_autoScaleToStage)
            {
                setStageScaleMode();
            }// end if
            stage.addEventListener(Event.RESIZE, onStageResize);
            onStageResize();
            return;
        }// end function

        public function getChildLayer(param1:DisplayObject3D, param2:Boolean = true, param3:Boolean = true) : ViewportLayer
        {
            return containerSprite.getChildLayer(param1, param2, param3);
        }// end function

        public function hitTestPoint2D(param1:Point) : RenderHitData
        {
            var _loc_2:RenderableListItem;
            var _loc_3:RenderHitData;
            var _loc_4:IRenderListItem;
            var _loc_5:uint;
            renderHitData.clear();
            if (interactive)
            {
                _loc_3 = renderHitData;
                _loc_5 = lastRenderList.length;
                do
                {
                    // label
                    if (_loc_4 is RenderableListItem)
                    {
                        _loc_2 = _loc_4 as RenderableListItem;
                        _loc_3 = _loc_2.hitTestPoint2D(param1, _loc_3);
                        if (_loc_3.hasHit)
                        {
                            return _loc_3;
                        }// end if
                    }// end if
                    var _loc_6:* = lastRenderList[--_loc_5];
                    _loc_4 = lastRenderList[--_loc_5];
                }while (_loc_6)
            }// end if
            return renderHitData;
        }// end function

        public function get containerSprite() : ViewportLayer
        {
            return _containerSprite;
        }// end function

        public function set viewportWidth(param1:Number) : void
        {
            _width = param1;
            _hWidth = param1 / 2;
            containerSprite.x = _hWidth;
            cullingRectangle.x = -_hWidth;
            cullingRectangle.width = param1;
            sizeRectangle.width = param1;
            if (_autoClipping)
            {
                scrollRect = sizeRectangle;
            }// end if
            return;
        }// end function

        public function get autoClipping() : Boolean
        {
            return _autoClipping;
        }// end function

        protected function setStageScaleMode() : void
        {
            if (!stageScaleModeSet)
            {
                PaperLogger.info("Viewport autoScaleToStage : Papervision has changed the Stage scale mode.");
                stage.align = StageAlign.TOP_LEFT;
                stage.scaleMode = StageScaleMode.NO_SCALE;
                stageScaleModeSet = true;
            }// end if
            return;
        }// end function

        public function get viewportWidth() : Number
        {
            return _width;
        }// end function

        public function set autoScaleToStage(param1:Boolean) : void
        {
            _autoScaleToStage = param1;
            if (param1 && stage != null)
            {
                setStageScaleMode();
                onStageResize();
            }// end if
            return;
        }// end function

        public function set viewportObjectFilter(param1:ViewportObjectFilter) : void
        {
            _viewportObjectFilter = param1;
            return;
        }// end function

        public function set interactive(param1:Boolean) : void
        {
            if (param1 != _interactive)
            {
                if (_interactive && interactiveSceneManager)
                {
                    interactiveSceneManager.destroy();
                    interactiveSceneManager = null;
                }// end if
                _interactive = param1;
                if (param1)
                {
                    interactiveSceneManager = new InteractiveSceneManager(this);
                }// end if
            }// end if
            return;
        }// end function

        public function set viewportHeight(param1:Number) : void
        {
            _height = param1;
            _hHeight = param1 / 2;
            containerSprite.y = _hHeight;
            cullingRectangle.y = -_hHeight;
            cullingRectangle.height = param1;
            sizeRectangle.height = param1;
            if (_autoClipping)
            {
                scrollRect = sizeRectangle;
            }// end if
            return;
        }// end function

        public function get viewportObjectFilter() : ViewportObjectFilter
        {
            return _viewportObjectFilter;
        }// end function

        public function get autoScaleToStage() : Boolean
        {
            return _autoScaleToStage;
        }// end function

        public function get interactive() : Boolean
        {
            return _interactive;
        }// end function

        public function hitTestPointObject(param1:Point, param2:DisplayObject3D) : RenderHitData
        {
            var _loc_3:RenderableListItem;
            var _loc_4:RenderHitData;
            var _loc_5:IRenderListItem;
            var _loc_6:uint;
            if (interactive)
            {
                _loc_4 = new RenderHitData();
                _loc_6 = lastRenderList.length;
                do
                {
                    // label
                    if (_loc_5 is RenderableListItem)
                    {
                        _loc_3 = _loc_5 as RenderableListItem;
                        if (_loc_3.renderableInstance is Triangle3D)
                        {
                            if (Triangle3D(_loc_3.renderableInstance).instance != param2)
                            {
                            }// end if
                        }
                        else
                        {
                        }
                        else
                        {
                            _loc_4 = _loc_3.hitTestPoint2D(param1, _loc_4);
                            if (_loc_4.hasHit)
                            {
                                return _loc_4;
                            }// end if
                        }// end if
                    }// end else if
                    var _loc_7:* = lastRenderList[--_loc_6];
                    _loc_5 = lastRenderList[--_loc_6];
                }while (_loc_7)
            }// end if
            return new RenderHitData();
        }// end function

        public function destroy() : void
        {
            if (interactiveSceneManager)
            {
                interactiveSceneManager.destroy();
                interactiveSceneManager = null;
            }// end if
            lastRenderList = null;
            return;
        }// end function

    }
}
